/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Witch;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class CompatibilityUtils
extends NMSUtils {
    public static boolean USE_MAGIC_DAMAGE = true;
    public static boolean isDamaging = false;
    public static final int MAX_ENTITY_RANGE = 72;
    private static final Map<World.Environment, Integer> maxHeights = new HashMap<World.Environment, Integer>();
    private static WeakReference<ThrownPotion> potionReference = null;

    public static void applyPotionEffects(LivingEntity entity, Collection<PotionEffect> effects) {
        for (PotionEffect effect : effects) {
            CompatibilityUtils.applyPotionEffect(entity, effect);
        }
    }

    public static void applyPotionEffect(LivingEntity entity, PotionEffect effect) {
        boolean applyEffect = true;
        Collection currentEffects = entity.getActivePotionEffects();
        for (PotionEffect currentEffect : currentEffects) {
            if (!currentEffect.getType().equals((Object)effect.getType())) continue;
            if (effect.getAmplifier() < 0) {
                applyEffect = false;
                break;
            }
            if (currentEffect.getAmplifier() <= effect.getAmplifier() && effect.getDuration() <= 0x1FFFFFFF) continue;
            applyEffect = false;
            break;
        }
        if (applyEffect) {
            entity.addPotionEffect(effect, true);
        }
    }

    public static boolean setDisplayName(ItemStack itemStack, String displayName) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object displayNode = CompatibilityUtils.createNode(tag, "display");
        if (displayNode == null) {
            return false;
        }
        CompatibilityUtils.setMeta(displayNode, "Name", displayName);
        return true;
    }

    public static boolean setLore(ItemStack itemStack, Collection<String> lore) {
        Object handle = CompatibilityUtils.getHandle(itemStack);
        if (handle == null) {
            return false;
        }
        Object tag = CompatibilityUtils.getTag(handle);
        if (tag == null) {
            return false;
        }
        Object displayNode = CompatibilityUtils.createNode(tag, "display");
        if (displayNode == null) {
            return false;
        }
        Object loreList = CompatibilityUtils.setStringList(displayNode, "Lore", lore);
        return loreList != null;
    }

    public static Inventory createInventory(InventoryHolder holder, int size, String name) {
        Inventory inventory = null;
        try {
            String shorterName = name;
            if (shorterName.length() > 32) {
                shorterName = shorterName.substring(0, 31);
            }
            inventory = (Inventory)class_CraftInventoryCustom_constructor.newInstance(holder, size, ChatColor.translateAlternateColorCodes((char)'&', (String)shorterName));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return inventory;
    }

    public static void setInvulnerable(Entity entity) {
        CompatibilityUtils.setInvulnerable(entity, true);
    }

    public static void setInvulnerable(Entity entity, boolean flag) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_invulnerableField.set(handle, flag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setSilent(Entity entity, boolean flag) {
        if (class_Entity_setSilentMethod == null) {
            return;
        }
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_setSilentMethod.invoke(handle, flag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isSilent(Entity entity) {
        if (class_Entity_isSilentMethod == null) {
            return false;
        }
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            return (Boolean)class_Entity_isSilentMethod.invoke(handle, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static Location getPaintingOffset(Location loc, BlockFace facing, Art art) {
        switch (art) {
            case ALBAN: 
            case AZTEC: 
            case AZTEC2: 
            case BOMB: 
            case KEBAB: 
            case PLANT: 
            case WASTELAND: {
                return loc;
            }
            case GRAHAM: 
            case WANDERER: {
                return loc.getBlock().getLocation().add(0.0, -1.0, 0.0);
            }
            case CREEBET: 
            case COURBET: 
            case POOL: 
            case SEA: 
            case SUNSET: 
            case DONKEYKONG: 
            case SKELETON: {
                if (facing == BlockFace.WEST) {
                    return loc.getBlock().getLocation().add(0.0, 0.0, -1.0);
                }
                if (facing == BlockFace.SOUTH) {
                    return loc.getBlock().getLocation().add(-1.0, 0.0, 0.0);
                }
                return loc;
            }
            case BUST: 
            case MATCH: 
            case SKULL_AND_ROSES: 
            case STAGE: 
            case VOID: 
            case WITHER: 
            case FIGHTERS: 
            case BURNINGSKULL: 
            case PIGSCENE: 
            case POINTER: {
                if (facing == BlockFace.WEST) {
                    return loc.getBlock().getLocation().add(0.0, -1.0, -1.0);
                }
                if (facing == BlockFace.SOUTH) {
                    return loc.getBlock().getLocation().add(-1.0, -1.0, 0.0);
                }
                return loc.add(0.0, -1.0, 0.0);
            }
        }
        return loc;
    }

    public static Painting spawnPainting(Location location, BlockFace facing, Art art) {
        Painting newPainting = null;
        try {
            location = CompatibilityUtils.getPaintingOffset(location, facing, art);
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = null;
            Object directionEnum = Enum.valueOf(class_EnumDirection, facing.name());
            Object blockLocation = class_BlockPosition_Constructor.newInstance(location.getX(), location.getY(), location.getZ());
            newEntity = class_EntityPaintingConstructor.newInstance(worldHandle, blockLocation, directionEnum);
            if (newEntity != null) {
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof Painting)) {
                    return null;
                }
                newPainting = (Painting)bukkitEntity;
                newPainting.setFacingDirection(facing, true);
                newPainting.setArt(art, true);
                class_World_addEntityMethod.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            newPainting = null;
        }
        return newPainting;
    }

    public static ItemFrame spawnItemFrame(Location location, BlockFace facing, Rotation rotation, ItemStack item) {
        ItemFrame newItemFrame = null;
        try {
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = null;
            Object directionEnum = Enum.valueOf(class_EnumDirection, facing.name());
            Object blockLocation = class_BlockPosition_Constructor.newInstance(location.getX(), location.getY(), location.getZ());
            newEntity = class_EntityItemFrameConstructor.newInstance(worldHandle, blockLocation, directionEnum);
            if (newEntity != null) {
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof ItemFrame)) {
                    return null;
                }
                newItemFrame = (ItemFrame)bukkitEntity;
                newItemFrame.setItem(CompatibilityUtils.getCopy(item));
                newItemFrame.setFacingDirection(facing, true);
                newItemFrame.setRotation(rotation);
                try {
                    class_World_addEntityMethod.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                }
                catch (Exception ex) {
                    newItemFrame = null;
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return newItemFrame;
    }

    public static ArmorStand spawnArmorStand(Location location) {
        ArmorStand armorStand = null;
        try {
            Object newEntity = class_CraftWorld_createEntityMethod.invoke((Object)location.getWorld(), location, ArmorStand.class);
            if (newEntity != null) {
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof ArmorStand)) {
                    return null;
                }
                armorStand = (ArmorStand)bukkitEntity;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return armorStand;
    }

    public static boolean addToWorld(World world, Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        try {
            Object worldHandle = CompatibilityUtils.getHandle(world);
            Object entityHandle = CompatibilityUtils.getHandle(entity);
            class_World_addEntityMethod.invoke(worldHandle, entityHandle, reason);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static List<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        if (location == null) {
            return null;
        }
        Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
        try {
            x = Math.min(x, 72.0);
            z = Math.min(z, 72.0);
            Object bb = class_AxisAlignedBB_Constructor.newInstance(location.getX() - x, location.getY() - y, location.getZ() - z, location.getX() + x, location.getY() + y, location.getZ() + z);
            List entityList = (List)class_World_getEntitiesMethod.invoke(worldHandle, null, bb);
            ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
            for (Object entity : entityList) {
                Entity bukkitEntity = (Entity)class_Entity_getBukkitEntityMethod.invoke(entity, new Object[0]);
                if (bukkitEntity instanceof ComplexLivingEntity) {
                    ComplexLivingEntity complex = (ComplexLivingEntity)bukkitEntity;
                    Set parts = complex.getParts();
                    for (ComplexEntityPart part : parts) {
                        bukkitEntityList.add((Entity)part);
                    }
                    continue;
                }
                bukkitEntityList.add(bukkitEntity);
            }
            return bukkitEntityList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Minecart spawnCustomMinecart(Location location, Material material, short data, int offset) {
        Minecart newMinecart = null;
        try {
            Constructor minecartConstructor = class_EntityMinecartRideable.getConstructor(class_World, Double.TYPE, Double.TYPE, Double.TYPE);
            Method addEntity = class_World.getMethod("addEntity", class_Entity, CreatureSpawnEvent.SpawnReason.class);
            Method setPositionRotationMethod = class_Entity.getMethod("setPositionRotation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            Object worldHandle = CompatibilityUtils.getHandle(location.getWorld());
            Object newEntity = minecartConstructor.newInstance(worldHandle, location.getX(), location.getY(), location.getZ());
            if (newEntity != null) {
                setPositionRotationMethod.invoke(newEntity, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
                addEntity.invoke(worldHandle, newEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                Entity bukkitEntity = CompatibilityUtils.getBukkitEntity(newEntity);
                if (bukkitEntity == null || !(bukkitEntity instanceof Minecart)) {
                    return null;
                }
                newMinecart = (Minecart)bukkitEntity;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return newMinecart;
    }

    public static Class<? extends Runnable> getTaskClass(BukkitTask task) {
        Class taskClass = null;
        try {
            Method getTaskClassMethod = class_CraftTask.getDeclaredMethod("getTaskClass", new Class[0]);
            getTaskClassMethod.setAccessible(true);
            taskClass = (Class)getTaskClassMethod.invoke((Object)task, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return taskClass;
    }

    public static Runnable getTaskRunnable(BukkitTask task) {
        Runnable runnable = null;
        try {
            Field taskField = class_CraftTask.getDeclaredField("task");
            taskField.setAccessible(true);
            runnable = (Runnable)taskField.get(task);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return runnable;
    }

    public static void ageItem(Item item, int ticksToAge) {
        try {
            Class<?> itemClass = CompatibilityUtils.fixBukkitClass("net.minecraft.server.EntityItem");
            Object handle = CompatibilityUtils.getHandle((Entity)item);
            Field ageField = itemClass.getDeclaredField("age");
            ageField.setAccessible(true);
            ageField.set(handle, ticksToAge);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void damage(Damageable target, double amount, Entity source) {
        if (target == null || target.isDead()) {
            return;
        }
        while (target instanceof ComplexEntityPart) {
            target = ((ComplexEntityPart)target).getParent();
        }
        if (USE_MAGIC_DAMAGE && target.getType() == EntityType.ENDER_DRAGON) {
            CompatibilityUtils.magicDamage(target, amount, source);
            return;
        }
        isDamaging = true;
        try {
            if (target instanceof ArmorStand) {
                double newHealth = Math.max(0.0, target.getHealth() - amount);
                if (newHealth <= 0.0) {
                    EntityDeathEvent deathEvent = new EntityDeathEvent((LivingEntity)((ArmorStand)target), new ArrayList());
                    Bukkit.getPluginManager().callEvent((Event)deathEvent);
                    target.remove();
                } else {
                    target.setHealth(newHealth);
                }
            } else {
                target.damage(amount, source);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        isDamaging = false;
    }

    public static void magicDamage(Damageable target, double amount, Entity source) {
        try {
            if (target == null || target.isDead()) {
                return;
            }
            if (class_EntityLiving_damageEntityMethod == null || class_DamageSource_MagicField == null || class_DamageSource_getMagicSourceMethod == null) {
                CompatibilityUtils.damage(target, amount, source);
                return;
            }
            if (!USE_MAGIC_DAMAGE || target instanceof Witch || target instanceof Enderman || target instanceof ArmorStand || !(target instanceof LivingEntity)) {
                CompatibilityUtils.damage(target, amount, source);
                return;
            }
            Object targetHandle = CompatibilityUtils.getHandle((Entity)target);
            if (targetHandle == null) {
                return;
            }
            isDamaging = true;
            Object sourceHandle = CompatibilityUtils.getHandle(source);
            if (sourceHandle != null && source instanceof LivingEntity) {
                ThrownPotion potion = potionReference == null ? null : (ThrownPotion)potionReference.get();
                Location location = target.getLocation();
                if (potion == null) {
                    potion = (ThrownPotion)location.getWorld().spawnEntity(location, EntityType.SPLASH_POTION);
                    potion.remove();
                    potionReference = new WeakReference<ThrownPotion>(potion);
                }
                potion.teleport(location);
                potion.setShooter((ProjectileSource)((LivingEntity)source));
                Object potionHandle = CompatibilityUtils.getHandle((Entity)potion);
                Object damageSource = class_DamageSource_getMagicSourceMethod.invoke(null, potionHandle, sourceHandle);
                if (class_EntityDamageSource_setThornsMethod != null) {
                    class_EntityDamageSource_setThornsMethod.invoke(damageSource, new Object[0]);
                }
                class_EntityLiving_damageEntityMethod.invoke(targetHandle, damageSource, Float.valueOf((float)amount));
            } else {
                Object magicSource = class_DamageSource_MagicField.get(null);
                class_EntityLiving_damageEntityMethod.invoke(targetHandle, magicSource, Float.valueOf((float)amount));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        isDamaging = false;
    }

    @Deprecated
    public static void setTarget(LivingEntity entity, Location target) {
    }

    public static Location getEyeLocation(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getEyeLocation();
        }
        return entity.getLocation();
    }

    public static ConfigurationSection loadConfiguration(String fileName) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load(fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    public static ConfigurationSection loadConfiguration(InputStream stream) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load((Reader)new InputStreamReader(stream));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    public static ConfigurationSection loadConfiguration(File file) throws IOException, InvalidConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration();
        try {
            configuration.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    public static void setTNTSource(TNTPrimed tnt, LivingEntity source) {
        try {
            Object tntHandle = CompatibilityUtils.getHandle((Entity)tnt);
            Object sourceHandle = CompatibilityUtils.getHandle(source);
            class_EntityTNTPrimed_source.set(tntHandle, sourceHandle);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.WARNING, "Unable to set TNT source", ex);
        }
    }

    public static void setEntityMotion(Entity entity, Vector motion) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_motXField.set(handle, motion.getX());
            class_Entity_motYField.set(handle, motion.getY());
            class_Entity_motZField.set(handle, motion.getZ());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Vector getNormal(Block block, Location intersection) {
        double x = intersection.getX() - ((double)block.getX() + 0.5);
        double y = intersection.getY() - ((double)block.getY() + 0.5);
        double z = intersection.getZ() - ((double)block.getZ() + 0.5);
        double ax = Math.abs(x);
        double ay = Math.abs(y);
        double az = Math.abs(z);
        if (ax > ay && ax > az) {
            return new Vector(Math.signum(x), 0.0, 0.0);
        }
        if (ay > ax && ay > az) {
            return new Vector(0.0, Math.signum(y), 0.0);
        }
        return new Vector(0.0, 0.0, Math.signum(z));
    }

    public static boolean setLock(Block block, String lockName) {
        if (class_TileEntityContainer_setLock == null || class_ChestLock_Constructor == null) {
            return false;
        }
        Object tileEntity = CompatibilityUtils.getTileEntity(block.getLocation());
        if (tileEntity == null) {
            return false;
        }
        if (!class_TileEntityContainer.isInstance(tileEntity)) {
            return false;
        }
        try {
            Object lock = class_ChestLock_Constructor.newInstance(lockName);
            class_TileEntityContainer_setLock.invoke(tileEntity, lock);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean clearLock(Block block) {
        if (class_TileEntityContainer_setLock == null) {
            return false;
        }
        Object tileEntity = CompatibilityUtils.getTileEntity(block.getLocation());
        if (tileEntity == null) {
            return false;
        }
        if (!class_TileEntityContainer.isInstance(tileEntity)) {
            return false;
        }
        try {
            class_TileEntityContainer_setLock.invoke(tileEntity, new Object[]{null});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isLocked(Block block) {
        if (class_TileEntityContainer_getLock == null || class_ChestLock_isEmpty == null) {
            return false;
        }
        Object tileEntity = CompatibilityUtils.getTileEntity(block.getLocation());
        if (tileEntity == null) {
            return false;
        }
        if (!class_TileEntityContainer.isInstance(tileEntity)) {
            return false;
        }
        try {
            Object lock = class_TileEntityContainer_getLock.invoke(tileEntity, new Object[0]);
            if (lock == null) {
                return false;
            }
            return (Boolean)class_ChestLock_isEmpty.invoke(lock, new Object[0]) == false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static String getLock(Block block) {
        if (class_TileEntityContainer_getLock == null || class_ChestLock_getString == null) {
            return null;
        }
        Object tileEntity = CompatibilityUtils.getTileEntity(block.getLocation());
        if (tileEntity == null) {
            return null;
        }
        if (!class_TileEntityContainer.isInstance(tileEntity)) {
            return null;
        }
        try {
            Object lock = class_TileEntityContainer_getLock.invoke(tileEntity, new Object[0]);
            if (lock == null) {
                return null;
            }
            return (String)class_ChestLock_getString.invoke(lock, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void setFallingBlockDamage(FallingBlock entity, float fallHurtAmount, int fallHurtMax) {
        Object entityHandle = CompatibilityUtils.getHandle((Entity)entity);
        if (entityHandle == null) {
            return;
        }
        try {
            class_EntityFallingBlock_hurtEntitiesField.set(entityHandle, true);
            class_EntityFallingBlock_fallHurtAmountField.set(entityHandle, Float.valueOf(fallHurtAmount));
            class_EntityFallingBlock_fallHurtMaxField.set(entityHandle, fallHurtMax);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void configureMaxHeights(ConfigurationSection config) {
        maxHeights.clear();
        Set keys = config.getKeys(false);
        for (String key : keys) {
            try {
                World.Environment worldType = World.Environment.valueOf((String)key.toUpperCase());
                maxHeights.put(worldType, config.getInt(key));
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Invalid environment type: " + key, ex);
            }
        }
    }

    public static int getMaxHeight(World world) {
        Integer maxHeight = maxHeights.get(world.getEnvironment());
        if (maxHeight == null) {
            maxHeight = world.getMaxHeight();
        }
        return maxHeight;
    }

    public static void setInvisible(ArmorStand armorStand, boolean invisible) {
        try {
            Object handle = CompatibilityUtils.getHandle((LivingEntity)armorStand);
            class_ArmorStand_setInvisible.invoke(handle, invisible);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setGravity(ArmorStand armorStand, boolean gravity) {
        if (class_Entity_setNoGravity == null && class_ArmorStand_setGravity == null) {
            return;
        }
        try {
            Object handle = CompatibilityUtils.getHandle((LivingEntity)armorStand);
            if (class_Entity_setNoGravity != null) {
                class_Entity_setNoGravity.invoke(handle, !gravity);
            } else {
                class_ArmorStand_setGravity.invoke(handle, gravity);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setDisabledSlots(ArmorStand armorStand, int disabledSlots) {
        if (class_EntityArmorStand_disabledSlotsField == null) {
            return;
        }
        try {
            Object handle = CompatibilityUtils.getHandle((LivingEntity)armorStand);
            class_EntityArmorStand_disabledSlotsField.set(handle, disabledSlots);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int getDisabledSlots(ArmorStand armorStand) {
        if (class_EntityArmorStand_disabledSlotsField == null) {
            return 0;
        }
        try {
            Object handle = CompatibilityUtils.getHandle((LivingEntity)armorStand);
            return (Integer)class_EntityArmorStand_disabledSlotsField.get(handle);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static void setYawPitch(Entity entity, float yaw, float pitch) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_setYawPitchMethod.invoke(handle, Float.valueOf(yaw), Float.valueOf(pitch));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setLocation(Entity entity, double x, double y, double z, float yaw, float pitch) {
        try {
            Object handle = CompatibilityUtils.getHandle(entity);
            class_Entity_setLocationMethod.invoke(handle, x, y, z, Float.valueOf(yaw), Float.valueOf(pitch));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addFlightExemption(Player player, int ticks) {
        if (class_PlayerConnection_floatCountField == null) {
            return;
        }
        try {
            Object handle = CompatibilityUtils.getHandle(player);
            Object connection = class_EntityPlayer_playerConnectionField.get(handle);
            class_PlayerConnection_floatCountField.set(connection, -ticks);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isValidProjectileClass(Class<?> projectileType) {
        return projectileType != null && (class_EntityArrow.isAssignableFrom(projectileType) || class_EntityProjectile.isAssignableFrom(projectileType) || class_EntityFireball.isAssignableFrom(projectileType));
    }

    public static Projectile spawnProjectile(Class<?> projectileType, Location location, Vector direction, ProjectileSource source, float speed, float spread, float spreadLocations, Random random) {
        Constructor<?> constructor = null;
        Method shootMethod = null;
        Method setPositionRotationMethod = null;
        Field projectileSourceField = null;
        Field dirXField = null;
        Field dirYField = null;
        Field dirZField = null;
        Object nmsWorld = CompatibilityUtils.getHandle(location.getWorld());
        Projectile projectile = null;
        try {
            Entity entity;
            constructor = projectileType.getConstructor(class_World);
            if (class_EntityFireball.isAssignableFrom(projectileType)) {
                dirXField = projectileType.getField("dirX");
                dirYField = projectileType.getField("dirY");
                dirZField = projectileType.getField("dirZ");
            }
            if (class_EntityProjectile.isAssignableFrom(projectileType) || class_EntityArrow.isAssignableFrom(projectileType)) {
                shootMethod = projectileType.getMethod("shoot", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            }
            setPositionRotationMethod = projectileType.getMethod("setPositionRotation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
            projectileSourceField = projectileType.getField("projectileSource");
            Object nmsProjectile = null;
            try {
                nmsProjectile = constructor.newInstance(nmsWorld);
            }
            catch (Exception ex) {
                nmsProjectile = null;
                Bukkit.getLogger().log(Level.WARNING, "Error spawning projectile of class " + projectileType.getName(), ex);
            }
            if (nmsProjectile == null) {
                throw new Exception("Failed to spawn projectile of class " + projectileType.getName());
            }
            if (dirXField != null && dirYField != null && dirZField != null) {
                double spreadWeight = Math.min((double)0.4f, (double)spread * (double)0.0075f);
                double dx = (double)speed * (direction.getX() + random.nextGaussian() * spreadWeight);
                double dy = (double)speed * (direction.getY() + random.nextGaussian() * spreadWeight);
                double dz = (double)speed * (direction.getZ() + random.nextGaussian() * spreadWeight);
                dirXField.set(nmsProjectile, dx * 0.1);
                dirYField.set(nmsProjectile, dy * 0.1);
                dirZField.set(nmsProjectile, dz * 0.1);
            }
            Vector modifiedLocation = location.toVector().clone();
            if (class_EntityFireball.isAssignableFrom(projectileType) && spreadLocations > 0.0f) {
                modifiedLocation.setX(modifiedLocation.getX() + direction.getX() + random.nextGaussian() * (double)spread / 5.0);
                modifiedLocation.setY(modifiedLocation.getY() + direction.getY() + random.nextGaussian() * (double)spread / 5.0);
                modifiedLocation.setZ(modifiedLocation.getZ() + direction.getZ() + random.nextGaussian() * (double)spread / 5.0);
            }
            setPositionRotationMethod.invoke(nmsProjectile, modifiedLocation.getX(), modifiedLocation.getY(), modifiedLocation.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
            if (shootMethod != null) {
                shootMethod.invoke(nmsProjectile, direction.getX(), direction.getY(), direction.getZ(), Float.valueOf(speed), Float.valueOf(spread));
            }
            if ((entity = NMSUtils.getBukkitEntity(nmsProjectile)) == null || !(entity instanceof Projectile)) {
                throw new Exception("Got invalid bukkit entity from projectile of class " + projectileType.getName());
            }
            projectile = (Projectile)entity;
            if (source != null) {
                projectile.setShooter(source);
                projectileSourceField.set(nmsProjectile, source);
            }
            class_World_addEntityMethod.invoke(nmsWorld, nmsProjectile, CreatureSpawnEvent.SpawnReason.DEFAULT);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        return projectile;
    }

    public static void setDamage(Projectile projectile, double damage) {
        if (class_EntityArrow_damageField == null) {
            return;
        }
        try {
            Object handle = CompatibilityUtils.getHandle((Entity)projectile);
            class_EntityArrow_damageField.set(handle, damage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void decreaseLifespan(Projectile projectile, int ticks) {
        if (class_EntityArrow_lifeField == null) {
            return;
        }
        try {
            Object handle = CompatibilityUtils.getHandle((Entity)projectile);
            int currentLife = (Integer)class_EntityArrow_lifeField.get(handle);
            if (currentLife < ticks) {
                class_EntityArrow_lifeField.set(handle, ticks);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Entity spawnEntity(Location target, EntityType entityType, CreatureSpawnEvent.SpawnReason spawnReason) {
        Entity entity;
        block6: {
            if (class_CraftWorld_spawnMethod == null) {
                return target.getWorld().spawnEntity(target, entityType);
            }
            entity = null;
            try {
                World world = target.getWorld();
                try {
                    if (!class_CraftWorld_spawnMethod_isLegacy) {
                        entity = (Entity)class_CraftWorld_spawnMethod.invoke((Object)world, target, entityType.getEntityClass(), null, spawnReason);
                        break block6;
                    }
                    entity = (Entity)class_CraftWorld_spawnMethod.invoke((Object)world, target, entityType.getEntityClass(), spawnReason);
                }
                catch (Exception ex) {
                    entity = target.getWorld().spawnEntity(target, entityType);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return entity;
    }

    public static String getResourcePack(Server server) {
        String rp = null;
        try {
            Object minecraftServer = CompatibilityUtils.getHandle(server);
            if (minecraftServer != null) {
                rp = (String)class_MinecraftServer_getResourcePackMethod.invoke(minecraftServer, new Object[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rp;
    }

    public static boolean setResourcePack(Player player, String rp, byte[] hash) {
        try {
            String hashString = BaseEncoding.base16().lowerCase().encode(hash);
            class_EntityPlayer_setResourcePackMethod.invoke(CompatibilityUtils.getHandle(player), rp, hashString);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean removeItemAttribute(ItemStack item, Attribute attribute) {
        try {
            Object handle = CompatibilityUtils.getHandle(item);
            if (handle == null) {
                return false;
            }
            Object tag = CompatibilityUtils.getTag(handle);
            if (tag == null) {
                return false;
            }
            String attributeName = null;
            switch (attribute) {
                case GENERIC_ATTACK_SPEED: {
                    attributeName = "generic.attackSpeed";
                    break;
                }
                case GENERIC_ATTACK_DAMAGE: {
                    attributeName = "generic.attackDamage";
                    break;
                }
                case GENERIC_MOVEMENT_SPEED: {
                    attributeName = "generic.movementSpeed";
                    break;
                }
            }
            if (attributeName == null) {
                return false;
            }
            Object attributesNode = CompatibilityUtils.getNode(tag, "AttributeModifiers");
            if (attributesNode == null) {
                return false;
            }
            int size = (Integer)class_NBTTagList_sizeMethod.invoke(attributesNode, new Object[0]);
            for (int i = 0; i < size; ++i) {
                Object candidate = class_NBTTagList_getMethod.invoke(attributesNode, i);
                String key = CompatibilityUtils.getMetaString(candidate, "AttributeName");
                if (!key.equals(attributeName)) continue;
                if (size == 1) {
                    CompatibilityUtils.removeMeta(tag, "AttributeModifiers");
                } else {
                    class_NBTTagList_removeMethod.invoke(attributesNode, i);
                }
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean setItemAttribute(ItemStack item, Attribute attribute, double value, String slot) {
        try {
            Object handle = CompatibilityUtils.getHandle(item);
            if (handle == null) {
                return false;
            }
            Object tag = CompatibilityUtils.getTag(handle);
            if (tag == null) {
                return false;
            }
            Object attributesNode = CompatibilityUtils.getNode(tag, "AttributeModifiers");
            Object attributeNode = null;
            String attributeName = null;
            UUID attributeUUID = null;
            int attributeOperation = 0;
            switch (attribute) {
                case GENERIC_ATTACK_SPEED: {
                    attributeName = "generic.attackSpeed";
                    attributeUUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
                    break;
                }
                case GENERIC_ATTACK_DAMAGE: {
                    attributeName = "generic.attackDamage";
                    attributeUUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
                    break;
                }
                case GENERIC_MOVEMENT_SPEED: {
                    attributeName = "generic.movementSpeed";
                    attributeUUID = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
                    break;
                }
                case GENERIC_MAX_HEALTH: {
                    attributeName = "generic.maxHealth";
                    attributeUUID = UUID.fromString("5D6F0BA2-1186-46AC-B896-C61C5CEE99CC");
                    break;
                }
                case GENERIC_LUCK: {
                    attributeName = "generic.luck";
                    attributeUUID = UUID.fromString("03C3C89D-7037-4B42-869F-B146BCB64D2E");
                    break;
                }
                case GENERIC_ARMOR: {
                    attributeName = "generic.armor";
                    attributeUUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
                    break;
                }
            }
            if (attributeName == null) {
                return false;
            }
            if (attributesNode == null) {
                attributesNode = class_NBTTagList.newInstance();
                class_NBTTagCompound_setMethod.invoke(tag, "AttributeModifiers", attributesNode);
            } else {
                int size = (Integer)class_NBTTagList_sizeMethod.invoke(attributesNode, new Object[0]);
                for (int i = 0; i < size; ++i) {
                    Object candidate = class_NBTTagList_getMethod.invoke(attributesNode, i);
                    String key = CompatibilityUtils.getMetaString(candidate, "AttributeName");
                    if (!key.equals(attributeName)) continue;
                    attributeNode = candidate;
                    break;
                }
            }
            if (attributeNode == null) {
                attributeNode = class_NBTTagCompound.newInstance();
                CompatibilityUtils.setMeta(attributeNode, "AttributeName", attributeName);
                CompatibilityUtils.setMeta(attributeNode, "Name", "Equipment Modifier");
                CompatibilityUtils.setMetaInt(attributeNode, "Operation", attributeOperation);
                CompatibilityUtils.setMetaLong(attributeNode, "UUIDMost", attributeUUID.getMostSignificantBits());
                CompatibilityUtils.setMetaLong(attributeNode, "UUIDLeast", attributeUUID.getLeastSignificantBits());
                if (slot != null) {
                    CompatibilityUtils.setMeta(attributeNode, "Slot", slot);
                }
                class_NBTTagList_addMethod.invoke(attributesNode, attributeNode);
            }
            CompatibilityUtils.setMetaDouble(attributeNode, "Amount", value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static void sendExperienceUpdate(Player player, float experience, int level) {
        try {
            Object packet = class_PacketPlayOutExperience_Constructor.newInstance(Float.valueOf(experience), player.getTotalExperience(), level);
            CompatibilityUtils.sendPacket(player, packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Object getEntityData(Entity entity) {
        if (class_Entity_saveMethod == null) {
            return null;
        }
        Object data = null;
        try {
            Object nmsEntity = CompatibilityUtils.getHandle(entity);
            if (nmsEntity != null) {
                data = class_NBTTagCompound.newInstance();
                class_Entity_saveMethod.invoke(nmsEntity, data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return data;
    }

    public static String getEntityType(Entity entity) {
        if (class_Entity_getTypeMethod == null) {
            return null;
        }
        String entityType = null;
        try {
            Object nmsEntity = CompatibilityUtils.getHandle(entity);
            if (nmsEntity != null) {
                entityType = (String)class_Entity_getTypeMethod.invoke(nmsEntity, new Object[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return entityType;
    }

    public static void applyItemData(ItemStack item, Block block) {
        try {
            Object entityDataTag = CompatibilityUtils.getNode(item, "BlockEntityTag");
            if (entityDataTag == null) {
                return;
            }
            NMSUtils.setTileEntityData(block.getLocation(), entityDataTag);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void swingOffhand(Entity entity, int range) {
        int rangeSquared = range * range;
        String worldName = entity.getWorld().getName();
        Location center = entity.getLocation();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().getName().equals(worldName) || player.getLocation().distanceSquared(center) > (double)rangeSquared) continue;
            CompatibilityUtils.swingOffhand(player, entity);
        }
    }

    public static void swingOffhand(Player sendToPlayer, Entity entity) {
        try {
            Object packet = class_PacketPlayOutAnimation_Constructor.newInstance(CompatibilityUtils.getHandle(entity), 3);
            CompatibilityUtils.sendPacket(sendToPlayer, packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void sendTitle(Player player, String title, String subTitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(title, subTitle);
    }

    public static boolean sendActionBar(Player player, String message) {
        if (class_PacketPlayOutChat == null) {
            return false;
        }
        try {
            Object chatComponent = class_ChatComponentText_constructor.newInstance(message);
            Object packet = enum_ChatMessageType_GAME_INFO == null ? class_PacketPlayOutChat_constructor.newInstance(chatComponent, (byte)2) : class_PacketPlayOutChat_constructor.newInstance(chatComponent, enum_ChatMessageType_GAME_INFO);
            CompatibilityUtils.sendPacket(player, packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static float getDurability(Material material) {
        if (class_Block_durabilityField == null || class_CraftMagicNumbers_getBlockMethod == null) {
            return 0.0f;
        }
        try {
            Object block = class_CraftMagicNumbers_getBlockMethod.invoke(null, material);
            if (block == null) {
                return 0.0f;
            }
            return ((Float)class_Block_durabilityField.get(block)).floatValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0f;
        }
    }

    private static void sendBreaking(Player player, long id, Location location, int breakAmount) {
        try {
            Object blockPosition = class_BlockPosition_Constructor.newInstance(location.getX(), location.getY(), location.getZ());
            Object packet = class_PacketPlayOutBlockBreakAnimation_Constructor.newInstance((int)id, blockPosition, breakAmount);
            CompatibilityUtils.sendPacket(player, packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static int getBlockEntityId(Block block) {
        return (block.getX() & 0xFFF) << 20 | (block.getZ() & 0xFFF) << 8 | block.getY() & 0xFF;
    }

    public static void setBreaking(Block block, int breakAmount, int range) {
        String worldName = block.getWorld().getName();
        Location location = block.getLocation();
        int rangeSquared = range * range;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().getName().equals(worldName) || player.getLocation().distanceSquared(location) > (double)rangeSquared) continue;
            CompatibilityUtils.sendBreaking(player, CompatibilityUtils.getBlockEntityId(block), location, breakAmount);
        }
    }

    public static Set<String> getTags(Entity entity) {
        return null;
    }

    public static boolean isJumping(LivingEntity entity) {
        if (class_Entity_jumpingField == null) {
            return false;
        }
        try {
            return (Boolean)class_Entity_jumpingField.get(CompatibilityUtils.getHandle(entity));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static float getForwardMovement(LivingEntity entity) {
        if (class_Entity_moveForwardField == null) {
            return 0.0f;
        }
        try {
            return ((Float)class_Entity_moveForwardField.get(CompatibilityUtils.getHandle(entity))).floatValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0f;
        }
    }

    public static float getStrafeMovement(LivingEntity entity) {
        if (class_Entity_moveStrafingField == null) {
            return 0.0f;
        }
        try {
            return ((Float)class_Entity_moveStrafingField.get(CompatibilityUtils.getHandle(entity))).floatValue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0f;
        }
    }
}

