/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.listeners;

import java.util.ArrayList;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.SignHelper;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Squid;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class PSEntityListener
implements Listener {
    private final PreciousStones plugin = PreciousStones.getInstance();

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityTarget(EntityTargetEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getEntity().getLocation().getWorld())) {
            return;
        }
        Entity target = event.getTarget();
        if (target instanceof Player && event.getReason().equals((Object)EntityTargetEvent.TargetReason.CLOSEST_PLAYER) && event.getTarget() instanceof Player) {
            Entity mob;
            Player player = (Player)event.getTarget();
            Field field = this.plugin.getForceFieldManager().getEnabledSourceField(target.getLocation(), FieldFlag.REMOVE_MOB);
            if (field != null && FieldFlag.REMOVE_MOB.applies(field, player) && (mob = event.getEntity()) instanceof Monster) {
                mob.remove();
            }
            if (this.plugin.getForceFieldManager().hasSourceField(target.getLocation(), FieldFlag.PREVENT_MOB_DAMAGE)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        Field field;
        Player player;
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).getFoodLevel() < event.getFoodLevel() && (field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.TELEPORT_ON_FEEDING)) != null && FieldFlag.TELEPORT_ON_FEEDING.applies(field, player)) {
            event.setCancelled(true);
            this.plugin.getTeleportationManager().teleport((Entity)player, field, "teleportAnnounceFeeding");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageByBlock(EntityDamageByBlockEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL)) {
                if (this.plugin.getVelocityManager().isFallDamageImmune(player)) {
                    event.setCancelled(true);
                    this.plugin.getCommunicationManager().showThump(player);
                    return;
                }
                Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.NO_FALL_DAMAGE);
                if (field != null && FieldFlag.NO_FALL_DAMAGE.applies(field, player)) {
                    this.plugin.getCommunicationManager().showThump(player);
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        Field field;
        if (event.isCancelled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Location loc = event.getLocation();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(loc.getWorld())) {
            return;
        }
        if ((entity instanceof Monster || entity instanceof Slime || entity instanceof Squid) && (field = this.plugin.getForceFieldManager().getEnabledSourceField(loc, FieldFlag.PREVENT_MOB_SPAWN)) != null) {
            event.setCancelled(true);
        }
        if (entity instanceof Animals && (field = this.plugin.getForceFieldManager().getEnabledSourceField(loc, FieldFlag.PREVENT_ANIMAL_SPAWN)) != null) {
            event.setCancelled(true);
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(loc, FieldFlag.POTIONS)) != null) {
            List<String> types = field.getSettings().getPotionTargets();
            this.plugin.getPotionManager().addEffectToEntity(field, event.getEntity(), types);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getEntity().getLocation().getWorld())) {
            return;
        }
        if (this.plugin.getForceFieldManager().hasSourceField(event.getEntity().getLocation(), FieldFlag.PREVENT_EXPLOSIONS)) {
            event.setCancelled(true);
        }
        if (event.getEntity() instanceof Creeper && this.plugin.getForceFieldManager().hasSourceField(event.getEntity().getLocation(), FieldFlag.PREVENT_CREEPER_EXPLOSIONS)) {
            event.setCancelled(true);
        }
        if (event.getEntity() instanceof TNTPrimed && this.plugin.getForceFieldManager().hasSourceField(event.getEntity().getLocation(), FieldFlag.PREVENT_TNT_EXPLOSIONS)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ArrayList<BlockEntry> saved = new ArrayList<BlockEntry>();
        ArrayList<BlockEntry> unprotected = new ArrayList<BlockEntry>();
        ArrayList<BlockEntry> revert = new ArrayList<BlockEntry>();
        ArrayList<BlockEntry> tnts = new ArrayList<BlockEntry>();
        Field rollbackField = null;
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getLocation().getWorld())) {
            return;
        }
        List blocks = event.blockList();
        for (Block block : blocks) {
            Field field;
            if (this.plugin.getSettingsManager().isUnbreakableType(block) && this.plugin.getUnbreakableManager().isUnbreakable(block)) {
                revert.add(new BlockEntry(block));
                block.setType(Material.AIR, false);
                continue;
            }
            if (this.plugin.getForceFieldManager().isField(block)) {
                field = this.plugin.getForceFieldManager().getField(block);
                if (field.hasFlag(FieldFlag.BREAKABLE)) {
                    this.plugin.getForceFieldManager().deleteField(field);
                    continue;
                }
                revert.add(new BlockEntry(block));
                block.setType(Material.AIR, false);
                continue;
            }
            if (this.plugin.getForceFieldManager().hasSourceField(block.getLocation(), FieldFlag.PREVENT_EXPLOSIONS)) {
                saved.add(new BlockEntry(block));
                event.setCancelled(true);
                continue;
            }
            if (SignHelper.cannotBreakFieldSign(block, null)) {
                event.setCancelled(true);
                return;
            }
            if (event.getEntity() instanceof Creeper && this.plugin.getForceFieldManager().hasSourceField(event.getEntity().getLocation(), FieldFlag.PREVENT_CREEPER_EXPLOSIONS)) {
                saved.add(new BlockEntry(block));
                event.setCancelled(true);
                continue;
            }
            if ((event.getEntity() instanceof Wither || event.getEntity() instanceof WitherSkull) && this.plugin.getForceFieldManager().hasSourceField(event.getEntity().getLocation(), FieldFlag.PREVENT_WITHER_EXPLOSIONS)) {
                saved.add(new BlockEntry(block));
                event.setCancelled(true);
                continue;
            }
            if (event.getEntity() instanceof TNTPrimed && this.plugin.getForceFieldManager().hasSourceField(event.getEntity().getLocation(), FieldFlag.PREVENT_TNT_EXPLOSIONS)) {
                saved.add(new BlockEntry(block));
                event.setCancelled(true);
                continue;
            }
            rollbackField = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.ROLLBACK_EXPLOSIONS);
            if (rollbackField != null) {
                if (block.getType() != Material.TNT) {
                    this.plugin.getGriefUndoManager().addBlock(rollbackField, block, true);
                    continue;
                }
                tnts.add(new BlockEntry(block));
                continue;
            }
            field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.GRIEF_REVERT);
            if (field != null && !field.getSettings().canGrief(new BlockTypeEntry(block.getType()))) {
                if (block.getType() == Material.TNT) {
                    tnts.add(new BlockEntry(block));
                    block.setType(Material.AIR);
                } else if (!this.plugin.getSettingsManager().isGriefUndoBlackListType(block.getType())) {
                    saved.add(new BlockEntry(block));
                    this.plugin.getGriefUndoManager().addBlock(field, block, true);
                }
                if (!saved.isEmpty()) {
                    this.plugin.getStorageManager().offerGrief(field);
                }
            } else {
                unprotected.add(new BlockEntry(block));
            }
            if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.TRANSLOCATION)) == null || !field.isNamed()) continue;
            this.plugin.getTranslocationManager().removeBlock(field, block);
        }
        if (event.isCancelled()) {
            event.getLocation().getWorld().createExplosion(event.getLocation(), 0.0f, false);
            event.getLocation().getWorld().playEffect(event.getLocation(), Effect.SMOKE, 1);
        }
        if (!tnts.isEmpty()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                for (BlockEntry db : tnts) {
                    Block block = db.getLocation().getWorld().getBlockAt(db.getLocation());
                    if (block == null) continue;
                    Location midloc = new Location(block.getWorld(), (double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5);
                    block.getWorld().spawn(midloc, TNTPrimed.class);
                    block.setType(Material.AIR);
                }
                tnts.clear();
            }, 10L);
        }
        if (rollbackField != null) {
            Field field = rollbackField;
            field.setProgress(true);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                this.plugin.getGriefUndoManager().undoDirtyGrief(field);
                field.setProgress(false);
            }, 2L);
        }
        if (!revert.isEmpty()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                for (BlockEntry db : revert) {
                    Block block = db.getLocation().getBlock();
                    block.setType(db.getType(), true);
                }
                revert.clear();
            }, 3L);
        }
        if (!saved.isEmpty() && !unprotected.isEmpty()) {
            event.setCancelled(true);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                for (BlockEntry db : unprotected) {
                    Block block = db.getLocation().getWorld().getBlockAt(db.getLocation());
                    if (!this.plugin.getPermissionsManager().canBuild(null, block.getLocation())) continue;
                    block.setType(Material.AIR);
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemSpawn(ItemSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Field rollbackField = this.plugin.getForceFieldManager().getEnabledSourceField(event.getLocation(), FieldFlag.ROLLBACK_EXPLOSIONS);
        if (rollbackField != null && rollbackField.isProgress()) {
            event.setCancelled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamage(EntityDamageEvent event) {
        Field field;
        Player attacker;
        Player victim;
        EntityDamageByEntityEvent sub;
        block39: {
            Projectile projectile;
            Player player;
            Field field2;
            Field field3;
            Player player2;
            if (event.isCancelled()) {
                return;
            }
            if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getEntity().getLocation().getWorld())) {
                return;
            }
            if (event.getEntity().getType().equals((Object)EntityType.ITEM_FRAME) && (player2 = Helper.getDamagingPlayer(event)) != null && !this.plugin.getPermissionsManager().has(player2, "preciousstones.bypass.item-frame-take") && (field3 = this.plugin.getForceFieldManager().getEnabledSourceField(event.getEntity().getLocation(), FieldFlag.PREVENT_ITEM_FRAME_TAKE)) != null && FieldFlag.PREVENT_ITEM_FRAME_TAKE.applies(field3, player2)) {
                event.setCancelled(true);
            }
            if (event.getEntity().getType().equals((Object)EntityType.ARMOR_STAND) && ((player2 = Helper.getDamagingPlayer(event)) != null && !this.plugin.getPermissionsManager().has(player2, "preciousstones.bypass.armor-stand-take") || player2 == null) && (field3 = this.plugin.getForceFieldManager().getEnabledSourceField(event.getEntity().getLocation(), FieldFlag.PROTECT_ARMOR_STANDS)) != null) {
                if (player2 != null) {
                    if (FieldFlag.PROTECT_ARMOR_STANDS.applies(field3, player2)) {
                        event.setCancelled(true);
                    }
                } else {
                    event.setCancelled(true);
                }
            }
            if (event.getEntity() instanceof Player) {
                player2 = (Player)event.getEntity();
                field3 = this.plugin.getForceFieldManager().getEnabledSourceField(player2.getLocation(), FieldFlag.TELEPORT_ON_DAMAGE);
                if (field3 != null && FieldFlag.TELEPORT_ON_DAMAGE.applies(field3, player2)) {
                    event.setCancelled(true);
                    this.plugin.getTeleportationManager().teleport((Entity)player2, field3, "teleportAnnounceDamage");
                }
                if (player2.getHealth() - event.getDamage() < 0.0 && (field3 = this.plugin.getForceFieldManager().getEnabledSourceField(player2.getLocation(), FieldFlag.TELEPORT_BEFORE_DEATH)) != null && FieldFlag.TELEPORT_BEFORE_DEATH.applies(field3, player2)) {
                    event.setCancelled(true);
                    this.plugin.getTeleportationManager().teleport((Entity)player2, field3, "teleportAnnounceDeath");
                }
            }
            if (event.getEntity() instanceof Ageable && (field2 = this.plugin.getForceFieldManager().getEnabledSourceField(event.getEntity().getLocation(), FieldFlag.PROTECT_ANIMALS)) != null && event instanceof EntityDamageByEntityEvent) {
                player = Helper.getDamagingPlayer(event);
                if (player != null) {
                    if (FieldFlag.PROTECT_ANIMALS.applies(field2, player)) {
                        event.setCancelled(true);
                        return;
                    }
                } else if (field2.hasFlag(FieldFlag.PROTECT_ANIMALS)) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (event.getEntity() instanceof Villager && (field2 = this.plugin.getForceFieldManager().getEnabledSourceField(event.getEntity().getLocation(), FieldFlag.PROTECT_VILLAGERS)) != null && event instanceof EntityDamageByEntityEvent) {
                player = Helper.getDamagingPlayer(event);
                if (player != null) {
                    if (FieldFlag.PROTECT_VILLAGERS.applies(field2, player)) {
                        event.setCancelled(true);
                        return;
                    }
                } else if (field2.hasFlag(FieldFlag.PROTECT_VILLAGERS)) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (event.getEntity() instanceof Monster || event.getEntity() instanceof Golem || event.getEntity() instanceof WaterMob) {
                field2 = this.plugin.getForceFieldManager().getEnabledSourceField(event.getEntity().getLocation(), FieldFlag.PROTECT_MOBS);
                if (field2 == null || !(event instanceof EntityDamageByEntityEvent)) return;
                player = Helper.getDamagingPlayer(event);
                if (player != null) {
                    if (!FieldFlag.PROTECT_MOBS.applies(field2, player)) return;
                    event.setCancelled(true);
                    return;
                } else {
                    if (!field2.hasFlag(FieldFlag.PROTECT_MOBS)) return;
                    event.setCancelled(true);
                    return;
                }
            }
            if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL) && event.getEntity() instanceof Player) {
                player2 = (Player)event.getEntity();
                if (this.plugin.getVelocityManager().isFallDamageImmune(player2)) {
                    event.setCancelled(true);
                    this.plugin.getCommunicationManager().showThump(player2);
                    return;
                }
                field3 = this.plugin.getForceFieldManager().getEnabledSourceField(player2.getLocation(), FieldFlag.NO_FALL_DAMAGE);
                if (field3 != null && FieldFlag.NO_FALL_DAMAGE.applies(field3, player2)) {
                    this.plugin.getCommunicationManager().showThump(player2);
                    event.setCancelled(true);
                }
            }
            if (!(event instanceof EntityDamageByEntityEvent) || !((sub = (EntityDamageByEntityEvent)event).getEntity() instanceof Player)) return;
            victim = (Player)sub.getEntity();
            attacker = null;
            if (sub.getDamager() instanceof Player) {
                attacker = (Player)sub.getDamager();
            } else if (sub.getDamager() instanceof Projectile && (projectile = (Projectile)sub.getDamager()).getShooter() instanceof Player) {
                attacker = (Player)projectile.getShooter();
            }
            if (attacker == null) return;
            field = this.plugin.getForceFieldManager().getEnabledSourceField(victim.getLocation(), FieldFlag.PREVENT_PVP);
            if (field != null) {
                if (this.plugin.getPermissionsManager().has(attacker, "preciousstones.bypass.pvp")) {
                    this.plugin.getCommunicationManager().warnBypassPvP(attacker, victim, field);
                    break block39;
                } else {
                    if (this.plugin.getCombatTagManager().isInCombat(attacker) && this.plugin.getCombatTagManager().isInCombat(victim)) {
                        this.plugin.getCommunicationManager().warnBypassPvPDueToCombat(attacker, victim);
                        return;
                    }
                    sub.setCancelled(true);
                    this.plugin.getCommunicationManager().warnPvP(attacker, victim, field);
                    return;
                }
            }
            field = this.plugin.getForceFieldManager().getEnabledSourceField(attacker.getLocation(), FieldFlag.PREVENT_PVP);
            if (field != null) {
                if (!this.plugin.getPermissionsManager().has(attacker, "preciousstones.bypass.pvp")) {
                    sub.setCancelled(true);
                    this.plugin.getCommunicationManager().warnPvP(attacker, victim, field);
                    return;
                }
                this.plugin.getCommunicationManager().warnBypassPvP(attacker, victim, field);
            }
        }
        field = this.plugin.getForceFieldManager().getEnabledSourceField(victim.getLocation(), FieldFlag.TELEPORT_ON_PVP);
        if (field == null || !FieldFlag.TELEPORT_ON_PVP.applies(field, attacker.getName())) return;
        sub.setCancelled(true);
        this.plugin.getTeleportationManager().teleport((Entity)attacker, field, "teleportAnnouncePvp");
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityCombustByEntityEvent(EntityCombustByEntityEvent event) {
        Field field;
        Player attacker;
        Player victim;
        block27: {
            Arrow arrow;
            Player player;
            Field field2;
            if (event.isCancelled()) {
                return;
            }
            if (event.getEntity() instanceof Ageable && (field2 = this.plugin.getForceFieldManager().getEnabledSourceField(event.getEntity().getLocation(), FieldFlag.PROTECT_ANIMALS)) != null) {
                if (event.getCombuster() instanceof Player) {
                    player = (Player)event.getCombuster();
                    if (FieldFlag.PROTECT_ANIMALS.applies(field2, player)) {
                        event.setCancelled(true);
                        return;
                    }
                } else if (field2.hasFlag(FieldFlag.PROTECT_ANIMALS)) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (event.getEntity() instanceof Villager && (field2 = this.plugin.getForceFieldManager().getEnabledSourceField(event.getEntity().getLocation(), FieldFlag.PROTECT_VILLAGERS)) != null) {
                if (event.getCombuster() instanceof Player) {
                    player = (Player)event.getCombuster();
                    if (FieldFlag.PROTECT_VILLAGERS.applies(field2, player)) {
                        event.setCancelled(true);
                        return;
                    }
                } else if (field2.hasFlag(FieldFlag.PROTECT_VILLAGERS)) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (event.getEntity() instanceof Monster || event.getEntity() instanceof Golem || event.getEntity() instanceof WaterMob) {
                field2 = this.plugin.getForceFieldManager().getEnabledSourceField(event.getEntity().getLocation(), FieldFlag.PROTECT_MOBS);
                if (field2 == null) return;
                if (event.getCombuster() instanceof Player) {
                    player = (Player)event.getCombuster();
                    if (!FieldFlag.PROTECT_MOBS.applies(field2, player)) return;
                    event.setCancelled(true);
                    return;
                } else {
                    if (!field2.hasFlag(FieldFlag.PROTECT_MOBS)) return;
                    event.setCancelled(true);
                    return;
                }
            }
            if (!(event.getEntity() instanceof Player)) return;
            victim = (Player)event.getEntity();
            attacker = null;
            if (event.getCombuster() instanceof Player) {
                attacker = (Player)event.getCombuster();
            } else if (event.getCombuster() instanceof Arrow && (arrow = (Arrow)event.getCombuster()).getShooter() instanceof Player) {
                attacker = (Player)arrow.getShooter();
            }
            if (attacker == null) return;
            field = this.plugin.getForceFieldManager().getEnabledSourceField(victim.getLocation(), FieldFlag.PREVENT_PVP);
            if (field != null) {
                if (this.plugin.getPermissionsManager().has(attacker, "preciousstones.bypass.pvp")) {
                    this.plugin.getCommunicationManager().warnBypassPvP(attacker, victim, field);
                    break block27;
                } else {
                    if (this.plugin.getCombatTagManager().isInCombat(attacker) && this.plugin.getCombatTagManager().isInCombat(victim)) {
                        this.plugin.getCommunicationManager().warnBypassPvPDueToCombat(attacker, victim);
                        return;
                    }
                    event.setCancelled(true);
                    this.plugin.getCommunicationManager().warnPvP(attacker, victim, field);
                    return;
                }
            }
            field = this.plugin.getForceFieldManager().getEnabledSourceField(attacker.getLocation(), FieldFlag.PREVENT_PVP);
            if (field != null) {
                if (!this.plugin.getPermissionsManager().has(attacker, "preciousstones.bypass.pvp")) {
                    event.setCancelled(true);
                    this.plugin.getCommunicationManager().warnPvP(attacker, victim, field);
                    return;
                }
                this.plugin.getCommunicationManager().warnBypassPvP(attacker, victim, field);
            }
        }
        field = this.plugin.getForceFieldManager().getEnabledSourceField(victim.getLocation(), FieldFlag.TELEPORT_ON_PVP);
        if (field == null || !FieldFlag.TELEPORT_ON_PVP.applies(field, attacker.getName())) return;
        event.setCancelled(true);
        this.plugin.getTeleportationManager().teleport((Entity)attacker, field, "teleportAnnouncePvp");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDoorBreak(EntityBreakDoorEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getBlock() == null) {
            return;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getBlock().getLocation().getWorld())) {
            return;
        }
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(event.getBlock().getLocation(), FieldFlag.PREVENT_DESTROY);
        if (field != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteractAtEntityEvent(PlayerInteractAtEntityEvent event) {
        Field field;
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getRightClicked();
        Player player = event.getPlayer();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(entity.getLocation().getWorld())) {
            return;
        }
        if (entity.getType().equals((Object)EntityType.ARMOR_STAND) && player != null && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.armor-stand-take") && (field = this.plugin.getForceFieldManager().getEnabledSourceField(entity.getLocation(), FieldFlag.PROTECT_ARMOR_STANDS)) != null && FieldFlag.PROTECT_ARMOR_STANDS.applies(field, player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            this.plugin.getEntryManager().leaveAllFields(player);
            Player killer = event.getEntity().getKiller();
            if (killer != null) {
                this.plugin.getSnitchManager().recordSnitchPlayerKill(killer, player);
            }
            this.plugin.getCuboidManager().cancelOpenCuboid(player);
        } else {
            Player killer = event.getEntity().getKiller();
            if (killer != null) {
                this.plugin.getSnitchManager().recordSnitchEntityKill(killer, (Entity)event.getEntity());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Field field;
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Entity entity = event.getEntity();
        if (entity == null || block == null) {
            return;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(block.getLocation().getWorld())) {
            return;
        }
        if (entity instanceof Enderman) {
            field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_ENDERMAN_DESTROY);
            if (field != null) {
                event.setCancelled(true);
            }
        } else if ((entity instanceof EnderDragon || entity instanceof Monster || entity instanceof Ghast) && (field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_DESTROY)) != null) {
            event.setCancelled(true);
        }
        if (entity instanceof Player) {
            Field field2;
            Player player = (Player)entity;
            if (this.plugin.getSettingsManager().isCrop(block) && (field2 = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PROTECT_CROPS)) != null && FieldFlag.PROTECT_CROPS.applies(field2, player)) {
                event.setCancelled(true);
            }
        } else if (!(entity instanceof Villager) && this.plugin.getSettingsManager().isCrop(block) && (field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PROTECT_CROPS)) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityBlockForm(EntityBlockFormEvent event) {
        BlockState blockState;
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getEntity().getLocation().getWorld())) {
            return;
        }
        if (event.getEntity() instanceof Player && (blockState = event.getNewState()).getType().equals((Object)Material.FROSTED_ICE)) {
            Block block = blockState.getBlock();
            Field field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_PLACE);
            if (field != null) {
                Player player = (Player)event.getEntity();
                if (!field.getSettings().inPlaceBlacklist(block) && FieldFlag.PREVENT_PLACE.applies(field, player) && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place")) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onHangingBreakByEntityEvent(HangingBreakByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Hanging entity = event.getEntity();
        Entity remover = event.getRemover();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(entity.getLocation().getWorld())) {
            return;
        }
        if (remover instanceof Player) {
            Field field;
            Player player = (Player)event.getRemover();
            if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.destroy") && (field = this.plugin.getForceFieldManager().getEnabledSourceField(entity.getLocation(), FieldFlag.PREVENT_DESTROY)) != null && FieldFlag.PREVENT_DESTROY.applies(field, player)) {
                event.setCancelled(true);
                this.plugin.getCommunicationManager().warnDestroyHanging(player, entity, field);
            }
        } else {
            Field field = this.plugin.getForceFieldManager().getEnabledSourceField(entity.getLocation(), FieldFlag.PREVENT_DESTROY);
            if (field != null) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onHangingPlaceEvent(HangingPlaceEvent event) {
        Field field;
        if (event.isCancelled()) {
            return;
        }
        Hanging entity = event.getEntity();
        Player player = event.getPlayer();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(entity.getLocation().getWorld())) {
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place") && (field = this.plugin.getForceFieldManager().getEnabledSourceField(entity.getLocation(), FieldFlag.PREVENT_PLACE)) != null && FieldFlag.PREVENT_PLACE.applies(field, player)) {
            event.setCancelled(true);
            this.plugin.getCommunicationManager().warnPlaceHanging(player, entity, field);
        }
    }

    @EventHandler
    public void onHangingBreakEvent(HangingBreakEvent event) {
        Field field;
        if (event.isCancelled()) {
            return;
        }
        Hanging entity = event.getEntity();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(entity.getLocation().getWorld())) {
            return;
        }
        if (!event.getCause().equals((Object)HangingBreakEvent.RemoveCause.ENTITY) && (field = this.plugin.getForceFieldManager().getEnabledSourceField(entity.getLocation(), FieldFlag.PREVENT_DESTROY)) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPotionSplash(PotionSplashEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ThrownPotion potion = event.getPotion();
        ProjectileSource shooter = potion.getShooter();
        if (shooter != null && shooter instanceof Player) {
            Player player = (Player)shooter;
            Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.PREVENT_POTION_SPLASH);
            if (field != null && FieldFlag.PREVENT_POTION_SPLASH.applies(field, player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProjectileThrow(ProjectileLaunchEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Projectile projectile = event.getEntity();
        ProjectileSource shooter = projectile.getShooter();
        if (shooter != null && shooter instanceof Player) {
            Player player = (Player)shooter;
            Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.NO_PROJECTILE_THROW);
            if (field != null && FieldFlag.NO_PROJECTILE_THROW.applies(field, player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onShearEntity(PlayerShearEntityEvent event) {
        Field field;
        Player player = event.getPlayer();
        if (player != null && (field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.PROTECT_ANIMALS)) != null && FieldFlag.PROTECT_ANIMALS.applies(field, player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareItemCraftEvent(PrepareItemCraftEvent event) {
        ItemStack is = event.getInventory().getResult();
        if (is == null) {
            return;
        }
        BlockTypeEntry type = new BlockTypeEntry(is.getType());
        FieldSettings settings = this.plugin.getSettingsManager().getFieldSettings(type);
        if (settings != null && settings.hasMetaName() && settings.isMetaAutoSet()) {
            HumanEntity entity = event.getView().getPlayer();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                PlayerEntry playerEntry = this.plugin.getPlayerManager().getPlayerEntry(player);
                if (playerEntry.isDisabled()) {
                    return;
                }
            }
            ItemMeta meta = is.getItemMeta();
            meta.setDisplayName(settings.getMetaName());
            meta.setLore(settings.getMetaLore());
            is.setItemMeta(meta);
            event.getInventory().setResult(is);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemDrop(PlayerDropItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(event.getPlayer().getLocation(), FieldFlag.NO_DROPPING_ITEMS);
        if (field != null && FieldFlag.NO_DROPPING_ITEMS.applies(field, event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onCreeperPower(CreeperPowerEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(event.getEntity().getLocation(), FieldFlag.PREVENT_CREEPER_EXPLOSIONS);
        if (field != null) {
            event.setCancelled(true);
        }
    }
}

