/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import org.bukkit.ChatColor;

public class SnitchEntry {
    private String name;
    private String reason;
    private String details;
    private int eventCount;
    private Field field;
    private ZonedDateTime age;

    public SnitchEntry() {
    }

    public SnitchEntry(String name, String reason, String details) {
        this.name = name;
        this.reason = reason;
        this.details = details;
        this.eventCount = 1;
        this.age = LocalDateTime.now().atZone(ZoneId.systemDefault());
    }

    public SnitchEntry(Field field, String name, String reason, String details, int eventCount) {
        this.field = field;
        this.name = name;
        this.reason = reason;
        this.details = details;
        this.eventCount = eventCount;
        this.age = LocalDateTime.now().atZone(ZoneId.systemDefault());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public String getReasonDisplay() {
        String out = this.reason;
        if (this.reason.equals("Block Break")) {
            out = ChatColor.DARK_RED + this.reason;
        }
        if (this.reason.equals("Block Place")) {
            out = ChatColor.DARK_RED + this.reason;
        }
        if (this.reason.equals("Entry")) {
            out = ChatColor.BLUE + this.reason;
        }
        if (this.reason.equals("Used")) {
            out = ChatColor.GREEN + this.reason;
        }
        if (this.reason.equals("Shopped")) {
            out = ChatColor.GREEN + this.reason;
        }
        if (this.reason.equals("Ignite")) {
            out = ChatColor.DARK_RED + this.reason;
        }
        if (this.getEventCount() > 1) {
            return out + " (" + this.getEventCount() + ")";
        }
        return out;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getDetails() {
        return this.details;
    }

    public void addCount() {
        this.setEventCount(this.getEventCount() + 1);
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public int getAgeInSeconds() {
        ZonedDateTime now = LocalDateTime.now().atZone(ZoneId.systemDefault());
        return (int)ChronoUnit.SECONDS.between(now, this.age);
    }
}

