/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.listeners;

import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.ItemStack;

public class PSVehicleListener
implements Listener {
    private final PreciousStones plugin = PreciousStones.getInstance();

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleCreate(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && item != null && Helper.isBoat(item.getType())) {
            Player player;
            Location loc = event.getClickedBlock().getLocation();
            Field field = this.plugin.getForceFieldManager().getEnabledSourceField(loc, FieldFlag.PREVENT_VEHICLE_CREATE);
            if (field != null && FieldFlag.PREVENT_VEHICLE_CREATE.applies(field, player = event.getPlayer())) {
                if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.use")) {
                    this.plugin.getCommunicationManager().notifyVehicleBypassCreate(player, loc, field);
                } else {
                    event.setCancelled(true);
                    this.plugin.getCommunicationManager().warnCreateVehicle(player, loc, field);
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        Player player;
        Vehicle vehicle = event.getVehicle();
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(vehicle.getLocation(), FieldFlag.PREVENT_VEHICLE_DESTROY);
        if (field != null && event.getAttacker() instanceof Player && FieldFlag.PREVENT_VEHICLE_DESTROY.applies(field, player = (Player)event.getAttacker())) {
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.destroy")) {
                this.plugin.getCommunicationManager().notifyBypassDestroyVehicle(player, vehicle, field);
            } else {
                event.setCancelled(true);
                this.plugin.getCommunicationManager().warnDestroyVehicle(player, vehicle, field);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleMove(VehicleMoveEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(vehicle.getLocation().getWorld())) {
            return;
        }
        List passengers = vehicle.getPassengers();
        for (Entity passenger : passengers) {
            if (!(passenger instanceof Player)) continue;
            this.plugin.getPlayerListener().onPlayerMove(new PlayerMoveEvent((Player)passenger, event.getFrom(), event.getTo()));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleEnter(VehicleEnterEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(vehicle.getLocation().getWorld())) {
            return;
        }
        List passengers = vehicle.getPassengers();
        for (Entity passenger : passengers) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.PREVENT_VEHICLE_ENTER);
            if (field == null || !FieldFlag.PREVENT_VEHICLE_ENTER.applies(field, player)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleExit(VehicleExitEvent event) {
        Vehicle vehicle = event.getVehicle();
        List passengers = vehicle.getPassengers();
        for (Entity passenger : passengers) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.PREVENT_VEHICLE_EXIT);
            if (field == null || !FieldFlag.PREVENT_VEHICLE_EXIT.applies(field, player)) continue;
            event.setCancelled(true);
        }
    }
}

