/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.DirtyFieldReason;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PaymentEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.RentEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class FlagsModule {
    private Field field;
    private List<FieldFlag> flags = new ArrayList<FieldFlag>();
    private List<FieldFlag> disabledFlags = new ArrayList<FieldFlag>();
    private List<FieldFlag> insertedFlags = new ArrayList<FieldFlag>();
    private List<FieldFlag> clearedFlags = new ArrayList<FieldFlag>();

    public FlagsModule(Field field) {
        this.field = field;
    }

    public void addFlag(FieldFlag flag) {
        this.flags.add(flag);
    }

    public void addDisabledFlag(FieldFlag flag) {
        this.flags.remove((Object)flag);
        this.disabledFlags.add(flag);
    }

    public boolean hasFlag(FieldFlag flag) {
        boolean ret = this.flags.contains((Object)flag);
        if (!ret) {
            ret = this.insertedFlags.contains((Object)flag);
        }
        if (this.disabledFlags.contains((Object)flag)) {
            ret = false;
        }
        return ret;
    }

    public boolean hasFlag(String flagStr) {
        return this.hasFlag(Helper.toFieldFlag(flagStr));
    }

    public String getFlagsAsString() {
        JSONObject json = new JSONObject();
        JSONArray disabledFlags = new JSONArray();
        disabledFlags.addAll(this.getDisabledFlagsStringList());
        JSONArray clearedFlags = new JSONArray();
        clearedFlags.addAll(this.getClearedFlagsStringList());
        JSONArray insertedFlags = new JSONArray();
        insertedFlags.addAll(this.getInsertedFlagsStringList());
        JSONArray renterList = new JSONArray();
        renterList.addAll(this.field.getRentingModule().getRentersString());
        JSONArray paymentList = new JSONArray();
        paymentList.addAll(this.field.getRentingModule().getPaymentString());
        JSONArray blacklistedCommandsList = new JSONArray();
        blacklistedCommandsList.addAll(this.field.getListingModule().getBlacklistedCommands());
        JSONArray whitelistedBlocksList = new JSONArray();
        whitelistedBlocksList.addAll(this.field.getListingModule().getWhitelistedBlocks());
        JSONArray mergedFields = new JSONArray();
        mergedFields.addAll(this.field.getSettings().getMergedFieldsTypeEntries());
        if (!paymentList.isEmpty()) {
            json.put((Object)"payments", (Object)paymentList);
        }
        if (!disabledFlags.isEmpty()) {
            json.put((Object)"disabledFlags", (Object)disabledFlags);
        }
        if (!insertedFlags.isEmpty()) {
            json.put((Object)"insertedFlags", (Object)insertedFlags);
        }
        if (!clearedFlags.isEmpty()) {
            json.put((Object)"clearedFlags", (Object)clearedFlags);
        }
        if (!blacklistedCommandsList.isEmpty()) {
            json.put((Object)"blacklistedCommands", (Object)blacklistedCommandsList);
        }
        if (!renterList.isEmpty()) {
            json.put((Object)"renters", (Object)renterList);
        }
        if (this.field.getRevertingModule().getRevertSecs() > 0) {
            json.put((Object)"revertSecs", (Object)this.field.getRevertingModule().getRevertSecs());
        }
        if (this.field.getRentingModule().hasLimitSeconds()) {
            json.put((Object)"limitSeconds", (Object)this.field.getRentingModule().getLimitSeconds());
        }
        if (this.field.isDisabled()) {
            json.put((Object)"disabled", (Object)this.field.isDisabled());
        }
        if (this.field.getHidingModule().isHidden()) {
            json.put((Object)"hidden", (Object)this.field.getHidingModule().isHidden());
        }
        if (this.field.getForestingModule().getForesterUsed() > 0) {
            json.put((Object)"foresterUsed", (Object)this.field.getForestingModule().getForesterUsed());
        }
        if (!this.field.getSettings().getMergedFields().isEmpty()) {
            json.put((Object)"mergedFields", this.field.getSettings().getMergedFields());
        }
        return json.toString();
    }

    public ArrayList<String> getDisabledFlagsStringList() {
        ArrayList<String> ll = new ArrayList<String>();
        for (FieldFlag flag : this.disabledFlags) {
            ll.add(Helper.toFlagStr(flag));
        }
        return ll;
    }

    public ArrayList<String> getInsertedFlagsStringList() {
        ArrayList<String> ll = new ArrayList<String>();
        for (FieldFlag flag : this.insertedFlags) {
            ll.add(Helper.toFlagStr(flag));
        }
        return ll;
    }

    public ArrayList<String> getClearedFlagsStringList() {
        ArrayList<String> ll = new ArrayList<String>();
        for (FieldFlag flag : this.clearedFlags) {
            ll.add(Helper.toFlagStr(flag));
        }
        return ll;
    }

    public List<FieldFlag> getInsertedFlags() {
        return this.insertedFlags;
    }

    public List<FieldFlag> getClearedFlags() {
        return this.clearedFlags;
    }

    public void setFlags(String flagString) {
        JSONObject flags;
        if (flagString != null && !flagString.isEmpty() && (flags = (JSONObject)JSONValue.parse((String)flagString)) != null) {
            for (Object flag : flags.keySet()) {
                try {
                    JSONArray localFlags;
                    if (flag.equals("disabledFlags")) {
                        JSONArray disabledFlags = (JSONArray)flags.get(flag);
                        for (Object flagStr : disabledFlags) {
                            if ((flagStr.toString().equalsIgnoreCase("dynmap-area") || flagStr.toString().equalsIgnoreCase("dynmap-marker")) && this.hasFlag(FieldFlag.DYNMAP_NO_TOGGLE)) continue;
                            this.disableFlag(flagStr.toString(), true);
                        }
                        continue;
                    }
                    if (flag.equals("insertedFlags")) {
                        localFlags = (JSONArray)flags.get(flag);
                        for (Object flagStr : localFlags) {
                            this.insertFieldFlag(flagStr.toString());
                        }
                        continue;
                    }
                    if (flag.equals("clearedFlags")) {
                        localFlags = (JSONArray)flags.get(flag);
                        for (Object flagStr : localFlags) {
                            this.clearFieldFlag(flagStr.toString());
                        }
                        continue;
                    }
                    if (flag.equals("renters")) {
                        JSONArray renterList = (JSONArray)flags.get(flag);
                        this.field.getRentingModule().clearRenters();
                        for (Object flagStr : renterList) {
                            RentEntry entry = new RentEntry(flagStr.toString());
                            this.field.getRentingModule().addRenter(entry);
                        }
                        continue;
                    }
                    if (flag.equals("blacklistedCommands")) {
                        JSONArray blacklistedCommandsList = (JSONArray)flags.get(flag);
                        for (Object flagStr : blacklistedCommandsList) {
                            this.field.getListingModule().getBlacklistedCommands().add(flagStr.toString());
                        }
                        continue;
                    }
                    if (flag.equals("whitelistedBlocks")) {
                        JSONArray whitelistedBlocksList = (JSONArray)flags.get(flag);
                        for (Object flagStr : whitelistedBlocksList) {
                            this.field.getListingModule().getWhitelistedBlocks().add(new BlockTypeEntry(flagStr.toString()));
                        }
                        continue;
                    }
                    if (flag.equals("mergedFields")) {
                        JSONArray mergedFields = (JSONArray)flags.get(flag);
                        for (Object flagStr : mergedFields) {
                            this.field.getSettings().addMergedField(new BlockTypeEntry(flagStr.toString()));
                        }
                        continue;
                    }
                    if (flag.equals("foresterUsed")) {
                        this.field.getForestingModule().setForesterUsed(((Long)flags.get(flag)).intValue());
                        continue;
                    }
                    if (flag.equals("revertSecs")) {
                        this.field.getRevertingModule().setRevertSecs(((Long)flags.get(flag)).intValue());
                        continue;
                    }
                    if (flag.equals("limitSeconds")) {
                        this.field.getRentingModule().setLimitSeconds(((Long)flags.get(flag)).intValue());
                        continue;
                    }
                    if (flag.equals("disabled")) {
                        this.field.setDisabledNoMask((Boolean)flags.get(flag));
                        continue;
                    }
                    if (flag.equals("hidden")) {
                        this.field.getHidingModule().setHidden((Boolean)flags.get(flag));
                        continue;
                    }
                    if (!flag.equals("payments")) continue;
                    JSONArray paymentList = (JSONArray)flags.get(flag);
                    paymentList.clear();
                    for (Object flagStr : paymentList) {
                        this.field.getRentingModule().addPayment(new PaymentEntry(flagStr.toString()));
                    }
                }
                catch (Exception ex) {
                    System.out.print("Failed reading field flag: " + flag);
                    System.out.print("Value: " + flags.get(flag));
                    for (StackTraceElement el : ex.getStackTrace()) {
                        System.out.print(el.toString());
                    }
                }
            }
        }
    }

    public void enableFlag(String flagStr) {
        boolean canEnable = false;
        Iterator<FieldFlag> iter = this.disabledFlags.iterator();
        while (iter.hasNext()) {
            FieldFlag flag = iter.next();
            if (!Helper.toFlagStr(flag).equals(flagStr)) continue;
            iter.remove();
            canEnable = true;
            this.field.addDirty(DirtyFieldReason.FLAGS);
            PreciousStones.debug("DirtyFlags: enableFlag", new Object[0]);
        }
        if (canEnable && !this.flags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.flags.add(Helper.toFieldFlag(flagStr));
        }
    }

    public void disableFlag(String flagStr, boolean skipSave) {
        boolean hasFlag = false;
        Iterator<FieldFlag> iter = this.flags.iterator();
        while (iter.hasNext()) {
            FieldFlag flag = iter.next();
            if (!Helper.toFlagStr(flag).equals(flagStr)) continue;
            iter.remove();
            hasFlag = true;
            if (skipSave) continue;
            this.field.addDirty(DirtyFieldReason.FLAGS);
            PreciousStones.debug("DirtyFlags: disableFlag", new Object[0]);
        }
        if (hasFlag && !this.disabledFlags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.disabledFlags.add(Helper.toFieldFlag(flagStr));
        }
    }

    public boolean hasDisabledFlag(String flagStr) {
        for (FieldFlag flag : this.disabledFlags) {
            if (!Helper.toFlagStr(flag).equals(flagStr)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDisabledFlag(FieldFlag flag) {
        return this.disabledFlags.contains((Object)flag);
    }

    public List<FieldFlag> getDisabledFlags() {
        return Collections.unmodifiableList(this.disabledFlags);
    }

    public boolean toggleFieldFlag(String flagStr) {
        boolean hasFlag = this.hasFlag(flagStr);
        if (hasFlag) {
            this.disableFlag(flagStr, false);
            return false;
        }
        this.enableFlag(flagStr);
        return true;
    }

    public void RevertFlags() {
        this.insertedFlags.clear();
        this.disabledFlags.clear();
        this.flags.clear();
        for (FieldFlag flag : this.field.getSettings().getDefaultFlags()) {
            this.flags.add(flag);
        }
        this.field.addDirty(DirtyFieldReason.FLAGS);
        PreciousStones.debug("DirtyFlags: RevertFlags", new Object[0]);
    }

    public List<FieldFlag> getFlags() {
        return Collections.unmodifiableList(this.flags);
    }

    public boolean clearFieldFlag(String flagStr) {
        boolean cleared = false;
        if (this.insertedFlags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.insertedFlags.remove((Object)Helper.toFieldFlag(flagStr));
            cleared = true;
        }
        if (this.disabledFlags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.disabledFlags.remove((Object)Helper.toFieldFlag(flagStr));
            cleared = true;
        }
        if (this.flags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.flags.remove((Object)Helper.toFieldFlag(flagStr));
            cleared = true;
        }
        this.clearedFlags.add(Helper.toFieldFlag(flagStr));
        return cleared;
    }

    public boolean insertFieldFlag(String flagStr) {
        if (!this.insertedFlags.contains((Object)Helper.toFieldFlag(flagStr))) {
            this.insertedFlags.add(Helper.toFieldFlag(flagStr));
            if (this.clearedFlags.contains((Object)Helper.toFieldFlag(flagStr))) {
                this.clearedFlags.remove((Object)Helper.toFieldFlag(flagStr));
            }
            return true;
        }
        return false;
    }

    public void importFlags(List<FieldFlag> flags) {
        for (FieldFlag flag : flags) {
            this.insertFieldFlag(Helper.toFlagStr(flag));
        }
        this.field.addDirty(DirtyFieldReason.FLAGS);
    }

    public void setBreakable() {
        if (!this.flags.contains((Object)FieldFlag.BREAKABLE) && !this.insertedFlags.contains((Object)FieldFlag.BREAKABLE)) {
            this.insertedFlags.add(FieldFlag.BREAKABLE);
        }
    }

    public void unsetBreakable() {
        if (!this.flags.contains((Object)FieldFlag.BREAKABLE) && this.insertedFlags.contains((Object)FieldFlag.BREAKABLE)) {
            this.insertedFlags.remove((Object)FieldFlag.BREAKABLE);
        }
    }

    public void dirtyFlags(String reason) {
        this.field.addDirty(DirtyFieldReason.FLAGS);
        PreciousStones.debug("DirtyFlags: " + reason, new Object[0]);
        PreciousStones.getInstance().getStorageManager().offerField(this.field);
    }
}

