/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.Collection;
import java.util.TreeMap;
import java.util.UUID;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PlayerManager {
    private PreciousStones plugin;
    private TreeMap<String, PlayerEntry> players = new TreeMap();

    public PlayerManager() {
        this.plugin = PreciousStones.getInstance();
    }

    public PlayerEntry getPlayerEntry(String playerName) {
        PlayerEntry data = this.players.get(playerName.toLowerCase());
        if (data == null) {
            data = this.plugin.getStorageManager().extractPlayer(playerName);
            if (data == null) {
                data = this.plugin.getStorageManager().createPlayer(playerName, null);
            }
            this.players.put(playerName.toLowerCase(), data);
        }
        return data;
    }

    public PlayerEntry getPlayerEntry(Player player) {
        String playerName = player.getName();
        PlayerEntry data = this.players.get(playerName.toLowerCase());
        if (data == null) {
            UUID uuid = player.getUniqueId();
            data = this.plugin.getStorageManager().extractPlayer(uuid);
            if (data == null) {
                data = this.plugin.getStorageManager().extractPlayer(player.getName());
            } else if (!playerName.equalsIgnoreCase(data.getName())) {
                this.plugin.getStorageManager().migrate(data.getName(), playerName);
                data.setName(playerName);
            }
            if (data == null) {
                data = this.plugin.getStorageManager().createPlayer(playerName, uuid);
            }
            this.players.put(playerName.toLowerCase(), data);
        }
        return data;
    }

    public void playerLogin(Player player) {
        PlayerEntry data = this.getPlayerEntry(player);
        data.setOnline(true);
    }

    public void playerLogoff(Player player) {
        PlayerEntry data = this.getPlayerEntry(player);
        data.setOnline(false);
        data.setOutsideLocation(null);
    }

    public void updateOutsideLocation(Player player) {
        PlayerEntry data = this.getPlayerEntry(player);
        data.setOutsideLocation(player.getLocation());
    }

    public Location getOutsideLocation(Player player) {
        PlayerEntry data = this.getPlayerEntry(player);
        Location loc = data.getOutsideLocation();
        if (loc != null) {
            loc = new Location(loc.getWorld(), (double)loc.getBlockX() + 0.5, (double)loc.getBlockY(), (double)loc.getBlockZ() + 0.5, loc.getYaw(), loc.getPitch());
        }
        return loc;
    }

    public Location getOutsideFieldLocation(Field field, Player player) {
        World world = player.getWorld();
        int x = player.getLocation().getBlockX();
        int y = player.getLocation().getBlockY() + 1;
        int z = player.getLocation().getBlockZ();
        int edgeX1 = field.getX() + (field.getRadius() + 1);
        int edgeX2 = field.getX() - (field.getRadius() + 1);
        int edgeZ1 = field.getZ() + (field.getRadius() + 1);
        int edgeZ2 = field.getZ() - (field.getRadius() + 1);
        Location loc = world.getSpawnLocation();
        if (this.isEmptySpace(world, edgeX1, y, z)) {
            loc = new Location(world, (double)edgeX1 + 0.5, (double)y, (double)z + 0.5, player.getLocation().getYaw(), player.getLocation().getPitch());
        } else if (this.isEmptySpace(world, edgeX2, y, z)) {
            loc = new Location(world, (double)edgeX2 + 0.5, (double)y, (double)z + 0.5, player.getLocation().getYaw(), player.getLocation().getPitch());
        } else if (this.isEmptySpace(world, x, y, edgeZ1)) {
            loc = new Location(world, (double)x + 0.5, (double)y, (double)edgeZ1 + 0.5, player.getLocation().getYaw(), player.getLocation().getPitch());
        } else if (this.isEmptySpace(world, x, y, edgeZ2)) {
            loc = new Location(world, (double)x + 0.5, (double)y, (double)edgeZ2 + 0.5, player.getLocation().getYaw(), player.getLocation().getPitch());
        }
        return loc;
    }

    private boolean isEmptySpace(World world, int x, int y, int z) {
        Material type1 = world.getBlockAt(x, y, z).getType();
        Material type2 = world.getBlockAt(x, y, z).getType();
        return this.plugin.getSettingsManager().isThroughType(type1) && this.plugin.getSettingsManager().isThroughType(type2);
    }

    public void offerOnlinePlayerEntries() {
        Collection<Player> onlinePlayers = Helper.getOnlinePlayers();
        for (Player player : onlinePlayers) {
            this.plugin.getStorageManager().offerPlayer(player.getName());
        }
    }
}

