/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.storage;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class DynamicQueryCreator {
    private final StringBuilder queryBuilder;
    private final List<Object> parameters;

    private DynamicQueryCreator(StringBuilder queryBuilder, List<Object> parameters) {
        this.queryBuilder = queryBuilder;
        this.parameters = parameters;
    }

    DynamicQueryCreator() {
        this(new StringBuilder(), new ArrayList<Object>());
    }

    DynamicQueryCreator(DynamicQueryCreator copyFrom) {
        this(new StringBuilder(copyFrom.queryBuilder.toString()), new ArrayList<Object>(copyFrom.parameters));
    }

    private void appendWithComma(String content) {
        if (this.queryBuilder.length() != 0) {
            this.queryBuilder.append(", ");
        }
        this.queryBuilder.append(content);
    }

    void add(String content, Object parameter) {
        this.appendWithComma(content);
        this.parameters.add(parameter);
    }

    void add(String content, Object ... parameters) {
        this.appendWithComma(content);
        for (Object parameter : parameters) {
            this.parameters.add(parameter);
        }
    }

    String toQueryString() {
        return this.queryBuilder.toString();
    }

    int setParameters(PreparedStatement prepStmt, int offset) throws SQLException {
        for (int n = 0; n < this.parameters.size(); ++n) {
            prepStmt.setObject(offset + 1 + n, this.parameters.get(n));
        }
        return this.parameters.size();
    }
}

