/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.listeners;

import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.ResultsFilter;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.ChunkVec;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.WorldLoadEvent;

public class PSWorldListener
implements Listener {
    private final PreciousStones plugin = PreciousStones.getInstance();

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkUnload(ChunkUnloadEvent event) {
        World world = event.getWorld();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(world)) {
            return;
        }
        List<Field> fields = this.plugin.getForceFieldManager().getSourceFieldsInChunk(new ChunkVec(event.getChunk()), FieldFlag.KEEP_CHUNKS_LOADED, new ResultsFilter[0]);
        if (!fields.isEmpty()) {
            // empty if block
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(world)) {
            return;
        }
        this.plugin.getStorageManager().loadWorldFields(world.getName());
        this.plugin.getStorageManager().loadWorldUnbreakables(world.getName());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPortalCreate(PortalCreateEvent event) {
        Field field;
        List blocks = event.getBlocks();
        if (event.getReason().equals((Object)PortalCreateEvent.CreateReason.FIRE) && (field = this.plugin.getForceFieldManager().getEnabledSourceField(((BlockState)blocks.get(0)).getLocation(), FieldFlag.PREVENT_PORTAL_CREATION)) != null) {
            event.setCancelled(true);
        }
        if (event.getReason().equals((Object)PortalCreateEvent.CreateReason.NETHER_PAIR) && (field = this.plugin.getForceFieldManager().getEnabledSourceField(((BlockState)blocks.get(0)).getLocation(), FieldFlag.PREVENT_PORTAL_DESTINATION)) != null) {
            event.setCancelled(true);
        }
    }
}

