/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.sacredlabyrinth.Phaed.PreciousStones.DirtyFieldReason;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.GriefBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.TranslocationBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.Unbreakable;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PurchaseEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.SnitchEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.SettingsManager;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.AbstractDBCore;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.DBCore;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.DynamicQueryCreator;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.MySQLCore2;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.SQLiteCore2;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.SqlUtils;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.TableCreator;
import net.sacredlabyrinth.Phaed.PreciousStones.uuid.UUIDMigration;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class StorageManager {
    private final DBCore core;
    private final PreciousStones plugin;
    private final Map<Vec, Field> pending = new HashMap<Vec, Field>();
    private final Set<Field> pendingGrief = new HashSet<Field>();
    private final Map<Unbreakable, Boolean> pendingUb = new HashMap<Unbreakable, Boolean>();
    private final Map<String, Boolean> pendingPlayers = new HashMap<String, Boolean>();
    private final List<SnitchEntry> pendingSnitchEntries = new ArrayList<SnitchEntry>();
    private boolean haltUpdates;

    public StorageManager() {
        this.plugin = PreciousStones.getInstance();
        try {
            this.core = this.initiateDB();
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Unable to initialise database", ex);
        }
        this.loadWorldData();
        this.saverScheduler();
        this.purgePlayers();
    }

    private DBCore initiateDB() throws SQLException {
        SettingsManager settings = this.plugin.getSettingsManager();
        boolean isMySql = settings.isUseMysql();
        AbstractDBCore core = isMySql ? new MySQLCore2(settings.getHost(), settings.getPort(), settings.getDatabase(), settings.getUsername(), settings.getPassword()) : new SQLiteCore2("PreciousStones", this.plugin.getDataFolder().getPath());
        try (TableCreator creator = new TableCreator(core);){
            creator.createTables();
            if (settings.getVersion() < 9.0) {
                creator.addData();
                settings.setVersion(9);
            }
            if (settings.getVersion() < 10.0) {
                creator.addSnitchDate();
                settings.setVersion(10);
            }
            if (isMySql && settings.getVersion() < 12.0) {
                creator.resetLastSeen();
                settings.setVersion(12);
            }
        }
        return core;
    }

    private Connection getConnection() throws SQLException {
        return this.core.getConnection();
    }

    public void closeConnection() {
        this.core.close();
    }

    public void loadWorldData() {
        PreciousStones.debug("finalizing queue", new Object[0]);
        this.plugin.getForceFieldManager().offerAllDirtyFields();
        this.processQueue();
        PreciousStones.debug("clearing fields from memory", new Object[0]);
        this.plugin.getForceFieldManager().clearChunkLists();
        this.plugin.getUnbreakableManager().clearChunkLists();
        Set worldNames = this.plugin.getServer().getWorlds().stream().map(World::getName).collect(Collectors.toSet());
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            PreciousStones.debug("loading fields by world", new Object[0]);
            for (String worldName : worldNames) {
                this.loadWorldFields(worldName);
                this.loadWorldUnbreakables(worldName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWorldFields(String worldName) {
        int fieldCount = 0;
        int cuboidCount = 0;
        ArrayList<Field> fields = new ArrayList<Field>();
        try (Connection conn = this.getConnection();){
            StorageManager storageManager = this;
            synchronized (storageManager) {
                fields.addAll(this.getFields(conn, worldName));
                fieldCount = fields.size();
                Collection<Field> cuboids = this.getCuboidFields(conn, worldName);
                cuboidCount = cuboids.size();
                fields.addAll(cuboids);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        for (Field field : fields) {
            this.plugin.getForceFieldManager().addToCollection(field);
            if (field.hasFlag(FieldFlag.GRIEF_REVERT) && field.getRevertingModule().getRevertSecs() > 0) {
                this.plugin.getGriefUndoManager().register(field);
            }
            if (field.hasFlag(FieldFlag.TRANSLOCATION) && field.isNamed()) {
                try (Connection conn = this.getConnection();){
                    boolean applied = this.isTranslocationApplied(conn, field.getName(), field.getOwner());
                    field.setDisabled(!applied, true);
                    int count = this.totalTranslocationCount0(conn, field.getName(), field.getOwner());
                    field.getTranslocatingModule().setTranslocationSize(count);
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            if (!field.hasFlag(FieldFlag.RENTABLE) && !field.hasFlag(FieldFlag.SHAREABLE)) continue;
            field.getRentingModule().scheduleNextRentUpdate();
        }
        if (fieldCount > 0) {
            PreciousStones.log("countsFields", worldName, fieldCount);
        }
        if (cuboidCount > 0) {
            PreciousStones.log("countsCuboids", worldName, cuboidCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int enableAllFlags(String flagStr) {
        int changed = 0;
        ArrayList<Field> fields = new ArrayList<Field>();
        List worlds = this.plugin.getServer().getWorlds();
        try (Connection conn = this.getConnection();){
            for (World world : worlds) {
                StorageManager storageManager = this;
                synchronized (storageManager) {
                    String worldName = world.getName();
                    fields.addAll(this.getFields(conn, worldName));
                    fields.addAll(this.getCuboidFields(conn, worldName));
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        this.plugin.getForceFieldManager().clearChunkLists();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (field.hasFlag(flagStr)) {
                ++changed;
                field.getFlagsModule().disableFlag(flagStr, false);
                field.getFlagsModule().dirtyFlags("enableAllFlags");
            }
            this.plugin.getForceFieldManager().addToCollection(field);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int disableAllFlags(String flagStr) {
        int changed = 0;
        ArrayList<Field> fields = new ArrayList<Field>();
        List worlds = this.plugin.getServer().getWorlds();
        try (Connection conn = this.getConnection();){
            for (World world : worlds) {
                StorageManager storageManager = this;
                synchronized (storageManager) {
                    String worldName = world.getName();
                    fields.addAll(this.getFields(conn, worldName));
                    fields.addAll(this.getCuboidFields(conn, worldName));
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        this.plugin.getForceFieldManager().clearChunkLists();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (field.getFlagsModule().hasDisabledFlag(flagStr)) {
                ++changed;
                field.getFlagsModule().enableFlag(flagStr);
                field.getFlagsModule().dirtyFlags("disableAllFlags");
            }
            this.plugin.getForceFieldManager().addToCollection(field);
        }
        return changed;
    }

    public void loadWorldUnbreakables(String worldName) {
        List<Unbreakable> unbreakables = this.getUnbreakables(worldName);
        for (Unbreakable ub : unbreakables) {
            this.plugin.getUnbreakableManager().addToCollection(ub);
        }
        if (!unbreakables.isEmpty()) {
            PreciousStones.log("countsUnbreakables", worldName, unbreakables.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerField(Field field) {
        Map<Vec, Field> map = this.pending;
        synchronized (map) {
            this.pending.put(field.toVec(), field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerGrief(Field field) {
        Set<Field> set = this.pendingGrief;
        synchronized (set) {
            this.pendingGrief.add(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerUnbreakable(Unbreakable ub, boolean insert) {
        Map<Unbreakable, Boolean> map = this.pendingUb;
        synchronized (map) {
            this.pendingUb.put(ub, insert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerPlayer(String playerName) {
        Map<String, Boolean> map = this.pendingPlayers;
        synchronized (map) {
            this.pendingPlayers.put(playerName, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerDeletePlayer(String playerName) {
        Map<String, Boolean> map = this.pendingPlayers;
        synchronized (map) {
            this.pendingPlayers.put(playerName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerSnitchEntry(SnitchEntry se) {
        List<SnitchEntry> list = this.pendingSnitchEntries;
        synchronized (list) {
            this.pendingSnitchEntries.add(se);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Field> getFields(Connection conn, String worldName) throws SQLException {
        ArrayList<Field> out = new ArrayList<Field>();
        boolean foundInWrongTable = false;
        try (PreparedStatement prepStmt = conn.prepareStatement("SELECT pstone_fields.id as id, x, y, z, radius, height, type_id, data, velocity, world, owner, name, packed_allowed, last_used, flags FROM pstone_fields WHERE world = ?");){
            prepStmt.setString(1, worldName);
            try (ResultSet resultSet = prepStmt.executeQuery();){
                while (resultSet.next()) {
                    try {
                        long id = resultSet.getLong("id");
                        int x = resultSet.getInt("x");
                        int y = resultSet.getInt("y");
                        int z = resultSet.getInt("z");
                        int radius = resultSet.getInt("radius");
                        int height = resultSet.getInt("height");
                        int type_id = resultSet.getInt("type_id");
                        float velocity = resultSet.getFloat("velocity");
                        String world = resultSet.getString("world");
                        String owner = resultSet.getString("owner");
                        String name = resultSet.getString("name");
                        String flags = resultSet.getString("flags");
                        String packed_allowed = resultSet.getString("packed_allowed");
                        long last_used = resultSet.getLong("last_used");
                        BlockTypeEntry type = new BlockTypeEntry(Helper.getMaterial(type_id));
                        Field field = new Field(x, y, z, radius, height, velocity, world, type, owner, name, last_used);
                        field.setPackedAllowed(packed_allowed);
                        field.setId(id);
                        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(field);
                        if (fs == null) continue;
                        field.setSettings(fs);
                        field.getFlagsModule().setFlags(flags);
                        if (fs.getAutoDisableTime() > 0) {
                            field.setDisabled(true, true);
                        }
                        out.add(field);
                        if (!fs.hasDefaultFlag(FieldFlag.CUBOID)) continue;
                        this.deleteFieldFromBothTables(conn, field);
                        this.insertField0(conn, field);
                        foundInWrongTable = true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        if (foundInWrongTable) {
            System.err.println("[PreciousStones] Fields found in wrong table");
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Field> getCuboidFields(Connection conn, String worldName) throws SQLException {
        Throwable throwable;
        ResultSet resultSet;
        HashMap<Long, Field> out = new HashMap<Long, Field>();
        boolean foundInWrongTable = false;
        try (PreparedStatement prepStmt = conn.prepareStatement("SELECT pstone_cuboids.id as id, x, y, z, minx, miny, minz, maxx, maxy, maxz, type_id, data, velocity, world, owner, name, packed_allowed, last_used, flags FROM  pstone_cuboids WHERE pstone_cuboids.parent = 0 AND world = ?");){
            prepStmt.setString(1, worldName);
            resultSet = prepStmt.executeQuery();
            throwable = null;
            try {
                while (resultSet.next()) {
                    try {
                        long id = resultSet.getLong("id");
                        int x = resultSet.getInt("x");
                        int y = resultSet.getInt("y");
                        int z = resultSet.getInt("z");
                        int minx = resultSet.getInt("minx");
                        int miny = resultSet.getInt("miny");
                        int minz = resultSet.getInt("minz");
                        int maxx = resultSet.getInt("maxx");
                        int maxy = resultSet.getInt("maxy");
                        int maxz = resultSet.getInt("maxz");
                        int type_id = resultSet.getInt("type_id");
                        float velocity = resultSet.getFloat("velocity");
                        String world = resultSet.getString("world");
                        String owner = resultSet.getString("owner");
                        String name = resultSet.getString("name");
                        String flags = resultSet.getString("flags");
                        String packed_allowed = resultSet.getString("packed_allowed");
                        long last_used = resultSet.getLong("last_used");
                        BlockTypeEntry type = new BlockTypeEntry(Helper.getMaterial(type_id));
                        Field field = new Field(x, y, z, minx, miny, minz, maxx, maxy, maxz, velocity, world, type, owner, name, last_used);
                        field.setPackedAllowed(packed_allowed);
                        field.setId(id);
                        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(field);
                        if (fs == null) continue;
                        field.setSettings(fs);
                        field.getFlagsModule().setFlags(flags);
                        if (fs.getAutoDisableTime() > 0) {
                            field.setDisabled(true, true);
                        }
                        out.put(id, field);
                        if (fs.hasDefaultFlag(FieldFlag.CUBOID)) continue;
                        this.deleteFieldFromBothTables(conn, field);
                        this.insertField0(conn, field);
                        foundInWrongTable = true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Throwable ex) {
                throwable = ex;
                throw ex;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable ex) {
                            throwable.addSuppressed(ex);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        prepStmt = conn.prepareStatement("SELECT pstone_cuboids.id as id, parent, x, y, z, minx, miny, minz, maxx, maxy, maxz, type_id, data, velocity, world, owner, name, packed_allowed, last_used, flags FROM pstone_cuboids WHERE pstone_cuboids.parent > 0 AND world = ?");
        var6_6 = null;
        try {
            prepStmt.setString(1, worldName);
            resultSet = prepStmt.executeQuery();
            throwable = null;
            try {
                while (resultSet.next()) {
                    try {
                        long id = resultSet.getLong("id");
                        long parent = resultSet.getLong("parent");
                        int x = resultSet.getInt("x");
                        int y = resultSet.getInt("y");
                        int z = resultSet.getInt("z");
                        int minx = resultSet.getInt("minx");
                        int miny = resultSet.getInt("miny");
                        int minz = resultSet.getInt("minz");
                        int maxx = resultSet.getInt("maxx");
                        int maxy = resultSet.getInt("maxy");
                        int maxz = resultSet.getInt("maxz");
                        int type_id = resultSet.getInt("type_id");
                        float velocity = resultSet.getFloat("velocity");
                        String world = resultSet.getString("world");
                        String owner = resultSet.getString("owner");
                        String name = resultSet.getString("name");
                        String flags = resultSet.getString("flags");
                        String packed_allowed = resultSet.getString("packed_allowed");
                        long last_used = resultSet.getLong("last_used");
                        BlockTypeEntry type = new BlockTypeEntry(Helper.getMaterial(type_id));
                        Field field = new Field(x, y, z, minx, miny, minz, maxx, maxy, maxz, velocity, world, type, owner, name, last_used);
                        field.setPackedAllowed(packed_allowed);
                        Field parentField = (Field)out.get(parent);
                        if (parentField != null) {
                            field.setParent(parentField);
                            parentField.addChild(field);
                        } else {
                            field.markForDeletion();
                            this.offerField(field);
                        }
                        field.setId(id);
                        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(field);
                        if (fs == null) continue;
                        field.setSettings(fs);
                        field.getFlagsModule().setFlags(flags);
                        out.put(id, field);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resultSet != null) {
                    if (throwable != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var6_6 = throwable4;
            throw throwable4;
        }
        finally {
            if (prepStmt != null) {
                if (var6_6 != null) {
                    try {
                        prepStmt.close();
                    }
                    catch (Throwable throwable5) {
                        var6_6.addSuppressed(throwable5);
                    }
                } else {
                    prepStmt.close();
                }
            }
        }
        if (foundInWrongTable) {
            PreciousStones.log("fieldsInWrongTable", new Object[0]);
        }
        return out.values();
    }

    public void migrate(String oldUsername, String newUsername) {
        this.plugin.getForceFieldManager().migrateUsername(oldUsername, newUsername);
        this.plugin.getUnbreakableManager().migrateUsername(oldUsername, newUsername);
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt1 = conn.prepareStatement("UPDATE `pstone_storedblocks` SET player_name = ? WHERE player_name = ?");
             PreparedStatement prepStmt2 = conn.prepareStatement("UPDATE `pstone_translocations` SET player_name = ? WHERE player_name = ?");){
            prepStmt1.setString(1, newUsername);
            prepStmt1.setString(2, oldUsername);
            prepStmt2.setString(1, newUsername);
            prepStmt2.setString(2, oldUsername);
            prepStmt1.execute();
            prepStmt2.execute();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        PreciousStones.log("[Username Changed] From: " + oldUsername + " To: " + newUsername, new Object[0]);
        Player player = this.plugin.getServer().getPlayerExact(newUsername);
        if (player != null) {
            ChatHelper.send((CommandSender)player, "usernameChanged", new Object[0]);
        }
    }

    public void deletePlayerAndData(String playerName) {
        int purged = this.plugin.getForceFieldManager().deleteBelonging(playerName);
        if (purged > 0) {
            PreciousStones.log("countsPurgedFields", playerName, purged);
        }
        if ((purged = this.plugin.getUnbreakableManager().deleteBelonging(playerName)) > 0) {
            PreciousStones.log("countsPurgedUnbreakables", playerName, purged);
        }
        this.offerDeletePlayer(playerName);
    }

    private PlayerEntry extractPlayer(ResultSet resultSet) throws SQLException {
        if (!resultSet.next()) {
            return null;
        }
        PlayerEntry data = new PlayerEntry();
        String uuid = resultSet.getString("uuid");
        if (uuid != null && uuid.equalsIgnoreCase("null")) {
            uuid = null;
        }
        String name = resultSet.getString("player_name");
        long last_seen = resultSet.getLong("last_seen");
        String flags = resultSet.getString("flags");
        if (last_seen > 0L) {
            ZonedDateTime lastUsedDate = Instant.ofEpochMilli(last_seen).atZone(ZoneId.systemDefault());
            ZonedDateTime now = LocalDateTime.now().atZone(ZoneId.systemDefault());
            int lastSeenDays = (int)ChronoUnit.DAYS.between(lastUsedDate, now);
            PreciousStones.debug("Player last seen: %s [%s]", lastSeenDays, name);
        }
        data.setName(name);
        data.setFlags(flags);
        if (uuid != null) {
            data.setOnlineUUID(UUID.fromString(uuid));
        } else {
            UUID pulledUUID = UUIDMigration.findPlayerUUID(name);
            if (pulledUUID != null) {
                data.setOnlineUUID(pulledUUID);
                PreciousStones.log("[Online UUID Found] Player: " + name + " UUID: " + pulledUUID.toString(), new Object[0]);
                this.plugin.getStorageManager().updatePlayerUUID(name, pulledUUID);
            }
        }
        return data;
    }

    /*
     * Exception decompiling
     */
    public PlayerEntry extractPlayer(String playerName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public PlayerEntry extractPlayer(UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public PlayerEntry createPlayer(String playerName, UUID uuid) {
        PlayerEntry data = new PlayerEntry();
        data.setName(playerName);
        data.setOnlineUUID(uuid);
        PreciousStones.log("[New Player]: " + playerName + " UUID: " + uuid, new Object[0]);
        return data;
    }

    public void purgePlayers() {
        int purgeDays = this.plugin.getSettingsManager().getPurgeAfterDays();
        long lastSeen = LocalDateTime.now().atZone(ZoneId.systemDefault()).minusDays(purgeDays).toInstant().toEpochMilli();
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("SELECT player_name FROM pstone_players WHERE last_seen < ?");){
            prepStmt.setLong(1, lastSeen);
            try (ResultSet resultSet = prepStmt.executeQuery();){
                while (resultSet.next()) {
                    String name = resultSet.getString("player_name");
                    this.deletePlayerAndData(name);
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Unbreakable> getUnbreakables(String worldName) {
        ArrayList<Unbreakable> out = new ArrayList<Unbreakable>();
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("SELECT * FROM  `pstone_unbreakables` WHERE world = ?");){
            prepStmt.setString(1, worldName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    while (resultSet.next()) {
                        int x = resultSet.getInt("x");
                        int y = resultSet.getInt("y");
                        int z = resultSet.getInt("z");
                        int type_id = resultSet.getInt("type_id");
                        String world = resultSet.getString("world");
                        String owner = resultSet.getString("owner");
                        BlockTypeEntry type = new BlockTypeEntry(Helper.getMaterial(type_id));
                        Unbreakable ub = new Unbreakable(x, y, z, world, type, owner);
                        out.add(ub);
                    }
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return out;
    }

    private void updateGrief(Connection conn, Field field) throws SQLException {
        if (field.isDirty(DirtyFieldReason.GRIEF_BLOCKS)) {
            Queue<GriefBlock> grief = field.getRevertingModule().getGrief();
            for (GriefBlock gb : grief) {
                this.insertBlockGrief(conn, field, gb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateField(Connection conn, Field field) throws SQLException {
        block40: {
            String fieldUpdates;
            DynamicQueryCreator cuboidCreator;
            DynamicQueryCreator creator = new DynamicQueryCreator();
            if (field.isDirty(DirtyFieldReason.OWNER)) {
                creator.add("owner = ?", (Object)field.getOwner());
            }
            if (field.isDirty(DirtyFieldReason.RADIUS)) {
                creator.add("radius = ?", (Object)field.getRadius());
            }
            if (field.isDirty(DirtyFieldReason.HEIGHT)) {
                creator.add("height = ?", (Object)field.getHeight());
            }
            if (field.isDirty(DirtyFieldReason.VELOCITY)) {
                creator.add("velocity = ?", (Object)Float.valueOf(field.getVelocity()));
            }
            if (field.isDirty(DirtyFieldReason.NAME)) {
                creator.add("name = ?", (Object)field.getName());
            }
            if (field.isDirty(DirtyFieldReason.ALLOWED)) {
                creator.add("packed_allowed = ?", (Object)field.getPackedAllowed());
            }
            if (field.isDirty(DirtyFieldReason.LASTUSED)) {
                creator.add("last_used = ?", (Object)Helper.getMillis());
            }
            if (field.isDirty(DirtyFieldReason.FLAGS)) {
                creator.add("flags = ?", (Object)field.getFlagsModule().getFlagsAsString());
            }
            if (field.hasFlag(FieldFlag.CUBOID)) {
                cuboidCreator = new DynamicQueryCreator(creator);
                if (field.isDirty(DirtyFieldReason.DIMENSIONS)) {
                    cuboidCreator.add("minx = ?, miny = ?, minz = ?, maxx = ?, maxy = ?, maxz = ?", field.getMinx(), field.getMiny(), field.getMinz(), field.getMaxx(), field.getMaxy(), field.getMaxz());
                }
            } else {
                cuboidCreator = null;
            }
            if ((fieldUpdates = creator.toQueryString()).isEmpty()) {
                return;
            }
            try {
                String cuboidUpdates;
                try (PreparedStatement prepStmt = conn.prepareStatement("UPDATE `pstone_fields` SET " + fieldUpdates + " WHERE x = ? AND y = ? AND z = ? AND world = ?");){
                    int setCount = creator.setParameters(prepStmt, 0);
                    SqlUtils.setFieldCoordinates(prepStmt, field, setCount);
                    prepStmt.execute();
                }
                if (cuboidCreator == null || (cuboidUpdates = cuboidCreator.toQueryString()).isEmpty()) break block40;
                try (PreparedStatement prepStmt = conn.prepareStatement("UPDATE `pstone_cuboids` SET " + cuboidUpdates + " WHERE x = ? AND y = ? AND z = ? AND world = ?");){
                    int setCount = cuboidCreator.setParameters(prepStmt, 0);
                    SqlUtils.setFieldCoordinates(prepStmt, field, setCount);
                    prepStmt.execute();
                }
            }
            finally {
                field.clearDirty();
            }
        }
    }

    public void insertField(Field field) {
        try (Connection conn = this.getConnection();){
            this.insertField0(conn, field);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertField0(Connection conn, Field field) throws SQLException {
        Object[] parameters;
        String query;
        Vec vec = field.toVec();
        if (this.pending.containsKey(vec)) {
            this.processSingleField(conn, this.pending.get(field.toVec()));
        }
        if (field.hasFlag(FieldFlag.CUBOID)) {
            query = "INSERT INTO `pstone_cuboids` (`parent`, `x`, `y`, `z`, `world`, `minx`, `miny`, `minz`, `maxx`, `maxy`, `maxz`, `velocity`, `type_id`, `data`, `owner`, `name`, `packed_allowed`, `last_used`, `flags`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            parameters = new Object[]{field.getParent() == null ? 0L : field.getParent().getId(), field.getX(), field.getY(), field.getZ(), field.getWorld(), field.getMinx(), field.getMiny(), field.getMinz(), field.getMaxx(), field.getMaxy(), field.getMaxz(), Float.valueOf(field.getVelocity()), Helper.getMaterialId(field.getMaterial()), 0, field.getOwner(), field.getName(), field.getPackedAllowed(), Helper.getMillis(), field.getFlagsModule().getFlagsAsString()};
        } else {
            query = "INSERT INTO `pstone_fields` (`x`, `y`, `z`, `world`, `radius`, `height`, `velocity`, `type_id`, `data`, `owner`, `name`, `packed_allowed`, `last_used`, `flags`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            parameters = new Object[]{field.getX(), field.getY(), field.getZ(), field.getWorld(), field.getRadius(), field.getHeight(), Float.valueOf(field.getVelocity()), Helper.getMaterialId(field.getMaterial()), 0, field.getOwner(), field.getName(), field.getPackedAllowed(), Helper.getMillis(), field.getFlagsModule().getFlagsAsString()};
        }
        try (PreparedStatement prepStmt = conn.prepareStatement(query, 1);){
            SqlUtils.setArguments(prepStmt, parameters);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
                try (ResultSet genKeys = prepStmt.getGeneratedKeys();){
                    if (genKeys.next()) {
                        field.setId(genKeys.getLong(1));
                        return;
                    }
                }
            }
        }
        StorageManager storageManager = this;
        synchronized (storageManager) {
            field.setId(0L);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteField(Connection conn, Field field) throws SQLException {
        String table = field.hasFlag(FieldFlag.CUBOID) ? "pstone_cuboids" : "pstone_fields";
        String query = "DELETE FROM `{table}` WHERE x = ? AND y = ? AND z = ? AND world = ?";
        query = query.replace("{table}", table);
        Object[] parameters = new Object[]{field.getX(), field.getY(), field.getZ(), field.getWorld()};
        try (PreparedStatement prepStmt = conn.prepareStatement(query);){
            SqlUtils.setArguments(prepStmt, parameters);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFieldFromBothTables(Connection conn, Field field) throws SQLException {
        try (PreparedStatement prepStmt1 = conn.prepareStatement("DELETE FROM `pstone_fields` WHERE x = ? AND y = ? AND z = ? AND world = ?");
             PreparedStatement prepStmt2 = conn.prepareStatement("DELETE FROM `pstone_cuboids` WHERE x = ? AND y = ? AND z = ? AND world = ?");){
            prepStmt1.setInt(1, field.getX());
            prepStmt1.setInt(2, field.getY());
            prepStmt1.setInt(3, field.getZ());
            prepStmt1.setString(4, field.getWorld());
            prepStmt2.setInt(1, field.getX());
            prepStmt2.setInt(2, field.getY());
            prepStmt2.setInt(3, field.getZ());
            prepStmt2.setString(4, field.getWorld());
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt1.execute();
                prepStmt2.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFields(Connection conn, String playerName) throws SQLException {
        try (PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_fields` WHERE owner = ?");){
            prepStmt.setString(1, playerName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUnbreakables(Connection conn, String playerName) throws SQLException {
        try (PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_unbreakables` WHERE owner = ?");){
            prepStmt.setString(1, playerName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertUnbreakable(Connection conn, Unbreakable ub) throws SQLException {
        Object[] parameters = new Object[]{ub.getX(), ub.getY(), ub.getZ(), ub.getWorld(), ub.getOwner(), Helper.getMaterialId(ub.getMaterial()), 0};
        try (PreparedStatement prepStmt = conn.prepareStatement("INSERT INTO `pstone_unbreakables` (`x`, `y`, `z`, `world`, `owner`, `type_id`, `data`) VALUES (?, ?, ?, ?, ?, ?, ?)");){
            SqlUtils.setArguments(prepStmt, parameters);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUnbreakable(Connection conn, Unbreakable ub) throws SQLException {
        Object[] parameters = new Object[]{ub.getX(), ub.getY(), ub.getZ(), ub.getWorld()};
        try (PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_unbreakables` WHERE x = ? AND y = ? AND z = ? AND world = ?");){
            SqlUtils.setArguments(prepStmt, parameters);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPendingPurchasePayment(PurchaseEntry purchase) {
        BlockTypeEntry item = purchase.getItem();
        String itemName = item == null ? null : item.toString();
        Object[] parameters = new Object[]{purchase.getId(), purchase.getBuyer(), purchase.getOwner(), itemName, purchase.getAmount(), purchase.getFieldName(), purchase.getCoords()};
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("INSERT INTO `pstone_purchase_payments` (`id`, `buyer`, `owner`, `item`, `amount`, `fieldName`, `coords`) VALUES (?, ?, ?, ?, ?, ?, ?)");){
            SqlUtils.setArguments(prepStmt, parameters);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePendingPurchasePayment(PurchaseEntry purchase) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_purchase_payments` WHERE id = ?");){
            prepStmt.setInt(1, purchase.getId());
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PurchaseEntry> getPendingPurchases(String owner) {
        ArrayList<PurchaseEntry> out = new ArrayList<PurchaseEntry>();
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("SELECT * FROM  `pstone_purchase_payments` WHERE owner = ?");){
            prepStmt.setString(1, owner);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    while (resultSet.next()) {
                        try {
                            int id = resultSet.getInt("id");
                            String buyer = resultSet.getString("buyer");
                            String item = resultSet.getString("item");
                            String fieldName = resultSet.getString("fieldName");
                            String coords = resultSet.getString("coords");
                            int amount = resultSet.getInt("amount");
                            out.add(new PurchaseEntry(id, buyer, owner, fieldName, coords, new BlockTypeEntry(item), amount));
                        }
                        catch (Exception ex) {
                            PreciousStones.getLog().info(ex.getMessage());
                        }
                    }
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return out;
    }

    public void insertSnitchEntry(Field snitch, SnitchEntry se) {
        try (Connection conn = this.getConnection();){
            this.insertSnitchEntry0(conn, snitch, se);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertSnitchEntry0(Connection conn, Field snitch, SnitchEntry se) throws SQLException {
        block43: {
            long date = Helper.getMillis();
            if (this.core.getVendorType().supportsInsertOnDuplicateKeyUpdate()) {
                try (PreparedStatement prepStmt = conn.prepareStatement("INSERT INTO `pstone_snitches` (`x`, `y`, `z`, `world`, `name`, `reason`, `details`, `count`, `date`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE count = count + 1");){
                    SqlUtils.setArguments(prepStmt, snitch.getX(), snitch.getY(), snitch.getZ(), snitch.getWorld(), se.getName(), se.getReason(), se.getDetails(), 1, date);
                    StorageManager storageManager = this;
                    synchronized (storageManager) {
                        prepStmt.execute();
                        break block43;
                    }
                }
            }
            try (PreparedStatement insertStmt = conn.prepareStatement("INSERT OR IGNORE INTO `pstone_snitches` (`x`, `y`, `z`, `world`, `name`, `reason`, `details`, `count`, `date`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                 PreparedStatement updateStmt = conn.prepareStatement("UPDATE `pstone_snitches` SET count = count + 1 WHERE x = ? AND y = ? AND z = ? AND world = ? AND name = ? AND reason = ? AND details = ?");){
                SqlUtils.setArguments(insertStmt, snitch.getX(), snitch.getY(), snitch.getZ(), snitch.getWorld(), se.getName(), se.getReason(), se.getDetails(), 0, date);
                SqlUtils.setArguments(updateStmt, snitch.getX(), snitch.getY(), snitch.getZ(), snitch.getWorld(), se.getName(), se.getReason(), se.getDetails());
                StorageManager storageManager = this;
                synchronized (storageManager) {
                    insertStmt.execute();
                    updateStmt.execute();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSnitchEntries(Field snitch) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_snitches` WHERE x = ? AND y = ? AND z = ? AND world = ?");){
            prepStmt.setInt(1, snitch.getX());
            prepStmt.setInt(2, snitch.getY());
            prepStmt.setInt(3, snitch.getZ());
            prepStmt.setString(4, snitch.getWorld());
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SnitchEntry> getSnitchEntries(Field snitch) {
        ArrayList<SnitchEntry> workingSnitchEntries = new ArrayList<SnitchEntry>();
        List<SnitchEntry> list = this.pendingSnitchEntries;
        synchronized (list) {
            workingSnitchEntries.addAll(this.pendingSnitchEntries);
            this.pendingSnitchEntries.clear();
        }
        ArrayList<SnitchEntry> out = new ArrayList<SnitchEntry>();
        try (Connection conn = this.getConnection();){
            this.processSnitches(conn, workingSnitchEntries);
            try (PreparedStatement prepStmt = conn.prepareStatement("SELECT * FROM  `pstone_snitches` WHERE x = ? AND y = ? AND z = ? AND world = ? ORDER BY `date` DESC");){
                prepStmt.setInt(1, snitch.getX());
                prepStmt.setInt(2, snitch.getY());
                prepStmt.setInt(3, snitch.getZ());
                prepStmt.setString(4, snitch.getWorld());
                StorageManager storageManager = this;
                synchronized (storageManager) {
                    try (ResultSet resultSet = prepStmt.executeQuery();){
                        while (resultSet.next()) {
                            String name = resultSet.getString("name");
                            String reason = resultSet.getString("reason");
                            String details = resultSet.getString("details");
                            int count = resultSet.getInt("count");
                            SnitchEntry ub = new SnitchEntry(null, name, reason, details, count);
                            out.add(ub);
                        }
                    }
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePlayer(Connection conn, String playerName) throws SQLException {
        try (PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_players` WHERE player_name = ?");){
            prepStmt.setString(1, playerName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    public void updatePlayer(String playerName) {
        try (Connection conn = this.getConnection();){
            this.updatePlayer0(conn, playerName);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlayer0(Connection conn, String playerName) throws SQLException {
        block43: {
            long time = Helper.getMillis();
            PlayerEntry data = this.plugin.getPlayerManager().getPlayerEntry(playerName);
            if (this.core.getVendorType().supportsInsertOnDuplicateKeyUpdate()) {
                try (PreparedStatement prepStmt = conn.prepareStatement("INSERT INTO `pstone_players` (`player_name`, `uuid`, `last_seen`, `flags`) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE last_seen = ?, flags = ?");){
                    SqlUtils.setArguments(prepStmt, playerName, data.getOnlineUUID().toString(), time, data.getFlags(), time, data.getFlags());
                    StorageManager storageManager = this;
                    synchronized (storageManager) {
                        prepStmt.execute();
                        break block43;
                    }
                }
            }
            try (PreparedStatement insertStmt = conn.prepareStatement("INSERT OR IGNORE INTO `pstone_players` (`player_name`, `uuid`, `last_seen`, `flags`) VALUES (?, ?, ?, ?)");
                 PreparedStatement updateStmt = conn.prepareStatement("UPDATE pstone_players SET last_seen = ?, flags = ? WHERE player_name = ?");){
                SqlUtils.setArguments(insertStmt, playerName, data.getOnlineUUID().toString(), time, data.getFlags());
                SqlUtils.setArguments(updateStmt, time, data.getFlags(), playerName);
                StorageManager storageManager = this;
                synchronized (storageManager) {
                    insertStmt.execute();
                    updateStmt.execute();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayerUUID(String playerName, UUID uuid) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("UPDATE `pstone_players` SET `uuid` = ? WHERE `player_name` = ?");){
            prepStmt.setString(1, uuid.toString());
            prepStmt.setString(2, playerName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertBlockGrief(Connection conn, Field field, GriefBlock gb) throws SQLException {
        Object[] parameters = new Object[]{Helper.getMillis(), field.getX(), field.getY(), field.getZ(), field.getWorld(), gb.getX(), gb.getY(), gb.getZ(), Helper.getMaterialId(gb.getType()), 0, gb.getSignText()};
        try (PreparedStatement prepStmt = conn.prepareStatement("INSERT INTO `pstone_grief_undo` (`date_griefed`, `field_x`, `field_y`, `field_z`, `world`, `x`, `y`, `z`, `type_id`, `data`, `sign_text`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            SqlUtils.setArguments(prepStmt, parameters);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<GriefBlock> retrieveBlockGrief(Field field) {
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.haltUpdates = true;
        }
        HashSet<Field> workingGrief = new HashSet<Field>();
        Set<Field> set = this.pendingGrief;
        synchronized (set) {
            workingGrief.addAll(this.pendingGrief);
            this.pendingGrief.clear();
        }
        LinkedList<GriefBlock> out = new LinkedList<GriefBlock>();
        try (Connection conn = this.getConnection();){
            this.processGrief(conn, workingGrief);
            try (PreparedStatement prepStmt = conn.prepareStatement("SELECT * FROM  `pstone_grief_undo` WHERE field_x = ? AND field_y = ? AND field_z = ? AND world = ? ORDER BY y ASC");){
                SqlUtils.setFieldCoordinates(prepStmt, field);
                StorageManager storageManager2 = this;
                synchronized (storageManager2) {
                    try (ResultSet resultSet = prepStmt.executeQuery();){
                        while (resultSet.next()) {
                            int x = resultSet.getInt("x");
                            int y = resultSet.getInt("y");
                            int z = resultSet.getInt("z");
                            int type_id = resultSet.getInt("type_id");
                            String signText = resultSet.getString("sign_text");
                            BlockTypeEntry type = new BlockTypeEntry(Helper.getMaterial(type_id));
                            GriefBlock gb = new GriefBlock(x, y, z, field.getWorld(), type);
                            if (type_id == 0 || type_id == 8 || type_id == 9 || type_id == 10 || type_id == 11) {
                                gb.setEmpty(true);
                            }
                            gb.setSignText(signText);
                            out.add(gb);
                        }
                    }
                    if (!out.isEmpty()) {
                        PreciousStones.debug("Deleting grief from the db", new Object[0]);
                        Set<Field> set2 = this.pendingGrief;
                        synchronized (set2) {
                            this.pendingGrief.remove(field);
                        }
                        this.deleteBlockGrief0(conn, field);
                    }
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            StorageManager storageManager3 = this;
            synchronized (storageManager3) {
                this.haltUpdates = false;
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBlockGrief(Field field) {
        Set<Field> set = this.pendingGrief;
        synchronized (set) {
            this.pendingGrief.remove(field);
        }
        try (Connection conn = this.getConnection();){
            this.deleteBlockGrief0(conn, field);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBlockGrief0(Connection conn, Field field) throws SQLException {
        try (PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_grief_undo` WHERE field_x = ? AND field_y = ? AND field_z = ? AND world = ?");){
            SqlUtils.setFieldCoordinates(prepStmt, field);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBlockGrief(Block block) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_grief_undo` WHERE x = ? AND y = ? AND z = ? AND world = ?");){
            prepStmt.setInt(1, block.getX());
            prepStmt.setInt(2, block.getY());
            prepStmt.setInt(3, block.getZ());
            prepStmt.setString(4, block.getWorld().getName());
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public boolean existsTranslocatior(String name, String playerName) {
        boolean exists = false;
        try (Connection conn = this.getConnection();){
            exists = this.existsTranslocatior0(conn, name, playerName);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsTranslocatior0(Connection conn, String name, String playerName) throws SQLException {
        boolean exists = false;
        try (PreparedStatement prepStmt = conn.prepareStatement("SELECT COUNT(*) FROM `pstone_translocations` WHERE `name` = ? AND `player_name` = ?");){
            prepStmt.setString(1, name);
            prepStmt.setString(2, playerName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    while (resultSet.next()) {
                        exists = resultSet.getInt(1) > 0;
                    }
                }
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeSizeTranslocatiorField(Field field, String fieldName) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("SELECT * FROM `pstone_translocations` WHERE `name` = ? AND `player_name` = ? LIMIT 1");){
            prepStmt.setString(1, fieldName);
            prepStmt.setString(2, field.getOwner());
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    while (resultSet.next()) {
                        field.setRelativeCuboidDimensions(resultSet.getInt("minx"), resultSet.getInt("miny"), resultSet.getInt("minz"), resultSet.getInt("maxx"), resultSet.getInt("maxy"), resultSet.getInt("maxz"));
                    }
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTranslocationHead(Field field, String name) {
        Location relativeMin = field.getRelativeMin();
        Location relativeMax = field.getRelativeMax();
        Object[] parameters = new Object[]{name, field.getOwner(), relativeMin.getBlockX(), relativeMin.getBlockY(), relativeMin.getBlockZ(), relativeMax.getBlockX(), relativeMax.getBlockY(), relativeMax.getBlockZ()};
        try (Connection conn = this.getConnection();){
            if (this.existsTranslocatior0(conn, name, field.getOwner())) {
                return;
            }
            try (PreparedStatement prepStmt = conn.prepareStatement("INSERT INTO `pstone_translocations` (`name`, `player_name`, `minx`, `miny`, `minz`, `maxx`, `maxy`, `maxz`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                SqlUtils.setArguments(prepStmt, parameters);
                StorageManager storageManager = this;
                synchronized (storageManager) {
                    prepStmt.execute();
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void insertTranslocationBlock(Field field, TranslocationBlock tb) {
        this.insertTranslocationBlock(field, tb, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTranslocationBlock(Field field, TranslocationBlock tb, boolean applied) {
        Object[] parameters = new Object[]{field.getName(), field.getOwner(), field.getWorld(), tb.getRx(), tb.getRy(), tb.getRz(), tb.getType(), 0, tb.getContents(), tb.getSignText(), applied ? 1 : 0};
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("INSERT INTO `pstone_storedblocks` (`name`, `player_name`, `world`, `x`, `y`, `z`, `type_id`, `data`, `contents`, `sign_text`, `applied`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            SqlUtils.setArguments(prepStmt, parameters);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public int appliedTranslocationCount(Field field) {
        int count = 0;
        try (Connection conn = this.getConnection();){
            count = this.appliedTranslocationCount(conn, field.getName(), field.getOwner());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int appliedTranslocationCount(Connection conn, String name, String playerName) throws SQLException {
        int count = 0;
        try (PreparedStatement prepStmt = conn.prepareStatement("SELECT COUNT(*) FROM `pstone_storedblocks` WHERE `name` = ? AND `player_name` = ? AND `applied` = 1");){
            prepStmt.setString(1, name);
            prepStmt.setString(2, playerName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    while (resultSet.next()) {
                        count = resultSet.getInt(1);
                    }
                }
            }
        }
        return count;
    }

    public int totalTranslocationCount(String name, String playerName) {
        int count = 0;
        try (Connection conn = this.getConnection();){
            count = this.totalTranslocationCount0(conn, name, playerName);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int totalTranslocationCount0(Connection conn, String name, String playerName) throws SQLException {
        int count = 0;
        try (PreparedStatement prepStmt = conn.prepareStatement("SELECT COUNT(*) FROM `pstone_storedblocks` WHERE `name` = ? AND `player_name` = ?");){
            prepStmt.setString(1, name);
            prepStmt.setString(2, playerName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet res = prepStmt.executeQuery();){
                    while (res.next()) {
                        count = res.getInt(1);
                    }
                }
            }
        }
        return count;
    }

    public int unappliedTranslocationCount(Field field) {
        return this.unappliedTranslocationCount(field.getName(), field.getOwner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unappliedTranslocationCount(String name, String playerName) {
        int count = 0;
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("SELECT COUNT(*) FROM `pstone_storedblocks` WHERE `name` = ? AND `player_name` = ? AND `applied` = 0");){
            prepStmt.setString(1, name);
            prepStmt.setString(2, playerName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    while (resultSet.next()) {
                        count = resultSet.getInt(1);
                    }
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<TranslocationBlock> retrieveClearTranslocation(Field field) {
        LinkedList<TranslocationBlock> out = new LinkedList<TranslocationBlock>();
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("SELECT * FROM  `pstone_storedblocks` WHERE `name` = ? AND `player_name` = ? AND `applied` = 1 ORDER BY y ASC");){
            SqlUtils.setFieldNameAndOwner(prepStmt, field);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    while (resultSet.next()) {
                        int x = resultSet.getInt("x");
                        int y = resultSet.getInt("y");
                        int z = resultSet.getInt("z");
                        World world = this.plugin.getServer().getWorld(field.getWorld());
                        Location location = new Location(world, (double)x, (double)y, (double)z);
                        location = location.add(field.getLocation());
                        int type_id = resultSet.getInt("type_id");
                        String signText = resultSet.getString("sign_text");
                        String contents = resultSet.getString("contents");
                        BlockTypeEntry type = new BlockTypeEntry(Helper.getMaterial(type_id));
                        TranslocationBlock tb = new TranslocationBlock(location, type);
                        if (type_id == 0 || type_id == 8 || type_id == 9 || type_id == 10 || type_id == 11) {
                            tb.setEmpty(true);
                        }
                        tb.setContents(contents);
                        tb.setRelativeCoords(x, y, z);
                        tb.setSignText(signText);
                        out.add(tb);
                    }
                }
            }
            this.clearTranslocation(conn, field);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<TranslocationBlock> retrieveTranslocation(Field field) {
        LinkedList<TranslocationBlock> out = new LinkedList<TranslocationBlock>();
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("SELECT * FROM  `pstone_storedblocks` WHERE `name` = ? AND `player_name` = ? AND `applied` = 0 ORDER BY y ASC");){
            SqlUtils.setFieldNameAndOwner(prepStmt, field);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    while (resultSet.next()) {
                        int x = resultSet.getInt("x");
                        int y = resultSet.getInt("y");
                        int z = resultSet.getInt("z");
                        World world = this.plugin.getServer().getWorld(field.getWorld());
                        Location location = new Location(world, (double)x, (double)y, (double)z);
                        location = location.add(field.getLocation());
                        int type_id = resultSet.getInt("type_id");
                        String signText = resultSet.getString("sign_text");
                        String contents = resultSet.getString("contents");
                        BlockTypeEntry type = new BlockTypeEntry(Helper.getMaterial(type_id));
                        TranslocationBlock tb = new TranslocationBlock(location, type);
                        if (type_id == 0 || type_id == 8 || type_id == 9 || type_id == 10 || type_id == 11) {
                            tb.setEmpty(true);
                        }
                        tb.setContents(contents);
                        tb.setRelativeCoords(x, y, z);
                        tb.setSignText(signText);
                        out.add(tb);
                    }
                }
            }
            this.applyTranslocation(conn, field);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getTranslocationDetails(String playerName) {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("SELECT name, COUNT(name) FROM  `pstone_storedblocks` WHERE `player_name` = ? GROUP BY `name`");){
            prepStmt.setString(1, playerName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    while (resultSet.next()) {
                        String name = resultSet.getString(1);
                        int count = resultSet.getInt(2);
                        out.put(name, count);
                    }
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsFieldWithName(String name, String playerName) {
        boolean exists = false;
        try (Connection conn = this.getConnection();){
            for (String tableSuffix : new String[]{"fields", "cuboids"}) {
                try (PreparedStatement prepStmt = conn.prepareStatement("SELECT COUNT(*) FROM  `pstone_" + tableSuffix + "` WHERE `owner` = ? AND `name` = ?");){
                    prepStmt.setString(1, playerName);
                    prepStmt.setString(2, name);
                    StorageManager storageManager = this;
                    synchronized (storageManager) {
                        try (ResultSet resultSet = prepStmt.executeQuery();){
                            while (resultSet.next()) {
                                int count = resultSet.getInt(1);
                                exists = count > 0;
                            }
                        }
                    }
                }
                if (!exists) continue;
                break;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsTranslocationDataWithName(String name, String playerName) {
        boolean exists = false;
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("SELECT COUNT(*) FROM  `pstone_storedblocks` WHERE `player_name` = ? AND `name` = ?");){
            prepStmt.setString(1, playerName);
            prepStmt.setString(2, name);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                try (ResultSet res = prepStmt.executeQuery();){
                    while (res.next()) {
                        int count = res.getInt(1);
                        exists = count > 0;
                    }
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTranslocation(Connection conn, Field field) throws SQLException {
        try (PreparedStatement prepStmt = conn.prepareStatement("UPDATE `pstone_storedblocks` SET `applied` = 1 WHERE `name` = ? AND `player_name` = ? AND `applied` = 0");){
            SqlUtils.setFieldNameAndOwner(prepStmt, field);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTranslocation(Connection conn, Field field) throws SQLException {
        try (PreparedStatement prepStmt = conn.prepareStatement("UPDATE `pstone_storedblocks` SET `applied` = 0 WHERE `name` = ? AND `player_name` = ? AND `applied` = 1");){
            SqlUtils.setFieldNameAndOwner(prepStmt, field);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAppliedTranslocation(Field field) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_storedblocks` WHERE `name` = ? AND `player_name` = ? AND `applied` = 1");){
            SqlUtils.setFieldNameAndOwner(prepStmt, field);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranslocation(Field field, TranslocationBlock tb) {
        Location location = tb.getRelativeLocation();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_storedblocks` WHERE x = ? AND y = ? AND z = ? AND `name` = ? AND `player_name` = ?");){
            prepStmt.setInt(1, x);
            prepStmt.setInt(2, y);
            prepStmt.setInt(3, z);
            SqlUtils.setFieldNameAndOwner(prepStmt, field, 3);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTranslocation(Connection conn, String playerName) throws SQLException {
        try (PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_storedblocks` WHERE `player_name` = ?");){
            prepStmt.setString(1, playerName);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranslocation(String name, String playerName) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_storedblocks` WHERE `player_name` = ? AND `name` = ?");){
            prepStmt.setString(1, playerName);
            prepStmt.setString(2, name);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranslocationHead(String name, String playerName) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_translocations` WHERE `player_name` = ? AND `name` = ?");){
            prepStmt.setString(1, playerName);
            prepStmt.setString(2, name);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteBlockTypeFromTranslocation(String name, String playerName, BlockTypeEntry block) {
        int updateCount = 0;
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM `pstone_storedblocks` WHERE `player_name` = ? AND `name` = ? AND `type_id` = ?");){
            prepStmt.setString(1, playerName);
            prepStmt.setString(2, name);
            prepStmt.setInt(3, Helper.getMaterialId(block.getMaterial()));
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
                updateCount = prepStmt.getUpdateCount();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeTranslocationOwner(Field field, String newOwner) {
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("UPDATE `pstone_storedblocks` SET `player_name` = ? WHERE `name` = ? AND `player_name` = ?");){
            prepStmt.setString(1, newOwner);
            SqlUtils.setFieldNameAndOwner(prepStmt, field, 1);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTranslocationBlockApplied(Field field, TranslocationBlock tb, boolean applied) {
        Location location = tb.getRelativeLocation();
        Object[] parameters = new Object[]{applied ? 1 : 0, field.getName(), field.getOwner(), location.getBlockX(), location.getBlockY(), location.getBlockZ()};
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("UPDATE `pstone_storedblocks` SET `applied` = ? WHERE `name` = ? AND `x` = ? AND `y` = ? AND `z` = ?");){
            SqlUtils.setArguments(prepStmt, parameters);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private boolean isTranslocationApplied(Connection conn, String name, String playerName) throws SQLException {
        return this.appliedTranslocationCount(conn, name, playerName) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTranslocationBlockContents(Field field, TranslocationBlock tb) {
        Location location = tb.getRelativeLocation();
        Object[] parameters = new Object[]{tb.getContents(), field.getName(), field.getOwner(), location.getBlockX(), location.getBlockX(), location.getBlockZ()};
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("UPDATE `pstone_storedblocks` SET `contents` = ? WHERE `name` = ? AND `player_name` = ? AND `x` = ? AND `y` = ? AND `z` = ?");){
            SqlUtils.setArguments(prepStmt, parameters);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTranslocationSignText(Field field, TranslocationBlock tb) {
        Location location = tb.getRelativeLocation();
        Object[] parameters = new Object[]{tb.getSignText(), field.getName(), field.getOwner(), location.getBlockX(), location.getBlockY(), location.getBlockZ()};
        try (Connection conn = this.getConnection();
             PreparedStatement prepStmt = conn.prepareStatement("UPDATE `pstone_storedblocks` SET `sign_text` = ? WHERE `name` = ? AND `player_name` = ? AND `x` = ? AND `y` = ? AND `z` = ?");){
            SqlUtils.setArguments(prepStmt, parameters);
            StorageManager storageManager = this;
            synchronized (storageManager) {
                prepStmt.execute();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public BukkitTask saverScheduler() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::processQueue, 0L, 20L * (long)this.plugin.getSettingsManager().getSaveFrequency());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueue() {
        StorageManager storageManager = this;
        synchronized (storageManager) {
            if (this.haltUpdates) {
                return;
            }
        }
        HashMap<Vec, Field> working = new HashMap<Vec, Field>();
        HashMap<Unbreakable, Boolean> workingUb = new HashMap<Unbreakable, Boolean>();
        HashMap<String, Boolean> workingPlayers = new HashMap<String, Boolean>();
        HashSet<Field> workingGrief = new HashSet<Field>();
        ArrayList<SnitchEntry> workingSnitchEntries = new ArrayList<SnitchEntry>();
        Object object = this.pending;
        synchronized (object) {
            working.putAll(this.pending);
            this.pending.clear();
        }
        object = this.pendingUb;
        synchronized (object) {
            workingUb.putAll(this.pendingUb);
            this.pendingUb.clear();
        }
        object = this.pendingGrief;
        synchronized (object) {
            workingGrief.addAll(this.pendingGrief);
            this.pendingGrief.clear();
        }
        object = this.pendingPlayers;
        synchronized (object) {
            workingPlayers.putAll(this.pendingPlayers);
            this.pendingPlayers.clear();
        }
        object = this.pendingSnitchEntries;
        synchronized (object) {
            workingSnitchEntries.addAll(this.pendingSnitchEntries);
            this.pendingSnitchEntries.clear();
        }
        if (working.isEmpty() && workingUb.isEmpty() && workingGrief.isEmpty() && workingPlayers.isEmpty() && workingSnitchEntries.isEmpty()) {
            return;
        }
        try (Connection conn = this.getConnection();){
            if (!working.isEmpty()) {
                this.processFields(conn, working);
            }
            if (!workingUb.isEmpty()) {
                this.processUnbreakable(conn, workingUb);
            }
            if (!workingGrief.isEmpty()) {
                this.processGrief(conn, workingGrief);
            }
            if (!workingPlayers.isEmpty()) {
                this.processPlayers(conn, workingPlayers);
            }
            if (!workingSnitchEntries.isEmpty()) {
                this.processSnitches(conn, workingSnitchEntries);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleField(Connection conn, Field field) throws SQLException {
        if (this.plugin.getSettingsManager().isDebug()) {
            PreciousStones.getLog().info("[Queue] processing single query");
        }
        if (field.isDirty(DirtyFieldReason.DELETE)) {
            this.deleteField(conn, field);
        } else {
            this.updateField(conn, field);
        }
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.pending.remove(field.toVec());
        }
    }

    private void processFields(Connection conn, Map<Vec, Field> working) throws SQLException {
        if (this.plugin.getSettingsManager().isDebug() && !working.isEmpty()) {
            PreciousStones.getLog().info("[Queue] processing " + working.size() + " pstone queries...");
        }
        for (Field field : working.values()) {
            if (field.isDirty(DirtyFieldReason.DELETE)) {
                this.deleteField(conn, field);
                continue;
            }
            this.updateField(conn, field);
        }
    }

    private void processUnbreakable(Connection conn, Map<Unbreakable, Boolean> workingUb) throws SQLException {
        if (this.plugin.getSettingsManager().isDebug() && !workingUb.isEmpty()) {
            PreciousStones.getLog().info("[Queue] processing " + workingUb.size() + " unbreakable queries...");
        }
        for (Map.Entry<Unbreakable, Boolean> ub : workingUb.entrySet()) {
            if (ub.getValue().booleanValue()) {
                this.insertUnbreakable(conn, ub.getKey());
                continue;
            }
            this.deleteUnbreakable(conn, ub.getKey());
        }
    }

    private void processPlayers(Connection conn, Map<String, Boolean> workingPlayers) throws SQLException {
        if (this.plugin.getSettingsManager().isDebug() && !workingPlayers.isEmpty()) {
            PreciousStones.getLog().info("[Queue] processing " + workingPlayers.size() + " player queries...");
        }
        for (Map.Entry<String, Boolean> workingPlayerEntry : workingPlayers.entrySet()) {
            String playerName = workingPlayerEntry.getKey();
            if (workingPlayerEntry.getValue().booleanValue()) {
                this.updatePlayer0(conn, playerName);
                continue;
            }
            this.deletePlayer(conn, playerName);
            this.deleteTranslocation(conn, playerName);
            this.deleteFields(conn, playerName);
            this.deleteUnbreakables(conn, playerName);
        }
    }

    private void processSnitches(Connection conn, List<SnitchEntry> workingSnitchEntries) throws SQLException {
        if (this.plugin.getSettingsManager().isDebug() && !workingSnitchEntries.isEmpty()) {
            PreciousStones.getLog().info("[Queue] sending " + workingSnitchEntries.size() + " snitch queries...");
        }
        for (SnitchEntry se : workingSnitchEntries) {
            this.insertSnitchEntry0(conn, se.getField(), se);
        }
    }

    private void processGrief(Connection conn, Set<Field> workingGrief) throws SQLException {
        if (this.plugin.getSettingsManager().isDebug() && !workingGrief.isEmpty()) {
            PreciousStones.getLog().info("[Queue] processing " + workingGrief.size() + " grief queries...");
        }
        for (Field field : workingGrief) {
            this.updateGrief(conn, field);
        }
    }
}

