/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.listeners;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.UUID;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.ForceFieldManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldEditListener {
    @Subscribe
    public void onEditSession(EditSessionEvent event) throws WorldEditException {
        if (event.getStage() != EditSession.Stage.BEFORE_CHANGE) {
            return;
        }
        if (event.getActor() == null) {
            return;
        }
        Actor actor = event.getActor();
        if (!actor.isPlayer()) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)actor.getUniqueId());
        event.setExtent((Extent)new ForceFieldProtectionExtent(player, BukkitAdapter.adapt((World)event.getWorld()), event.getExtent()));
    }

    public static void register(JavaPlugin owningPlugin) {
        ((WorldEditPlugin)JavaPlugin.getPlugin(WorldEditPlugin.class)).getWorldEdit().getEventBus().register((Object)new WorldEditListener());
    }

    public static class ForceFieldProtectionExtent
    extends AbstractDelegateExtent {
        private boolean allowed = true;
        private boolean warned = false;
        private boolean notified = false;
        private org.bukkit.World world;
        private Player player;

        protected ForceFieldProtectionExtent(Player player, org.bukkit.World world, Extent extent) {
            super(extent);
            this.player = player;
            this.world = world;
        }

        public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 l, T block) throws WorldEditException {
            if (!this.allowed) {
                return this.allowed;
            }
            Location bukkitLocation = new Location(this.world, (double)l.getX(), (double)l.getY(), (double)l.getZ());
            Block bukkitBlock = bukkitLocation.getBlock();
            PreciousStones ps = PreciousStones.getInstance();
            ForceFieldManager ffm = ps.getForceFieldManager();
            Field field = ffm.getEnabledSourceField(bukkitLocation, FieldFlag.PREVENT_DESTROY);
            if (ffm.isField(bukkitBlock)) {
                return false;
            }
            if (field != null && !field.getSettings().inDestroyBlacklist(bukkitBlock) && FieldFlag.PREVENT_DESTROY.applies(field, this.player)) {
                if (ps.getPermissionsManager().has(this.player, "preciousstones.bypass.destroy")) {
                    if (!this.notified) {
                        ps.getCommunicationManager().notifyBypassDestroy(this.player, bukkitBlock, field);
                        this.notified = true;
                    }
                } else {
                    this.allowed = false;
                    if (!this.warned) {
                        ps.getCommunicationManager().warnDestroyArea(this.player, bukkitBlock, field);
                        this.warned = true;
                    }
                    return false;
                }
            }
            return super.setBlock(l, block);
        }
    }
}

