/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.blocks;

import java.util.ArrayList;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.ItemStackEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.AbstractVec;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TranslocationBlock
extends AbstractVec {
    private BlockTypeEntry type;
    private String signText = "";
    private boolean empty = false;
    private int rx;
    private int ry;
    private int rz;
    private List<ItemStackEntry> contents = new ArrayList<ItemStackEntry>();

    public TranslocationBlock(int x, int y, int z, String world, BlockTypeEntry type) {
        super(x, y, z, world);
        this.type = type;
    }

    public TranslocationBlock(Location loc, BlockTypeEntry type) {
        super(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), loc.getWorld().getName());
        this.type = type;
    }

    public TranslocationBlock(Block block) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
        this.type = new BlockTypeEntry(block.getType());
    }

    public TranslocationBlock(Field field, Block block) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
        this.type = new BlockTypeEntry(block.getType());
        this.setRelativeCoords(field);
    }

    public TranslocationBlock(BlockState state) {
        super(state.getX(), state.getY(), state.getZ(), state.getWorld().getName());
        this.type = new BlockTypeEntry(state.getType());
        this.empty = true;
    }

    public Material getType() {
        return this.type.getMaterial();
    }

    public String getSignText() {
        return this.signText;
    }

    public void setSignText(String signText) {
        this.signText = signText;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public TranslocationBlock(String packed) {
        super(Helper.locationFromPacked(packed).getBlockX(), Helper.locationFromPacked(packed).getBlockY(), Helper.locationFromPacked(packed).getBlockZ(), Helper.locationFromPacked(packed).getWorld().getName());
        String[] unpacked = packed.split("[|]");
        this.type = new BlockTypeEntry(unpacked[0]);
    }

    public String serialize() {
        return this.getType().name() + "|" + this.getLocation().getBlockX() + "|" + this.getLocation().getBlockY() + "|" + this.getLocation().getBlockZ() + "|" + this.getLocation().getWorld();
    }

    public void setRelativeCoords(int x, int y, int z) {
        this.rx = x;
        this.ry = y;
        this.rz = z;
    }

    public void setRelativeCoords(Field field) {
        Location location = this.getLocation();
        location = location.subtract(field.getLocation());
        this.rx = location.getBlockX();
        this.ry = location.getBlockY();
        this.rz = location.getBlockZ();
    }

    public Location getRelativeLocation() {
        World world = Bukkit.getServer().getWorld(this.getWorld());
        Location location = new Location(world, (double)this.rx, (double)this.ry, (double)this.rz);
        return location;
    }

    public Location getRelativeLocation(Field currentField) {
        World world = Bukkit.getServer().getWorld(this.getWorld());
        Location location = new Location(world, (double)this.rx, (double)this.ry, (double)this.rz);
        location = location.add(currentField.getLocation());
        return location;
    }

    public int getRx() {
        return this.rx;
    }

    public int getRy() {
        return this.ry;
    }

    public int getRz() {
        return this.rz;
    }

    private void extractContents() {
    }

    public ItemStack[] getItemStacks() {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        for (ItemStackEntry entry : this.contents) {
            out.add(entry.toItemStack());
        }
        return out.toArray(new ItemStack[0]);
    }

    public boolean hasItemStacks() {
        return !this.contents.isEmpty();
    }

    public void setContents(ItemStack[] stacks) {
        this.contents.clear();
        for (ItemStack stack : stacks) {
            if (stack == null) {
                this.contents.add(new ItemStackEntry(new ItemStack(Material.AIR)));
                continue;
            }
            this.contents.add(new ItemStackEntry(stack));
        }
    }

    public String getContents() {
        JSONArray out = new JSONArray();
        for (ItemStackEntry entry : this.contents) {
            out.add((Object)entry.serialize());
        }
        return out.toString();
    }

    public void setContents(String contents) {
        if (contents.length() == 0) {
            return;
        }
        JSONArray in = (JSONArray)JSONValue.parse((String)contents);
        this.contents.clear();
        for (Object item : in) {
            this.contents.add(new ItemStackEntry((JSONObject)item));
        }
    }
}

