/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sacredlabyrinth.Phaed.PreciousStones.shaded.com.zaxxer.hikari.HikariConfig;
import net.sacredlabyrinth.Phaed.PreciousStones.shaded.com.zaxxer.hikari.HikariDataSource;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.AbstractDBCore;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.VendorType;

class MySQLCore2
extends AbstractDBCore {
    private final HikariDataSource dataSource;

    MySQLCore2(String host, int port, String database, String username, String password) {
        super(VendorType.MYSQL);
        HikariConfig hikariConf = new HikariConfig();
        hikariConf.setJdbcUrl("jdbc:mysql://" + host + ':' + port + '/' + database + "?useUnicode=true&characterEncoding=utf-8");
        hikariConf.setUsername(username);
        hikariConf.setPassword(password);
        MySQLCore2.setExtraPoolDetails(hikariConf);
        this.dataSource = new HikariDataSource(hikariConf);
    }

    @Override
    HikariDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean supportsGetDataType() {
        return true;
    }

    @Override
    public String getDataType(Connection conn, String table, String column) throws SQLException {
        String dataType = "";
        try (PreparedStatement prepStmt = conn.prepareStatement("SELECT DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = ? AND COLUMN_NAME = ?");){
            prepStmt.setString(1, table);
            prepStmt.setString(2, column);
            try (ResultSet resultSet = prepStmt.executeQuery();){
                while (resultSet.next()) {
                    dataType = resultSet.getString("DATA_TYPE");
                }
            }
        }
        return dataType == null ? "" : dataType;
    }
}

