/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.DBCore;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.VendorType;

class TableCreator
implements AutoCloseable {
    private final DBCore core;
    private final Connection conn;
    private final boolean isMySql;

    TableCreator(DBCore core) throws SQLException {
        this.core = core;
        this.conn = core.getConnection();
        this.isMySql = core.getVendorType() == VendorType.MYSQL;
    }

    void createTables() throws SQLException {
        this.createCuboids();
        this.createFields();
        this.createUnbreakables();
        this.createGriefUndo();
        this.createTranslocations();
        this.createStoredBlocks();
        this.createPlayers();
        this.createSnitches();
        this.createPurchasePayments();
    }

    boolean tableExists(String table) throws SQLException {
        return this.core.tableExists(this.conn, table);
    }

    private void execute(String statement) throws SQLException {
        try (PreparedStatement prepStmt = this.conn.prepareStatement(statement);){
            prepStmt.execute();
        }
    }

    private void execute(String statement, Object param1) throws SQLException {
        try (PreparedStatement prepStmt = this.conn.prepareStatement(statement);){
            prepStmt.setObject(1, param1);
            prepStmt.execute();
        }
    }

    private void createCuboids() throws SQLException {
        this.execute("CREATE TABLE IF NOT EXISTS `pstone_cuboids` (" + (this.isMySql ? "`id` bigint(20) NOT NULL auto_increment PRIMARY KEY" : "`id` INTEGER PRIMARY KEY") + ", `parent` bigint(20) NOT NULL, `x` int(11) default NULL, `y` int(11) default NULL, `z` int(11) default NULL, `world` varchar(25) default NULL, `minx` int(11) default NULL, `maxx` int(11) default NULL, `miny` int(11) default NULL, `maxy` int(11) default NULL, `minz` int(11) default NULL, `maxz` int(11) default NULL, `velocity` float default NULL, `type_id` int(11) default NULL, `data` tinyint default 0, `owner` varchar(16) NOT NULL, `name` varchar(50) NOT NULL, `packed_allowed` text NOT NULL, `last_used` bigint(20) Default NULL, `flags` TEXT NOT NULL, " + (this.isMySql ? "UNIQUE KEY `uq_cuboid_fields_1` (`x`,`y`,`z`,`world`))" : "UNIQUE (`x`,`y`,`z`,`world`))"));
    }

    private void createFields() throws SQLException {
        this.execute("CREATE TABLE IF NOT EXISTS `pstone_fields` (" + (this.isMySql ? "`id` bigint(20) NOT NULL auto_increment PRIMARY KEY" : "`id` INTEGER PRIMARY KEY") + ", `x` int(11) default NULL, `y` int(11) default NULL, `z` int(11) default NULL, `world` varchar(25) default NULL, `radius` int(11) default NULL, `height` int(11) default NULL, `velocity` float default NULL, `type_id` int(11) default NULL, `data` tinyint default 0, `owner` varchar(16) NOT NULL, `name` varchar(50) NOT NULL, `packed_allowed` text NOT NULL, `last_used` bigint(20) Default NULL, `flags` TEXT NOT NULL, " + (this.isMySql ? "UNIQUE KEY `uq_pstone_fields_1` (`x`,`y`,`z`,`world`))" : "UNIQUE (`x`,`y`,`z`,`world`))"));
    }

    private void createUnbreakables() throws SQLException {
        this.execute("CREATE TABLE IF NOT EXISTS `pstone_unbreakables` (" + (this.isMySql ? "`id` bigint(20) NOT NULL auto_increment PRIMARY KEY" : "`id` INTEGER PRIMARY KEY") + ", `x` int(11) default NULL, `y` int(11) default NULL, `z` int(11) default NULL, `world` varchar(25) default NULL, `owner` varchar(16) NOT NULL, `type_id` int(11) default NULL, `data` tinyint default 0, " + (this.isMySql ? "UNIQUE KEY `uq_pstone_unbreakables_1` (`x`,`y`,`z`,`world`))" : "UNIQUE (`x`,`y`,`z`,`world`))"));
    }

    private void createGriefUndo() throws SQLException {
        this.execute("CREATE TABLE IF NOT EXISTS `pstone_grief_undo` (" + (this.isMySql ? "`id` bigint(20) NOT NULL auto_increment PRIMARY KEY, " : "`id` INTEGER PRIMARY KEY, ") + "`date_griefed` bigint(20), `field_x` int(11) default NULL, `field_y` int(11) default NULL, `field_z` int(11) default NULL, `world` varchar(25) NOT NULL, `x` int(11) default NULL, `y` int(11) default NULL, `z` int(11) default NULL, `type_id` int(11) NOT NULL, `data` TINYINT NOT NULL, `sign_text` varchar(75) NOT NULL)");
    }

    private void createTranslocations() throws SQLException {
        this.execute("CREATE TABLE IF NOT EXISTS `pstone_translocations` (" + (this.isMySql ? "`id` bigint(20) NOT NULL auto_increment PRIMARY KEY, " : "`id` INTEGER PRIMARY KEY, ") + "`name` varchar(36) NOT NULL, `player_name` varchar(16) NOT NULL, `minx` int(11) default NULL, `maxx` int(11) default NULL, `miny` int(11) default NULL, `maxy` int(11) default NULL, `minz` int(11) default NULL, `maxz` int(11) default NULL, " + (this.isMySql ? "UNIQUE KEY `uq_trans_1` (`name`,`player_name`))" : "UNIQUE (`name`,`player_name`))"));
    }

    private void createStoredBlocks() throws SQLException {
        this.execute("CREATE TABLE IF NOT EXISTS `pstone_storedblocks` (" + (this.isMySql ? "`id` bigint(20) NOT NULL auto_increment PRIMARY KEY, " : "`id` INTEGER PRIMARY KEY,  ") + "`name` varchar(36) NOT NULL, `player_name` varchar(16) NOT NULL, `x` int(11) default NULL, `y` int(11) default NULL, `z` int(11) default NULL, `world` varchar(25) NOT NULL, `type_id` int(11) NOT NULL, `data` TINYINT NOT NULL, `sign_text` varchar(75) NOT NULL, `applied` bit default 0, `contents` TEXT NOT NULL, " + (this.isMySql ? "UNIQUE KEY `uq_trans_2` (`x`,`y`,`z`,`world`))" : "UNIQUE (`x`,`y`,`z`,`world`))"));
    }

    private void createPlayers() throws SQLException {
        this.execute("CREATE TABLE IF NOT EXISTS `pstone_players` (`id` bigint(20), `uuid` varchar(255) default NULL, `player_name` varchar(16) NOT NULL, `last_seen` bigint(20) default NULL, flags TEXT default NULL, PRIMARY KEY (`player_name`))");
    }

    private void createSnitches() throws SQLException {
        if (this.tableExists("pstone_snitches")) {
            return;
        }
        this.execute("CREATE TABLE IF NOT EXISTS `pstone_snitches` (`id` bigint(20), `x` int(11) default NULL, `y` int(11) default NULL, `z` int(11) default NULL, `world` varchar(25) default NULL, `name` varchar(16) NOT NULL, `reason` varchar(20) default NULL, `details` varchar(50) default NULL, `count` int(11) default NULL, `date` varchar(25) default NULL, PRIMARY KEY (`x`, `y`, `z`, `world`, `name`, `reason`, `details`))");
        this.addIndexes();
    }

    private void createPurchasePayments() throws SQLException {
        if (this.tableExists("pstone_purchase_payments")) {
            return;
        }
        this.execute("CREATE TABLE IF NOT EXISTS `pstone_purchase_payments` (`id` bigint(20), `buyer` varchar(16) default NULL, `owner` varchar(16) NOT NULL, `item` varchar(20) default NULL, `amount` int(11) default NULL, `fieldName` varchar(255) default NULL, `coords` varchar(255) default NULL)");
        this.addIndexes();
    }

    private void addIndexes() throws SQLException {
        if (this.isMySql) {
            this.execute("ALTER TABLE `pstone_grief_undo` ADD UNIQUE KEY `key_grief_locs` (`x`, `y`, `z`, `world`)");
            this.execute("ALTER TABLE `pstone_fields` ADD INDEX `indx_field_owner` (`owner`);");
            this.execute("ALTER TABLE `pstone_players` ADD UNIQUE `unq_uuid` (uuid);");
            this.execute("ALTER TABLE `pstone_players` ADD INDEX `inx_player_name` (player_name);");
            this.execute("ALTER TABLE `pstone_cuboids` ADD INDEX `indx_cuboids_owner` (`owner`);");
            this.execute("ALTER TABLE `pstone_cuboids` ADD INDEX `indx_cuboids_parent` (`parent`);");
            this.execute("ALTER TABLE `pstone_unbreakables` ADD INDEX `indx_unbreakables_owner` (`owner`);");
            this.execute("ALTER TABLE `pstone_storedblocks` ADD INDEX `indx_storedblocks_1` (`name`, `player_name`, `applied`);");
            this.execute("ALTER TABLE `pstone_storedblocks` ADD INDEX `indx_storedblocks_2` (`name`, `player_name`, `applied`, `type_id`, `data`);");
        } else {
            this.execute("CREATE INDEX IF NOT EXISTS `indx_field_owner` ON `pstone_fields` (`owner`);");
            this.execute("CREATE UNIQUE INDEX IF NOT EXISTS `indx_players_uuid` ON `pstone_players` (`uuid`);");
            this.execute("CREATE UNIQUE INDEX IF NOT EXISTS `indx_player_name` ON `pstone_players` (`player_name`);");
            this.execute("CREATE INDEX IF NOT EXISTS `indx_cuboids_owner` ON `pstone_cuboids` (`owner`);");
            this.execute("CREATE INDEX IF NOT EXISTS `indx_cuboids_parent` ON `pstone_cuboids` (`parent`);");
            this.execute("CREATE INDEX IF NOT EXISTS `indx_unbreakables_owner` ON `pstone_unbreakables` (`owner`);");
        }
        PreciousStones.log("Added new indexes to database", new Object[0]);
    }

    private String getDataType(String table, String column) throws SQLException {
        if (!this.core.supportsGetDataType()) {
            return "";
        }
        return this.core.getDataType(this.conn, table, column);
    }

    void addData() throws SQLException {
        if (!this.getDataType("pstone_fields", "data").equals("tinyint")) {
            this.execute("alter table pstone_fields add column data tinyint default 0");
        }
        if (!this.getDataType("pstone_cuboids", "data").equals("tinyint")) {
            this.execute("alter table pstone_cuboids add column data tinyint default 0");
        }
        if (!this.getDataType("pstone_unbreakables", "data").equals("tinyint")) {
            this.execute("alter table pstone_unbreakables add column data tinyint default 0");
        }
    }

    void addSnitchDate() throws SQLException {
        if (!this.getDataType("pstone_snitches", "date").equals("varchar")) {
            this.execute("alter table pstone_snitches add column date varchar(25) default NULL");
        }
    }

    void resetLastSeen() throws SQLException {
        if (!this.getDataType("pstone_grief_undo", "date_griefed").equals("bigint")) {
            this.execute("alter table pstone_grief_undo modify date_griefed bigint");
            this.execute("update pstone_grief_undo date_griefed = ?", Helper.getMillis());
        }
        if (!this.getDataType("pstone_fields", "last_used").equals("bigint")) {
            this.execute("alter table pstone_fields modify last_used bigint");
            this.execute("update pstone_fields last_used = ?", Helper.getMillis());
        }
        if (!this.getDataType("pstone_cuboids", "last_used").equals("bigint")) {
            this.execute("alter table pstone_cuboids modify last_used bigint");
            this.execute("update pstone_cuboids last_used = ?", Helper.getMillis());
        }
        if (!this.getDataType("pstone_players", "last_seen").equals("bigint")) {
            this.execute("alter table pstone_players modify last_seen bigint");
            this.execute("update pstone_players last_seen = ?", Helper.getMillis());
        }
    }

    @Override
    public void close() throws SQLException {
        this.conn.close();
    }
}

