/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.sacredlabyrinth.Phaed.PreciousStones.MaterialName;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.SignHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.SettingsManager;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;

public class FieldSettings {
    protected String metaName = "";
    protected boolean metaAutoSet = false;
    protected List<String> metaLore = new ArrayList<String>();
    protected int foresterUses = 1;
    protected BlockTypeEntry groundBlock;
    protected int treeCount = 64;
    protected int creatureCount = 6;
    protected int growTime = 20;
    protected int shrubDensity = 64;
    protected boolean validField = true;
    protected BlockTypeEntry type;
    protected int radius = 0;
    protected Material fenceItem = Material.AIR;
    protected int fenceItemPrice = 0;
    protected int heal = 0;
    protected int damage = 0;
    protected Material maskOnDisabled = Material.OBSIDIAN;
    protected Material maskOnEnabled = Material.OBSIDIAN;
    protected int feed = 0;
    protected int repair = 0;
    protected int launchHeight = 0;
    protected int cannonHeight = 0;
    protected int customHeight = 0;
    protected int customVolume = 0;
    protected int mineDelaySeconds = 0;
    protected int lightningDelaySeconds = 0;
    protected Material lightningReplaceBlock = Material.AIR;
    protected int mixingGroup = 0;
    protected int autoDisableTime = 0;
    protected int mustBeAbove = 0;
    protected int mustBeBelow = 0;
    protected boolean mineHasFire = false;
    protected int mine = 6;
    protected String groupOnEntry = "";
    protected String requiredPermissionAllow = "";
    protected String requiredPermissionUse = "";
    protected String requiredPermission = "";
    protected String deleteIfNoPermission = "";
    protected GameMode forceEntryGameMode = null;
    protected GameMode forceLeavingGameMode = null;
    protected String title;
    protected int price = 0;
    protected int refund = -1;
    protected int teleportCost = 0;
    protected int teleportBackAfterSeconds = 0;
    protected int teleportMaxDistance = 0;
    protected int griefRevertInterval = 0;
    protected int payToEnable = 0;
    protected int rentsLimit = 0;
    protected List<String> commandOnEnter = new ArrayList<String>();
    protected List<String> commandOnExit = new ArrayList<String>();
    protected List<String> playerCommandOnEnter = new ArrayList<String>();
    protected List<String> playerCommandOnExit = new ArrayList<String>();
    protected List<BlockTypeEntry> teleportIfHoldingItems = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> teleportIfNotHoldingItems = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> teleportIfHasItems = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> teleportIfNotHasItems = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> unusableItems = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> teleportIfWalkingOn = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> teleportIfNotWalkingOn = new ArrayList<BlockTypeEntry>();
    protected List<Integer> treeTypes = new ArrayList<Integer>();
    protected List<Integer> shrubTypes = new ArrayList<Integer>();
    protected List<String> creatureTypes = new ArrayList<String>();
    protected List<BlockTypeEntry> fertileBlocks = new ArrayList<BlockTypeEntry>();
    protected List<Integer> limits = new ArrayList<Integer>();
    protected List<BlockTypeEntry> surfaces = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> translocationBlacklist = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> preventPlaceBlacklist = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> preventDestroyBlacklist = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> preventUse = new ArrayList<BlockTypeEntry>();
    protected List<BlockTypeEntry> confiscatedItems = new ArrayList<BlockTypeEntry>();
    protected List<String> allowedWorlds = new ArrayList<String>();
    protected List<String> allowedOnlyInside = new ArrayList<String>();
    protected List<String> allowedOnlyOutside = new ArrayList<String>();
    protected List<String> commandBlackList = new ArrayList<String>();
    protected List<FieldFlag> defaultFlags = new ArrayList<FieldFlag>();
    protected List<FieldFlag> reversedFlags = new ArrayList<FieldFlag>();
    protected List<FieldFlag> alledflags = new ArrayList<FieldFlag>();
    protected List<FieldFlag> disabledFlags = new ArrayList<FieldFlag>();
    protected List<BlockTypeEntry> allowGrief = new ArrayList<BlockTypeEntry>();
    protected HashMap<PotionEffectType, Integer> potions = new HashMap();
    protected List<PotionEffectType> neutralizePotions = new ArrayList<PotionEffectType>();
    protected List<String> allowedPlayers = new ArrayList<String>();
    protected List<String> deniedPlayers = new ArrayList<String>();
    protected List<String> potionTargets = new ArrayList<String>();
    protected LinkedHashMap<String, Object> map;
    private Set<FieldSettings> mergedFields = new HashSet<FieldSettings>();
    private double priceMultiplier = 0.0;

    public FieldSettings(LinkedHashMap<String, Object> map) {
        this.map = map;
        if (map == null) {
            return;
        }
        this.defaultFlags.add(FieldFlag.ALL);
        if (!this.validation()) {
            return;
        }
        this.parseSettings();
    }

    protected boolean validation() {
        this.title = this.loadString("title");
        if (this.title == null) {
            this.validField = false;
            return false;
        }
        this.type = this.loadTypeEntry("block");
        if (this.type == null) {
            this.validField = false;
            return false;
        }
        return true;
    }

    protected void parseSettings() {
        String leavingGameMode;
        String entryGameMode;
        PreciousStones.debug("**********************", new Object[0]);
        this.customHeight = this.loadInt("custom-height");
        if (this.customHeight > 0 && this.customHeight % 2 == 0) {
            ++this.customHeight;
        }
        if ((entryGameMode = this.loadString("entry-game-mode")).equalsIgnoreCase("creative")) {
            this.forceEntryGameMode = GameMode.CREATIVE;
        }
        if (entryGameMode.equalsIgnoreCase("survival")) {
            this.forceEntryGameMode = GameMode.SURVIVAL;
        }
        if ((leavingGameMode = this.loadString("leaving-game-mode")).equalsIgnoreCase("creative")) {
            this.forceLeavingGameMode = GameMode.CREATIVE;
        }
        if (leavingGameMode.equalsIgnoreCase("survival")) {
            this.forceLeavingGameMode = GameMode.SURVIVAL;
        }
        List<String> pts = this.loadStringList("potions");
        List<Integer> intensities = this.loadIntList("potion-intensity");
        int pos = 0;
        for (String name : pts) {
            int i = 1;
            if (intensities != null) {
                i = intensities.get(pos);
            }
            if (PotionEffectType.getByName((String)name) != null) {
                this.potions.put(PotionEffectType.getByName((String)name), i);
            }
            ++pos;
        }
        List<String> npts = this.loadStringList("neutralize-potions");
        for (String name : npts) {
            if (PotionEffectType.getByName((String)name) == null) continue;
            this.neutralizePotions.add(PotionEffectType.getByName((String)name));
        }
        this.loadBoolean("no-resize");
        this.loadBoolean("prevent-fire");
        this.loadBoolean("prevent-fire-spread");
        this.loadBoolean("enable-with-redstone");
        this.loadBoolean("allow-place");
        this.loadBoolean("allow-destroy");
        this.loadBoolean("prevent-place");
        this.loadBoolean("prevent-destroy");
        this.loadBoolean("prevent-use-doors");
        this.loadBoolean("prevent-use-redstone");
        this.loadBoolean("prevent-vehicle-destroy");
        this.loadBoolean("prevent-vehicle-create");
        this.loadBoolean("prevent-enderman-destroy");
        this.loadBoolean("prevent-explosions");
        this.loadBoolean("prevent-creeper-explosions");
        this.loadBoolean("prevent-wither-explosions");
        this.loadBoolean("prevent-tnt-explosions");
        this.loadBoolean("rollback-explosions");
        this.loadBoolean("prevent-pvp");
        this.loadBoolean("prevent-teleport");
        this.loadBoolean("prevent-mob-damage");
        this.loadBoolean("prevent-mob-spawn");
        this.loadBoolean("prevent-animal-spawn");
        this.loadBoolean("prevent-spawn-egg");
        this.loadBoolean("prevent-entry");
        this.loadBoolean("prevent-unprotectable");
        this.loadBoolean("prevent-potion-splash");
        this.loadBoolean("prevent-portal-enter");
        this.loadBoolean("prevent-portal-creation");
        this.loadBoolean("prevent-portal-destination");
        this.loadBoolean("prevent-potion-splash");
        this.loadBoolean("prevent-vehicle-enter");
        this.loadBoolean("prevent-vehicle-exit");
        this.loadBoolean("prevent-item-frame-take");
        this.loadBoolean("protect-armor-stands");
        this.loadBoolean("prevent-entity-interact");
        this.loadBoolean("protect-animals");
        this.loadBoolean("protect-villagers");
        this.loadBoolean("protect-crops");
        this.loadBoolean("protect-mobs");
        this.loadBoolean("protect-lwc");
        this.loadBoolean("protect-inventories");
        this.loadBoolean("remove-mob");
        this.loadBoolean("worldguard-repellent");
        this.loadBoolean("breakable");
        this.loadBoolean("welcome-message");
        this.loadBoolean("farewell-message");
        this.loadBoolean("air");
        this.loadBoolean("snitch");
        this.loadBoolean("no-conflict");
        this.loadBoolean("no-owner");
        this.loadBoolean("launch");
        this.loadBoolean("cannon");
        this.loadBoolean("lightning");
        this.loadBoolean("no-fall-damage");
        this.loadBoolean("sneak-to-place");
        this.loadBoolean("sneak-to-place-only");
        this.loadBoolean("plot");
        this.loadBoolean("prevent-flow");
        this.loadBoolean("forester");
        this.loadBoolean("grief-revert");
        this.loadBoolean("grief-revert-drop");
        this.loadBoolean("grief-revert-safety");
        this.loadBoolean("entry-alert");
        this.loadBoolean("cuboid");
        this.loadBoolean("visualize-on-src");
        this.loadBoolean("visualize-on-place");
        this.loadBoolean("keep-chunks-loaded");
        this.loadBoolean("place-grief");
        this.loadBoolean("toggle-on-disabled");
        this.loadBoolean("redefine-on-disabled");
        this.loadBoolean("modify-on-disabled");
        this.loadBoolean("enable-on-src");
        this.loadBoolean("breakable-on-disabled");
        this.loadBoolean("no-player-place");
        this.loadBoolean("no-projectile-throw");
        this.loadBoolean("no-dropping-items");
        this.loadBoolean("no-player-sprint");
        this.loadBoolean("translocation");
        this.loadBoolean("translocation-safety");
        this.loadBoolean("prevent-flight");
        this.loadBoolean("allowed-can-break");
        this.loadBoolean("sneaking-bypass");
        this.loadBoolean("dynmap-area");
        this.loadBoolean("dynmap-marker");
        this.loadBoolean("dynmap-disabled");
        this.loadBoolean("dynmap-no-toggle");
        this.loadBoolean("dynmap-hide-players");
        this.loadBoolean("dynmap-show-players");
        this.loadBoolean("can-change-owner");
        this.loadBoolean("no-allowing");
        this.loadBoolean("hidable");
        this.loadBoolean("teleport-before-death");
        this.loadBoolean("teleport-on-damage");
        this.loadBoolean("teleport-on-feeding");
        this.loadBoolean("teleport-mobs-on-enable");
        this.loadBoolean("teleport-animals-on-enable");
        this.loadBoolean("teleport-players-on-enable");
        this.loadBoolean("teleport-villagers-on-enable");
        this.loadBoolean("teleport-on-fire");
        this.loadBoolean("teleport-on-pvp");
        this.loadBoolean("teleport-on-block-place");
        this.loadBoolean("teleport-on-block-break");
        this.loadBoolean("teleport-on-sneak");
        this.loadBoolean("teleport-on-entry");
        this.loadBoolean("teleport-on-exit");
        this.loadBoolean("teleport-explosion-effect");
        this.loadBoolean("teleport-relatively");
        this.loadBoolean("teleport-announce");
        this.loadBoolean("teleport-destination");
        this.loadBoolean("disable-when-online");
        this.loadBoolean("no-growth");
        this.loadBoolean("single-use");
        this.loadBoolean("commands-on-overlap");
        this.loadBoolean("shareable");
        this.loadBoolean("buyable");
        this.loadBoolean("rentable");
        this.loadBoolean("command-blacklisting");
        this.loadBoolean("anti-plot");
        this.loadBoolean("potion-ignore-player");
        this.metaAutoSet = this.loadBoolean("meta-autoset");
        this.metaName = this.loadString("meta-name");
        this.metaLore = this.loadStringList("meta-lore");
        this.foresterUses = this.loadInt("forester-uses");
        this.surfaces = this.loadTypeEntries("surfaces");
        this.requiredPermission = this.loadString("required-permission");
        this.requiredPermissionUse = this.loadString("required-permission-use");
        this.requiredPermissionAllow = this.loadString("required-permission-allow");
        this.deleteIfNoPermission = this.loadString("delete-if-no-permission");
        this.groupOnEntry = this.loadString("group-on-entry");
        this.autoDisableTime = this.loadPeriodSeconds("auto-disable");
        this.radius = this.loadInt("radius");
        this.mixingGroup = this.loadInt("mixing-group");
        this.customVolume = this.loadInt("custom-volume");
        this.launchHeight = this.loadInt("launch-velocity");
        this.cannonHeight = this.loadInt("cannon-velocity");
        this.mineDelaySeconds = this.loadInt("mine-delay-seconds");
        this.mineHasFire = this.loadBoolean("mine-has-fire");
        this.lightningReplaceBlock = this.loadMaterial("lightning-replace-block");
        this.lightningDelaySeconds = this.loadInt("lightning-delay-seconds");
        this.treeCount = this.loadInt("tree-count");
        this.growTime = this.loadInt("grow-time");
        this.shrubDensity = this.loadInt("shrub-density");
        this.groundBlock = this.loadTypeEntry("ground-block");
        this.preventUse = this.loadTypeEntries("prevent-use");
        this.confiscatedItems = this.loadTypeEntries("confiscate-items");
        this.allowedPlayers = this.loadStringList("always-allow-players");
        this.deniedPlayers = this.loadStringList("always-deny-players");
        this.allowGrief = this.loadTypeEntries("allow-grief");
        this.treeTypes = this.loadIntList("tree-types");
        this.shrubTypes = this.loadIntList("shrub-types");
        this.creatureTypes = this.loadStringList("creature-types");
        this.fertileBlocks = this.loadTypeEntries("fertile-blocks");
        this.allowedWorlds = this.loadStringList("allowed-worlds");
        this.creatureCount = this.loadInt("creature-count");
        this.limits = this.loadIntList("limits");
        this.price = this.loadInt("price");
        this.refund = this.loadInt("refund", -1);
        this.unusableItems = this.loadTypeEntries("unusable-items");
        this.translocationBlacklist = this.loadTypeEntries("translocation-blacklist");
        this.preventPlaceBlacklist = this.loadTypeEntries("prevent-place-blacklist");
        this.preventDestroyBlacklist = this.loadTypeEntries("prevent-destroy-blacklist");
        this.allowedOnlyInside = this.loadStringList("allowed-only-inside");
        this.allowedOnlyOutside = this.loadStringList("allowed-only-outside");
        this.heal = this.loadInt("heal");
        this.feed = this.loadInt("feed");
        this.repair = this.loadInt("repair");
        this.damage = this.loadInt("damage");
        this.maskOnDisabled = this.loadMaterial("mask-on-disabled");
        this.maskOnEnabled = this.loadMaterial("mask-on-enabled");
        this.mine = this.loadInt("mine");
        this.heal = this.loadInt("heal");
        this.griefRevertInterval = this.loadInt("grief-revert-interval");
        this.commandOnEnter = this.loadStringList("command-on-enter");
        this.commandOnExit = this.loadStringList("command-on-exit");
        this.playerCommandOnEnter = this.loadStringList("player-command-on-enter");
        this.playerCommandOnExit = this.loadStringList("player-command-on-exit");
        this.commandBlackList = this.loadStringList("command-blacklist");
        this.teleportCost = this.loadInt("teleport-cost");
        this.teleportBackAfterSeconds = this.loadInt("teleport-back-after-seconds");
        this.teleportMaxDistance = this.loadInt("teleport-max-distance");
        this.teleportIfWalkingOn = this.loadTypeEntries("teleport-if-walking-on");
        this.teleportIfNotWalkingOn = this.loadTypeEntries("teleport-if-not-walking-on");
        this.teleportIfHoldingItems = this.loadTypeEntries("teleport-if-holding-items");
        this.teleportIfNotHoldingItems = this.loadTypeEntries("teleport-if-not-holding-items");
        this.teleportIfHasItems = this.loadTypeEntries("teleport-if-has-items");
        this.teleportIfNotHasItems = this.loadTypeEntries("teleport-if-not-has-items");
        this.mustBeAbove = this.loadInt("must-be-above");
        this.mustBeBelow = this.loadInt("must-be-below");
        this.payToEnable = this.loadInt("pay-to-enable");
        this.fenceItem = this.loadMaterial("fence-on-place");
        this.fenceItemPrice = this.loadInt("price-per-fence");
        this.rentsLimit = this.loadInt("rents-limit");
        this.potionTargets = this.loadStringList("potion-targets");
        this.priceMultiplier = this.loadDouble("price-multiplier");
    }

    protected boolean loadBoolean(String flagStr) {
        if (this.containsKey(flagStr)) {
            boolean value = Boolean.parseBoolean(this.getValue(flagStr).toString());
            if (value) {
                this.loadFlags(this.getKey(flagStr));
            }
            PreciousStones.debug("   %s: %s", flagStr, value);
            return value;
        }
        return false;
    }

    protected Material loadMaterial(String flagStr) {
        return this.loadMaterial(flagStr, Material.AIR);
    }

    protected Material loadMaterial(String flagStr, Material defaultValue) {
        Material material = null;
        if (this.containsKey(flagStr) && Helper.isString(this.getValue(flagStr))) {
            String value = (String)this.getValue(flagStr);
            material = MaterialName.getBlockMaterial(value);
        }
        if (material == null) {
            material = defaultValue;
        }
        return material;
    }

    protected int loadInt(String flagStr) {
        return this.loadInt(flagStr, 0);
    }

    protected int loadInt(String flagStr, int defaultValue) {
        if (this.containsKey(flagStr)) {
            if (Helper.isInteger(this.getValue(flagStr))) {
                int value = (Integer)this.getValue(flagStr);
                this.loadFlags(this.getKey(flagStr));
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return defaultValue;
    }

    protected double loadDouble(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isDouble(this.getValue(flagStr)) || Helper.isInteger(this.getValue(flagStr))) {
                double value = ((Number)this.getValue(flagStr)).doubleValue();
                this.loadFlags(this.getKey(flagStr));
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return 0.0;
    }

    protected String loadString(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isString(this.getValue(flagStr))) {
                String value = (String)this.getValue(flagStr);
                if (value != null) {
                    if (!value.isEmpty()) {
                        this.loadFlags(this.getKey(flagStr));
                    }
                    PreciousStones.debug("   %s: %s", flagStr, value);
                    return ChatColor.translateAlternateColorCodes((char)'&', (String)value);
                }
                PreciousStones.log(Level.WARNING, (Object)"** Malformed Flag %s", flagStr);
                return null;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return "";
    }

    protected int loadPeriodSeconds(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isInteger(this.getValue(flagStr))) {
                int value = (Integer)this.getValue(flagStr);
                this.loadFlags(this.getKey(flagStr));
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            if (Helper.isString(this.getValue(flagStr))) {
                String str = (String)this.getValue(flagStr);
                int value = SignHelper.periodToSeconds(str);
                this.loadFlags(this.getKey(flagStr));
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return 0;
    }

    protected BlockTypeEntry loadTypeEntry(String flagStr) {
        if (this.containsKey(flagStr)) {
            Object typeStr = this.getValue(flagStr);
            BlockTypeEntry value = new BlockTypeEntry(typeStr.toString());
            if (value.isValid()) {
                this.loadFlags(this.getKey(flagStr));
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return null;
    }

    protected List<String> loadStringList(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isStringList(this.getValue(flagStr))) {
                List value = (List)this.getValue(flagStr);
                if (value != null) {
                    if (!value.isEmpty()) {
                        this.loadFlags(this.getKey(flagStr));
                    }
                    PreciousStones.debug("   %s: %s", flagStr, value);
                    ArrayList<String> colored = new ArrayList<String>();
                    for (String s : value) {
                        if (s == null || s.isEmpty()) {
                            colored.add("");
                            continue;
                        }
                        colored.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
                    }
                    return colored;
                }
                PreciousStones.log(Level.WARNING, (Object)"** Malformed Flag %s", flagStr);
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return new ArrayList<String>();
    }

    protected List<BlockTypeEntry> loadTypeEntries(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isStringList(this.getValue(flagStr))) {
                List<BlockTypeEntry> value = Helper.toTypeEntriesBlind((List)this.getValue(flagStr));
                if (!value.isEmpty()) {
                    this.loadFlags(this.getKey(flagStr));
                }
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return new ArrayList<BlockTypeEntry>();
    }

    protected List<Integer> loadIntList(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isIntList(this.getValue(flagStr))) {
                List value = (List)this.getValue(flagStr);
                if (value != null) {
                    if (!value.isEmpty()) {
                        this.loadFlags(this.getKey(flagStr));
                    }
                    PreciousStones.debug("   %s: %s", flagStr, value);
                    return value;
                }
                PreciousStones.log(Level.WARNING, (Object)"** Malformed Flag %s", flagStr);
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return new ArrayList<Integer>();
    }

    protected boolean containsKey(String flagStr) {
        if (this.map.containsKey(flagStr)) {
            return true;
        }
        if (this.map.containsKey("~" + flagStr)) {
            return true;
        }
        if (this.map.containsKey("^" + flagStr)) {
            return true;
        }
        return this.map.containsKey("?" + flagStr);
    }

    protected String getKey(String flagStr) {
        if (this.map.containsKey(flagStr)) {
            return flagStr;
        }
        if (this.map.containsKey("~" + flagStr)) {
            return "~" + flagStr;
        }
        if (this.map.containsKey("^" + flagStr)) {
            return "^" + flagStr;
        }
        if (this.map.containsKey("?" + flagStr)) {
            return "?" + flagStr;
        }
        return null;
    }

    protected Object getValue(String flagStr) {
        if (this.map.get(flagStr) != null) {
            return this.map.get(flagStr);
        }
        if (this.map.get("~" + flagStr) != null) {
            return this.map.get("~" + flagStr);
        }
        if (this.map.get("^" + flagStr) != null) {
            return this.map.get("^" + flagStr);
        }
        if (this.map.get("?" + flagStr) != null) {
            return this.map.get("?" + flagStr);
        }
        return null;
    }

    protected void loadFlags(String flagStr) {
        if (flagStr == null || flagStr.isEmpty()) {
            return;
        }
        if (flagStr.startsWith("^")) {
            FieldFlag flag = FieldFlag.getByString(flagStr);
            if (flag != null) {
                if (!this.reversedFlags.contains((Object)flag)) {
                    this.alledflags.add(flag);
                }
                this.loadFlags(flagStr.substring(1));
            }
            return;
        }
        if (flagStr.startsWith("~")) {
            FieldFlag flag = FieldFlag.getByString(flagStr);
            if (flag != null) {
                if (!this.alledflags.contains((Object)flag)) {
                    this.reversedFlags.add(flag);
                }
                this.loadFlags(flagStr.substring(1));
            }
            return;
        }
        if (flagStr.startsWith("?")) {
            FieldFlag flag = FieldFlag.getByString(flagStr);
            if (flag != null) {
                this.disabledFlags.add(flag);
                this.loadFlags(flagStr.substring(1));
            }
            return;
        }
        FieldFlag flag = FieldFlag.getByString(flagStr);
        if (flag != null) {
            this.defaultFlags.add(flag);
        }
    }

    public boolean hasDefaultFlag(FieldFlag flag) {
        return this.defaultFlags.contains((Object)flag);
    }

    public boolean hasNameableFlag() {
        for (FieldFlag flag : this.defaultFlags) {
            if (!flag.isNameable()) continue;
            return true;
        }
        return false;
    }

    public boolean hasVeocityFlag() {
        return this.defaultFlags.contains((Object)FieldFlag.CANNON) || this.defaultFlags.contains((Object)FieldFlag.LAUNCH);
    }

    public boolean hasLimit() {
        return !this.limits.isEmpty();
    }

    public String getTitle() {
        return this.title;
    }

    public int getCustomHeight() {
        return this.customHeight;
    }

    public boolean canTranslocate(BlockTypeEntry type) {
        return !this.translocationBlacklist.contains(type);
    }

    public boolean teleportDueToWalking(Location loc, Field field, Player player) {
        Block standingOn = new Vec(loc).subtract(0, 1, 0).getBlock();
        if (standingOn.getType() == Material.AIR) {
            return false;
        }
        boolean teleport = false;
        if (FieldFlag.TELEPORT_IF_WALKING_ON.applies(field, player)) {
            teleport = this.teleportIfWalkingOn.contains(new BlockTypeEntry(standingOn));
        }
        if (FieldFlag.TELEPORT_IF_NOT_WALKING_ON.applies(field, player)) {
            teleport = !this.teleportIfNotWalkingOn.contains(new BlockTypeEntry(standingOn));
        }
        return teleport;
    }

    public boolean inDestroyBlacklist(Block block) {
        BlockTypeEntry type = new BlockTypeEntry(block);
        return this.preventDestroyBlacklist.contains(type);
    }

    public boolean inPlaceBlacklist(Block block) {
        BlockTypeEntry type = new BlockTypeEntry(block);
        return this.preventPlaceBlacklist.contains(type);
    }

    public boolean isCanceledCommand(String command) {
        int i = (command = command.replace("/", "")).indexOf(32);
        if (i > -1) {
            command = command.substring(0, i);
        }
        return this.commandBlackList.contains(command);
    }

    public boolean isTeleportHoldingItem(BlockTypeEntry entry) {
        if (!entry.isValid()) {
            return true;
        }
        if (this.teleportIfHasItems.contains(new BlockTypeEntry(Material.AIR)) && entry.getMaterial() != Material.AIR) {
            return true;
        }
        return this.teleportIfHoldingItems.contains(entry);
    }

    public boolean isTeleportNotHoldingItem(BlockTypeEntry entry) {
        if (!entry.isValid()) {
            return true;
        }
        return this.teleportIfNotHoldingItems.contains(entry);
    }

    public boolean isTeleportHasItem(BlockTypeEntry entry) {
        if (!entry.isValid()) {
            return false;
        }
        if (this.teleportIfHasItems.contains(new BlockTypeEntry(Material.AIR)) && entry.getMaterial() != Material.AIR) {
            return true;
        }
        return this.teleportIfHasItems.contains(entry);
    }

    public boolean isTeleportHasNotItem(BlockTypeEntry entry) {
        if (!entry.isValid()) {
            return false;
        }
        return this.teleportIfNotHasItems.contains(entry);
    }

    public boolean isReversedFlag(FieldFlag flag) {
        return this.reversedFlags.contains((Object)flag);
    }

    public boolean isAlledFlag(FieldFlag flag) {
        return this.alledflags.contains((Object)flag);
    }

    public boolean canUse(BlockTypeEntry entry) {
        if (!entry.isValid()) {
            return true;
        }
        return !this.preventUse.contains(entry);
    }

    public boolean isUnusableItem(Material type) {
        for (BlockTypeEntry entry : this.unusableItems) {
            if (entry.getMaterial() != type) continue;
            return true;
        }
        return false;
    }

    public boolean canCarry(Material type) {
        if (this.confiscatedItems.isEmpty()) {
            return true;
        }
        for (BlockTypeEntry entry : this.confiscatedItems) {
            if (entry.getMaterial() != type) continue;
            return false;
        }
        return true;
    }

    public String getPotionString() {
        String out = "";
        for (PotionEffectType potion : this.potions.keySet()) {
            out = out + Helper.friendlyName(potion.getName()) + ", ";
        }
        return Helper.stripTrailing(out, ", ");
    }

    public String getNeutralizePotionString() {
        String out = "";
        for (PotionEffectType potion : this.neutralizePotions) {
            out = out + Helper.friendlyName(potion.getName()) + ", ";
        }
        return Helper.stripTrailing(out, ", ");
    }

    public Set<FieldSettings> getMergedFields() {
        return this.mergedFields;
    }

    public List<BlockTypeEntry> getMergedFieldsTypeEntries() {
        return this.mergedFields.stream().map(FieldSettings::getTypeEntry).collect(Collectors.toList());
    }

    public void addMergedField(BlockTypeEntry entry) {
        SettingsManager sm = PreciousStones.getInstance().getSettingsManager();
        FieldSettings fs = sm.getFieldSettings(entry);
        this.mergedFields.add(fs);
        for (FieldFlag flag : fs.getDefaultFlags()) {
            if (flag.equals((Object)FieldFlag.GROUP_ON_ENTRY)) {
                this.groupOnEntry = fs.groupOnEntry;
            }
            if (flag.equals((Object)FieldFlag.LAUNCH)) {
                this.launchHeight = (int)((double)(this.launchHeight + fs.launchHeight) / 1.5);
            }
            if (flag.equals((Object)FieldFlag.CANNON)) {
                this.cannonHeight = (int)((double)(this.cannonHeight + fs.cannonHeight) / 1.5);
            }
            if (flag.equals((Object)FieldFlag.MINE)) {
                this.mineDelaySeconds = fs.mineDelaySeconds;
                this.mineHasFire = fs.mineHasFire;
                if (fs.mine > 0) {
                    this.mine = this.mine > 0 ? (this.mine + fs.mine) / 2 : fs.mine;
                }
            }
            if (flag.equals((Object)FieldFlag.LIGHTNING)) {
                this.lightningReplaceBlock = fs.lightningReplaceBlock;
                this.lightningDelaySeconds = fs.lightningDelaySeconds;
            }
            if (flag.equals((Object)FieldFlag.FORESTER)) {
                if (fs.treeCount > 0) {
                    this.treeCount = this.treeCount > 0 ? (this.treeCount + fs.treeCount) / 2 : fs.treeCount;
                }
                if (fs.shrubDensity > 0) {
                    this.shrubDensity = this.shrubDensity > 0 ? (this.shrubDensity + fs.shrubDensity) / 2 : fs.shrubDensity;
                }
                if (fs.creatureCount > 0) {
                    this.creatureCount = this.creatureCount > 0 ? (this.creatureCount + fs.creatureCount) / 2 : fs.creatureCount;
                }
                if (fs.growTime > 0) {
                    this.growTime = this.growTime > 0 ? (this.growTime + fs.growTime) / 2 : fs.growTime;
                }
                this.groundBlock = fs.groundBlock;
                Helper.addUnique(this.treeTypes, fs.treeTypes);
                Helper.addUnique(this.shrubTypes, fs.shrubTypes);
                Helper.addUnique(this.creatureTypes, fs.creatureTypes);
                Helper.addUnique(this.fertileBlocks, fs.fertileBlocks);
            }
            Helper.addUnique(this.preventUse, fs.preventUse);
            Helper.addUnique(this.confiscatedItems, fs.confiscatedItems);
            Helper.addUnique(this.allowedPlayers, fs.allowedPlayers);
            Helper.addUnique(this.deniedPlayers, fs.deniedPlayers);
            Helper.addUnique(this.allowGrief, fs.allowGrief);
            Helper.addUnique(this.allowedWorlds, fs.allowedWorlds);
            Helper.addUnique(this.limits, fs.limits);
            Helper.addUnique(this.unusableItems, fs.unusableItems);
            Helper.addUnique(this.translocationBlacklist, fs.translocationBlacklist);
            Helper.addUnique(this.preventPlaceBlacklist, fs.preventPlaceBlacklist);
            Helper.addUnique(this.preventDestroyBlacklist, fs.preventDestroyBlacklist);
            Helper.addUnique(this.allowedOnlyInside, fs.allowedOnlyInside);
            Helper.addUnique(this.allowedOnlyOutside, fs.allowedOnlyOutside);
            if (fs.heal > 0) {
                this.heal = this.heal > 0 ? (this.heal + fs.heal) / 2 : fs.heal;
            }
            if (fs.feed > 0) {
                this.feed = this.feed > 0 ? (this.feed + fs.feed) / 2 : fs.feed;
            }
            if (fs.repair > 0) {
                this.repair = this.repair > 0 ? (this.repair + fs.repair) / 2 : fs.repair;
            }
            if (fs.damage > 0) {
                this.damage = this.damage > 0 ? (this.damage + fs.damage) / 2 : fs.damage;
            }
            this.maskOnEnabled = fs.maskOnEnabled != Material.AIR ? fs.maskOnEnabled : this.maskOnEnabled;
            Material material = this.maskOnDisabled = fs.maskOnDisabled != Material.AIR ? fs.maskOnDisabled : this.maskOnDisabled;
            if (fs.griefRevertInterval > 0) {
                this.griefRevertInterval = this.griefRevertInterval > 0 ? (this.griefRevertInterval + fs.griefRevertInterval) / 2 : fs.griefRevertInterval;
            }
            Helper.addUnique(this.playerCommandOnEnter, fs.playerCommandOnEnter);
            Helper.addUnique(this.playerCommandOnExit, fs.playerCommandOnExit);
            Helper.addUnique(this.commandOnEnter, fs.commandOnEnter);
            Helper.addUnique(this.commandOnExit, fs.commandOnExit);
            Helper.addUnique(this.commandBlackList, fs.commandBlackList);
            if (fs.teleportCost > 0) {
                this.teleportCost = this.teleportCost > 0 ? (this.teleportCost + fs.teleportCost) / 2 : fs.teleportCost;
            }
            if (fs.teleportBackAfterSeconds > 0) {
                this.teleportBackAfterSeconds = this.teleportBackAfterSeconds > 0 ? (this.teleportBackAfterSeconds + fs.teleportBackAfterSeconds) / 2 : fs.teleportBackAfterSeconds;
            }
            if (fs.teleportMaxDistance > 0) {
                this.teleportMaxDistance = this.teleportMaxDistance > 0 ? (this.teleportMaxDistance + fs.teleportMaxDistance) / 2 : fs.teleportMaxDistance;
            }
            Helper.addUnique(this.teleportIfWalkingOn, fs.teleportIfWalkingOn);
            Helper.addUnique(this.teleportIfNotWalkingOn, fs.teleportIfNotWalkingOn);
            Helper.addUnique(this.teleportIfHoldingItems, fs.teleportIfHoldingItems);
            Helper.addUnique(this.teleportIfNotHoldingItems, fs.teleportIfNotHoldingItems);
            Helper.addUnique(this.teleportIfHasItems, fs.teleportIfHasItems);
            Helper.addUnique(this.teleportIfNotHasItems, fs.teleportIfNotHasItems);
            if (fs.mustBeAbove > 0) {
                this.mustBeAbove = this.mustBeAbove > 0 ? (this.mustBeAbove + fs.mustBeAbove) / 2 : fs.mustBeAbove;
            }
            if (fs.mustBeBelow > 0) {
                this.mustBeBelow = this.mustBeBelow > 0 ? (this.mustBeBelow + fs.mustBeBelow) / 2 : fs.mustBeBelow;
            }
            if (fs.payToEnable > 0) {
                this.payToEnable = this.payToEnable > 0 ? (this.payToEnable + fs.payToEnable) / 2 : fs.payToEnable;
            }
            if (fs.fenceItem != Material.AIR && this.fenceItem != Material.AIR) {
                this.fenceItem = fs.fenceItem;
            }
            if (fs.fenceItemPrice > 0) {
                this.fenceItemPrice = this.fenceItemPrice > 0 ? (this.fenceItemPrice + fs.fenceItemPrice) / 2 : fs.fenceItemPrice;
            }
            if (fs.rentsLimit > 0) {
                this.rentsLimit = this.rentsLimit > 0 ? (this.rentsLimit + fs.rentsLimit) / 2 : fs.rentsLimit;
            }
            if (fs.priceMultiplier > 0.0) {
                this.priceMultiplier = this.priceMultiplier > 0.0 ? (this.priceMultiplier + fs.priceMultiplier) / 2.0 : fs.priceMultiplier;
            }
            Helper.addUnique(this.potionTargets, fs.potionTargets);
        }
    }

    public boolean inAllowedList(String playerName) {
        return this.allowedPlayers.contains(playerName);
    }

    public boolean inDeniedList(String playerName) {
        return this.deniedPlayers.contains(playerName);
    }

    public boolean canGrief(BlockTypeEntry entry) {
        if (!entry.isValid()) {
            return false;
        }
        return this.allowGrief.contains(entry);
    }

    public boolean allowedWorld(World world) {
        return this.allowedWorlds.isEmpty() || this.allowedWorlds.contains(world.getName());
    }

    public boolean hasAllowedOnlyInside() {
        return !this.allowedOnlyInside.isEmpty();
    }

    public boolean isAllowedOnlyInside(Field field) {
        return this.allowedOnlyInside.contains(field.getSettings().getTitle());
    }

    public String getAllowedOnlyInsideString() {
        return Helper.toMessage(this.allowedOnlyInside, " or ");
    }

    public boolean hasAllowedOnlyOutside() {
        return !this.allowedOnlyOutside.isEmpty();
    }

    public boolean isAllowedOnlyOutside(Field field) {
        return this.allowedOnlyOutside.contains(field.getSettings().getTitle());
    }

    public String getAllowedOnlyOutsideString() {
        return Helper.toMessage(this.allowedOnlyOutside, " or ");
    }

    public Material getMaterial() {
        return this.type.getMaterial();
    }

    public BlockTypeEntry getTypeEntry() {
        return this.type;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getLaunchHeight() {
        return this.launchHeight;
    }

    public int getCannonHeight() {
        return this.cannonHeight;
    }

    public int getMineDelaySeconds() {
        return this.mineDelaySeconds;
    }

    public int getLightningDelaySeconds() {
        return this.lightningDelaySeconds;
    }

    public Material getLightningReplaceBlock() {
        return this.lightningReplaceBlock;
    }

    public int getPrice() {
        return this.price;
    }

    public int getMultipliedPrice(Player player) {
        List<Field> playerFields = PreciousStones.getInstance().getForceFieldManager().getPlayerFields(player.getName(), this.getTypeEntry());
        int count = playerFields.size();
        return this.getMultipliedPrice(count);
    }

    public int getMultipliedRefundPrice(Player player) {
        List<Field> playerFields = PreciousStones.getInstance().getForceFieldManager().getPlayerFields(player.getName(), this.getTypeEntry());
        int count = playerFields.size() - 1;
        return this.getMultipliedPrice(count);
    }

    private int getMultipliedPrice(int count) {
        if (count <= 0) {
            return this.price;
        }
        if (this.priceMultiplier == 0.0) {
            return this.price;
        }
        if (this.priceMultiplier < 1.0) {
            return (int)((double)this.price * this.priceMultiplier * (double)(count + 2));
        }
        if (this.priceMultiplier == 1.0) {
            return (int)((double)this.price * this.priceMultiplier * (double)(count + 1));
        }
        return (int)((double)this.price * this.priceMultiplier * (double)count);
    }

    public boolean isValidField() {
        return this.validField;
    }

    public List<Integer> getLimits() {
        return Collections.unmodifiableList(this.limits);
    }

    public List<FieldFlag> getDefaultFlags() {
        return Collections.unmodifiableList(this.defaultFlags);
    }

    public int getCustomVolume() {
        return this.customVolume;
    }

    public int getMixingGroup() {
        return this.mixingGroup;
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public int getAutoDisableTime() {
        return this.autoDisableTime;
    }

    public String getGroupOnEntry() {
        return this.groupOnEntry;
    }

    public GameMode getForceEntryGameMode() {
        return this.forceEntryGameMode;
    }

    public GameMode getForceLeavingGameMode() {
        return this.forceLeavingGameMode;
    }

    public int getHeal() {
        return this.heal;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getFeed() {
        return this.feed;
    }

    public int getRepair() {
        return this.repair;
    }

    public List<Integer> getTreeTypes() {
        return new ArrayList<Integer>(this.treeTypes);
    }

    public List<Integer> getShrubTypes() {
        return new ArrayList<Integer>(this.shrubTypes);
    }

    public int getShrubDensity() {
        return this.shrubDensity;
    }

    public int getTreeCount() {
        return this.treeCount;
    }

    public int getGrowTime() {
        return this.growTime;
    }

    public boolean isFertileType(BlockTypeEntry entry) {
        if (!entry.isValid()) {
            return false;
        }
        return this.fertileBlocks.contains(entry);
    }

    public BlockTypeEntry getGroundBlock() {
        return this.groundBlock;
    }

    public List<String> getCreatureTypes() {
        return this.creatureTypes;
    }

    public int getCreatureCount() {
        return this.creatureCount;
    }

    public boolean isMineHasFire() {
        return this.mineHasFire;
    }

    public int getMineStrength() {
        return this.mine;
    }

    public HashMap<PotionEffectType, Integer> getPotions() {
        return this.potions;
    }

    public List<PotionEffectType> getNeutralizePotions() {
        return this.neutralizePotions;
    }

    public Material getMaskOnDisabledBlock() {
        return this.maskOnDisabled;
    }

    public Material getMaskOnEnabledBlock() {
        return this.maskOnEnabled;
    }

    public String getRequiredPermissionAllow() {
        return this.requiredPermissionAllow;
    }

    public String getRequiredPermissionUse() {
        return this.requiredPermissionUse;
    }

    public int getRefund(Player player) {
        int refunded = -1;
        if (this.refund > -1) {
            refunded = this.refund;
        } else if (this.price > 0) {
            refunded = this.getMultipliedRefundPrice(player);
        }
        return refunded;
    }

    public int getTeleportCost() {
        return this.teleportCost;
    }

    public int getTeleportBackAfterSeconds() {
        return this.teleportBackAfterSeconds;
    }

    public int getTeleportMaxDistance() {
        return this.teleportMaxDistance;
    }

    public int getGriefRevertInterval() {
        return this.griefRevertInterval;
    }

    public List<String> getCommandsOnEnter() {
        return this.commandOnEnter;
    }

    public List<String> getCommandsOnExit() {
        return this.commandOnExit;
    }

    public List<String> getPlayerCommandsOnEnter() {
        return this.playerCommandOnEnter;
    }

    public List<String> getPlayerCommandsOnExit() {
        return this.playerCommandOnExit;
    }

    public List<FieldFlag> getDisabledFlags() {
        return this.disabledFlags;
    }

    public int getMustBeAbove() {
        return this.mustBeAbove;
    }

    public int getMustBeBelow() {
        return this.mustBeBelow;
    }

    public int getPayToEnable() {
        return this.payToEnable;
    }

    public String getDeleteIfNoPermission() {
        return this.deleteIfNoPermission;
    }

    public Material getFenceItem() {
        return this.fenceItem;
    }

    public int getFenceItemPrice() {
        return this.fenceItemPrice;
    }

    public boolean isSurface(Block fieldBlock) {
        if (this.surfaces.isEmpty()) {
            return true;
        }
        return this.surfaces.contains(new BlockTypeEntry(fieldBlock.getLocation().add(0.0, -1.0, 0.0).getBlock()));
    }

    public String getSurfaceString() {
        String out = "";
        for (BlockTypeEntry entry : this.surfaces) {
            out = out + entry + ", ";
        }
        return Helper.stripTrailing(out, ", ");
    }

    public int getForesterUses() {
        return this.foresterUses;
    }

    public boolean matchesMetaName(ItemStack item) {
        if (!this.hasMetaName()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.getDisplayName() != null) {
            return meta.getDisplayName().equals(this.metaName);
        }
        return false;
    }

    public boolean hasMetaName() {
        return this.metaName != null && !this.metaName.isEmpty();
    }

    public String getMetaName() {
        return this.metaName;
    }

    public List<String> getMetaLore() {
        return this.metaLore;
    }

    public boolean isMetaAutoSet() {
        return this.metaAutoSet;
    }

    public int getRentsLimit() {
        return this.rentsLimit;
    }

    public List<String> getPotionTargets() {
        return this.potionTargets;
    }

    public double getPriceMultiplier() {
        return this.priceMultiplier;
    }
}

