/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.storage;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.DBCore;

public class SQLiteCore
implements DBCore {
    private Logger log;
    private Connection connection;
    private String dbLocation;
    private String dbName;
    private File file;

    public SQLiteCore(String dbName, String dbLocation) {
        this.dbName = dbName;
        this.dbLocation = dbLocation;
        this.log = PreciousStones.getLog();
    }

    private void initialize() {
        if (this.file == null) {
            File dbFolder = new File(this.dbLocation);
            if (this.dbName.contains("/") || this.dbName.contains("\\") || this.dbName.endsWith(".db")) {
                this.log.severe("The database name can not contain: /, \\, or .db");
                return;
            }
            if (!dbFolder.exists()) {
                dbFolder.mkdir();
            }
            this.file = new File(dbFolder.getAbsolutePath() + File.separator + this.dbName + ".db");
        }
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.file.getAbsolutePath());
        }
        catch (SQLException ex) {
            this.log.severe("SQLite exception on initialize " + ex);
        }
        catch (ClassNotFoundException ex) {
            this.log.severe("You need the SQLite library " + ex);
        }
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.initialize();
            }
        }
        catch (SQLException e) {
            this.initialize();
        }
        return this.connection;
    }

    @Override
    public Boolean checkConnection() {
        return this.getConnection() != null;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            this.log.severe("Failed to close database connection! " + e.getMessage());
        }
    }

    @Override
    public ResultSet select(String query) {
        try {
            Statement statement = this.getConnection().createStatement();
            return statement.executeQuery(query);
        }
        catch (SQLException ex) {
            this.log.severe("Error at SQL Query: " + ex.getMessage());
            this.log.severe("Query: " + query);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long insert(String query) {
        PreciousStones.debug(query, new Object[0]);
        try {
            ResultSet keys = null;
            try (Statement statement = this.getConnection().createStatement();){
                statement.executeUpdate(query);
                keys = statement.executeQuery("SELECT last_insert_rowid()");
                if (keys == null) return 0L;
                if (!keys.next()) return 0L;
                long l = keys.getLong(1);
                return l;
            }
        }
        catch (SQLException ex) {
            if (ex.toString().contains("not return ResultSet")) return 0L;
            this.log.severe("Error at SQL INSERT Query: " + ex);
        }
        return 0L;
    }

    @Override
    public void update(String query) {
        block5: {
            PreciousStones.debug(query, new Object[0]);
            try (Statement statement = this.getConnection().createStatement();){
                statement.executeQuery(query);
            }
            catch (SQLException ex) {
                if (ex.toString().contains("not return ResultSet")) break block5;
                this.log.severe("Error at SQL UPDATE Query: " + ex);
            }
        }
    }

    @Override
    public void delete(String query) {
        block5: {
            PreciousStones.debug(query, new Object[0]);
            try (Statement statement = this.getConnection().createStatement();){
                statement.executeQuery(query);
            }
            catch (SQLException ex) {
                if (ex.toString().contains("not return ResultSet")) break block5;
                this.log.severe("Error at SQL DELETE Query: " + ex);
            }
        }
    }

    @Override
    public Boolean execute(String query) {
        PreciousStones.debug(query, new Object[0]);
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute(query);
        }
        catch (SQLException ex) {
            this.log.severe("Error at SQL Query: " + ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Boolean existsTable(String table) {
        try {
            ResultSet tables = this.getConnection().getMetaData().getTables(null, null, table, null);
            return tables.next();
        }
        catch (SQLException e) {
            this.log.severe("Failed to check if table " + table + " exists: " + e.getMessage());
            return false;
        }
    }

    @Override
    public Boolean existsColumn(String table, String column) {
        try {
            ResultSet col = this.getConnection().getMetaData().getColumns(null, null, table, column);
            return col.next();
        }
        catch (Exception e) {
            this.log.severe("Failed to check if column " + column + " exists in table " + table + " : " + e.getMessage());
            return false;
        }
    }

    @Override
    public String getDataType(String table, String column) {
        return "";
    }
}

