/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.translocation;

import java.util.LinkedList;
import java.util.Queue;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.TranslocationBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TranslocationApplier
implements Runnable {
    private PreciousStones plugin;
    private Queue<TranslocationBlock> translocationQueue;
    private Queue<TranslocationBlock> dependentQueue = new LinkedList<TranslocationBlock>();
    private final int timerID;
    private final World world;
    private final Field field;

    public TranslocationApplier(Field field, Queue<TranslocationBlock> translocationQueue, World world) {
        this.field = field;
        this.translocationQueue = translocationQueue;
        this.world = world;
        this.plugin = PreciousStones.getInstance();
        field.getTranslocatingModule().setTranslocating(true);
        this.timerID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 5L, 5L);
    }

    @Override
    public void run() {
        boolean applied;
        TranslocationBlock tb;
        int i = 0;
        while (i < 100 && !this.translocationQueue.isEmpty()) {
            tb = this.translocationQueue.poll();
            if (tb != null) {
                if (this.plugin.getSettingsManager().isDependentBlock(tb.getType())) {
                    this.dependentQueue.add(tb);
                    continue;
                }
                if (this.field.hasFlag(FieldFlag.TRANSLOCATION_SAFETY)) {
                    this.movePlayers(tb);
                }
                if (!(applied = PreciousStones.getInstance().getTranslocationManager().applyTranslocationBlock(tb, this.world))) {
                    this.plugin.getStorageManager().updateTranslocationBlockApplied(this.field, tb, false);
                }
            }
            ++i;
        }
        if (this.translocationQueue.isEmpty()) {
            while (i < 200 && !this.dependentQueue.isEmpty()) {
                tb = this.dependentQueue.poll();
                if (this.field.hasFlag(FieldFlag.TRANSLOCATION_SAFETY)) {
                    this.movePlayers(tb);
                }
                if (!(applied = PreciousStones.getInstance().getTranslocationManager().applyTranslocationBlock(tb, this.world))) {
                    this.plugin.getStorageManager().updateTranslocationBlockApplied(this.field, tb, false);
                }
                ++i;
            }
            if (!this.dependentQueue.iterator().hasNext()) {
                Bukkit.getServer().getScheduler().cancelTask(this.timerID);
                this.field.setDisabled(false);
                this.field.getTranslocatingModule().setTranslocating(false);
                this.field.getFlagsModule().dirtyFlags("TranslocationApplier");
            }
        }
    }

    private void movePlayers(TranslocationBlock tb) {
        for (Player player : this.world.getPlayers()) {
            Vec location;
            Vec blockLocation = tb.toVec();
            if (!blockLocation.equals(location = new Vec(player.getLocation())) && !blockLocation.equals(location.add(0, 1, 0))) continue;
            this.plugin.getTeleportationManager().teleportAway(player);
        }
    }
}

