/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.blocks;

import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.AbstractVec;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class GriefBlock
extends AbstractVec {
    private BlockTypeEntry type;
    private String signText = "";
    private boolean empty = false;

    public GriefBlock(int x, int y, int z, String world, BlockTypeEntry type) {
        super(x, y, z, world);
        this.type = type;
    }

    public GriefBlock(Location loc, BlockTypeEntry type) {
        super(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), loc.getWorld().getName());
        this.type = type;
    }

    public GriefBlock(Block block) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
        this.type = new BlockTypeEntry(block.getTypeId(), block.getData());
    }

    public GriefBlock(BlockState state) {
        super(state.getX(), state.getY(), state.getZ(), state.getWorld().getName());
        this.type = new BlockTypeEntry(state.getTypeId(), state.getRawData());
        this.empty = true;
    }

    public int getTypeId() {
        return this.type.getTypeId();
    }

    public byte getData() {
        return this.type.getData();
    }

    public String getSignText() {
        return this.signText;
    }

    public void setSignText(String signText) {
        this.signText = signText;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public GriefBlock(String packed) {
        super(Helper.locationFromPacked(packed).getBlockX(), Helper.locationFromPacked(packed).getBlockY(), Helper.locationFromPacked(packed).getBlockZ(), Helper.locationFromPacked(packed).getWorld().getName());
        String[] unpacked = packed.split("[|]");
        this.type = new BlockTypeEntry(Integer.parseInt(unpacked[0]), Byte.parseByte(unpacked[1]));
    }

    public String serialize() {
        return this.getTypeId() + "|" + this.getData() + "|" + this.getLocation().getBlockX() + "|" + this.getLocation().getBlockY() + "|" + this.getLocation().getBlockZ() + "|" + this.getLocation().getWorld();
    }
}

