/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sacredlabyrinth.Phaed.PreciousStones.MaterialName;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class BlockTypeEntry {
    private final Material material;
    private byte data = 0;

    public BlockTypeEntry(Block block) {
        this.material = block.getType();
        this.data = block.getData();
    }

    public BlockTypeEntry(Material material) {
        this.material = material;
    }

    public BlockTypeEntry(String string) {
        Pattern pattern = Pattern.compile("(?i)^(\\d+)$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.material = Material.getMaterial((int)Integer.parseInt(matcher.group(1)));
            return;
        }
        matcher.reset();
        pattern = Pattern.compile("(?i)^(\\d+):(\\d+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.material = Material.getMaterial((int)Integer.parseInt(matcher.group(1)));
            this.data = Byte.parseByte(matcher.group(2));
            return;
        }
        matcher.reset();
        pattern = Pattern.compile("(?i)^(.*):(\\d+)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.material = MaterialName.getBlockMaterial(matcher.group(1));
            this.data = Byte.parseByte(matcher.group(2));
            return;
        }
        matcher.reset();
        pattern = Pattern.compile("(?i)^(.*)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String name = matcher.group(1);
            Material m = MaterialName.getBlockMaterial(name);
            if (m == null) {
                m = MaterialName.getItemMaterial(name);
            }
            this.material = m != null ? m : null;
        } else {
            this.material = null;
        }
    }

    public BlockTypeEntry(BlockState block) {
        this.material = block.getType();
        this.data = block.getRawData();
    }

    public BlockTypeEntry(int typeId, byte data) {
        this.material = Material.getMaterial((int)typeId);
        this.data = data;
    }

    public BlockTypeEntry(int typeId) {
        this.material = Material.getMaterial((int)typeId);
    }

    public int getTypeId() {
        return this.getMaterial().getId();
    }

    public byte getData() {
        return this.data;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockTypeEntry)) {
            return false;
        }
        BlockTypeEntry other = (BlockTypeEntry)obj;
        int id1 = this.getTypeId();
        int id2 = other.getTypeId();
        byte data1 = this.getData();
        byte data2 = other.getData();
        if (this.getData() == 0 || other.getData() == 0 ? id1 == id2 : id1 == id2 && data1 == data2) {
            return true;
        }
        return id1 == 8 && id2 == 9 || id1 == 9 && id2 == 8 || id1 == 11 && id2 == 10 || id1 == 10 && id2 == 11 || id1 == 73 && id2 == 74 || id1 == 74 && id2 == 73 || id1 == 61 && id2 == 62 || id1 == 62 && id2 == 61;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.getTypeId();
        hash = 47 * hash + this.getData();
        return hash;
    }

    public String toString() {
        if (this.getData() == 0) {
            return MaterialName.getIDName(this.getMaterial()) + "";
        }
        return MaterialName.getIDName(this.getMaterial()) + ":" + this.getData();
    }

    public void setData(byte data) {
        this.data = data;
    }

    public boolean isValid() {
        return this.getMaterial() != null;
    }

    public Material getMaterial() {
        return this.material;
    }
}

