/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import java.util.ArrayList;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CuboidEntry {
    private Field field;
    private List<BlockEntry> selected = new ArrayList<BlockEntry>();
    private int minx;
    private int miny;
    private int minz;
    private int maxx;
    private int maxy;
    private int maxz;
    private Location expanded;

    public CuboidEntry(Field field) {
        this.field = field;
        this.minx = field.getX();
        this.miny = field.getY();
        this.minz = field.getZ();
        this.maxx = field.getX();
        this.maxy = field.getY();
        this.maxz = field.getZ();
    }

    public CuboidEntry(Field field, boolean existing) {
        this.field = field;
        if (existing) {
            this.minx = field.getMinx();
            this.miny = field.getMiny();
            this.minz = field.getMinz();
            this.maxx = field.getMaxx();
            this.maxy = field.getMaxy();
            this.maxz = field.getMaxz();
        } else {
            this.minx = field.getX();
            this.miny = field.getY();
            this.minz = field.getZ();
            this.maxx = field.getX();
            this.maxy = field.getY();
            this.maxz = field.getZ();
        }
    }

    public CuboidEntry(Field field, int minx, int maxx, int miny, int maxy, int minz, int maxz, List<BlockEntry> selected, Location expanded) {
        this.field = field;
        this.maxx = maxx;
        this.minx = minx;
        this.maxy = maxy;
        this.miny = miny;
        this.maxz = maxz;
        this.minz = minz;
        this.selected = new ArrayList<BlockEntry>(selected);
        this.expanded = expanded;
    }

    public void addSelected(Block block) {
        if (!this.selected.contains(block)) {
            this.selected.add(new BlockEntry(block));
            this.calculate();
        }
    }

    public void removeSelected(Block block) {
        this.selected.remove(new BlockEntry(block));
        this.calculate();
    }

    public void revertLastSelected() {
        if (this.selected.size() > 1) {
            this.selected.remove(this.selected.size() - 1);
        }
        this.calculate();
    }

    public BlockEntry getLastSelected() {
        if (this.selected.size() > 1) {
            return this.selected.get(this.selected.size() - 1);
        }
        return null;
    }

    public boolean isSelected(Block block) {
        return this.selected.contains(new BlockEntry(block));
    }

    public int selectedCount() {
        return this.selected.size();
    }

    private void calculate() {
        this.minx = this.field.getX();
        this.miny = this.field.getY();
        this.minz = this.field.getZ();
        this.maxx = this.field.getX();
        this.maxy = this.field.getY();
        this.maxz = this.field.getZ();
        for (BlockEntry bd : this.selected) {
            Location loc = bd.getLocation();
            if (loc.getBlockX() < this.minx) {
                this.minx = loc.getBlockX();
            }
            if (loc.getBlockY() < this.miny) {
                this.miny = loc.getBlockY();
            }
            if (loc.getBlockZ() < this.minz) {
                this.minz = loc.getBlockZ();
            }
            if (loc.getBlockX() > this.maxx) {
                this.maxx = loc.getBlockX();
            }
            if (loc.getBlockY() > this.maxy) {
                this.maxy = loc.getBlockY();
            }
            if (loc.getBlockZ() <= this.maxz) continue;
            this.maxz = loc.getBlockZ();
        }
    }

    public void expand(int num, String dir) {
        if (dir.toLowerCase().startsWith("u")) {
            this.maxy += num;
        } else if (dir.toLowerCase().startsWith("d")) {
            this.miny -= num;
        } else if (dir.toLowerCase().startsWith("n")) {
            this.minz -= num;
        } else if (dir.toLowerCase().startsWith("s")) {
            this.maxz += num;
        } else if (dir.toLowerCase().startsWith("e")) {
            this.maxx += num;
        } else if (dir.toLowerCase().startsWith("w")) {
            this.minx -= num;
        } else if (dir.toLowerCase().startsWith("a")) {
            this.minx -= num;
            this.miny -= num;
            this.minz -= num;
            this.maxz += num;
            this.maxx += num;
            this.minx -= num;
        }
    }

    public void expand(int u, int d, int n, int s, int e, int w) {
        this.maxy += u;
        this.miny -= d;
        this.minz -= n;
        this.maxz += s;
        this.maxx += e;
        this.minx -= w;
    }

    public void contract(int num, String dir) {
        if (dir.toLowerCase().startsWith("u")) {
            this.maxy -= num;
        } else if (dir.toLowerCase().startsWith("d")) {
            this.miny += num;
        } else if (dir.toLowerCase().startsWith("n")) {
            this.minz += num;
        } else if (dir.toLowerCase().startsWith("s")) {
            this.maxz -= num;
        } else if (dir.toLowerCase().startsWith("e")) {
            this.maxx -= num;
        } else if (dir.toLowerCase().startsWith("w")) {
            this.minx += num;
        } else if (dir.toLowerCase().startsWith("a")) {
            this.maxy -= num;
            this.miny += num;
            this.minz += num;
            this.maxz -= num;
            this.maxx -= num;
            this.minx += num;
        }
        this.fixOverContract();
    }

    public void contract(int u, int d, int n, int s, int e, int w) {
        this.maxy -= u;
        this.miny += d;
        this.minz += n;
        this.maxz -= s;
        this.maxx -= e;
        this.minx += w;
        this.fixOverContract();
    }

    public void fixOverContract() {
        if (this.maxy < this.field.getY()) {
            this.maxy = this.field.getY();
        }
        if (this.miny > this.field.getY()) {
            this.miny = this.field.getY();
        }
        if (this.minz > this.field.getZ()) {
            this.minz = this.field.getZ();
        }
        if (this.maxz < this.field.getZ()) {
            this.maxz = this.field.getZ();
        }
        if (this.maxx < this.field.getX()) {
            this.maxx = this.field.getX();
        }
        if (this.minx > this.field.getX()) {
            this.minx = this.field.getX();
        }
    }

    public Block getExpandedBlock(Player player) {
        this.calculate();
        Location loc = player.getLocation();
        if (!this.envelopsPlusOne(loc)) {
            ChatHelper.send((CommandSender)player, "mustBeInCuboidToExpand", new Object[0]);
            return null;
        }
        List lineOfSight = player.getLineOfSight(PreciousStones.getInstance().getSettingsManager().getThroughFieldsByteSet(), Math.max(Math.max(Math.max(Helper.getWidthFromCoords(this.maxx, this.miny), Helper.getWidthFromCoords(this.maxz, this.minz)), Helper.getWidthFromCoords(this.maxy, this.miny)), 256));
        for (Block block : lineOfSight) {
            if (this.envelopsPlusOne(block.getLocation())) continue;
            if (this.expanded != null) {
                player.sendBlockChange(this.expanded, 0, (byte)0);
            }
            this.expanded = block.getLocation();
            return block;
        }
        return null;
    }

    private boolean envelopsPlusOne(Location loc) {
        return loc.getX() < (double)(this.maxx + 1) && loc.getX() > (double)(this.minx - 1) && loc.getY() > (double)(this.miny - 1) && loc.getY() < (double)(this.maxy + 1) && loc.getZ() > (double)(this.minz - 1) && loc.getZ() < (double)(this.maxz + 1);
    }

    public void finalizeField() {
        this.field.setCuboidDimensions(this.minx, this.miny, this.minz, this.maxx, this.maxy, this.maxz);
    }

    public boolean testOverflow(Location newLoc) {
        int testVolume;
        int minxt = this.minx;
        int minyt = this.miny;
        int minzt = this.minz;
        int maxxt = this.maxx;
        int maxyt = this.maxy;
        int maxzt = this.maxz;
        if (newLoc.getBlockX() < minxt) {
            minxt = newLoc.getBlockX();
        }
        if (newLoc.getBlockY() < minyt) {
            minyt = newLoc.getBlockY();
        }
        if (newLoc.getBlockZ() < minzt) {
            minzt = newLoc.getBlockZ();
        }
        if (newLoc.getBlockX() > maxxt) {
            maxxt = newLoc.getBlockX();
        }
        if (newLoc.getBlockY() > maxyt) {
            maxyt = newLoc.getBlockY();
        }
        if (newLoc.getBlockZ() > maxzt) {
            maxzt = newLoc.getBlockZ();
        }
        return (testVolume = Helper.getWidthFromCoords(maxyt, minyt) * Helper.getWidthFromCoords(maxxt, minxt) * Helper.getWidthFromCoords(maxzt, minzt)) <= this.getMaxVolume();
    }

    public int getOverflow() {
        return this.getVolume() - this.getMaxVolume();
    }

    public int getVolume() {
        return Helper.getWidthFromCoords(this.maxy, this.miny) * Helper.getWidthFromCoords(this.maxx, this.minx) * Helper.getWidthFromCoords(this.maxz, this.minz);
    }

    public int getMaxVolume() {
        int volume = this.field.getMaxVolume();
        for (Field child : this.field.getChildren()) {
            volume += child.getMaxVolume();
        }
        return volume;
    }

    public int getAvailableVolume() {
        PreciousStones.debug("x: %s %s", this.minx, this.maxx);
        PreciousStones.debug("y: %s %s", this.miny, this.maxy);
        PreciousStones.debug("z: %s %s", this.minz, this.maxz);
        PreciousStones.debug("Lengths: %s %s %s", Helper.getWidthFromCoords(this.maxx, this.minx), Helper.getWidthFromCoords(this.maxy, this.miny), Helper.getWidthFromCoords(this.maxz, this.minz));
        PreciousStones.debug("Max volume: %s", this.getMaxVolume());
        PreciousStones.debug("Volume: %s", this.getVolume());
        return this.getMaxVolume() - this.getVolume();
    }

    public Field getField() {
        return this.field;
    }

    public boolean isExceeded() {
        return this.getVolume() > this.getMaxVolume();
    }

    public int getMinx() {
        if (this.selected.isEmpty()) {
            return 0;
        }
        return this.minx;
    }

    public int getMiny() {
        if (this.selected.isEmpty()) {
            return 0;
        }
        return this.miny;
    }

    public int getMinz() {
        if (this.selected.isEmpty()) {
            return 0;
        }
        return this.minz;
    }

    public int getMaxx() {
        if (this.selected.isEmpty()) {
            return 0;
        }
        return this.maxx;
    }

    public int getMaxy() {
        if (this.selected.isEmpty()) {
            return 0;
        }
        return this.maxy;
    }

    public int getMaxz() {
        if (this.selected.isEmpty()) {
            return 0;
        }
        return this.maxz;
    }

    public Field getMockField() {
        return new Field(this.field.getX(), this.field.getY(), this.field.getZ(), this.minx, this.miny, this.minz, this.maxx, this.maxy, this.maxz, 0.0f, this.field.getWorld(), this.field.getTypeEntry(), this.field.getOwner(), this.field.getName(), 0L);
    }

    public CuboidEntry Clone() {
        return new CuboidEntry(this.field, this.minx, this.maxx, this.miny, this.maxy, this.minz, this.maxz, this.selected, this.expanded);
    }
}

