/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.ForesterManager;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ForesterEntry {
    private Field field;
    private int count;
    private String playerName;
    private int growTime;
    private boolean landPrepared;
    private PreciousStones plugin;

    public ForesterEntry(Field field, Player player) {
        this.field = field;
        this.playerName = player.getName();
        this.count = 0;
        this.growTime = Math.max(field.getSettings().getGrowTime(), 2);
        this.plugin = PreciousStones.getInstance();
        this.scheduleNextUpdate();
        field.getForestingModule().recordForesterUse();
        field.getForestingModule().setForesting(true);
        ChatHelper.send((CommandSender)player, "foresterActivating", new Object[0]);
        if (field.getForestingModule().hasForesterUse()) {
            ChatHelper.send((CommandSender)player, "foresterUsesLeft", field.getForestingModule().foresterUsesLeft());
        }
    }

    public Field getField() {
        return this.field;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ForesterEntry)) {
            return false;
        }
        ForesterEntry other = (ForesterEntry)obj;
        return other.getField().getX() == this.getField().getX() && other.getField().getY() == this.getField().getY() && other.getField().getZ() == this.getField().getZ() && other.getField().getWorld().equals(this.getField().getWorld());
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (this.field != null ? this.field.hashCode() : 0);
        return hash;
    }

    private void scheduleNextUpdate() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new Update(), (long)this.growTime);
    }

    private boolean doPlantingAttempt() {
        PreciousStones.debug("planting attempt", new Object[0]);
        World world = this.plugin.getServer().getWorld(this.field.getWorld());
        Player player = this.plugin.getServer().getPlayer(this.playerName);
        if (world == null || player == null) {
            return false;
        }
        if (!this.landPrepared) {
            PreciousStones.debug("prepare land", new Object[0]);
            this.plugin.getForesterManager().prepareLand(this.field, world);
            PreciousStones.debug("land prepared", new Object[0]);
            this.landPrepared = true;
        }
        if (!this.field.getSettings().getTreeTypes().isEmpty()) {
            PreciousStones.debug("generate tree", new Object[0]);
            this.plugin.getForesterManager().generateTree(this.field, player, world);
        }
        ++this.count;
        if (this.count >= this.field.getSettings().getTreeCount()) {
            this.plugin.getForesterManager().doCreatureSpawns(this.field);
            if (!this.field.getForestingModule().hasForesterUse()) {
                Block block = world.getBlockAt(this.field.getX(), this.field.getY(), this.field.getZ());
                block.setTypeId(0, false);
                block.getLocation().add(0.0, -1.0, 0.0).getBlock().setTypeId(this.field.getSettings().getGroundBlock().getTypeId(), false);
                if (!this.field.getSettings().getTreeTypes().isEmpty()) {
                    world.generateTree(block.getLocation(), ForesterManager.getTree(this.field.getSettings()));
                }
                this.plugin.getForceFieldManager().releaseNoDrop(this.field);
            }
            this.field.getForestingModule().setForesting(false);
            return false;
        }
        return true;
    }

    private class Update
    implements Runnable {
        private Update() {
        }

        @Override
        public void run() {
            if (ForesterEntry.this.doPlantingAttempt()) {
                ForesterEntry.this.scheduleNextUpdate();
            }
        }
    }
}

