/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.EntryFields;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.StackHelper;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public final class EntryManager {
    private PreciousStones plugin;
    private final List<Field> enteredFields = new ArrayList<Field>();
    private final HashMap<String, EntryFields> entriesByPlayer = new HashMap();
    private final HashMap<String, EntryFields> dynamicEntries = new HashMap();
    private int updateCount = 0;

    public EntryManager() {
        this.plugin = PreciousStones.getInstance();
        this.scheduleNextUpdate();
    }

    private boolean isDynamic(Field field) {
        return field.hasFlag(FieldFlag.DAMAGE) || field.hasFlag(FieldFlag.REPAIR) || field.hasFlag(FieldFlag.HEAL) || field.hasFlag(FieldFlag.FEED) || field.hasFlag(FieldFlag.POTIONS) || field.hasFlag(FieldFlag.NEUTRALIZE_POTIONS) || field.hasFlag(FieldFlag.CONFISCATE_ITEMS) || field.hasFlag(FieldFlag.AIR);
    }

    private void scheduleNextUpdate() {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new Update(), 20L);
    }

    private void doEffects() {
        try {
            for (String playerName : this.dynamicEntries.keySet()) {
                Player player = Bukkit.getServer().getPlayerExact(playerName);
                if (player == null) continue;
                EntryFields ef = this.dynamicEntries.get(playerName);
                List<Field> fields = ef.getFields();
                boolean hasDamage = false;
                boolean hasHeal = false;
                boolean hasFeeding = false;
                boolean hasAir = false;
                boolean hasRepair = false;
                boolean hasPotion = false;
                for (Field field : fields) {
                    int food;
                    if (field.isDisabled()) continue;
                    if (this.updateCount % 5 == 0 && FieldFlag.CONFISCATE_ITEMS.applies(field, player)) {
                        this.plugin.getConfiscationManager().confiscateItems(field, player);
                    }
                    if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.giveair") && !hasAir && FieldFlag.AIR.applies(field, player) && player.getRemainingAir() < 300) {
                        player.setRemainingAir(600);
                        this.plugin.getCommunicationManager().showGiveAir(player);
                        hasAir = true;
                    }
                    if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.feed") && !hasFeeding && FieldFlag.FEED.applies(field, player) && (food = player.getFoodLevel()) < 20) {
                        player.setFoodLevel(food + field.getSettings().getFeed());
                        this.plugin.getCommunicationManager().showFeeding(player);
                        hasFeeding = true;
                    }
                    if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.heal") && !hasHeal && FieldFlag.HEAL.applies(field, player) && player.getHealth() < 20.0 && player.getHealth() > 0.0) {
                        player.setHealth((double)((int)this.healthCheck(player.getHealth() + (double)field.getSettings().getHeal())));
                        this.plugin.getCommunicationManager().showHeal(player);
                        hasHeal = true;
                    }
                    if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.repair") && !hasRepair && FieldFlag.REPAIR.applies(field, player)) {
                        ItemStack[] items;
                        ItemStack[] armors;
                        for (ItemStack armor : armors = player.getInventory().getArmorContents()) {
                            short dur;
                            if (!this.plugin.getSettingsManager().isRepairableItemType(new BlockTypeEntry(armor.getType())) || (dur = armor.getDurability()) <= 0) continue;
                            if ((dur = (short)(dur - field.getSettings().getRepair())) < 0) {
                                dur = 0;
                            }
                            armor.setDurability(dur);
                            this.plugin.getCommunicationManager().showRepair(player);
                            hasRepair = true;
                            break;
                        }
                        for (ItemStack item : items = player.getInventory().getContents()) {
                            short dur;
                            if (item == null || !this.plugin.getSettingsManager().isRepairableItemType(new BlockTypeEntry(item.getType())) || (dur = item.getDurability()) <= 0) continue;
                            if ((dur = (short)(dur - field.getSettings().getRepair())) < 0) {
                                dur = 0;
                            }
                            item.setDurability(dur);
                            this.plugin.getCommunicationManager().showRepair(player);
                            hasRepair = true;
                            break;
                        }
                    }
                    if (!(this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.damage") || field.hasFlag(FieldFlag.SNEAKING_BYPASS) && player.isSneaking() || hasDamage || !FieldFlag.DAMAGE.applies(field, player) || !(player.getHealth() > 0.0))) {
                        double health = this.healthCheck(player.getHealth() - (double)field.getSettings().getDamage());
                        player.setHealth((double)((int)Math.max(health, 0.0)));
                        if (health <= 1.0 && player != null) {
                            player.playEffect(EntityEffect.DEATH);
                        }
                        if (player != null) {
                            this.plugin.getCommunicationManager().showDamage(player);
                        }
                        hasDamage = true;
                    }
                    if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.potions") && !hasPotion && FieldFlag.POTIONS.applies(field, player)) {
                        this.plugin.getPotionManager().applyPotions(player, field);
                        hasPotion = true;
                    }
                    if (!FieldFlag.NEUTRALIZE_POTIONS.applies(field, player)) continue;
                    this.plugin.getPotionManager().neutralizePotions(player, field);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getPlayerEntryFields(Player player) {
        HashMap<String, EntryFields> hashMap = this.entriesByPlayer;
        synchronized (hashMap) {
            EntryFields ef = this.entriesByPlayer.get(player.getName());
            if (ef != null) {
                ArrayList<Field> e = new ArrayList<Field>();
                e.addAll(ef.getFields());
                return e;
            }
        }
        return null;
    }

    public void reevaluateEnteredFields(Player player) {
        List<Field> entryFields;
        if (player == null) {
            return;
        }
        Field confField = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.CONFISCATE_ITEMS);
        if (confField == null) {
            this.plugin.getConfiscationManager().returnItems(player);
        }
        if (this.plugin.getSettingsManager().isVisualizeEndOnMove() && !this.plugin.getPermissionsManager().has(player, "preciousstones.admin.visualize") && !this.plugin.getCuboidManager().hasOpenCuboid(player)) {
            this.plugin.getVisualizationManager().revert(player);
        }
        if ((entryFields = this.plugin.getEntryManager().getPlayerEntryFields(player)) != null) {
            for (Field entryField : entryFields) {
                if (entryField.envelops(player.getLocation())) continue;
                this.plugin.getEntryManager().leaveField(player, entryField);
                if (this.plugin.getEntryManager().containsSameNameOwnedField(player, entryField)) continue;
                this.plugin.getEntryManager().leaveOverlappedArea(player, entryField);
            }
        }
        List<Field> currentFields = this.plugin.getForceFieldManager().getEnabledSourceFields(player.getLocation(), FieldFlag.ALL);
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.entry")) {
            for (Field field : currentFields) {
                Field f;
                if (!FieldFlag.PREVENT_ENTRY.applies(field, player)) continue;
                Location loc = this.plugin.getPlayerManager().getOutsideFieldLocation(field, player);
                Location outside = this.plugin.getPlayerManager().getOutsideLocation(player);
                if (outside != null && (f = this.plugin.getForceFieldManager().getEnabledSourceField(outside, FieldFlag.PREVENT_ENTRY)) != null) {
                    loc = outside;
                }
                player.teleport(loc);
                this.plugin.getCommunicationManager().warnEntry(player, field);
                return;
            }
        }
        this.plugin.getPlayerManager().updateOutsideLocation(player);
        for (Field currentField : currentFields) {
            if (this.plugin.getEntryManager().enteredField(player, currentField)) continue;
            if (!this.plugin.getEntryManager().containsSameNameOwnedField(player, currentField)) {
                this.plugin.getEntryManager().enterOverlappedArea(player, currentField);
            }
            this.plugin.getEntryManager().enterField(player, currentField);
        }
    }

    public void enterOverlappedArea(Player player, Field field) {
        int slot;
        PlayerInventory inv;
        ItemStack item;
        if (field.hasFlag(FieldFlag.WELCOME_MESSAGE)) {
            this.plugin.getCommunicationManager().showWelcomeMessage(player, field);
        }
        if (FieldFlag.TELEPORT_ON_ENTRY.applies(field, player)) {
            this.plugin.getTeleportationManager().teleport((Entity)player, field, "teleportAnnounceEnter");
        }
        if (FieldFlag.GROUP_ON_ENTRY.applies(field, player) && !field.getSettings().getGroupOnEntry().isEmpty()) {
            this.plugin.getPermissionsManager().addGroup(player, field.getSettings().getGroupOnEntry());
        }
        if (FieldFlag.CONFISCATE_ITEMS.applies(field, player)) {
            this.plugin.getConfiscationManager().confiscateItems(field, player);
        }
        if (FieldFlag.ENTRY_GAME_MODE.applies(field, player)) {
            player.setGameMode(field.getSettings().getForceEntryGameMode());
        }
        if (FieldFlag.PREVENT_FLIGHT.applies(field, player)) {
            if (this.plugin.getSettingsManager().isNotifyFlyZones()) {
                ChatHelper.send((CommandSender)player, "noFlyEnter", new Object[0]);
            }
            player.setAllowFlight(false);
        }
        if (!(!FieldFlag.ENTRY_ALERT.applies(field, player) || this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.entryalert") || field.hasFlag(FieldFlag.SNEAKING_BYPASS) && player.isSneaking() || this.plugin.getPermissionsManager().isVanished(player))) {
            this.plugin.getForceFieldManager().announceAllowedPlayers(field, ChatHelper.format("entryAnnounce", player.getName(), field.getName(), field.getCoords()));
        }
        if (field.hasFlag(FieldFlag.COMMANDS_ON_OVERLAP)) {
            this.fireEnterCommands(field, player);
        }
        if (FieldFlag.UNUSABLE_ITEMS.applies(field, player) && (item = (inv = player.getInventory()).getItem(slot = inv.getHeldItemSlot())) != null && field.getSettings().isUnusableItem(item.getTypeId(), item.getData().getData())) {
            StackHelper.unHoldItem(player, slot);
            ChatHelper.send((CommandSender)player, "cannotUseItemMoved", new Object[0]);
        }
    }

    public void leaveOverlappedArea(final Player player, final Field field) {
        Field sub;
        if (field.hasFlag(FieldFlag.FAREWELL_MESSAGE)) {
            this.plugin.getCommunicationManager().showFarewellMessage(player, field);
        }
        if (FieldFlag.TELEPORT_ON_EXIT.applies(field, player)) {
            this.plugin.getTeleportationManager().teleport((Entity)player, field, "teleportAnnounceExit");
        }
        if (FieldFlag.GROUP_ON_ENTRY.applies(field, player)) {
            final String group = field.getSettings().getGroupOnEntry();
            if (!field.getSettings().getGroupOnEntry().isEmpty()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Field sourceField = EntryManager.this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.GROUP_ON_ENTRY);
                        boolean skip = false;
                        if (sourceField != null && sourceField.getSettings().getGroupOnEntry().equals(group)) {
                            skip = true;
                        }
                        if (!skip) {
                            EntryManager.this.plugin.getPermissionsManager().removeGroup(player, field.getSettings().getGroupOnEntry());
                        }
                    }
                }, 1L);
            }
        }
        if (FieldFlag.CONFISCATE_ITEMS.applies(field, player)) {
            this.plugin.getConfiscationManager().returnItems(player);
        }
        if (FieldFlag.POTIONS.applies(field, player)) {
            HashMap<PotionEffectType, Integer> potions = field.getSettings().getPotions();
            for (PotionEffectType pot : potions.keySet()) {
                player.removePotionEffect(pot);
            }
        }
        if (FieldFlag.LEAVING_GAME_MODE.applies(field, player)) {
            final FieldSettings settings = field.getSettings();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Field field = EntryManager.this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.ENTRY_GAME_MODE);
                    if (field != null) {
                        player.setGameMode(settings.getForceEntryGameMode());
                    } else {
                        player.setGameMode(settings.getForceLeavingGameMode());
                    }
                }
            }, 1L);
        }
        if (FieldFlag.PREVENT_FLIGHT.applies(field, player) && (sub = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.PREVENT_FLIGHT)) == null) {
            if (this.plugin.getSettingsManager().isNotifyFlyZones()) {
                ChatHelper.send((CommandSender)player, "noFlyLeave", new Object[0]);
            }
            player.setAllowFlight(true);
        }
        if (field.hasFlag(FieldFlag.COMMANDS_ON_OVERLAP)) {
            this.fireExitCommands(field, player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterField(Player player, Field field) {
        EntryFields ef;
        PreciousStones.debug(player.getName() + " entered a " + field.getSettings().getTitle() + " field", new Object[0]);
        EntryFields newEntryField = new EntryFields(field);
        HashMap<String, EntryFields> hashMap = this.entriesByPlayer;
        synchronized (hashMap) {
            ef = this.entriesByPlayer.get(player.getName());
            if (ef != null) {
                ef.addField(field);
            } else {
                this.entriesByPlayer.put(player.getName(), newEntryField);
            }
        }
        if (this.isDynamic(field)) {
            hashMap = this.dynamicEntries;
            synchronized (hashMap) {
                ef = this.dynamicEntries.get(player.getName());
                if (ef != null) {
                    ef.addField(field);
                } else {
                    this.dynamicEntries.put(player.getName(), newEntryField);
                }
            }
        }
        if (!this.enteredFields.contains(field)) {
            this.enteredFields.add(field);
        }
        this.enteredSingleField(player, field);
    }

    public void enteredSingleField(Player player, Field field) {
        if (!field.isDisabled()) {
            this.plugin.getSnitchManager().recordSnitchEntry(player, field);
            if (!field.hasFlag(FieldFlag.SNEAKING_BYPASS) || !player.isSneaking()) {
                this.plugin.getVelocityManager().launchPlayer(player, field);
                this.plugin.getVelocityManager().shootPlayer(player, field);
            }
            if (!(this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.damage") || field.hasFlag(FieldFlag.SNEAKING_BYPASS) && player.isSneaking())) {
                this.plugin.getMineManager().enterMine(player, field);
                this.plugin.getLightningManager().enterLightning(player, field);
            }
        }
        if (field.hasFlag(FieldFlag.MASK_ON_DISABLED) && field.isDisabled()) {
            field.getMaskingModule().mask(player);
        }
        if (field.hasFlag(FieldFlag.HIDABLE) && field.getHidingModule().isHidden() && this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.hiding")) {
            player.sendBlockChange(field.getLocation(), field.getTypeId(), (byte)field.getData());
        }
        if (!field.hasFlag(FieldFlag.COMMANDS_ON_OVERLAP)) {
            this.fireEnterCommands(field, player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveField(Player player, Field field) {
        EntryFields ef;
        if (field == null) {
            return;
        }
        PreciousStones.debug(player.getName() + " left a " + field.getSettings().getTitle() + " field", new Object[0]);
        HashMap<String, EntryFields> hashMap = this.entriesByPlayer;
        synchronized (hashMap) {
            ef = this.entriesByPlayer.get(player.getName());
            if (ef != null) {
                ef.removeField(field);
                if (ef.size() == 0) {
                    this.entriesByPlayer.remove(player.getName());
                }
            }
        }
        hashMap = this.dynamicEntries;
        synchronized (hashMap) {
            ef = this.dynamicEntries.get(player.getName());
            if (ef != null) {
                ef.removeField(field);
                if (ef.size() == 0) {
                    this.dynamicEntries.remove(player.getName());
                }
            }
        }
        this.enteredFields.remove(field);
        this.leftSingleField(player, field);
    }

    public void leftSingleField(Player player, Field field) {
        if (!field.hasFlag(FieldFlag.COMMANDS_ON_OVERLAP)) {
            this.fireExitCommands(field, player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leaveAllFields(Player player) {
        HashMap<String, EntryFields> hashMap = this.entriesByPlayer;
        synchronized (hashMap) {
            if (this.entriesByPlayer.containsKey(player.getName())) {
                EntryFields entryFields = this.entriesByPlayer.get(player.getName());
                for (Field field : entryFields.getFields()) {
                    this.leftSingleField(player, field);
                    this.leaveOverlappedArea(player, field);
                }
                this.entriesByPlayer.remove(player.getName());
            }
        }
        hashMap = this.dynamicEntries;
        synchronized (hashMap) {
            if (this.dynamicEntries.containsKey(player.getName())) {
                this.dynamicEntries.remove(player.getName());
            }
        }
        List<String> allEntryGroups = this.plugin.getSettingsManager().getAllEntryGroups();
        for (String group : allEntryGroups) {
            this.plugin.getPermissionsManager().removeGroup(player, group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPlayers(Field field) {
        Iterator<Field> iter;
        List<Field> fields;
        EntryFields ef;
        Player player;
        HashMap<String, EntryFields> hashMap = this.entriesByPlayer;
        synchronized (hashMap) {
            for (String playerName : this.entriesByPlayer.keySet()) {
                player = Bukkit.getServer().getPlayerExact(playerName);
                if (player == null) continue;
                ef = this.entriesByPlayer.get(playerName);
                fields = ef.getFields();
                iter = fields.iterator();
                while (iter.hasNext()) {
                    Field testfield = iter.next();
                    if (!field.equals(testfield)) continue;
                    iter.remove();
                    this.leftSingleField(player, field);
                    this.leaveOverlappedArea(player, field);
                }
            }
        }
        hashMap = this.dynamicEntries;
        synchronized (hashMap) {
            for (String playerName : this.dynamicEntries.keySet()) {
                player = Bukkit.getServer().getPlayerExact(playerName);
                if (player == null) continue;
                ef = this.dynamicEntries.get(playerName);
                fields = ef.getFields();
                iter = fields.iterator();
                while (iter.hasNext()) {
                    Field testField = iter.next();
                    if (!field.equals(testField)) continue;
                    iter.remove();
                    this.leftSingleField(player, field);
                    this.leaveOverlappedArea(player, field);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enteredField(Player player, Field field) {
        HashMap<String, EntryFields> hashMap = this.entriesByPlayer;
        synchronized (hashMap) {
            EntryFields ef = this.entriesByPlayer.get(player.getName());
            if (ef == null) {
                return false;
            }
            return ef.containsField(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSameNameOwnedField(Player player, Field field) {
        HashMap<String, EntryFields> hashMap = this.entriesByPlayer;
        synchronized (hashMap) {
            EntryFields ef = this.entriesByPlayer.get(player.getName());
            if (ef != null) {
                List<Field> entryFields = ef.getFields();
                for (Field entryField : entryFields) {
                    if (!entryField.getOwner().equals(field.getOwner()) || !entryField.getName().equals(field.getName()) || !entryField.getType().equals(field.getType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private double healthCheck(double health) {
        if (health < 0.0) {
            return 0.0;
        }
        if (health > 20.0) {
            return 20.0;
        }
        return health;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInhabitant(Field field, String playerName) {
        HashMap<String, EntryFields> hashMap = this.entriesByPlayer;
        synchronized (hashMap) {
            EntryFields ef = this.entriesByPlayer.get(playerName);
            List<Field> fields = ef.getFields();
            return fields.contains(field);
        }
    }

    public boolean hasInhabitants(Field field) {
        return this.enteredFields.contains(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> getInhabitants(Field field) {
        HashSet<String> inhabitants = new HashSet<String>();
        HashMap<String, EntryFields> hashMap = this.entriesByPlayer;
        synchronized (hashMap) {
            for (String playerName : this.entriesByPlayer.keySet()) {
                EntryFields ef = this.entriesByPlayer.get(playerName);
                List<Field> fields = ef.getFields();
                for (Field testfield : fields) {
                    if (!field.equals(testfield)) continue;
                    inhabitants.add(playerName);
                }
            }
        }
        return inhabitants;
    }

    private void fireEnterCommands(Field field, Player player) {
        if (FieldFlag.COMMAND_ON_ENTER.applies(field, player) && !field.getSettings().getCommandsOnEnter().isEmpty()) {
            for (String cmd : field.getSettings().getCommandsOnEnter()) {
                cmd = cmd.replace("{player}", player.getName());
                cmd = cmd.replace("{owner}", field.getOwner());
                cmd = cmd.replace("{x}", player.getLocation().getBlockX() + "");
                cmd = cmd.replace("{y}", player.getLocation().getBlockY() + "");
                cmd = cmd.replace("{z}", player.getLocation().getBlockZ() + "");
                cmd = cmd.replace("{world}", player.getLocation().getWorld().getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
            }
        }
        if (FieldFlag.PLAYER_COMMAND_ON_ENTER.applies(field, player) && !field.getSettings().getPlayerCommandsOnEnter().isEmpty()) {
            for (String cmd : field.getSettings().getPlayerCommandsOnEnter()) {
                cmd = cmd.replace("{player}", player.getName());
                cmd = cmd.replace("{owner}", field.getOwner());
                cmd = cmd.replace("{x}", player.getLocation().getBlockX() + "");
                cmd = cmd.replace("{y}", player.getLocation().getBlockY() + "");
                cmd = cmd.replace("{z}", player.getLocation().getBlockZ() + "");
                cmd = cmd.replace("{world}", player.getLocation().getWorld().getName());
                player.performCommand(cmd);
            }
        }
    }

    private void fireExitCommands(Field field, Player player) {
        if (FieldFlag.COMMAND_ON_EXIT.applies(field, player) && !field.getSettings().getCommandsOnExit().isEmpty()) {
            for (String cmd : field.getSettings().getCommandsOnExit()) {
                cmd = cmd.replace("{player}", player.getName());
                cmd = cmd.replace("{owner}", field.getOwner());
                cmd = cmd.replace("{x}", player.getLocation().getBlockX() + "");
                cmd = cmd.replace("{y}", player.getLocation().getBlockY() + "");
                cmd = cmd.replace("{z}", player.getLocation().getBlockZ() + "");
                cmd = cmd.replace("{world}", player.getLocation().getWorld().getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
            }
        }
        if (FieldFlag.PLAYER_COMMAND_ON_EXIT.applies(field, player) && !field.getSettings().getPlayerCommandsOnExit().isEmpty()) {
            for (String cmd : field.getSettings().getPlayerCommandsOnExit()) {
                cmd = cmd.replace("{player}", player.getName());
                cmd = cmd.replace("{owner}", field.getOwner());
                cmd = cmd.replace("{x}", player.getLocation().getBlockX() + "");
                cmd = cmd.replace("{y}", player.getLocation().getBlockY() + "");
                cmd = cmd.replace("{z}", player.getLocation().getBlockZ() + "");
                cmd = cmd.replace("{world}", player.getLocation().getWorld().getName());
                player.performCommand(cmd);
            }
        }
    }

    public void actOnInhabitantsOnDisableToggle(final Field field) {
        Set<Player> inhabitants = this.plugin.getForceFieldManager().getFieldInhabitants(field);
        for (final Player player : inhabitants) {
            if (player == null) continue;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (field.isDisabled()) {
                        if (FieldFlag.POTIONS.applies(field, player)) {
                            EntryManager.this.plugin.getPotionManager().removePotions(player, field);
                        }
                        if (FieldFlag.CONFISCATE_ITEMS.applies(field, player)) {
                            EntryManager.this.plugin.getConfiscationManager().returnItems(player);
                        }
                    } else {
                        if (FieldFlag.LAUNCH.applies(field, player)) {
                            EntryManager.this.plugin.getVelocityManager().launchPlayer(player, field);
                        }
                        if (FieldFlag.CANNON.applies(field, player)) {
                            EntryManager.this.plugin.getVelocityManager().shootPlayer(player, field);
                        }
                        if (FieldFlag.POTIONS.applies(field, player)) {
                            EntryManager.this.plugin.getPotionManager().applyPotions(player, field);
                        }
                        if (FieldFlag.CONFISCATE_ITEMS.applies(field, player)) {
                            EntryManager.this.plugin.getConfiscationManager().confiscateItems(field, player);
                        }
                    }
                }
            }, 0L);
        }
    }

    private class Update
    implements Runnable {
        private Update() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap hashMap = EntryManager.this.dynamicEntries;
            synchronized (hashMap) {
                EntryManager.this.doEffects();
            }
            EntryManager.this.scheduleNextUpdate();
            EntryManager.this.updateCount++;
            if (EntryManager.this.updateCount > 214783640) {
                EntryManager.this.updateCount = 0;
            }
        }
    }
}

