/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.ResultsFilter;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.TargetBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.CuboidEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.ForesterEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.PermissionsManager;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.AbstractVec;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.ChunkVec;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public final class ForceFieldManager {
    private final Map<FieldFlag, List<Field>> fieldsByFlag = Maps.newHashMap();
    private final Map<String, List<Field>> fieldsByWorld = Maps.newHashMap();
    private final Map<String, Map<BlockTypeEntry, List<Field>>> fieldsByOwnerAndType = Maps.newHashMap();
    private final Map<String, Map<FieldFlag, List<Field>>> fieldsByOwnerAndFlag = Maps.newHashMap();
    private final Map<String, List<Field>> fieldsByOwner = Maps.newHashMap();
    private final Map<Vec, Field> fieldsByVec = Maps.newHashMap();
    private final HashMap<ChunkVec, HashMap<FieldFlag, List<Field>>> sourceFields = new HashMap();
    private Queue<Field> deletionQueue = new LinkedList<Field>();
    private PreciousStones plugin = PreciousStones.getInstance();

    public void clearChunkLists() {
        this.fieldsByFlag.clear();
        this.fieldsByWorld.clear();
        this.fieldsByOwner.clear();
        this.fieldsByOwnerAndType.clear();
        this.fieldsByOwnerAndFlag.clear();
        this.fieldsByVec.clear();
        this.sourceFields.clear();
    }

    public void add(Block fieldBlock, Player player, BlockPlaceEvent event) {
        ScoreboardManager manager;
        Scoreboard board;
        Team team;
        OfflinePlayer offlinePlayer;
        String clan;
        Field field;
        boolean notify = true;
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(fieldBlock);
        if (fs == null) {
            return;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(fieldBlock.getWorld())) {
            return;
        }
        if (!this.plugin.getWorldGuardManager().canBuildField(player, fieldBlock, fs)) {
            ChatHelper.send((CommandSender)player, "fieldIntersectsWG", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getLimitManager().reachedLimit(player, fs)) {
            event.setCancelled(true);
            return;
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.purchase") && fs.getPrice() > 0 && !this.purchase(player, fs.getPrice())) {
            return;
        }
        String owner = fs.hasDefaultFlag(FieldFlag.NO_OWNER) ? "Server" : player.getName();
        boolean isChild = false;
        boolean isImport = false;
        if (this.plugin.getCuboidManager().hasOpenCuboid(player)) {
            CuboidEntry ce = this.plugin.getCuboidManager().getOpenCuboid(player);
            if (!(ce.getField().getSettings().getMixingGroup() == fs.getMixingGroup() && fs.getMixingGroup() != 0 || ce.getField().getSettings().getTypeEntry().equals(fs.getTypeEntry()))) {
                this.plugin.getCuboidManager().cancelOpenCuboid(player);
                ChatHelper.send((CommandSender)player, "cuboidCannotMix", new Object[0]);
                event.setCancelled(true);
                return;
            }
            if (fs.getPrice() > ce.getField().getSettings().getPrice()) {
                this.plugin.getCuboidManager().cancelOpenCuboid(player);
                ChatHelper.send((CommandSender)player, "cuboidCannotAddProps", new Object[0]);
                event.setCancelled(true);
                return;
            }
            field = new Field(fieldBlock, 0, 0, owner);
            ce.getField().addChild(field);
            field.setParent(ce.getField());
            isChild = true;
            notify = false;
            if (!ce.getField().getTypeEntry().equals(fs.getTypeEntry())) {
                ce.getField().getFlagsModule().importFlags(fs.getDefaultFlags());
                ChatHelper.send((CommandSender)player, "flagsImported", fs.getTitle());
                isImport = true;
            }
        } else {
            field = new Field(fieldBlock, fs.getRadius(), fs.getCustomHeight(), owner);
        }
        field.setSettings(fs);
        if (field.hasFlag(FieldFlag.FORESTER)) {
            if (!field.hasFlag(FieldFlag.PLACE_DISABLED)) {
                ForesterEntry fe = new ForesterEntry(field, player);
            }
        } else {
            if (field.hasFlag(FieldFlag.CUBOID) && !isImport && isChild) {
                this.plugin.getCuboidManager().openChild(player, field);
            }
            this.plugin.getStorageManager().insertField(field);
        }
        this.addToCollection(field);
        if (field.hasFlag(FieldFlag.VISUALIZE_ON_PLACE) && !isChild) {
            this.plugin.getVisualizationManager().visualizeSingleFieldFast(player, field);
        }
        if (notify) {
            if (field.hasFlag(FieldFlag.BREAKABLE)) {
                this.plugin.getCommunicationManager().notifyPlaceBreakableFF(player, fieldBlock);
            } else {
                this.plugin.getCommunicationManager().notifyPlaceFF(player, fieldBlock);
            }
        }
        for (FieldFlag flag : field.getSettings().getDisabledFlags()) {
            field.getFlagsModule().disableFlag(flag.toString(), true);
        }
        if (field.hasFlag(FieldFlag.PLACE_DISABLED)) {
            field.setDisabled(true);
        }
        if (field.hasFlag(FieldFlag.GRIEF_REVERT) && field.getSettings().getGriefRevertInterval() > 0) {
            field.getRevertingModule().setRevertSecs(field.getSettings().getGriefRevertInterval());
            this.plugin.getGriefUndoManager().register(field);
        }
        if (field.hasFlag(FieldFlag.RENTABLE) || field.hasFlag(FieldFlag.SHAREABLE)) {
            field.getRentingModule().scheduleNextRentUpdate();
        }
        if (this.plugin.getSettingsManager().isAutoAddClan() && (clan = this.plugin.getSimpleClansManager().getClan(player.getName())) != null) {
            field.addAllowed("c:" + clan);
        }
        if (this.plugin.getSettingsManager().isAutoAddTeam() && (offlinePlayer = this.plugin.getServer().getOfflinePlayer(player.getName())) != null && (team = (board = (manager = Bukkit.getScoreboardManager()).getMainScoreboard()).getPlayerTeam(offlinePlayer)) != null) {
            field.addAllowed("t:" + team.getName());
        }
        if (field.getSettings().getFenceItem() > 0 && (field.getFencingModule().getFencePrice() == 0 || this.purchase(player, field.getFencingModule().getFencePrice()))) {
            field.getFencingModule().generateFence(field.getSettings().getFenceItem());
            ChatHelper.send((CommandSender)player, "fenceGenerated", new Object[0]);
        }
        field.getBlock().setMetadata("Pstone", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        this.plugin.getForceFieldManager().addAllowOverlappingOwners(field);
        field.startDisabler();
        this.plugin.getStorageManager().offerField(field);
    }

    public void addToCollection(Field field) {
        ArrayList<FieldFlag> flags = new ArrayList<FieldFlag>();
        flags.addAll(field.getSettings().getDefaultFlags());
        flags.addAll(field.getFlagsModule().getInsertedFlags());
        for (FieldFlag flag : flags) {
            List<Field> fields = this.fieldsByFlag.get((Object)flag);
            if (fields == null) {
                fields = new ArrayList<Field>();
            }
            fields.add(field);
            this.fieldsByFlag.put(flag, fields);
        }
        this.fieldsByVec.put(field.toVec(), field);
        List<Field> fields = this.fieldsByWorld.get(field.getWorld());
        if (fields == null) {
            fields = new ArrayList<Field>();
        }
        fields.add(field);
        this.fieldsByWorld.put(field.getWorld(), fields);
        fields = this.getFieldsByOwner().get(field.getOwner().toLowerCase());
        if (fields == null) {
            fields = new ArrayList<Field>();
        }
        fields.add(field);
        this.getFieldsByOwner().put(field.getOwner().toLowerCase(), fields);
        HashMap types = this.fieldsByOwnerAndType.get(field.getOwner().toLowerCase());
        if (types == null) {
            types = Maps.newHashMap();
        }
        if ((fields = (ArrayList<Field>)types.get(field.getTypeEntry())) == null) {
            fields = new ArrayList<Field>();
        }
        fields.add(field);
        types.put(field.getTypeEntry(), fields);
        this.fieldsByOwnerAndType.put(field.getOwner().toLowerCase(), types);
        HashMap allFlags = this.fieldsByOwnerAndFlag.get(field.getOwner().toLowerCase());
        if (allFlags == null) {
            allFlags = Maps.newHashMap();
        }
        for (FieldFlag flag : field.getFlagsModule().getFlags()) {
            fields = (List)allFlags.get((Object)flag);
            if (fields == null) {
                fields = new ArrayList();
            }
            fields.add(field);
            allFlags.put(flag, fields);
        }
        this.fieldsByOwnerAndFlag.put(field.getOwner().toLowerCase(), allFlags);
        this.addSourceField(field);
    }

    public void addSourceField(Field field) {
        Set<ChunkVec> scvs = field.getEnvelopingChunks();
        for (ChunkVec scv : scvs) {
            HashMap<FieldFlag, List<Field>> sf = this.sourceFields.get(scv);
            if (sf == null) {
                sf = new HashMap();
            }
            ArrayList<FieldFlag> flags = new ArrayList<FieldFlag>();
            flags.addAll(field.getSettings().getDefaultFlags());
            flags.addAll(field.getFlagsModule().getInsertedFlags());
            for (FieldFlag flag : flags) {
                List<Field> fields = sf.get((Object)flag);
                if (fields == null) {
                    fields = new ArrayList<Field>();
                }
                if (!fields.contains(field)) {
                    fields.add(field);
                }
                sf.put(flag, fields);
            }
            this.sourceFields.put(scv, sf);
        }
    }

    public void deleteField(Field field) {
        Map<FieldFlag, List<Field>> allFlags;
        Map<BlockTypeEntry, List<Field>> types;
        List<Field> fields;
        if (field == null) {
            return;
        }
        if (field.getSettings() != null) {
            Set<FieldFlag> flags = this.fieldsByFlag.keySet();
            for (FieldFlag flag : flags) {
                List<Field> fields2 = this.fieldsByFlag.get((Object)flag);
                if (fields2 == null) continue;
                fields2.remove(field);
            }
        }
        this.fieldsByVec.remove(field.toVec());
        List<Field> owned = this.getFieldsByOwner().get(field.getOwner().toLowerCase());
        if (owned != null) {
            owned.remove(field);
        }
        if ((fields = this.fieldsByWorld.get(field.getWorld())) != null) {
            fields.remove(field);
        }
        if ((types = this.fieldsByOwnerAndType.get(field.getOwner().toLowerCase())) != null && (fields = types.get(field.getTypeEntry())) != null) {
            fields.remove(field);
        }
        if ((allFlags = this.fieldsByOwnerAndFlag.get(field.getOwner().toLowerCase())) != null) {
            for (FieldFlag flag : field.getFlagsModule().getFlags()) {
                fields = allFlags.get((Object)flag);
                if (fields == null) continue;
                fields.remove(field);
            }
        }
        this.removeSourceField(field);
        FieldSettings fs = field.getSettings();
        if (fs != null) {
            ArrayList<FieldFlag> flags = new ArrayList<FieldFlag>();
            flags.addAll(fs.getDefaultFlags());
            flags.addAll(field.getFlagsModule().getInsertedFlags());
            if (flags.contains((Object)FieldFlag.SNITCH)) {
                this.plugin.getStorageManager().deleteSnitchEntries(field);
            }
            if (flags.contains((Object)FieldFlag.GRIEF_REVERT)) {
                this.plugin.getGriefUndoManager().remove(field);
                this.plugin.getStorageManager().deleteBlockGrief(field);
            }
        }
        this.plugin.getEntryManager().removeAllPlayers(field);
        if (field.isParent()) {
            for (Field c : field.getChildren()) {
                c.clearParent();
                this.queueRelease(c);
            }
            field.clearChildren();
            this.flush();
        }
        if (field.isChild()) {
            this.release(field.getParent());
            return;
        }
        field.markForDeletion();
        this.plugin.getStorageManager().offerField(field);
    }

    public void removeSourceField(Field field) {
        Set<ChunkVec> scvs = field.getEnvelopingChunks();
        for (ChunkVec scv : scvs) {
            HashMap<FieldFlag, List<Field>> sf = this.sourceFields.get(scv);
            if (sf == null) continue;
            ArrayList<FieldFlag> flags = new ArrayList<FieldFlag>();
            flags.addAll(field.getSettings().getDefaultFlags());
            flags.addAll(field.getFlagsModule().getInsertedFlags());
            for (FieldFlag flag : flags) {
                List<Field> fields = sf.get((Object)flag);
                if (fields == null) continue;
                fields.remove(field);
                if (!fields.isEmpty()) continue;
                sf.remove((Object)flag);
            }
            if (!sf.isEmpty()) continue;
            this.sourceFields.remove(scv);
        }
    }

    public List<Field> getFields(String target, World world) {
        ArrayList<Field> out = new ArrayList<Field>();
        List<Field> fields = this.fieldsByWorld.get(world.getName());
        if (fields != null) {
            for (Field field : fields) {
                if (target.equals("*")) {
                    out.add(field);
                    continue;
                }
                if (target.contains("g:")) {
                    String group = target.substring(2);
                    if (!this.plugin.getPermissionsManager().inGroup(field.getOwner(), world, group)) continue;
                    out.add(field);
                    continue;
                }
                if (target.contains("c:")) {
                    String clan = target.substring(2);
                    if (!this.plugin.getSimpleClansManager().isInClan(field.getOwner(), clan)) continue;
                    out.add(field);
                    continue;
                }
                if (target.contains("t:")) {
                    ScoreboardManager manager;
                    Scoreboard board;
                    Team team;
                    String tm = target.substring(2);
                    OfflinePlayer offlinePlayer = PreciousStones.getInstance().getServer().getOfflinePlayer(field.getOwner());
                    if (offlinePlayer == null || (team = (board = (manager = Bukkit.getScoreboardManager()).getMainScoreboard()).getPlayerTeam(offlinePlayer)) == null || !tm.equalsIgnoreCase(team.getName())) continue;
                    out.add(field);
                    continue;
                }
                if (!field.isOwner(target)) continue;
                out.add(field);
            }
        }
        return out;
    }

    public Field getField(Block block) {
        return this.getField(block.getLocation());
    }

    public Field getField(Location location) {
        return this.fieldsByVec.get(new Vec(location));
    }

    public boolean isField(Block fieldBlock) {
        return this.getField(fieldBlock) != null;
    }

    public int getCount() {
        int size = 0;
        List worlds = this.plugin.getServer().getWorlds();
        if (worlds != null) {
            for (World world : worlds) {
                List<Field> fields = this.fieldsByWorld.get(world.getName());
                if (fields == null) continue;
                size += fields.size();
            }
        }
        return size;
    }

    public void offerAllDirtyFields() {
        ArrayList<Field> fields = new ArrayList<Field>(this.fieldsByVec.values());
        for (Field field : fields) {
            if (!field.isDirty()) continue;
            this.plugin.getStorageManager().offerField(field);
        }
    }

    public HashMap<BlockTypeEntry, Integer> getFieldCounts(String target) {
        HashMap<BlockTypeEntry, Integer> counts = new HashMap<BlockTypeEntry, Integer>();
        List worlds = this.plugin.getServer().getWorlds();
        for (World world : worlds) {
            List<Field> fields = this.getFields(target, world);
            for (Field field : fields) {
                if (counts.containsKey(field.getTypeEntry())) {
                    counts.put(field.getTypeEntry(), counts.get(field.getTypeEntry()) + 1);
                    continue;
                }
                counts.put(field.getTypeEntry(), 1);
            }
        }
        return counts;
    }

    public int cleanOrphans(World world) {
        int cleanedCount = 0;
        List<Field> fields = this.fieldsByWorld.get(world.getName());
        if (fields != null) {
            for (Field field : fields) {
                if (field.getHidingModule().isHidden() && !field.missingBlock() || field.matchesBlockType()) continue;
                ++cleanedCount;
                this.queueRelease(field);
            }
        }
        this.flush();
        if (cleanedCount != 0) {
            PreciousStones.log("countsOrphan", world.getName(), cleanedCount);
        }
        return cleanedCount;
    }

    public int revertOrphans(World world) {
        int revertedCount = 0;
        boolean currentChunkLoaded = false;
        AbstractVec currentChunk = null;
        List<Field> fields = this.fieldsByWorld.get(world.getName());
        if (fields != null) {
            for (Field field : fields) {
                ChunkVec cv = field.toChunkVec();
                if (!cv.equals(currentChunk)) {
                    if (!currentChunkLoaded && currentChunk != null) {
                        world.unloadChunk(currentChunk.getX(), currentChunk.getZ());
                    }
                    if (!(currentChunkLoaded = world.isChunkLoaded(cv.getX(), cv.getZ()))) {
                        world.loadChunk(cv.getX(), cv.getZ());
                    }
                    currentChunk = cv;
                }
                if (field.getHidingModule().isHidden() || field.matchesBlockType()) continue;
                Block block = field.getBlock();
                block.setTypeId(field.getTypeId());
                block.setData((byte)field.getData());
                ++revertedCount;
            }
        }
        return revertedCount;
    }

    public Block getBlock(Field field) {
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world == null) {
            return null;
        }
        return world.getBlockAt(field.getX(), field.getY(), field.getZ());
    }

    public boolean isRedstoneHookedDisabled(Field field) {
        BlockFace[] faces;
        Block block = this.getBlock(field);
        if (this.isAnywayPowered(block)) {
            return false;
        }
        int topId = block.getRelative(BlockFace.UP).getTypeId();
        if (topId == 70 || topId == 72) {
            return true;
        }
        for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
            Block faceblock = block.getRelative(face);
            int faceId = faceblock.getTypeId();
            if (faceId == 75) {
                return true;
            }
            if (faceId == 77) {
                return true;
            }
            if (faceId == 69 && faceblock.getBlockPower() == 0) {
                return true;
            }
            if (faceId != 55 || faceblock.getBlockPower() != 0) continue;
            return true;
        }
        BlockFace[] upfaces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        Block upblock = block.getRelative(BlockFace.UP);
        for (BlockFace face : upfaces) {
            Block faceblock = upblock.getRelative(face);
            int faceId = faceblock.getTypeId();
            if (faceId != 55 || faceblock.getBlockPower() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean powersField(Field field, Block block) {
        BlockFace[] faces;
        for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.DOWN, BlockFace.UP}) {
            Block faceblock = block.getRelative(face);
            if (field.getX() != faceblock.getX() || field.getY() != faceblock.getY() || field.getZ() != faceblock.getZ()) continue;
            return true;
        }
        BlockFace[] downfaces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        Block upblock = block.getRelative(BlockFace.DOWN);
        for (BlockFace face : downfaces) {
            Block faceblock = upblock.getRelative(face);
            if (field.getX() != faceblock.getX() || field.getY() != faceblock.getY() || field.getZ() != faceblock.getZ()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnywayPowered(Block block) {
        BlockFace[] faces;
        if (block.isBlockIndirectlyPowered() || block.isBlockPowered()) {
            return true;
        }
        for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
            Block source = block.getRelative(face);
            if (source.getTypeId() != 55 || source.getBlockPower() <= 0) continue;
            return true;
        }
        BlockFace[] upfaces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        Block upblock = block.getRelative(BlockFace.UP);
        for (BlockFace face : upfaces) {
            Block faceblock = upblock.getRelative(face);
            if (faceblock.getTypeId() != 55 || faceblock.getBlockPower() <= 0) continue;
            return true;
        }
        return false;
    }

    public void announceAllowedPlayers(Field field, String msg) {
        List<String> allowed = field.getAllAllowed();
        for (String playerName : allowed) {
            Player pl = Bukkit.getServer().getPlayerExact(playerName);
            if (pl == null) continue;
            ChatHelper.send((CommandSender)pl, "announceToAllowedPlayers", msg);
        }
    }

    public Block touchingFieldBlock(Block block) {
        if (block == null) {
            return null;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Block surroundingBlock = block.getWorld().getBlockAt(block.getX() + x, block.getY() + y, block.getZ() + z);
                    if (!this.plugin.getForceFieldManager().isField(surroundingBlock)) continue;
                    return surroundingBlock;
                }
            }
        }
        return null;
    }

    public boolean cleanSnitchList(Field field) {
        FieldSettings fs = field.getSettings();
        if (fs.hasDefaultFlag(FieldFlag.SNITCH)) {
            field.getSnitchingModule().clearSnitch();
            this.plugin.getStorageManager().deleteSnitchEntries(field);
            return true;
        }
        return false;
    }

    public boolean setNameField(Field field, String name) {
        FieldSettings fs = field.getSettings();
        if (fs.hasNameableFlag() && !field.getName().equals(name)) {
            field.setName(name);
            this.plugin.getStorageManager().offerField(field);
            return true;
        }
        return false;
    }

    public HashSet<String> getWho(Player owner, Field field) {
        HashSet<String> playerNames = this.plugin.getEntryManager().getInhabitants(field);
        Iterator<String> iter = playerNames.iterator();
        while (iter.hasNext()) {
            String playerName = iter.next();
            Player player = Bukkit.getServer().getPlayer(playerName);
            if (player == null) continue;
            if (this.plugin.getPermissionsManager().isVanished(player)) {
                iter.remove();
                continue;
            }
            if (owner.canSee(player)) continue;
            iter.remove();
        }
        return playerNames;
    }

    public boolean isAllowed(Block fieldBlock, String playerName) {
        Field field = this.getField(fieldBlock);
        return field != null && this.isAllowed(field, playerName);
    }

    public boolean isAllowed(Field field, String target) {
        if (field == null || target == null) {
            return false;
        }
        Player player = Bukkit.getServer().getPlayerExact(target);
        if (player != null && this.plugin.getPermissionsManager().has(player, "preciousstones.admin.allowed") && !field.hasFlag(FieldFlag.NO_ALLOWING)) {
            return true;
        }
        if (field.getSettings() == null) {
            return false;
        }
        if (!(field.getSettings().getRequiredPermissionAllow().isEmpty() || this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.required-permission") || this.plugin.getPermissionsManager().has(player, field.getSettings().getRequiredPermissionAllow()))) {
            return false;
        }
        if (field.getSettings().inAllowedList(target)) {
            return true;
        }
        if (field.getSettings().inDeniedList(target)) {
            return false;
        }
        if (this.plugin.getSettingsManager().isWarAllow() && this.plugin.getSimpleClansManager().inWar(field, target)) {
            return true;
        }
        return field.isAllowed(target);
    }

    public boolean isOwned(Field field, Player player) {
        if (field == null || player == null) {
            return false;
        }
        if (this.plugin.getPermissionsManager().has(player, "preciousstones.admin.allowed") && !field.hasFlag(FieldFlag.NO_ALLOWING)) {
            return true;
        }
        return field.isOwner(player.getName());
    }

    public boolean addAllowed(Field field, String target) {
        if (!field.isInAllowedList(target)) {
            field.addAllowed(target);
            this.plugin.getStorageManager().offerField(field);
            return true;
        }
        return false;
    }

    public boolean removeAllowed(Field field, String target) {
        if (field.isInAllowedList(target)) {
            field.removeAllowed(target);
            this.plugin.getStorageManager().offerField(field);
            return true;
        }
        return false;
    }

    public int allowAll(Player player, String allowedName) {
        List<Field> fields = this.getOwnersFields(player, FieldFlag.ALL);
        int allowedCount = 0;
        int notAllowed = 0;
        for (Field field : fields) {
            if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.on-disabled") && field.hasFlag(FieldFlag.MODIFY_ON_DISABLED) && !field.isDisabled()) {
                ++notAllowed;
                continue;
            }
            if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.no-allowing") && field.hasFlag(FieldFlag.NO_ALLOWING)) continue;
            if (!this.isAllowed(field, allowedName)) {
                field.addAllowed(allowedName);
                ++allowedCount;
            }
            this.plugin.getStorageManager().offerField(field);
        }
        if (notAllowed > 0) {
            ChatHelper.send((CommandSender)player, "fieldsSkipped", notAllowed);
        }
        return allowedCount;
    }

    public int removeConflictingFields(Field field, String allowedName) {
        Set<Field> sources = field.getIntersectingFields();
        int conflicted = 0;
        for (Field source : sources) {
            if (source.hasFlag(FieldFlag.NO_CONFLICT) || field.getOwner().equalsIgnoreCase(source.getOwner()) || !source.isOwner(allowedName)) continue;
            this.deleteField(source);
            ++conflicted;
        }
        return conflicted;
    }

    public boolean hasSubFields(Field field) {
        Set<Field> sources = field.getIntersectingFields();
        for (Field source : sources) {
            if (!source.getSettings().isAllowedOnlyInside(field)) continue;
            return true;
        }
        return false;
    }

    public int removeAll(Player player, String target) {
        List<Field> fields = this.getOwnersFields(player, FieldFlag.ALL);
        int removedCount = 0;
        int notRemoved = 0;
        for (Field field : fields) {
            if (field.containsPlayer(target)) {
                ChatHelper.send((CommandSender)player, "playerInsideNotRemoved", new Object[0]);
                continue;
            }
            if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.on-disabled") && field.hasFlag(FieldFlag.MODIFY_ON_DISABLED) && !field.isDisabled()) {
                ++notRemoved;
                continue;
            }
            int conflicted = this.plugin.getForceFieldManager().removeConflictingFields(field, target);
            if (conflicted > 0) {
                ChatHelper.send((CommandSender)player, "removedConflictingFields", conflicted, target);
                continue;
            }
            if (this.isAllowed(field, target)) {
                field.removeAllowed(target);
                ++removedCount;
            }
            this.plugin.getStorageManager().offerField(field);
        }
        if (notRemoved > 0) {
            ChatHelper.send((CommandSender)player, "fieldsSkipped", notRemoved);
        }
        return removedCount;
    }

    public String getOwner(Block fieldBlock) {
        Field field = this.getField(fieldBlock);
        if (field != null) {
            return field.getOwner();
        }
        return "";
    }

    public List<Field> getOwnersFields(Player player, FieldFlag flag) {
        List<Field> fields = this.fieldsByFlag.get((Object)flag);
        ArrayList<Field> out = new ArrayList<Field>();
        if (fields != null) {
            for (Field field : fields) {
                if (!field.isOwner(player.getName())) continue;
                out.add(field);
            }
        }
        return out;
    }

    public List<Field> getSourceFieldsInChunk(Chunk chunk, FieldFlag flag, ResultsFilter ... filters) {
        return this.getSourceFieldsInChunk(new ChunkVec(chunk), flag, filters);
    }

    public List<Field> getSourceFieldsInChunk(ChunkVec cv, FieldFlag flag, ResultsFilter ... filters) {
        List<Field> fields;
        HashMap<FieldFlag, List<Field>> flagList = this.sourceFields.get(cv);
        if (flagList != null && (fields = flagList.get((Object)flag)) != null && fields.size() > 0 && (fields = new ArrayList<Field>(fields)).size() > 0) {
            Iterator<Field> it = fields.iterator();
            block0: while (it.hasNext()) {
                Field field = it.next();
                for (ResultsFilter filter : filters) {
                    if (filter.Filter(field)) continue;
                    it.remove();
                    continue block0;
                }
            }
            return fields;
        }
        return new ArrayList<Field>();
    }

    public Field getSmallestSourceFieldInChunk(Chunk chunk, FieldFlag flag, ResultsFilter ... filters) {
        ChunkVec cv = new ChunkVec(chunk);
        List<Field> allFields = this.getSourceFieldsInChunk(cv, FieldFlag.ALL, filters);
        if (allFields.size() == 0) {
            return null;
        }
        Field absoluteSmallest = this.getSmallestVolumeField(allFields);
        if (absoluteSmallest != null && absoluteSmallest.hasFlag(FieldFlag.PLOT)) {
            if (!absoluteSmallest.hasFlag(flag)) {
                return null;
            }
            return absoluteSmallest;
        }
        List<Field> fields = this.getSourceFieldsInChunk(cv, flag, filters);
        Field smallest = this.getSmallestVolumeField(fields);
        return smallest;
    }

    public Field getSmallestVolumeField(List<Field> fields) {
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        Collections.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                Integer o1 = f1.getFlatVolume();
                Integer o2 = f2.getFlatVolume();
                PreciousStones.debug("%s: %s", f1.getType(), o1);
                PreciousStones.debug("%s: %s", f2.getType(), o2);
                return o1.compareTo(o2);
            }
        });
        for (Field smallest : fields) {
            if (smallest.hasFlag(FieldFlag.ANTI_PLOT) || smallest.getActualVolume() <= 1 || smallest.getHeight() <= 1) continue;
            return smallest;
        }
        return fields.get(0);
    }

    public List<Field> getSourceFields(final Location loc, FieldFlag flag) {
        ResultsFilter envelopsFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return field.envelops(loc);
            }
        };
        return this.getSourceFieldsInChunk(new ChunkVec(loc.getChunk()), flag, envelopsFilter);
    }

    public List<Field> getEnabledSourceFields(final Location loc, final FieldFlag flag) {
        ResultsFilter envelopsFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return field.envelops(loc);
            }
        };
        ResultsFilter disabledFlagFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return !field.getFlagsModule().hasDisabledFlag(flag);
            }
        };
        ResultsFilter notDisabledFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return !field.isDisabled();
            }
        };
        ResultsFilter disableIfOnlineFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return !field.hasFlag(FieldFlag.DISABLE_WHEN_ONLINE) || !field.hasOnlineAllowed();
            }
        };
        Chunk c = null;
        try {
            c = loc.getChunk();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (c == null) {
            return new ArrayList<Field>();
        }
        return this.getSourceFieldsInChunk(new ChunkVec(c), flag, envelopsFilter, disabledFlagFilter, notDisabledFilter, disableIfOnlineFilter);
    }

    public Field getEnabledSourceField(final Location loc, final FieldFlag flag) {
        ResultsFilter envelopsFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return field.envelops(loc);
            }
        };
        ResultsFilter disabledFlagFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return !field.getFlagsModule().hasDisabledFlag(flag);
            }
        };
        ResultsFilter notDisabledFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return !field.isDisabled();
            }
        };
        ResultsFilter disableIfOnlineFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                if (field.hasFlag(FieldFlag.DISABLE_WHEN_ONLINE)) {
                    return !field.hasOnlineAllowed();
                }
                return true;
            }
        };
        return this.getSmallestSourceFieldInChunk(loc.getChunk(), flag, envelopsFilter, notDisabledFilter, disabledFlagFilter, disableIfOnlineFilter);
    }

    public Field getConflictSourceField(final Location loc, final String playerName, FieldFlag flag) {
        ResultsFilter envelopsFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return field.envelops(loc);
            }
        };
        ResultsFilter noConflictFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return !field.hasFlag(FieldFlag.NO_CONFLICT);
            }
        };
        ResultsFilter allowedFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return !ForceFieldManager.this.isAllowed(field, playerName);
            }
        };
        return this.getSmallestSourceFieldInChunk(loc.getChunk(), flag, allowedFilter, envelopsFilter, noConflictFilter);
    }

    public boolean hasSourceField(Location loc, FieldFlag flag) {
        return this.getEnabledSourceField(loc, flag) != null;
    }

    public Set<Field> getFieldsInCustomArea(final Location loc, int chunkRadius, FieldFlag flag) {
        HashSet<Field> out = new HashSet<Field>();
        int xlow = (loc.getBlockX() >> 4) - chunkRadius;
        int xhigh = (loc.getBlockX() >> 4) + chunkRadius;
        int zlow = (loc.getBlockZ() >> 4) - chunkRadius;
        int zhigh = (loc.getBlockZ() >> 4) + chunkRadius;
        for (int x = xlow; x <= xhigh; ++x) {
            for (int z = zlow; z <= zhigh; ++z) {
                ResultsFilter envelopsFilter = new ResultsFilter(){

                    @Override
                    public boolean Filter(Field field) {
                        return field.envelops(loc);
                    }
                };
                List<Field> fields = this.getSourceFieldsInChunk(new ChunkVec(x, z, loc.getWorld().getName()), flag, envelopsFilter);
                if (fields == null) continue;
                out.addAll(fields);
            }
        }
        return out;
    }

    public Set<Field> getFieldsInCustomArea(final Location loc, int chunkradius, FieldFlag flag, Player player) {
        HashSet<Field> out = new HashSet<Field>();
        int xlow = (loc.getBlockX() >> 4) - chunkradius;
        int xhigh = (loc.getBlockX() >> 4) + chunkradius;
        int zlow = (loc.getBlockZ() >> 4) - chunkradius;
        int zhigh = (loc.getBlockZ() >> 4) + chunkradius;
        for (int x = xlow; x <= xhigh; ++x) {
            for (int z = zlow; z <= zhigh; ++z) {
                ResultsFilter envelopsFilter = new ResultsFilter(){

                    @Override
                    public boolean Filter(Field field) {
                        return field.envelops(loc);
                    }
                };
                List<Field> fields = this.getSourceFieldsInChunk(new ChunkVec(x, z, loc.getWorld().getName()), flag, envelopsFilter);
                if (fields == null) continue;
                for (Field field : fields) {
                    if (!this.isAllowed(field, player.getName())) continue;
                    out.add(field);
                }
            }
        }
        return out;
    }

    public Field getPointedField(Player player) {
        Field f;
        TargetBlock aiming = new TargetBlock(player, this.plugin.getSettingsManager().getMaxTargetDistance(), 0.2, this.plugin.getSettingsManager().getThroughFieldsSet());
        Block targetBlock = aiming.getTargetBlock();
        if (targetBlock != null && (f = this.getField(targetBlock)) != null) {
            if (f.isChild()) {
                f = f.getParent();
            }
            if (this.isAllowed(f, player.getName())) {
                return f;
            }
        }
        return null;
    }

    public Field getOneAllowedField(final Block blockInArea, final Player player, FieldFlag flag) {
        Field pointed = this.getPointedField(player);
        if (pointed != null) {
            return pointed;
        }
        ResultsFilter envelopsFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return field.envelops(blockInArea.getLocation());
            }
        };
        ResultsFilter allowedFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return ForceFieldManager.this.isAllowed(field, player.getName());
            }
        };
        return this.getSmallestSourceFieldInChunk(blockInArea.getLocation().getChunk(), flag, envelopsFilter, allowedFilter);
    }

    public Field getOneOwnedField(final Block blockInArea, final Player player, FieldFlag flag) {
        Field pointed = this.getPointedField(player);
        if (pointed != null) {
            return pointed;
        }
        ResultsFilter envelopsFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return field.envelops(blockInArea.getLocation());
            }
        };
        ResultsFilter allowedFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return ForceFieldManager.this.isOwned(field, player);
            }
        };
        return this.getSmallestSourceFieldInChunk(blockInArea.getLocation().getChunk(), flag, envelopsFilter, allowedFilter);
    }

    public Field getOneNonOwnedField(final Block blockInArea, final Player player, FieldFlag flag) {
        Field pointed = this.getPointedField(player);
        if (pointed != null) {
            return pointed;
        }
        ResultsFilter envelopsFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return field.envelops(blockInArea.getLocation());
            }
        };
        ResultsFilter allowedFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return !ForceFieldManager.this.isOwned(field, player);
            }
        };
        return this.getSmallestSourceFieldInChunk(blockInArea.getLocation().getChunk(), flag, envelopsFilter, allowedFilter);
    }

    public Field getOneField(final Block blockInArea, Player player, FieldFlag flag) {
        Field pointed = this.getPointedField(player);
        if (pointed != null) {
            return pointed;
        }
        ResultsFilter envelopsFilter = new ResultsFilter(){

            @Override
            public boolean Filter(Field field) {
                return field.envelops(blockInArea.getLocation());
            }
        };
        return this.getSmallestSourceFieldInChunk(blockInArea.getLocation().getChunk(), flag, envelopsFilter);
    }

    public Field unbreakableConflicts(Block placedBlock, Player placer) {
        List<Field> sources = this.getSourceFields(placedBlock.getLocation(), FieldFlag.ALL);
        ArrayList<Field> out = new ArrayList<Field>();
        for (Field field : sources) {
            if (field.hasFlag(FieldFlag.NO_CONFLICT) || this.isAllowed(field, placer.getName()) || !field.envelops(placedBlock)) continue;
            out.add(field);
        }
        return this.getSmallestVolumeField(out);
    }

    public Field fieldConflicts(Block placedBlock, Player placer) {
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(placedBlock);
        if (fs == null) {
            return null;
        }
        if (fs.hasDefaultFlag(FieldFlag.NO_CONFLICT)) {
            return null;
        }
        Field placedField = new Field(placedBlock, fs.getRadius(), fs.getCustomHeight());
        Set<Field> intersecting = placedField.getIntersectingFields();
        ArrayList<Field> out = new ArrayList<Field>();
        for (Field field : intersecting) {
            if (field.hasFlag(FieldFlag.NO_CONFLICT) || this.isAllowed(field, placer.getName())) continue;
            out.add(field);
        }
        return this.getSmallestVolumeField(out);
    }

    public boolean existsConflict(Field mockField, Player placer) {
        if (mockField.hasFlag(FieldFlag.NO_CONFLICT)) {
            return false;
        }
        Set<Field> intersecting = mockField.getIntersectingFields();
        for (Field field : intersecting) {
            if (field.hasFlag(FieldFlag.NO_CONFLICT) || this.isAllowed(field, placer.getName())) continue;
            return true;
        }
        return false;
    }

    public Field fieldConflicts(CuboidEntry ce, Player placer) {
        if (ce.getField().hasFlag(FieldFlag.NO_CONFLICT)) {
            return null;
        }
        Set<Field> intersecting = ce.getField().getIntersectingFields();
        ArrayList<Field> out = new ArrayList<Field>();
        for (Field field : intersecting) {
            if (field.hasFlag(FieldFlag.NO_CONFLICT) || this.isAllowed(field, placer.getName())) continue;
            out.add(field);
        }
        return this.getSmallestVolumeField(out);
    }

    public void addAllowOverlappingOwners(Field field) {
        FieldSettings fs = field.getSettings();
        if (fs == null) {
            return;
        }
        if (fs.hasDefaultFlag(FieldFlag.NO_CONFLICT)) {
            return;
        }
        Set<Field> intersecting = field.getIntersectingFields();
        for (Field overlap : intersecting) {
            if (overlap.hasFlag(FieldFlag.NO_CONFLICT) || !overlap.isAllowed(field.getOwner())) continue;
            field.addAllowed(overlap.getOwner());
        }
    }

    public int deleteBelonging(String playerName) {
        int deletedFields = 0;
        List<Field> fields = this.getFieldsByOwner().get(playerName.toLowerCase());
        if (fields != null) {
            for (Field field : fields) {
                if (field.hasFlag(FieldFlag.NO_OWNER)) continue;
                this.queueRelease(field);
                ++deletedFields;
            }
        }
        this.flush();
        return deletedFields;
    }

    public int hideBelonging(String playerName) {
        int hiddenFields = 0;
        List<Field> fields = this.getFieldsByOwner().get(playerName.toLowerCase());
        if (fields != null) {
            for (Field field : fields) {
                if (!field.hasFlag(FieldFlag.HIDABLE) || field.getHidingModule().isHidden() || field.hasFlag(FieldFlag.NO_OWNER) || !field.matchesBlockType()) continue;
                field.getHidingModule().hide();
                ++hiddenFields;
            }
        }
        return hiddenFields;
    }

    public int unhideBelonging(String playerName) {
        int unhiddenFields = 0;
        List<Field> fields = this.getFieldsByOwner().get(playerName.toLowerCase());
        if (fields != null) {
            for (Field field : fields) {
                if (!field.hasFlag(FieldFlag.HIDABLE) || !field.getHidingModule().isHidden() || field.hasFlag(FieldFlag.NO_OWNER)) continue;
                field.getHidingModule().unHide();
                ++unhiddenFields;
            }
        }
        return unhiddenFields;
    }

    public void release(Block block) {
        Field field = this.getField(block);
        if (field != null) {
            this.release(field);
        }
    }

    public void release(Field field) {
        this.dropField(field);
        this.deleteField(field);
    }

    public void releaseWipe(Block block) {
        this.deleteField(this.getField(block));
        block.setType(Material.AIR);
    }

    public void releaseNoDrop(Field field) {
        this.deleteField(field);
    }

    public void queueRelease(Field field) {
        if (!this.deletionQueue.contains(field)) {
            this.deletionQueue.add(field);
        }
    }

    public void flush() {
        while (this.deletionQueue.size() > 0) {
            Field pending = this.deletionQueue.poll();
            this.dropField(pending);
            this.deleteField(pending);
        }
    }

    public void dropField(Field field) {
        this.dropFieldBlock(field.getBlock());
    }

    public void dropFieldBlock(Block block) {
        Field field = this.getField(block);
        field.getHidingModule().unHide();
        this.dropBlock(block, field.getTypeEntry(), field.getSettings());
    }

    public void dropBlock(Block block, BlockTypeEntry type, FieldSettings settings) {
        World world = block.getWorld();
        ItemStack is = new ItemStack(type.getTypeId(), 1, 0, Byte.valueOf(type.getData()));
        if (settings.hasMetaName()) {
            ItemMeta meta = is.getItemMeta();
            meta.setDisplayName(settings.getMetaName());
            meta.setLore(settings.getMetaLore());
            is.setItemMeta(meta);
        }
        block.setType(Material.AIR);
        if (this.plugin.getSettingsManager().isDropOnDelete()) {
            world.dropItemNaturally(block.getLocation(), is);
        }
    }

    public int deleteFields(List<Field> sourceFields) {
        int deletedCount = 0;
        for (Field f : sourceFields) {
            this.queueRelease(f);
            ++deletedCount;
        }
        if (deletedCount > 0) {
            this.flush();
        }
        return deletedCount;
    }

    public int deleteFieldsOfType(BlockTypeEntry type) {
        int deletedCount = 0;
        Collection<Field> fields = this.fieldsByVec.values();
        for (Field field : fields) {
            if (!field.getTypeEntry().equals(type)) continue;
            this.queueRelease(field);
            ++deletedCount;
        }
        if (deletedCount > 0) {
            this.flush();
        }
        return deletedCount;
    }

    public int deletePlayerFieldsOfType(String playerName, BlockTypeEntry type) {
        List<Field> fields;
        int deletedCount = 0;
        Map<BlockTypeEntry, List<Field>> types = this.fieldsByOwnerAndType.get(playerName.toLowerCase());
        if (types != null && (fields = types.get(type)) != null) {
            for (Field field : fields) {
                this.queueRelease(field);
                ++deletedCount;
            }
        }
        if (deletedCount > 0) {
            this.flush();
        }
        return deletedCount;
    }

    public boolean purchase(Player player, double amount) {
        if (this.plugin.getPermissionsManager().hasEconomy()) {
            if (!PermissionsManager.hasMoney(player, amount)) {
                ChatHelper.send((CommandSender)player, "economyNotEnoughMoney", new Object[0]);
                return false;
            }
        } else {
            return false;
        }
        this.plugin.getPermissionsManager().playerCharge(player, amount);
        return true;
    }

    public void refund(Player player, double amount) {
        if (this.plugin.getPermissionsManager().hasEconomy()) {
            this.plugin.getPermissionsManager().playerCredit(player, amount);
            ChatHelper.send((CommandSender)player, "economyAccountCredited", new Object[0]);
        }
    }

    public boolean fieldTouchesPlayers(Block block, Player self) {
        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(block);
        if (fs == null) {
            return false;
        }
        Field field = new Field(block, fs.getRadius(), fs.getCustomHeight());
        List players = block.getWorld().getPlayers();
        for (Player player : players) {
            if (player.equals(self) || this.isAllowed(field, player.getName()) || !field.envelops(player.getLocation())) continue;
            return true;
        }
        return false;
    }

    public Set<Player> getFieldInhabitants(Field field) {
        HashSet<Player> out = new HashSet<Player>();
        List players = field.getLocation().getWorld().getPlayers();
        for (Player player : players) {
            if (!field.envelops(player.getLocation())) continue;
            out.add(player);
        }
        return out;
    }

    public void changeOwner(Field field, String owner) {
        List<Field> fields = this.getFieldsByOwner().get(field.getOwner().toLowerCase());
        if (fields != null) {
            fields.remove(field);
            field.setNewOwner(owner);
            fields = this.getFieldsByOwner().get(owner.toLowerCase());
            if (fields == null) {
                fields = new ArrayList<Field>();
            }
            fields.add(field);
            this.getFieldsByOwner().put(owner.toLowerCase(), fields);
        }
    }

    public Field getDestinationField(String owner, Field sourceField) {
        ArrayList<Field> out = new ArrayList<Field>();
        List<Field> fields = this.getFieldsByOwner().get(owner.toLowerCase());
        if (fields != null) {
            for (Field field : fields) {
                if (field.equals(sourceField) || !field.hasFlag(FieldFlag.TELEPORT_DESTINATION) || !field.getName().equalsIgnoreCase(sourceField.getName())) continue;
                out.add(field);
            }
        }
        if (out.isEmpty()) {
            return null;
        }
        if (out.size() == 1) {
            return (Field)out.get(0);
        }
        return (Field)out.get(new Random().nextInt(out.size()));
    }

    public void disableFieldsOnLogoff(String name) {
        List<Field> fields = this.getFieldsByOwner().get(name.toLowerCase());
        if (fields != null) {
            for (Field field : fields) {
                if (!field.hasFlag(FieldFlag.DISABLE_ON_LOGOFF)) continue;
                List<String> allAllowed = field.getAllAllowed();
                boolean someoneOnline = false;
                for (String playerName : allAllowed) {
                    Player allowed = Bukkit.getServer().getPlayerExact(playerName);
                    if (allowed == null) continue;
                    someoneOnline = true;
                }
                if (someoneOnline) continue;
                field.setDisabled(true);
            }
        }
    }

    public void enableFieldsOnLogon(String name) {
        List<Field> fields = this.getFieldsByOwner().get(name.toLowerCase());
        if (fields != null) {
            for (Field field : fields) {
                if (!field.hasFlag(FieldFlag.ENABLE_ON_LOGON)) continue;
                List<String> allAllowed = field.getAllAllowed();
                boolean someoneOnline = false;
                for (String playerName : allAllowed) {
                    Player allowed = Bukkit.getServer().getPlayerExact(playerName);
                    if (allowed == null) continue;
                    someoneOnline = true;
                }
                if (someoneOnline) continue;
                field.setDisabled(false);
            }
        }
    }

    public int getFieldCount(String playerName, BlockTypeEntry type) {
        List<Field> fields;
        Map<BlockTypeEntry, List<Field>> types = this.fieldsByOwnerAndType.get(playerName.toLowerCase());
        if (types != null && (fields = types.get(type)) != null) {
            return fields.size();
        }
        return 0;
    }

    public int getTotalFieldCount(String playerName) {
        List<Field> fields = this.getFieldsByOwner().get(playerName.toLowerCase());
        if (fields != null) {
            return fields.size();
        }
        return 0;
    }

    public List<Field> getFieldsOwnedBy(String playerName, FieldFlag flag) {
        Map<FieldFlag, List<Field>> flags = this.fieldsByOwnerAndFlag.get(playerName);
        if (flags != null) {
            return flags.get((Object)flag);
        }
        return null;
    }

    public void removeFieldsIfNoPermission(String playerName) {
        List<Field> fields;
        Player player = Bukkit.getServer().getPlayer(playerName);
        if (player != null && (fields = this.getFieldsOwnedBy(playerName, FieldFlag.DELETE_IF_NO_PERMISSION)) != null) {
            int deletedCount = 0;
            for (Field field : fields) {
                String permission = field.getSettings().getDeleteIfNoPermission();
                if (permission.isEmpty() || this.plugin.getPermissionsManager().has(player, permission)) continue;
                this.queueRelease(field);
                ++deletedCount;
            }
            if (deletedCount > 0) {
                this.flush();
                PreciousStones.log("logDeletedNoPermission", deletedCount, playerName);
            }
        }
    }

    public List<Field> getPlayerFields(String playerName, FieldFlag flag) {
        Map<FieldFlag, List<Field>> fields = this.fieldsByOwnerAndFlag.get(playerName);
        if (fields == null) {
            return null;
        }
        return fields.get((Object)flag);
    }

    public void migrateUsername(String oldName, String newName) {
        List<Field> fields = this.getFieldsByOwner().get(oldName.toLowerCase());
        for (Field field : fields) {
            field.setOwner(newName);
            PreciousStones.getInstance().getStorageManager().offerField(field);
        }
    }

    public Map<String, List<Field>> getFieldsByOwner() {
        return this.fieldsByOwner;
    }

    public void giveField(Player player, FieldSettings settings, int count) {
        ItemStack is = new ItemStack(settings.getTypeId(), count, 0, Byte.valueOf(settings.getData()));
        if (settings.hasMetaName()) {
            ItemMeta meta = is.getItemMeta();
            meta.setDisplayName(settings.getMetaName());
            meta.setLore(settings.getMetaLore());
            is.setItemMeta(meta);
        }
        player.getInventory().addItem(new ItemStack[]{is});
    }
}

