/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.HashMap;
import java.util.Queue;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.Rollback;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.GriefBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.plugin.Plugin;

public final class GriefUndoManager {
    private PreciousStones plugin;
    private HashMap<Field, Integer> intervalFields = new HashMap();

    public GriefUndoManager() {
        this.plugin = PreciousStones.getInstance();
    }

    public void register(Field field) {
        int taskId;
        if (field.getRevertingModule().getRevertSecs() == 0) {
            return;
        }
        if (this.intervalFields.containsKey(field)) {
            taskId = this.intervalFields.get(field);
            Bukkit.getScheduler().cancelTask(taskId);
        }
        taskId = this.startInterval(field);
        this.intervalFields.put(field, taskId);
    }

    public void remove(Field field) {
        this.intervalFields.remove(field);
    }

    public void addBlock(Field field, BlockState state) {
        GriefBlock gb = new GriefBlock(state);
        field.getRevertingModule().addGriefBlock(gb);
    }

    public void addBlock(Field field, Block block, boolean clear) {
        if (!this.plugin.getSettingsManager().isDependentBlock(block.getTypeId())) {
            BlockFace[] faces;
            PreciousStones.debug("not depenedent", new Object[0]);
            for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
                Block rel = block.getRelative(face);
                if (!this.plugin.getSettingsManager().isDependentBlock(rel.getTypeId())) continue;
                this.addBlock(field, rel, clear);
                PreciousStones.debug("+found dependent", new Object[0]);
            }
        }
        if (block.getTypeId() == 64 || block.getTypeId() == 71 || block.getTypeId() == 330) {
            field.getRevertingModule().addGriefBlock(new GriefBlock(block));
            Block bottom = block.getRelative(BlockFace.DOWN);
            Block top = block.getRelative(BlockFace.UP);
            if (bottom.getTypeId() == 64 || bottom.getTypeId() == 71 || bottom.getTypeId() == 330) {
                field.getRevertingModule().addGriefBlock(new GriefBlock(bottom));
                if (clear) {
                    bottom.setTypeId(0);
                    block.setTypeId(0);
                }
            }
            if (top.getTypeId() == 64 || top.getTypeId() == 71 || top.getTypeId() == 330) {
                field.getRevertingModule().addGriefBlock(new GriefBlock(top));
                if (clear) {
                    top.setTypeId(0);
                    block.setTypeId(0);
                }
            }
            return;
        }
        if (block.getState() instanceof Sign) {
            field.getRevertingModule().addGriefBlock(this.handleSign(block));
        } else {
            PreciousStones.debug("added grief to field", new Object[0]);
            field.getRevertingModule().addGriefBlock(new GriefBlock(block));
        }
        if (clear) {
            block.setTypeId(0);
        }
    }

    private GriefBlock handleSign(Block block) {
        GriefBlock gb = new GriefBlock(block);
        String signText = "";
        Sign sign = (Sign)block.getState();
        for (String line : sign.getLines()) {
            signText = signText + line + "`";
        }
        signText = Helper.stripTrailing(signText, "`");
        gb.setSignText(signText);
        return gb;
    }

    public int undoGrief(Field field) {
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world != null) {
            PreciousStones.debug("Retrieving block grief", new Object[0]);
            Queue<GriefBlock> gbs = this.plugin.getStorageManager().retrieveBlockGrief(field);
            if (!gbs.isEmpty()) {
                PreciousStones.debug("Rolling back %s griefed blocks", gbs.size());
                this.plugin.getCommunicationManager().notifyRollBack(field, gbs.size());
                Rollback rollback = new Rollback(gbs, world, field);
            }
            return gbs.size();
        }
        return 0;
    }

    public int undoDirtyGrief(Field field) {
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world != null) {
            PreciousStones.debug("Retrieving dirty grief", new Object[0]);
            Queue<GriefBlock> gbs = field.getRevertingModule().getGrief();
            if (!gbs.isEmpty()) {
                PreciousStones.debug("Rolling back %s dirty griefed blocks", gbs.size());
                this.plugin.getCommunicationManager().notifyRollBack(field, gbs.size());
                Rollback rollback = new Rollback(gbs, world, field);
            }
            return gbs.size();
        }
        return 0;
    }

    public void undoGriefBlock(GriefBlock gb, World world) {
        int[] seeThrough;
        if (gb == null) {
            return;
        }
        Block block = world.getBlockAt(gb.getX(), gb.getY(), gb.getZ());
        if (block == null) {
            return;
        }
        if (gb.isEmpty()) {
            block.setTypeIdAndData(gb.getTypeId(), gb.getData(), true);
            return;
        }
        boolean noConflict = false;
        block0: for (int st : seeThrough = new int[]{0, 6, 8, 31, 32, 37, 38, 39, 40, 9, 10, 11, 12, 51, 59, 83, 81}) {
            if (block.getTypeId() != st) continue;
            noConflict = true;
            if (st != 12) break;
            for (int count = 1; count < 256; ++count) {
                int type = world.getBlockTypeIdAt(gb.getX(), gb.getY() + count, gb.getZ());
                if (type != 0 && type != 8 && type != 9 && type != 10 && type != 11) continue;
                Block toSand = world.getBlockAt(gb.getX(), gb.getY() + count, gb.getZ());
                toSand.setTypeId(12, false);
                break block0;
            }
            break;
        }
        if (noConflict) {
            block.setTypeIdAndData(gb.getTypeId(), gb.getData(), true);
            if (block.getState() instanceof Sign && gb.getSignText().length() > 0) {
                Sign sign = (Sign)block.getState();
                String[] lines = gb.getSignText().split("[`]");
                for (int i = 0; i < lines.length; ++i) {
                    sign.setLine(i, lines[i]);
                    sign.update();
                }
            }
        }
    }

    private int startInterval(final Field field) {
        return Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                GriefUndoManager.this.undoGrief(field);
            }
        }, (long)field.getRevertingModule().getRevertSecs() * 20L, (long)field.getRevertingModule().getRevertSecs() * 20L);
    }
}

