/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.ArrayList;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.RelativeBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.TeleportEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.PermissionsManager;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TeleportationManager {
    private PreciousStones plugin = PreciousStones.getInstance();

    public boolean teleport(Entity entity, Field sourceField) {
        return this.teleport(entity, sourceField, "");
    }

    public boolean teleport(Entity entity, Field sourceField, String announce) {
        Field destinationField = this.plugin.getForceFieldManager().getDestinationField(sourceField.getOwner(), sourceField);
        if (destinationField != null) {
            if (sourceField.getSettings().getTeleportMaxDistance() > 0 && sourceField.getLocation().distance(destinationField.getLocation()) > (double)sourceField.getSettings().getTeleportMaxDistance()) {
                Player player = Bukkit.getServer().getPlayerExact(sourceField.getOwner());
                if (player != null) {
                    ChatHelper.send((CommandSender)player, "teleportMaxDistance", sourceField.getSettings().getTeleportMaxDistance());
                }
                return false;
            }
            if (sourceField.getSettings().getTeleportCost() > 0 && this.plugin.getPermissionsManager().hasEconomy()) {
                if (PermissionsManager.hasMoney(Bukkit.getServer().getPlayerExact(sourceField.getOwner()), (double)sourceField.getSettings().getTeleportCost())) {
                    this.plugin.getPermissionsManager().playerCharge(Bukkit.getServer().getPlayerExact(sourceField.getOwner()), (double)sourceField.getSettings().getTeleportCost());
                } else {
                    Player player = Bukkit.getServer().getPlayerExact(sourceField.getOwner());
                    if (player != null) {
                        ChatHelper.send((CommandSender)player, "economyNotEnoughMoney", new Object[0]);
                    }
                    return false;
                }
            }
            if (sourceField.hasFlag(FieldFlag.TELEPORT_RELATIVELY)) {
                return this.plugin.getTeleportationManager().teleport(new TeleportEntry(entity, new RelativeBlock(sourceField.toVec(), new Vec(entity.getLocation())), sourceField, destinationField, announce));
            }
            return this.plugin.getTeleportationManager().teleport(new TeleportEntry(entity, sourceField, destinationField, announce));
        }
        return false;
    }

    public boolean teleport(TeleportEntry entry) {
        ArrayList<TeleportEntry> entries = new ArrayList<TeleportEntry>();
        entries.add(entry);
        return this.teleport(entries);
    }

    public boolean teleport(List<TeleportEntry> entries) {
        for (TeleportEntry entry : entries) {
            Entity entity = entry.getEntity();
            Location destination = entry.getDestination();
            Field sourceField = entry.getSourceField();
            Vec currentPosition = null;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.plugin.getPlayerManager().getPlayerEntry(player.getName()).setTeleporting(false);
                if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.teleport") || sourceField.hasFlag(FieldFlag.SNEAKING_BYPASS) && !sourceField.hasFlag(FieldFlag.TELEPORT_ON_SNEAK) && player.isSneaking()) continue;
                currentPosition = new Vec(player.getLocation());
            }
            World world = destination.getWorld();
            Vec safe = this.findSafeLocation(destination);
            double x = (double)safe.getX() + 0.5;
            double y = safe.getY();
            double z = (double)safe.getZ() + 0.5;
            if (y == -1.0) continue;
            if (!world.isChunkLoaded(destination.getBlockX() >> 4, destination.getBlockZ() >> 4)) {
                world.loadChunk(destination.getBlockX() >> 4, destination.getBlockZ() >> 4);
            }
            Location loc = new Location(world, x, y, z, entity.getLocation().getYaw(), entity.getLocation().getPitch());
            if (sourceField.hasFlag(FieldFlag.TELEPORT_EXPLOSION_EFFECT)) {
                world.createExplosion(entity.getLocation(), -1.0f);
            }
            entity.teleport(loc);
            if (sourceField.hasFlag(FieldFlag.TELEPORT_EXPLOSION_EFFECT)) {
                world.createExplosion(loc, -1.0f);
            }
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (sourceField.hasFlag(FieldFlag.TELEPORT_ANNOUNCE) && !entry.getAnnounce().isEmpty()) {
                ChatHelper.send((CommandSender)player, entry.getAnnounce(), new Object[0]);
            }
            if (sourceField.getSettings().getTeleportBackAfterSeconds() <= 0) continue;
            if (sourceField.hasFlag(FieldFlag.TELEPORT_ANNOUNCE)) {
                ChatHelper.send((CommandSender)player, "teleportAnnounceBack", sourceField.getSettings().getTeleportBackAfterSeconds());
            }
            PlayerEntry playerEntry = this.plugin.getPlayerManager().getPlayerEntry(player.getName());
            playerEntry.setTeleportSecondsRemaining(sourceField.getSettings().getTeleportBackAfterSeconds());
            playerEntry.setTeleportVec(currentPosition);
            playerEntry.startTeleportCountDown();
            this.plugin.getStorageManager().offerPlayer(player.getName());
        }
        return true;
    }

    public void teleportAway(Player player) {
        Location destination = player.getLocation();
        World world = destination.getWorld();
        Vec safe = this.findSafeLocation(destination);
        double x = (double)safe.getX() + 0.5;
        double y = safe.getY();
        double z = (double)safe.getZ() + 0.5;
        if (y == -1.0) {
            return;
        }
        if (!world.isChunkLoaded(destination.getBlockX() >> 4, destination.getBlockZ() >> 4)) {
            world.loadChunk(destination.getBlockX() >> 4, destination.getBlockZ() >> 4);
        }
        Location loc = new Location(world, x, y, z, destination.getYaw(), destination.getPitch());
        player.teleport(loc);
    }

    private Vec findSafeLocation(Location dest) {
        Vec d = new Vec(dest);
        if (this.blockIsSafe(d)) {
            return d;
        }
        if (this.blockIsSafe(d.add(0, 1, 0))) {
            return d.add(0, 1, 0);
        }
        if (this.blockIsSafe(d.add(0, 2, 0))) {
            return d.add(0, 2, 0);
        }
        if (this.blockIsSafe(d.add(1, 0, 0))) {
            return d.add(1, 0, 0);
        }
        if (this.blockIsSafe(d.add(-1, 0, 0))) {
            return d.add(-1, 0, 0);
        }
        if (this.blockIsSafe(d.add(0, 0, 1))) {
            return d.add(0, 0, 1);
        }
        if (this.blockIsSafe(d.add(0, 0, -1))) {
            return d.add(0, 0, -1);
        }
        if (this.blockIsSafe(d.add(1, 0, 1))) {
            return d.add(1, 0, 1);
        }
        if (this.blockIsSafe(d.add(-1, 0, 1))) {
            return d.add(-1, 0, 1);
        }
        if (this.blockIsSafe(d.add(1, 0, -1))) {
            return d.add(1, 0, -1);
        }
        if (this.blockIsSafe(d.add(-1, 0, -1))) {
            return d.add(-1, 0, -1);
        }
        return new Vec(d.getX(), this.findSafeHeight(dest), d.getZ(), d.getWorld());
    }

    private int findSafeHeight(Location dest) {
        int y = dest.getBlockY();
        while (!this.blockIsSafe(dest.getWorld(), dest.getBlockX(), y, dest.getBlockZ())) {
            if (++y < 255) continue;
            return -1;
        }
        return y;
    }

    private boolean blockIsSafe(Vec vec) {
        return this.blockIsSafe(vec.toWorld(), vec.getX(), vec.getY(), vec.getZ());
    }

    private boolean blockIsSafe(World world, int x, int y, int z) {
        int head = world.getBlockTypeIdAt(x, y + 1, z);
        int feet = world.getBlockTypeIdAt(x, y, z);
        return this.plugin.getSettingsManager().isThroughType(head) && this.plugin.getSettingsManager().isThroughType(feet);
    }
}

