/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.modules;

import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.FieldSign;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PurchaseEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.StackHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.PermissionsManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BuyingModule {
    /*
     * Enabled aggressive block sorting
     */
    public boolean buy(Player buyer, FieldSign s) {
        Field field = s.getField();
        PurchaseEntry purchase = new PurchaseEntry(buyer.getName(), field.getOwner(), field.getName(), field.getCoords(), s.getItem(), s.getPrice());
        if (s.getItem() == null) {
            if (!PreciousStones.getInstance().getPermissionsManager().hasEconomy()) return true;
            if (PermissionsManager.hasMoney(buyer, (double)s.getPrice())) {
                PreciousStones.getInstance().getPermissionsManager().playerCharge(buyer, (double)s.getPrice());
                this.processPurchase(purchase, s);
                return true;
            }
            ChatHelper.send((CommandSender)buyer, "economyNotEnoughMoney", new Object[0]);
            return false;
        }
        if (StackHelper.hasItems(buyer, s.getItem(), s.getPrice())) {
            StackHelper.remove(buyer, s.getItem(), s.getPrice());
            this.processPurchase(purchase, s);
            return true;
        }
        ChatHelper.send((CommandSender)buyer, "economyNotEnoughItems", new Object[0]);
        return false;
    }

    public void processPurchase(PurchaseEntry purchase, FieldSign s) {
        Field field = s.getField();
        field.setOwner(purchase.getBuyer());
        field.clearAllowed();
        Player owner = PreciousStones.getInstance().getServer().getPlayerExact(purchase.getOwner());
        if (owner != null) {
            this.giveMoney(owner, purchase);
        } else {
            PreciousStones.getInstance().getStorageManager().insertPendingPurchasePayment(purchase);
        }
        PreciousStones.getInstance().getCommunicationManager().logPurchase(s.getField().getOwner(), purchase.getBuyer(), purchase, s);
        s.eject();
    }

    public void giveMoney(Player owner, PurchaseEntry purchase) {
        if (purchase.isItemPayment()) {
            StackHelper.give(owner, purchase.getItem(), purchase.getAmount());
            if (purchase.getFieldName().isEmpty()) {
                ChatHelper.send((CommandSender)owner, "fieldSignItemPaymentReceivedNoName", purchase.getAmount(), purchase.getItem(), purchase.getBuyer(), purchase.getCoords());
            } else {
                ChatHelper.send((CommandSender)owner, "fieldSignItemPaymentReceived", purchase.getAmount(), purchase.getItem(), purchase.getBuyer(), purchase.getFieldName(), purchase.getCoords());
            }
        } else {
            PreciousStones.getInstance().getPermissionsManager().playerCredit(owner, purchase.getAmount());
            if (purchase.getFieldName().isEmpty()) {
                ChatHelper.send((CommandSender)owner, "fieldSignPaymentReceivedNoName", purchase.getAmount(), purchase.getBuyer(), purchase.getCoords());
            } else {
                ChatHelper.send((CommandSender)owner, "fieldSignPaymentReceived", purchase.getAmount(), purchase.getBuyer(), purchase.getFieldName(), purchase.getCoords());
            }
        }
        PreciousStones.getInstance().getCommunicationManager().logPurchaseCollect(purchase.getOwner(), purchase.getBuyer(), purchase);
    }
}

