/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.modules;

import java.util.ArrayList;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.block.Block;

public class HidingModule {
    private Field field;
    private boolean hidden;

    public HidingModule(Field field) {
        this.field = field;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void hide() {
        if (!this.field.hasFlag(FieldFlag.HIDABLE)) {
            return;
        }
        if (!this.isHidden()) {
            this.hidden = true;
            this.field.getFlagsModule().dirtyFlags("hide");
            BlockTypeEntry maskType = this.findMaskType();
            Block block = this.field.getBlock();
            block.setTypeId(maskType.getTypeId());
            block.setData(maskType.getData());
        }
        if (this.field.isParent()) {
            for (Field child : this.field.getChildren()) {
                if (child.getHidingModule().isHidden()) continue;
                child.getHidingModule().hide();
            }
        }
        if (this.field.isChild() && !this.field.getParent().getHidingModule().isHidden()) {
            this.field.getParent().getHidingModule().hide();
        }
    }

    public void unHide() {
        if (!this.field.hasFlag(FieldFlag.HIDABLE)) {
            return;
        }
        if (this.isHidden()) {
            this.hidden = false;
            this.field.getFlagsModule().dirtyFlags("unHide");
            Block block = this.field.getBlock();
            block.setTypeId(this.field.getTypeId());
            block.setData((byte)this.field.getData());
        }
        if (this.field.isParent()) {
            for (Field child : this.field.getChildren()) {
                if (!child.getHidingModule().isHidden()) continue;
                child.getHidingModule().unHide();
            }
        }
        if (this.field.isChild() && this.field.getParent().getHidingModule().isHidden()) {
            this.field.getParent().getHidingModule().unHide();
        }
    }

    private BlockTypeEntry findMaskType() {
        ArrayList<Vec> vecs = new ArrayList<Vec>();
        Vec center = new Vec(this.field.getBlock());
        vecs.add(center.add(1, 0, 0));
        vecs.add(center.add(-1, 0, 0));
        vecs.add(center.add(0, 0, 1));
        vecs.add(center.add(0, 0, -1));
        vecs.add(center.add(-1, -1, 0));
        vecs.add(center.add(0, -1, 1));
        vecs.add(center.add(0, 1, 0));
        for (Vec vec : vecs) {
            Block relative = vec.getBlock();
            if (relative.getTypeId() == 0) continue;
            BlockTypeEntry entry = new BlockTypeEntry(relative);
            if (!PreciousStones.getInstance().getSettingsManager().isHidingMaskType(entry)) continue;
            return entry;
        }
        return PreciousStones.getInstance().getSettingsManager().getFirstHidingMask();
    }
}

