/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.FieldSign;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PaymentEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.RentEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.SignHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.StackHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.managers.PermissionsManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RentingModule {
    private Field field;
    private List<RentEntry> renterEntries = new ArrayList<RentEntry>();
    private List<PaymentEntry> payment = new ArrayList<PaymentEntry>();
    private List<String> renters = new ArrayList<String>();
    private boolean signIsClean;
    private int limitSeconds;

    public RentingModule(Field field) {
        this.field = field;
    }

    public List<String> getRenters() {
        return Collections.unmodifiableList(this.renters);
    }

    public void addRenter(RentEntry entry) {
        this.renterEntries.add(entry);
        this.renters.add(entry.getPlayerName().toLowerCase());
    }

    public boolean hasRenter(String playerName) {
        return this.renters.contains(playerName.toLowerCase());
    }

    public boolean hasRenters() {
        return !this.renters.isEmpty();
    }

    public void clearRenters() {
        this.renterEntries.clear();
        this.renters.clear();
    }

    public void addPayment(PaymentEntry entry) {
        this.payment.add(entry);
    }

    public boolean hasLimitSeconds() {
        return this.limitSeconds > 0;
    }

    public int getLimitSeconds() {
        return this.limitSeconds;
    }

    public void setLimitSeconds(int limitSeconds) {
        this.limitSeconds = limitSeconds;
        this.field.getFlagsModule().dirtyFlags("setLimitSeconds");
    }

    public ArrayList<String> getRentersString() {
        ArrayList<String> ll = new ArrayList<String>();
        for (RentEntry entry : this.renterEntries) {
            ll.add(entry.serialize());
        }
        return ll;
    }

    public ArrayList<String> getPaymentString() {
        ArrayList<String> ll = new ArrayList<String>();
        for (PaymentEntry entry : this.payment) {
            ll.add(entry.toString());
        }
        return ll;
    }

    public RentEntry getRenter(Player player) {
        for (RentEntry entry : this.renterEntries) {
            if (!entry.getPlayerName().equals(player.getName())) continue;
            return entry;
        }
        return null;
    }

    public void addRent(Player player) {
        FieldSign s = this.field.getAttachedFieldSign();
        if (s != null) {
            int seconds = SignHelper.periodToSeconds(s.getPeriod());
            if (seconds == 0) {
                ChatHelper.send((CommandSender)player, "fieldSignRentError", new Object[0]);
                return;
            }
            RentEntry renter = this.getRenter(player);
            if (renter != null) {
                renter.addSeconds(seconds);
                ChatHelper.send((CommandSender)player, "fieldSignRentRented", SignHelper.secondsToPeriods(renter.getPeriodSeconds()));
            } else {
                this.renterEntries.add(new RentEntry(player.getName(), seconds));
                this.renters.add(player.getName().toLowerCase());
                if (this.renterEntries.size() == 1) {
                    this.scheduleNextRentUpdate();
                }
                ChatHelper.send((CommandSender)player, "fieldSignRentRented", s.getPeriod());
                PreciousStones.getInstance().getEntryManager().leaveField(player, this.field);
                PreciousStones.getInstance().getEntryManager().enterField(player, this.field);
            }
            this.field.getFlagsModule().dirtyFlags("addRent");
        }
    }

    public void removeRenter(RentEntry entry) {
        this.renterEntries.remove(entry);
        this.renters.remove(entry.getPlayerName().toLowerCase());
        this.field.getFlagsModule().dirtyFlags("removeRenter");
    }

    public boolean clearRents() {
        if (this.hasRenters()) {
            this.renterEntries.clear();
            this.renters.clear();
            this.cleanFieldSign();
            this.field.getFlagsModule().dirtyFlags("clearRents");
            return true;
        }
        return false;
    }

    public boolean removeRents() {
        FieldSign s = this.field.getAttachedFieldSign();
        if (s != null) {
            s.eject();
            this.renterEntries.clear();
            this.renters.clear();
            this.payment.clear();
            this.field.getFlagsModule().dirtyFlags("removeRents");
            return true;
        }
        return false;
    }

    public List<RentEntry> getRenterEntries() {
        return Collections.unmodifiableList(this.renterEntries);
    }

    public void abandonRent(Player player) {
        for (RentEntry entry : this.renterEntries) {
            if (!entry.getPlayerName().equals(player.getName())) continue;
            this.removeRenter(entry);
            this.cleanFieldSign();
            return;
        }
    }

    public void cleanFieldSign() {
        FieldSign s;
        if (!this.hasRenters() && (s = this.field.getAttachedFieldSign()) != null) {
            s.setAvailableColor();
            s.cleanRemainingTime();
        }
    }

    public void addPayment(String playerName, String fieldName, BlockTypeEntry item, int amount) {
        boolean added = false;
        for (PaymentEntry entry : this.payment) {
            if (!entry.getPlayer().equals(playerName) || item != null && !entry.getItem().equals(item)) continue;
            entry.setAmount(entry.getAmount() + amount);
            added = true;
        }
        if (!added) {
            this.payment.add(new PaymentEntry(playerName, fieldName, item, amount));
        }
        this.field.getFlagsModule().dirtyFlags("addPayment");
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean rent(Player player, FieldSign s) {
        if (this.getLimitSeconds() > 0) {
            PreciousStones.debug("field has rent limits in place: " + this.getLimitSeconds(), new Object[0]);
            RentEntry renter = this.getRenter(player);
            if (renter != null) {
                int seconds = SignHelper.periodToSeconds(s.getPeriod());
                if (renter.getPeriodSeconds() + seconds > this.getLimitSeconds()) {
                    PreciousStones.debug("limit reached", new Object[0]);
                    ChatHelper.send((CommandSender)player, "limitReached", new Object[0]);
                    return false;
                }
            }
        }
        if (s.getItem() != null) {
            PreciousStones.debug("is item rent", new Object[0]);
            if (!StackHelper.hasItems(player, s.getItem(), s.getPrice())) {
                ChatHelper.send((CommandSender)player, "economyNotEnoughItems", new Object[0]);
                return false;
            }
            StackHelper.remove(player, s.getItem(), s.getPrice());
            this.addPayment(player.getName(), s.getField().getName(), s.getItem(), s.getPrice());
            this.addRent(player);
            PreciousStones.getInstance().getCommunicationManager().logPayment(this.field.getOwner(), player.getName(), s);
        } else if (PreciousStones.getInstance().getPermissionsManager().hasEconomy()) {
            if (!PermissionsManager.hasMoney(player, (double)s.getPrice())) {
                ChatHelper.send((CommandSender)player, "economyNotEnoughMoney", new Object[0]);
                return false;
            }
            PreciousStones.getInstance().getPermissionsManager().playerCharge(player, (double)s.getPrice());
            this.addPayment(player.getName(), s.getField().getName(), null, s.getPrice());
            this.addRent(player);
            PreciousStones.getInstance().getCommunicationManager().logPayment(this.field.getOwner(), player.getName(), s);
        }
        if (s.isShareable()) {
            s.setSharedColor();
            return true;
        }
        if (!s.isRentable()) return true;
        s.setRentedColor();
        return true;
    }

    public boolean hasPendingPayments() {
        return !this.payment.isEmpty();
    }

    public void takePayment(Player player) {
        for (PaymentEntry entry : this.payment) {
            if (entry.isItemPayment()) {
                StackHelper.give(player, entry.getItem(), entry.getAmount());
                if (entry.getFieldName().isEmpty()) {
                    ChatHelper.send((CommandSender)player, "fieldSignItemPaymentReceivedNoName", entry.getAmount(), entry.getItem(), entry.getPlayer());
                    continue;
                }
                ChatHelper.send((CommandSender)player, "fieldSignItemPaymentReceived", entry.getAmount(), entry.getItem(), entry.getPlayer(), entry.getFieldName());
                continue;
            }
            PreciousStones.getInstance().getPermissionsManager().playerCredit(player, entry.getAmount());
            if (entry.getFieldName().isEmpty()) {
                ChatHelper.send((CommandSender)player, "fieldSignPaymentReceivedNoName", entry.getAmount(), entry.getPlayer());
                continue;
            }
            ChatHelper.send((CommandSender)player, "fieldSignPaymentReceived", entry.getAmount(), entry.getPlayer(), entry.getFieldName());
        }
        PreciousStones.getInstance().getCommunicationManager().logPaymentCollect(this.field.getOwner(), player.getName(), this.field.getAttachedFieldSign());
        this.payment.clear();
        this.field.getFlagsModule().dirtyFlags("takePayment");
    }

    public void scheduleNextRentUpdate() {
        if (!this.renterEntries.isEmpty()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)PreciousStones.getInstance(), (Runnable)new Update(), 20L);
        }
    }

    private class Update
    implements Runnable {
        private Update() {
        }

        @Override
        public void run() {
            FieldSign s;
            if (RentingModule.this.hasRenters() && (s = RentingModule.this.field.getAttachedFieldSign()) != null && (s.isRentable() || s.isShareable())) {
                boolean foundSomeone = false;
                if (PreciousStones.getInstance().getEntryManager().hasInhabitants(RentingModule.this.field)) {
                    Player closest = Helper.getClosestPlayer(RentingModule.this.field.getLocation(), 64);
                    for (RentEntry entry : RentingModule.this.renterEntries) {
                        if (!entry.getPlayerName().equalsIgnoreCase(closest.getName())) continue;
                        s.updateRemainingTime(entry.remainingRent());
                        foundSomeone = true;
                        RentingModule.this.signIsClean = false;
                    }
                }
                if (!foundSomeone && !RentingModule.this.signIsClean) {
                    s.cleanRemainingTime();
                    RentingModule.this.signIsClean = true;
                }
            }
            Iterator iter = RentingModule.this.renterEntries.iterator();
            while (iter.hasNext()) {
                RentEntry entry = (RentEntry)iter.next();
                if (!entry.isDone()) continue;
                RentingModule.this.renters.remove(entry.getPlayerName().toLowerCase());
                iter.remove();
                RentingModule.this.field.getFlagsModule().dirtyFlags("RentUpdateRunnable");
                if (RentingModule.this.field.getName().isEmpty()) {
                    ChatHelper.send(entry.getPlayerName(), "fieldSignRentExpiredNoName", new Object[0]);
                    continue;
                }
                ChatHelper.send(entry.getPlayerName(), "fieldSignRentExpired", RentingModule.this.field.getName());
            }
            RentingModule.this.scheduleNextRentUpdate();
        }
    }
}

