/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.translocation;

import java.util.LinkedList;
import java.util.Queue;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.TranslocationBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class TranslocationUpdater
implements Runnable {
    private PreciousStones plugin;
    private Queue<TranslocationBlock> translocationQueue = new LinkedList<TranslocationBlock>();
    private Queue<TranslocationBlock> dependentQueue = new LinkedList<TranslocationBlock>();
    private Queue<TranslocationBlock> clearDependentQueue = new LinkedList<TranslocationBlock>();
    private final int timerID;
    private final World world;
    private final Field field;

    public TranslocationUpdater(Field field, Queue<TranslocationBlock> translocationQueue, World world) {
        this.plugin = PreciousStones.getInstance();
        for (TranslocationBlock tb : translocationQueue) {
            if (tb == null) continue;
            if (this.plugin.getSettingsManager().isDependentBlock(tb.getTypeId())) {
                this.dependentQueue.add(tb);
                continue;
            }
            this.translocationQueue.add(tb);
        }
        this.field = field;
        this.world = world;
        field.getTranslocatingModule().setTranslocating(true);
        this.timerID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 5L, 5L);
    }

    @Override
    public void run() {
        boolean cleared;
        TranslocationBlock tb;
        int i;
        for (i = 0; i < 500 && !this.dependentQueue.isEmpty(); ++i) {
            tb = this.dependentQueue.poll();
            cleared = this.plugin.getTranslocationManager().updateTranslationBlock(this.field, tb, false);
            if (cleared) {
                this.clearDependentQueue.add(tb);
                continue;
            }
            this.plugin.getStorageManager().deleteTranslocation(this.field, tb);
        }
        if (this.dependentQueue.isEmpty()) {
            while (i < 500 && !this.clearDependentQueue.isEmpty()) {
                tb = this.clearDependentQueue.poll();
                this.plugin.getTranslocationManager().zeroOutBlock(tb);
                ++i;
            }
            if (this.clearDependentQueue.isEmpty()) {
                while (i < 500 && !this.translocationQueue.isEmpty()) {
                    tb = this.translocationQueue.poll();
                    cleared = this.plugin.getTranslocationManager().updateTranslationBlock(this.field, tb, true);
                    if (!cleared) {
                        this.plugin.getStorageManager().deleteTranslocation(this.field, tb);
                    }
                    ++i;
                }
                if (!this.translocationQueue.iterator().hasNext()) {
                    Bukkit.getServer().getScheduler().cancelTask(this.timerID);
                    this.field.setDisabled(true);
                    this.field.getTranslocatingModule().setTranslocating(false);
                    this.field.getFlagsModule().dirtyFlags("TranslocationUpdater");
                }
            }
        }
    }
}

