/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sacredlabyrinth.Phaed.PreciousStones.DirtyFieldReason;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.ResultsFilter;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.CuboidEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.FieldSign;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.ForesterEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.SignHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.StackHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.BuyingModule;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.FencingModule;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.FlagsModule;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.ForestingModule;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.HidingModule;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.ListingModule;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.MaskingModule;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.RentingModule;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.RevertingModule;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.SnitchingModule;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.TranslocatingModule;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.AbstractVec;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.ChunkVec;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WaterMob;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import ps.org.joda.time.DateTime;
import ps.org.joda.time.Days;

public class Field
extends AbstractVec
implements Comparable<Field> {
    private FieldSettings settings;
    private long id = 0L;
    private int radius;
    private int height;
    private int maxx;
    private int maxy;
    private int maxz;
    private int minx;
    private int miny;
    private float velocity;
    private int minz;
    private BlockTypeEntry type;
    private String owner;
    private String newOwner;
    private String name;
    private Field parent;
    private List<Field> children = new ArrayList<Field>();
    private Set<String> allowed = new HashSet<String>();
    private Set<DirtyFieldReason> dirty = new HashSet<DirtyFieldReason>();
    private long lastUsed;
    private boolean progress;
    private boolean open;
    private boolean disabled;
    private int disablerId;
    private FlagsModule flags = new FlagsModule(this);
    private BuyingModule buying = new BuyingModule();
    private RentingModule renting = new RentingModule(this);
    private MaskingModule masking = new MaskingModule(this);
    private HidingModule hiding = new HidingModule(this);
    private ForestingModule foresting = new ForestingModule(this);
    private TranslocatingModule translocating = new TranslocatingModule(this);
    private RevertingModule reverting = new RevertingModule(this);
    private ListingModule listing = new ListingModule(this);
    private SnitchingModule snitching = new SnitchingModule(this);
    private FencingModule fencing = new FencingModule(this);

    public Field(int x, int y, int z, int minx, int miny, int minz, int maxx, int maxy, int maxz, float velocity, String world, BlockTypeEntry type, String owner, String name, long lastUsed) {
        super(x, y, z, world);
        this.minx = minx;
        this.miny = miny;
        this.minz = minz;
        this.maxx = maxx;
        this.maxy = maxy;
        this.maxz = maxz;
        this.radius = Helper.getWidthFromCoords(x, minx);
        this.height = 0;
        this.velocity = velocity;
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.lastUsed = lastUsed;
    }

    public Field(int x, int y, int z, int radius, int height, float velocity, String world, BlockTypeEntry type, String owner, String name, long lastUsed) {
        super(x, y, z, world);
        this.radius = radius;
        this.height = height;
        this.velocity = velocity;
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.lastUsed = lastUsed;
        this.calculateDimensions();
    }

    public Field(Block block, int radius, int height, String owner) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
        this.radius = radius;
        this.height = height;
        this.owner = owner;
        this.name = "";
        this.type = new BlockTypeEntry(block.getTypeId(), block.getData());
        this.calculateDimensions();
    }

    public Field(Block block, int radius, int height) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
        this.radius = radius;
        this.height = height;
        this.name = "";
        this.owner = "";
        this.type = new BlockTypeEntry(block.getTypeId(), block.getData());
        this.calculateDimensions();
    }

    public Field(Block block) {
        super(block.getX(), block.getY(), block.getZ(), block.getWorld().getName());
    }

    private void calculateDimensions() {
        this.minx = this.getX() - this.radius;
        this.maxx = this.getX() + this.radius;
        this.minz = this.getZ() - this.radius;
        this.maxz = this.getZ() + this.radius;
        this.miny = this.getY() - this.radius;
        this.maxy = this.getY() + this.radius;
        if (this.height > 0) {
            this.miny = this.getY() - (this.height - 1) / 2;
            this.maxy = this.getY() + (this.height - 1) / 2;
        }
        if (this.flags.hasFlag(FieldFlag.CUBOID)) {
            this.dirty.add(DirtyFieldReason.DIMENSIONS);
        }
    }

    public int getMaxVolume() {
        int side;
        if (this.settings.getCustomVolume() > 0) {
            return this.settings.getCustomVolume();
        }
        int h = side = Math.max(this.settings.getRadius() * 2 + 1, 1);
        if (this.height > 0) {
            h = this.height;
        }
        return side * side * h;
    }

    public int getActualVolume() {
        int widthX = Helper.getWidthFromCoords(this.maxx, this.minx);
        int widthZ = Helper.getWidthFromCoords(this.maxz, this.minz);
        int height = Helper.getWidthFromCoords(this.maxy, this.miny);
        return height * widthX * widthZ;
    }

    public int getFlatVolume() {
        int widthX = Helper.getWidthFromCoords(this.maxx, this.minx);
        int widthZ = Helper.getWidthFromCoords(this.maxz, this.minz);
        return widthX * widthZ;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        if (this.height == 0) {
            this.height = this.radius * 2 + 1;
        }
        this.calculateDimensions();
        if (this.flags.hasFlag(FieldFlag.CUBOID)) {
            this.dirty.add(DirtyFieldReason.DIMENSIONS);
        } else {
            this.dirty.add(DirtyFieldReason.HEIGHT);
            this.dirty.add(DirtyFieldReason.RADIUS);
        }
    }

    public int canSetCuboidRadius(int radius) {
        int volume = this.getMaxVolume();
        int newVolume = (int)Math.pow(radius * 2 + 1, 3.0);
        return newVolume - volume;
    }

    public int expand(int num, String dir, boolean bypass) {
        CuboidEntry ce = new CuboidEntry(this, true);
        ce.expand(num, dir);
        int overflow = ce.getOverflow();
        if (overflow <= 0 || bypass) {
            ce.finalizeField();
        }
        return overflow;
    }

    public int expand(int u, int d, int n, int s, int e, int w, boolean bypass) {
        CuboidEntry ce = new CuboidEntry(this, true);
        ce.expand(u, d, n, s, e, w);
        int overflow = ce.getOverflow();
        if (overflow <= 0 || bypass) {
            ce.finalizeField();
        }
        return overflow;
    }

    public void contract(int num, String dir) {
        CuboidEntry ce = new CuboidEntry(this, true);
        ce.contract(num, dir);
        ce.finalizeField();
    }

    public void contract(int u, int d, int n, int s, int e, int w) {
        CuboidEntry ce = new CuboidEntry(this, true);
        ce.contract(u, d, n, s, e, w);
        ce.finalizeField();
    }

    public void setCuboidDimensions(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minx = minX;
        this.miny = minY;
        this.minz = minZ;
        this.maxx = maxX;
        this.maxy = maxY;
        this.maxz = maxZ;
        this.radius = (Helper.getWidthFromCoords(this.maxx, this.minx) - 1 + (Helper.getWidthFromCoords(this.maxz, this.minz) - 1)) / 2 / 2;
        this.dirty.add(DirtyFieldReason.DIMENSIONS);
    }

    public void setRelativeCuboidDimensions(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        World world = this.getBlock().getWorld();
        Location min = new Location(world, (double)minX, (double)minY, (double)minZ);
        min = min.add(this.getLocation());
        Location max = new Location(world, (double)maxX, (double)maxY, (double)maxZ);
        max = max.add(this.getLocation());
        this.setCuboidDimensions(min.getBlockX(), min.getBlockY(), min.getBlockZ(), max.getBlockX(), max.getBlockY(), max.getBlockZ());
    }

    public Location getRelativeMin() {
        World world = this.getBlock().getWorld();
        Location min = new Location(world, (double)this.minx, (double)this.miny, (double)this.minz);
        min.subtract(this.getLocation());
        return min;
    }

    public Location getRelativeMax() {
        World world = this.getBlock().getWorld();
        Location max = new Location(world, (double)this.maxx, (double)this.maxy, (double)this.maxz);
        max.subtract(this.getLocation());
        return max;
    }

    public int getTypeId() {
        return this.type.getTypeId();
    }

    public short getData() {
        return this.type.getData();
    }

    public BlockTypeEntry getTypeEntry() {
        return this.type;
    }

    public String getType() {
        return Material.getMaterial((int)this.getTypeId()).toString();
    }

    public int getRadius() {
        return this.radius;
    }

    public int getHeight() {
        if (this.height == 0) {
            return this.radius * 2 + 1;
        }
        return this.height;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        this.dirty.add(DirtyFieldReason.OWNER);
    }

    public boolean isOwner(String playerName) {
        return this.owner.equalsIgnoreCase(playerName);
    }

    public void setName(String name) {
        this.name = name;
        this.dirty.add(DirtyFieldReason.NAME);
    }

    public String getName() {
        return this.name;
    }

    public boolean isName(String name) {
        if (name == null) {
            return false;
        }
        return this.name.equalsIgnoreCase(name);
    }

    public List<String> getAllAllowed() {
        ArrayList<String> all = new ArrayList<String>();
        all.add(this.owner.toLowerCase());
        all.addAll(this.allowed);
        all.addAll(this.renting.getRenters());
        return all;
    }

    public void clearAllowed() {
        this.allowed.clear();
    }

    public boolean isInAllowedList(String target) {
        return this.allowed.contains(target.toLowerCase());
    }

    public boolean isAllowed(String target) {
        ScoreboardManager manager;
        Scoreboard board;
        Team team;
        if (target.equalsIgnoreCase(this.owner)) {
            return true;
        }
        if (this.allowed.contains("*")) {
            return true;
        }
        if (this.allowed.contains(target.toLowerCase())) {
            return true;
        }
        if (this.renting.hasRenter(target.toLowerCase())) {
            return true;
        }
        List<String> groups = PreciousStones.getInstance().getPermissionsManager().getGroups(this.getWorld(), target);
        for (String group : groups) {
            if (!this.allowed.contains("g:" + group)) continue;
            return true;
        }
        String clan = PreciousStones.getInstance().getSimpleClansManager().getClan(target);
        if (clan != null && this.allowed.contains("c:" + clan)) {
            return true;
        }
        OfflinePlayer offlinePlayer = PreciousStones.getInstance().getServer().getOfflinePlayer(target);
        return offlinePlayer != null && (team = (board = (manager = Bukkit.getScoreboardManager()).getMainScoreboard()).getPlayerTeam(offlinePlayer)) != null && this.allowed.contains("t:" + team.getName().toLowerCase());
    }

    public boolean addAllowed(String target) {
        if (this.isAllowed(target)) {
            return false;
        }
        this.allowed.add(target.toLowerCase());
        this.dirty.add(DirtyFieldReason.ALLOWED);
        return true;
    }

    public void removeAllowed(String target) {
        this.allowed.remove(target.toLowerCase());
        this.dirty.add(DirtyFieldReason.ALLOWED);
    }

    public boolean migrateAllowed(String oldPlayerName, String newPlayerName) {
        if (!this.allowed.remove(oldPlayerName = oldPlayerName.toLowerCase())) {
            return false;
        }
        this.allowed.add(newPlayerName);
        this.dirty.add(DirtyFieldReason.ALLOWED);
        return true;
    }

    public String getCoords() {
        return super.toString();
    }

    public String getCleanCoords() {
        return this.getX() + " " + this.getY() + " " + this.getZ();
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.getOwner() + "]";
    }

    public List<Vector> getCorners() {
        ArrayList<Vector> corners = new ArrayList<Vector>();
        corners.add(new Vector(this.minx, this.miny, this.minz));
        corners.add(new Vector(this.minx, this.miny, this.maxz));
        corners.add(new Vector(this.minx, this.maxy, this.minz));
        corners.add(new Vector(this.minx, this.maxy, this.maxz));
        corners.add(new Vector(this.maxx, this.miny, this.minz));
        corners.add(new Vector(this.maxx, this.miny, this.maxz));
        corners.add(new Vector(this.maxx, this.maxy, this.minz));
        corners.add(new Vector(this.maxx, this.maxy, this.maxz));
        return corners;
    }

    public Set<ChunkVec> getEnvelopingChunks() {
        HashSet<ChunkVec> envelopingChunks = new HashSet<ChunkVec>();
        for (int x = this.minx; x <= this.maxx + 15; x += 16) {
            for (int z = this.minz; z <= this.maxz + 15; z += 16) {
                envelopingChunks.add(new ChunkVec(x >> 4, z >> 4, this.getWorld()));
            }
        }
        return envelopingChunks;
    }

    public Set<Field> getIntersectingFields() {
        Set<ChunkVec> envelopingChunks = this.getEnvelopingChunks();
        HashSet<Field> sources = new HashSet<Field>();
        for (ChunkVec ecv : envelopingChunks) {
            List<Field> fields = PreciousStones.getInstance().getForceFieldManager().getSourceFieldsInChunk(ecv, FieldFlag.ALL, new ResultsFilter[0]);
            for (Field field : fields) {
                if (field.equals(this) || !field.intersects(this)) continue;
                sources.add(field);
            }
        }
        return sources;
    }

    public boolean intersects(Field field) {
        if (!field.getWorld().equals(this.getWorld())) {
            return false;
        }
        List<Vector> corners = field.getCorners();
        for (Vector vec : corners) {
            if (!this.envelops(vec)) continue;
            return true;
        }
        corners = this.getCorners();
        for (Vector vec : corners) {
            if (!field.envelops(vec)) continue;
            return true;
        }
        return false;
    }

    public boolean envelops(Vector vec) {
        int px = vec.getBlockX();
        int py = vec.getBlockY();
        int pz = vec.getBlockZ();
        return px >= this.minx && px <= this.maxx && py >= this.miny && py <= this.maxy && pz >= this.minz && pz <= this.maxz;
    }

    public boolean envelops(AbstractVec field) {
        int px = field.getX();
        int py = field.getY();
        int pz = field.getZ();
        return px >= this.minx && px <= this.maxx && py >= this.miny && py <= this.maxy && pz >= this.minz && pz <= this.maxz;
    }

    public boolean envelops(Block block) {
        return this.envelops(new Vec(block));
    }

    public boolean envelops(Location loc) {
        return this.envelops(new Vec(loc));
    }

    public float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float velocity) {
        this.velocity = velocity;
        this.dirty.add(DirtyFieldReason.VELOCITY);
    }

    public void markForDeletion() {
        this.dirty.add(DirtyFieldReason.DELETE);
    }

    public List<String> getAllowed() {
        return new ArrayList<String>(this.allowed);
    }

    public List<String> getRenters() {
        return this.renting.getRenters();
    }

    public boolean isRented() {
        return this.renting.hasRenters();
    }

    public boolean isRenter(String playerName) {
        return this.renting.hasRenter(playerName.toLowerCase());
    }

    public String getPackedAllowed() {
        return Helper.toMessage(this.allowed, "|");
    }

    public void setPackedAllowed(String packedAllowed) {
        this.allowed.clear();
        this.allowed.addAll(Helper.fromArray(packedAllowed.split("[|]")));
    }

    public void updateLastUsed() {
        this.lastUsed = new DateTime().getMillis();
        this.dirty.add(DirtyFieldReason.LASTUSED);
    }

    public int getAgeInDays() {
        if (this.lastUsed <= 0L) {
            return 0;
        }
        return Days.daysBetween(new DateTime(this.lastUsed), new DateTime()).getDays();
    }

    public FieldSettings getSettings() {
        return this.settings;
    }

    public void setSettings(FieldSettings settings) {
        for (FieldFlag flag : settings.getDefaultFlags()) {
            this.flags.addFlag(flag);
        }
        this.settings = settings;
    }

    public boolean isDirty(DirtyFieldReason dirtyType) {
        return this.dirty.contains((Object)dirtyType);
    }

    public boolean isDirty() {
        return !this.dirty.isEmpty();
    }

    public void clearDirty() {
        this.dirty.clear();
    }

    public double distance(Location loc) {
        return Math.sqrt(Math.pow(loc.getBlockX() - this.getX(), 2.0) + Math.pow(loc.getBlockY() - this.getY(), 2.0) + Math.pow(loc.getBlockZ() - this.getZ(), 2.0));
    }

    @Override
    public int compareTo(Field field) throws ClassCastException {
        int c = this.getX() - field.getX();
        if (c == 0) {
            c = this.getZ() - field.getZ();
        }
        if (c == 0) {
            c = this.getY() - field.getY();
        }
        if (c == 0) {
            c = this.getWorld().compareTo(field.getWorld());
        }
        return c;
    }

    public int getMaxx() {
        return this.maxx;
    }

    public int getMaxy() {
        return this.maxy;
    }

    public int getMaxz() {
        return this.maxz;
    }

    public int getMinx() {
        return this.minx;
    }

    public int getMiny() {
        return this.miny;
    }

    public int getMinz() {
        return this.minz;
    }

    public String getDimensionString() {
        return String.format("minx: %s maxx: %s miny: %s maxy: %s minz: %s maxz: %s", this.minx, this.maxx, this.miny, this.maxy, this.minz, this.maxz);
    }

    public boolean isProgress() {
        return this.progress;
    }

    public void setProgress(boolean progress) {
        this.progress = progress;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public List<Field> getChildren() {
        return this.children;
    }

    public Set<Field> getFamily() {
        HashSet<Field> out = new HashSet<Field>();
        out.addAll(this.children);
        out.add(this);
        return out;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void clearParent() {
        this.parent = null;
    }

    public void addChild(Field field) {
        this.children.add(field);
    }

    public Field getParent() {
        return this.parent;
    }

    public void setParent(Field parent) {
        this.parent = parent;
    }

    public boolean isParent() {
        return !this.children.isEmpty();
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public FieldSign getAttachedFieldSign() {
        return SignHelper.getAttachedFieldSign(this.getBlock());
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.setDisabled(disabled, null, false);
    }

    public void setDisabled(boolean disabled, boolean skipMask) {
        this.setDisabled(disabled, null, true);
    }

    public void setDisabledNoMask(boolean disabled) {
        this.setDisabled(disabled, null, true);
    }

    public boolean setDisabled(boolean disabled, Player player) {
        return this.setDisabled(disabled, player, false);
    }

    public boolean setDisabled(boolean disabled, Player player, boolean skipMask) {
        PreciousStones plugin = PreciousStones.getInstance();
        if (disabled != this.disabled) {
            this.disabled = disabled;
            if (disabled) {
                if (!skipMask) {
                    if (this.flags.hasFlag(FieldFlag.MASK_ON_DISABLED)) {
                        this.masking.mask();
                    }
                    if (this.flags.hasFlag(FieldFlag.MASK_ON_ENABLED)) {
                        this.masking.unmask();
                    }
                }
                if (this.flags.hasFlag(FieldFlag.BREAKABLE_ON_DISABLED)) {
                    this.flags.setBreakable();
                }
                if (this.flags.hasFlag(FieldFlag.TRANSLOCATION) && this.isNamed()) {
                    plugin.getTranslocationManager().applyTranslocation(this);
                }
                plugin.getEntryManager().removeAllPlayers(this);
            } else {
                if (this.settings.getPayToEnable() > 0) {
                    if (player == null) {
                        this.disabled = true;
                        return false;
                    }
                    if (!plugin.getForceFieldManager().purchase(player, this.settings.getPayToEnable())) {
                        this.disabled = true;
                        return false;
                    }
                }
                if (!skipMask) {
                    if (this.flags.hasFlag(FieldFlag.MASK_ON_DISABLED)) {
                        this.masking.unmask();
                    }
                    if (this.flags.hasFlag(FieldFlag.MASK_ON_ENABLED)) {
                        this.masking.mask();
                    }
                }
                this.startDisabler();
                if (this.flags.hasFlag(FieldFlag.BREAKABLE_ON_DISABLED)) {
                    this.flags.unsetBreakable();
                }
                if (this.flags.hasFlag(FieldFlag.TRANSLOCATION) && this.isNamed()) {
                    plugin.getTranslocationManager().clearTranslocation(this);
                }
                if (this.flags.hasFlag(FieldFlag.FORESTER) && this.foresting.hasForesterUse() && !this.foresting.isForesting() && player != null) {
                    ForesterEntry fe = new ForesterEntry(this, player);
                }
                if (this.flags.hasFlag(FieldFlag.TELEPORT_PLAYERS_ON_ENABLE) || this.flags.hasFlag(FieldFlag.TELEPORT_MOBS_ON_ENABLE) || this.flags.hasFlag(FieldFlag.TELEPORT_VILLAGERS_ON_ENABLE) || this.flags.hasFlag(FieldFlag.TELEPORT_ANIMALS_ON_ENABLE) || this.flags.hasFlag(FieldFlag.TELEPORT_ANIMALS_ON_ENABLE)) {
                    List entities = Bukkit.getServer().getWorld(this.getWorld()).getEntities();
                    for (Entity entity : entities) {
                        if (!this.envelops(entity.getLocation())) continue;
                        if (this.flags.hasFlag(FieldFlag.TELEPORT_MOBS_ON_ENABLE) && (entity instanceof Monster || entity instanceof Golem || entity instanceof WaterMob)) {
                            plugin.getTeleportationManager().teleport(entity, this);
                        }
                        if (this.flags.hasFlag(FieldFlag.TELEPORT_VILLAGERS_ON_ENABLE) && entity instanceof Villager) {
                            plugin.getTeleportationManager().teleport(entity, this);
                        }
                        if (this.flags.hasFlag(FieldFlag.TELEPORT_ANIMALS_ON_ENABLE) && entity instanceof Ageable) {
                            plugin.getTeleportationManager().teleport(entity, this);
                        }
                        if (!this.flags.hasFlag(FieldFlag.TELEPORT_PLAYERS_ON_ENABLE) || !(entity instanceof Player)) continue;
                        plugin.getTeleportationManager().teleport(entity, this);
                    }
                }
            }
        }
        return true;
    }

    public boolean startDisabler() {
        if (this.settings != null && this.settings.getAutoDisableTime() > 0) {
            Player player = Bukkit.getServer().getPlayerExact(this.owner);
            final String theOwner = this.owner;
            final Field thisField = this;
            if (player != null) {
                ChatHelper.send((CommandSender)player, "fieldWillDisable", this.settings.getTitle(), this.settings.getAutoDisableTime());
            }
            if (this.disablerId > 0) {
                Bukkit.getServer().getScheduler().cancelTask(this.disablerId);
            }
            this.disablerId = Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)PreciousStones.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (!thisField.isDisabled()) {
                        Player player = Bukkit.getServer().getPlayerExact(theOwner);
                        if (player != null) {
                            ChatHelper.send((CommandSender)player, "fieldHasDisabled", Field.this.settings.getTitle());
                        }
                        thisField.setDisabled(true);
                        thisField.getFlagsModule().dirtyFlags("startDisabler");
                        PreciousStones.getInstance().getEntryManager().actOnInhabitantsOnDisableToggle(thisField);
                    }
                }
            }, 20L * (long)this.settings.getAutoDisableTime());
            return true;
        }
        return false;
    }

    public void changeOwner() {
        this.setOwner(this.newOwner);
        this.setNewOwner(null);
    }

    public String getNewOwner() {
        return this.newOwner;
    }

    public void setNewOwner(String newOwner) {
        this.newOwner = newOwner;
    }

    public void addDirty(DirtyFieldReason reason) {
        this.dirty.add(reason);
    }

    public boolean containsPlayer(String playerName) {
        Player player = Bukkit.getServer().getPlayerExact(playerName);
        return player != null && this.envelops(player.getLocation());
    }

    public boolean matchesBlockType() {
        Block block = this.getBlock();
        return block.getTypeId() == this.getTypeId();
    }

    public boolean missingBlock() {
        Block block = this.getBlock();
        return block.getTypeId() == 0;
    }

    public boolean hasOnlineAllowed() {
        World world = Bukkit.getWorld((String)this.getWorld());
        if (world != null) {
            List<String> allAllowed = this.getAllAllowed();
            for (String allowed : allAllowed) {
                Player player = Bukkit.getServer().getPlayerExact(allowed);
                if (player == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNamed() {
        return this.getName().length() > 0;
    }

    public String getDetails() {
        return "[" + this.getType() + "|" + this.getX() + " " + this.getY() + " " + this.getZ() + "]";
    }

    public boolean take(Player player) {
        Block block = this.getBlock();
        if (block.getTypeId() != this.type.getTypeId()) {
            return false;
        }
        PreciousStones.getInstance().getForceFieldManager().deleteField(this);
        block.setType(Material.AIR);
        ItemStack is = new ItemStack(this.type.getTypeId(), 1, 0, Byte.valueOf(this.type.getData()));
        if (this.settings.hasMetaName()) {
            ItemMeta meta = is.getItemMeta();
            meta.setDisplayName(this.settings.getMetaName());
            meta.setLore(this.settings.getMetaLore());
            is.setItemMeta(meta);
        }
        StackHelper.give(player, is);
        return true;
    }

    public boolean hasFlag(FieldFlag flag) {
        return this.flags.hasFlag(flag);
    }

    public boolean hasFlag(String flagStr) {
        return this.flags.hasFlag(flagStr);
    }

    public RentingModule getRentingModule() {
        return this.renting;
    }

    public MaskingModule getMaskingModule() {
        return this.masking;
    }

    public HidingModule getHidingModule() {
        return this.hiding;
    }

    public ForestingModule getForestingModule() {
        return this.foresting;
    }

    public TranslocatingModule getTranslocatingModule() {
        return this.translocating;
    }

    public RevertingModule getRevertingModule() {
        return this.reverting;
    }

    public ListingModule getListingModule() {
        return this.listing;
    }

    public SnitchingModule getSnitchingModule() {
        return this.snitching;
    }

    public FencingModule getFencingModule() {
        return this.fencing;
    }

    public FlagsModule getFlagsModule() {
        return this.flags;
    }

    public BuyingModule getBuyingModule() {
        return this.buying;
    }
}

