/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.field;

import com.google.common.collect.Maps;
import java.util.Map;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import org.bukkit.entity.Player;

public enum FieldFlag {
    ALL,
    ALLOW_PLACE,
    ALLOW_DESTROY,
    PREVENT_FIRE,
    PREVENT_FIRE_SPREAD,
    PREVENT_PLACE,
    PREVENT_DESTROY,
    PREVENT_VEHICLE_DESTROY,
    PREVENT_ENDERMAN_DESTROY,
    PREVENT_EXPLOSIONS,
    PREVENT_CREEPER_EXPLOSIONS,
    PREVENT_WITHER_EXPLOSIONS,
    PREVENT_TNT_EXPLOSIONS,
    PREVENT_PVP,
    PREVENT_MOB_DAMAGE,
    PREVENT_MOB_SPAWN,
    PREVENT_ANIMAL_SPAWN,
    PREVENT_ENTRY,
    PREVENT_UNPROTECTABLE,
    PREVENT_FLOW,
    PREVENT_TELEPORT,
    PREVENT_FLIGHT,
    PREVENT_POTION_SPLASH,
    PREVENT_PORTAL_ENTER,
    PREVENT_PORTAL_CREATION,
    PREVENT_PORTAL_DESTINATION,
    PREVENT_ITEM_FRAME_TAKE,
    PROTECT_ARMOR_STANDS,
    PREVENT_ENTITY_INTERACT,
    PROTECT_ANIMALS,
    PROTECT_MOBS,
    PROTECT_VILLAGERS,
    PROTECT_CROPS,
    PROTECT_LWC,
    PROTECT_INVENTORIES,
    ROLLBACK_EXPLOSIONS,
    REMOVE_MOB,
    HEAL,
    DAMAGE,
    REPAIR,
    FEED,
    AIR,
    BREAKABLE,
    WELCOME_MESSAGE,
    FAREWELL_MESSAGE,
    SNITCH,
    NO_CONFLICT,
    LAUNCH,
    CANNON,
    MINE,
    LIGHTNING,
    NO_OWNER,
    FORESTER,
    GRIEF_REVERT,
    GRIEF_REVERT_DROP,
    GRIEF_REVERT_SAFETY,
    ENTRY_ALERT,
    CUBOID,
    ENABLE_ON_SRC,
    VISUALIZE_ON_SRC,
    VISUALIZE_ON_PLACE,
    KEEP_CHUNKS_LOADED,
    PLACE_GRIEF,
    TOGGLE_ON_DISABLED,
    REDEFINE_ON_DISABLED,
    MODIFY_ON_DISABLED,
    BREAKABLE_ON_DISABLED,
    ALLOWED_CAN_BREAK,
    SNEAKING_BYPASS,
    PLACE_DISABLED,
    PREVENT_USE,
    DYNMAP_AREA,
    DYNMAP_MARKER,
    DYNMAP_NO_TOGGLE,
    DYNMAP_DISABLED,
    DYNMAP_HIDE_PLAYERS,
    DYNMAP_SHOW_PLAYERS,
    CAN_CHANGE_OWNER,
    PLOT,
    POTIONS,
    NEUTRALIZE_POTIONS,
    SNEAK_TO_PLACE,
    NO_FALL_DAMAGE,
    CONFISCATE_ITEMS,
    ENABLE_WITH_REDSTONE,
    TRANSLOCATION,
    TRANSLOCATION_SAFETY,
    MASK_ON_ENABLED,
    MASK_ON_DISABLED,
    WORLDGUARD_REPELLENT,
    GROUP_ON_ENTRY,
    ENTRY_GAME_MODE,
    LEAVING_GAME_MODE,
    NO_ALLOWING,
    TELEPORT_ON_ENTRY,
    TELEPORT_ON_EXIT,
    TELEPORT_ON_SNEAK,
    TELEPORT_ON_BLOCK_BREAK,
    TELEPORT_ON_BLOCK_PLACE,
    TELEPORT_ON_PVP,
    TELEPORT_ON_FIRE,
    TELEPORT_ON_FEEDING,
    TELEPORT_ON_DAMAGE,
    TELEPORT_PLAYERS_ON_ENABLE,
    TELEPORT_MOBS_ON_ENABLE,
    TELEPORT_ANIMALS_ON_ENABLE,
    TELEPORT_VILLAGERS_ON_ENABLE,
    TELEPORT_DESTINATION,
    TELEPORT_BEFORE_DEATH,
    TELEPORT_EXPLOSION_EFFECT,
    TELEPORT_ANNOUNCE,
    TELEPORT_RELATIVELY,
    TELEPORT_IF_WALKING_ON,
    TELEPORT_IF_NOT_WALKING_ON,
    TELEPORT_IF_HOLDING_ITEMS,
    TELEPORT_IF_NOT_HOLDING_ITEMS,
    TELEPORT_IF_HAS_ITEMS,
    TELEPORT_IF_NOT_HAS_ITEMS,
    TELEPORT_COST,
    HIDABLE,
    COMMAND_ON_ENTER,
    COMMAND_ON_EXIT,
    UNUSABLE_ITEMS,
    PLAYER_COMMAND_ON_ENTER,
    PLAYER_COMMAND_ON_EXIT,
    COMMANDS_ON_OVERLAP,
    MUST_BE_ABOVE,
    MUST_BE_BELOW,
    NO_GROWTH,
    SINGLE_USE,
    DISABLE_WHEN_ONLINE,
    DISABLE_ON_LOGOFF,
    ENABLE_ON_LOGON,
    NO_PROJECTILE_THROW,
    NO_PLAYER_PLACE,
    NO_DROPPING_ITEMS,
    NO_PLAYER_SPRINT,
    PREVENT_VEHICLE_ENTER,
    PREVENT_VEHICLE_EXIT,
    RENTABLE,
    SHAREABLE,
    BUYABLE,
    DELETE_IF_NO_PERMISSION,
    COMMAND_BLACKLISTING,
    COMMAND_BLACKLIST,
    ANTI_PLOT,
    GLOBAL,
    NO_RESIZE;

    private static final FieldFlag[] applyToNonAllowed;
    private static final Map<String, FieldFlag> flags;
    private static final FieldFlag[] hidden;
    private static final FieldFlag[] nameable;
    private static final FieldFlag[] unToggable;

    public boolean applies(Field field, Player player) {
        return this.applies(field, player.getName());
    }

    public boolean applies(Field field, String playerName) {
        if (!field.hasFlag(this)) {
            return false;
        }
        boolean allowed = PreciousStones.getInstance().getForceFieldManager().isAllowed(field, playerName);
        if (field.getSettings().isReversedFlag(this)) {
            boolean bl = allowed = !allowed;
        }
        if (FieldFlag.appliesToNonAllowed(this)) {
            boolean bl = allowed = !allowed;
        }
        if (field.getSettings().isAlledFlag(this)) {
            allowed = true;
        }
        return allowed;
    }

    private static boolean appliesToNonAllowed(FieldFlag flag) {
        for (FieldFlag aa : applyToNonAllowed) {
            if (!aa.equals((Object)flag)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameable() {
        String flagStr = this.toString();
        for (FieldFlag flag : nameable) {
            if (!flag.toString().equalsIgnoreCase(flagStr)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnToggable() {
        String flagStr = this.toString();
        for (FieldFlag flag : unToggable) {
            if (!flag.toString().equalsIgnoreCase(flagStr)) continue;
            return true;
        }
        for (FieldFlag flag : hidden) {
            if (!flag.toString().equalsIgnoreCase(flagStr)) continue;
            return true;
        }
        return false;
    }

    public static FieldFlag[] getHidden() {
        return hidden;
    }

    public static FieldFlag getByString(String flagStr) {
        return flags.get(FieldFlag.stripModifiers(flagStr));
    }

    public static boolean isFlag(String flagStr) {
        return flags.get(flagStr) != null;
    }

    public static String stripModifiers(String flagStr) {
        boolean hasModifier;
        if (flagStr == null || flagStr.isEmpty()) {
            return flagStr;
        }
        boolean bl = hasModifier = flagStr.startsWith("^") || flagStr.startsWith("~") || flagStr.startsWith("?");
        while (hasModifier && flagStr.length() > 0) {
            hasModifier = (flagStr = flagStr.substring(1)).startsWith("^") || flagStr.startsWith("~") || flagStr.startsWith("?");
        }
        return flagStr;
    }

    public String toString() {
        return this.name().replace('_', '-').toLowerCase();
    }

    static {
        applyToNonAllowed = new FieldFlag[]{PREVENT_FIRE, PREVENT_FLOW, PREVENT_ENTRY, PREVENT_PLACE, PREVENT_DESTROY, PREVENT_VEHICLE_DESTROY, PREVENT_MOB_DAMAGE, PREVENT_USE, PREVENT_TELEPORT, PREVENT_FLIGHT, PREVENT_ITEM_FRAME_TAKE, PROTECT_ARMOR_STANDS, PREVENT_ENTITY_INTERACT, PROTECT_ANIMALS, PROTECT_CROPS, PROTECT_MOBS, PROTECT_INVENTORIES, PROTECT_VILLAGERS, PROTECT_LWC, DAMAGE, SNITCH, MINE, LIGHTNING, GRIEF_REVERT, PLACE_GRIEF, ENTRY_ALERT, ENTRY_GAME_MODE, LEAVING_GAME_MODE, CONFISCATE_ITEMS, UNUSABLE_ITEMS, TELEPORT_ON_ENTRY, TELEPORT_ON_EXIT, TELEPORT_ON_DAMAGE, TELEPORT_ON_FEEDING, TELEPORT_ON_FIRE, TELEPORT_ON_PVP, TELEPORT_IF_WALKING_ON, TELEPORT_IF_NOT_WALKING_ON, TELEPORT_IF_HOLDING_ITEMS, TELEPORT_IF_NOT_HOLDING_ITEMS, TELEPORT_IF_HAS_ITEMS, TELEPORT_IF_NOT_HAS_ITEMS, TELEPORT_ON_BLOCK_BREAK, TELEPORT_ON_BLOCK_PLACE, TELEPORT_BEFORE_DEATH, PREVENT_POTION_SPLASH, NO_PROJECTILE_THROW, NO_DROPPING_ITEMS, NO_PLAYER_SPRINT, PREVENT_VEHICLE_ENTER, PREVENT_VEHICLE_EXIT, COMMAND_BLACKLIST, NO_RESIZE};
        flags = Maps.newHashMap();
        hidden = new FieldFlag[]{ALL, DYNMAP_NO_TOGGLE};
        nameable = new FieldFlag[]{WELCOME_MESSAGE, FAREWELL_MESSAGE, ENTRY_ALERT, TRANSLOCATION, TELEPORT_IF_WALKING_ON, TELEPORT_IF_NOT_WALKING_ON, TELEPORT_IF_HOLDING_ITEMS, TELEPORT_IF_NOT_HOLDING_ITEMS, TELEPORT_IF_HAS_ITEMS, TELEPORT_IF_NOT_HAS_ITEMS, TELEPORT_BEFORE_DEATH, TELEPORT_ON_DAMAGE, TELEPORT_ON_FEEDING, TELEPORT_MOBS_ON_ENABLE, TELEPORT_ANIMALS_ON_ENABLE, TELEPORT_PLAYERS_ON_ENABLE, TELEPORT_VILLAGERS_ON_ENABLE, TELEPORT_ON_FIRE, TELEPORT_ON_PVP, TELEPORT_ON_BLOCK_PLACE, TELEPORT_ON_BLOCK_BREAK, TELEPORT_ON_SNEAK, TELEPORT_ON_ENTRY, TELEPORT_ON_EXIT, TELEPORT_DESTINATION, SINGLE_USE};
        unToggable = new FieldFlag[]{WORLDGUARD_REPELLENT, PLACE_DISABLED, SNEAKING_BYPASS, BREAKABLE_ON_DISABLED, MODIFY_ON_DISABLED, REDEFINE_ON_DISABLED, PREVENT_UNPROTECTABLE, TOGGLE_ON_DISABLED, NO_CONFLICT, NO_PLAYER_PLACE, NO_ALLOWING, CUBOID, DYNMAP_DISABLED, HIDABLE, TRANSLOCATION, SNEAK_TO_PLACE, COMMAND_ON_ENTER, COMMAND_ON_EXIT, PLAYER_COMMAND_ON_ENTER, PLAYER_COMMAND_ON_EXIT, DISABLE_WHEN_ONLINE, MUST_BE_ABOVE, MUST_BE_BELOW, DISABLE_ON_LOGOFF, ENABLE_ON_LOGON, RENTABLE, BUYABLE, SHAREABLE, COMMAND_BLACKLIST};
        for (FieldFlag flag : FieldFlag.values()) {
            flags.put(flag.toString(), flag);
        }
    }
}

