/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public final class SettingsManager {
    private int version;
    private BlockTypeEntry defaulItemCurrency;
    private int maxTargetDistance;
    private boolean commandsToRentBuy;
    private boolean warAllow;
    private boolean oncePerBlockOnMove;
    private int maxSizeTranslocation;
    private int maxSizeTranslocationForRedstone;
    private List<String> preventDestroyEverywhere;
    private List<String> preventPlaceEverywhere;
    private boolean sneakPlaceFields;
    private boolean showDefaultWelcomeFarewellMessages;
    private boolean sneakNormalBlock;
    private boolean disableGroundInfo;
    private boolean preventRemovalIfPlayerInField;
    private boolean autoAddClan;
    private boolean autoAddTeam;
    private int globalFieldLimit;
    private boolean noRefunds;
    private BlockTypeEntry cuboidDefiningType;
    private BlockTypeEntry cuboidVisualizationType;
    private boolean disableMessages;
    private List<String> blacklistedWorlds;
    private int maxSnitchRecords;
    private int saveFrequency;
    private List<String> griefUndoBlackList;
    private int griefRevertMinInterval;
    private boolean visualizationNewStyle;
    private BlockTypeEntry visualizeMarkBlock;
    private BlockTypeEntry visualizeFrameBlock;
    private BlockTypeEntry visualizeBlock;
    private int visualizeSeconds;
    private int visualizeDensity;
    private int visualizeTicksBetweenSends;
    private int visualizeSendSize;
    private int visualizeMaxFields;
    private boolean visualizeOnExpand;
    private boolean visualizeEndOnMove;
    private int purgeAfterDays;
    private boolean purgeBannedPlayers;
    private boolean debug;
    private List<LinkedHashMap<String, Object>> forceFieldBlocks = new ArrayList<LinkedHashMap<String, Object>>();
    private List<BlockTypeEntry> unbreakableBlocks = new ArrayList<BlockTypeEntry>();
    private List<BlockTypeEntry> bypassBlocks = new ArrayList<BlockTypeEntry>();
    private List<BlockTypeEntry> unprotectableBlocks = new ArrayList<BlockTypeEntry>();
    private List<BlockTypeEntry> hidingMaskBlocs = new ArrayList<BlockTypeEntry>();
    private List<BlockTypeEntry> toolItems = new ArrayList<BlockTypeEntry>();
    private List<BlockTypeEntry> repairableItems = new ArrayList<BlockTypeEntry>();
    private List<String> allEntryGroups = new ArrayList<String>();
    private boolean logRollback;
    private boolean logTranslocation;
    private boolean logFire;
    private boolean logEntry;
    private boolean logPlace;
    private boolean logPlaceArea;
    private boolean logUse;
    private boolean logDestroy;
    private boolean logDestroyArea;
    private boolean logUnprotectable;
    private boolean logPvp;
    private boolean logBypassPvp;
    private boolean logBypassDelete;
    private boolean logBypassPlace;
    private boolean logBypassDestroy;
    private boolean logConflictPlace;
    private boolean logRentsAndPurchases;
    private boolean notifyTranslocation;
    private boolean notifyRollback;
    private boolean notifyFlyZones;
    private boolean notifyPlace;
    private boolean notifyDestroy;
    private boolean notifyBypassPvp;
    private boolean notifyBypassPlace;
    private boolean notifyBypassDestroy;
    private boolean notifyBypassUnprotectable;
    private boolean warnInstantHeal;
    private boolean warnSlowHeal;
    private boolean warnSlowFeeding;
    private boolean warnSlowRepair;
    private boolean warnSlowDamage;
    private boolean warnFastDamage;
    private boolean warnGiveAir;
    private boolean warnPlace;
    private boolean warnUse;
    private boolean warnDestroy;
    private boolean warnDestroyArea;
    private boolean warnUnprotectable;
    private boolean warnEntry;
    private boolean warnPvp;
    private boolean warnFire;
    private boolean warnLaunch;
    private boolean warnCannon;
    private boolean warnMine;
    private boolean publicBlockDetails;
    private boolean dropOnDelete;
    private boolean disableAlertsForAdmins;
    private boolean disableBypassAlertsForAdmins;
    private boolean disableSimpleClanHook;
    private boolean offByDefault;
    private boolean useIdInSnitches;
    private int fenceMaxDepth;
    private int[] throughFields = new int[]{0, 6, 8, 9, 10, 11, 31, 32, 37, 38, 39, 40, 50, 51, 55, 59, 63, 65, 66, 69, 68, 70, 72, 75, 76, 77, 78, 83, 92, 93, 94, 104, 105, 106, 131, 132, 140, 141, 142};
    private int[] naturalThroughFields = new int[]{0, 6, 8, 9, 10, 11, 31, 32, 37, 38, 39, 40, 51, 59, 78, 83, 104, 105, 106, 141, 142};
    private HashSet<Byte> throughFieldsByteSet = new HashSet();
    private HashSet<Integer> throughFieldsSet = new HashSet();
    private HashSet<Integer> naturalThroughFieldSet = new HashSet();
    private int linesPerPage;
    private boolean useMysql;
    private String host;
    private String database;
    private String username;
    private String password;
    private int port;
    private final HashMap<BlockTypeEntry, FieldSettings> fieldDefinitions = new HashMap();
    private PreciousStones plugin = PreciousStones.getInstance();
    private File main;
    private FileConfiguration config = this.plugin.getConfig();
    private FileConfiguration cleanConfig = new YamlConfiguration();

    public SettingsManager() {
        this.main = new File(this.plugin.getDataFolder() + File.separator + "config.yml");
        this.load();
    }

    public void load() {
        for (int item : this.throughFields) {
            this.throughFieldsSet.add(item);
        }
        for (int item : this.throughFields) {
            this.throughFieldsByteSet.add((byte)item);
        }
        for (int item : this.naturalThroughFields) {
            this.naturalThroughFieldSet.add(item);
        }
        boolean exists = this.main.exists();
        if (exists) {
            try {
                this.config.options().copyDefaults(true);
                this.config.load(this.main);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.config.options().copyDefaults(true);
        }
        this.unbreakableBlocks = Helper.toTypeEntries(this.loadStringList("unbreakable-blocks"));
        this.forceFieldBlocks = (ArrayList)this.loadObject("force-field-blocks");
        this.bypassBlocks = Helper.toTypeEntries(this.loadStringList("bypass-blocks"));
        this.unprotectableBlocks = Helper.toTypeEntries(this.loadStringList("unprotectable-blocks"));
        this.hidingMaskBlocs = Helper.toTypeEntries(this.loadStringList("hiding-mask-blocks"));
        this.toolItems = Helper.toTypeEntries(this.loadStringList("tool-items"));
        this.repairableItems = Helper.toTypeEntries(this.loadStringList("repairable-items"));
        this.logTranslocation = this.loadBoolean("log.translocation");
        this.logRollback = this.loadBoolean("log.rollback");
        this.logFire = this.loadBoolean("log.fire");
        this.logEntry = this.loadBoolean("log.entry");
        this.logPlace = this.loadBoolean("log.place");
        this.logUse = this.loadBoolean("log.use");
        this.logPvp = this.loadBoolean("log.pvp");
        this.logDestroy = this.loadBoolean("log.destroy");
        this.logDestroyArea = this.loadBoolean("log.destroy-area");
        this.logPlaceArea = this.loadBoolean("log.place-area");
        this.logUnprotectable = this.loadBoolean("log.unprotectable");
        this.logBypassPvp = this.loadBoolean("log.bypass-pvp");
        this.logBypassDelete = this.loadBoolean("log.bypass-delete");
        this.logBypassPlace = this.loadBoolean("log.bypass-place");
        this.logBypassDestroy = this.loadBoolean("log.bypass-destroy");
        this.logConflictPlace = this.loadBoolean("log.conflict-place");
        this.logRentsAndPurchases = this.loadBoolean("log.rents-and-purchases");
        this.notifyTranslocation = this.loadBoolean("notify.translocation");
        this.notifyRollback = this.loadBoolean("notify.rollback");
        this.notifyPlace = this.loadBoolean("notify.place");
        this.notifyDestroy = this.loadBoolean("notify.destroy");
        this.notifyBypassUnprotectable = this.loadBoolean("notify.bypass-unprotectable");
        this.notifyBypassPvp = this.loadBoolean("notify.bypass-pvp");
        this.notifyBypassPlace = this.loadBoolean("notify.bypass-place");
        this.notifyBypassDestroy = this.loadBoolean("notify.bypass-destroy");
        this.notifyFlyZones = this.loadBoolean("notify.fly-zones");
        this.warnInstantHeal = this.loadBoolean("warn.instant-heal");
        this.warnSlowHeal = this.loadBoolean("warn.slow-heal");
        this.warnSlowDamage = this.loadBoolean("warn.slow-damage");
        this.warnSlowFeeding = this.loadBoolean("warn.slow-feeding");
        this.warnSlowRepair = this.loadBoolean("warn.slow-repair");
        this.warnFastDamage = this.loadBoolean("warn.fast-damage");
        this.warnGiveAir = this.loadBoolean("warn.air");
        this.warnFire = this.loadBoolean("warn.fire");
        this.warnEntry = this.loadBoolean("warn.entry");
        this.warnPlace = this.loadBoolean("warn.place");
        this.warnUse = this.loadBoolean("warn.use");
        this.warnPvp = this.loadBoolean("warn.pvp");
        this.warnDestroy = this.loadBoolean("warn.destroy");
        this.warnDestroyArea = this.loadBoolean("warn.destroy-area");
        this.warnUnprotectable = this.loadBoolean("warn.unprotectable");
        this.warnLaunch = this.loadBoolean("warn.launch");
        this.warnCannon = this.loadBoolean("warn.cannon");
        this.warnMine = this.loadBoolean("warn.mine");
        this.disableMessages = this.loadBoolean("settings.disable-messages");
        this.warAllow = this.loadBoolean("settings.allow-waring-clans-into-protections");
        this.preventRemovalIfPlayerInField = this.loadBoolean("settings.prevent-removal-if-player-in-field");
        this.commandsToRentBuy = this.loadBoolean("settings.use-commands-to-rent");
        this.disableSimpleClanHook = this.loadBoolean("settings.disable-simpleclans-hook");
        this.maxSizeTranslocation = this.loadInt("settings.max-size-translocation");
        this.maxSizeTranslocationForRedstone = this.loadInt("settings.max-size-translocation-for-redstone");
        this.version = this.loadInt("settings.version");
        this.preventPlaceEverywhere = this.loadStringList("settings.prevent-place-everywhere");
        this.preventDestroyEverywhere = this.loadStringList("settings.prevent-destroy-everywhere");
        this.showDefaultWelcomeFarewellMessages = this.loadBoolean("settings.show-default-welcome-farewell-messages");
        this.sneakPlaceFields = this.loadBoolean("settings.sneak-to-place-field");
        this.sneakNormalBlock = this.loadBoolean("settings.sneak-to-place-normal-block");
        this.disableGroundInfo = this.loadBoolean("settings.disable-ground-info");
        this.globalFieldLimit = this.loadInt("settings.global-field-limit");
        this.noRefunds = this.loadBoolean("settings.no-refund-for-fields");
        this.publicBlockDetails = this.loadBoolean("settings.public-block-details");
        this.dropOnDelete = this.loadBoolean("settings.drop-on-delete");
        this.disableAlertsForAdmins = this.loadBoolean("settings.disable-alerts-for-admins");
        this.disableBypassAlertsForAdmins = this.loadBoolean("settings.disable-bypass-alerts-for-admins");
        this.offByDefault = this.loadBoolean("settings.off-by-default");
        this.linesPerPage = this.loadInt("settings.lines-per-page");
        this.debug = this.loadBoolean("settings.show-debug-info");
        this.blacklistedWorlds = this.loadStringList("settings.blacklisted-worlds");
        this.autoAddClan = this.loadBoolean("settings.auto-allow-clan-on-fields");
        this.autoAddTeam = this.loadBoolean("settings.auto-allow-team-on-fields");
        this.oncePerBlockOnMove = this.loadBoolean("settings.check-once-per-block-on-move");
        this.useIdInSnitches = this.loadBoolean("settings.use-blockids-in-snitches");
        this.fenceMaxDepth = this.loadInt("settings.fence-max-depth");
        this.maxTargetDistance = this.loadInt("settings.max-target-distance");
        this.defaulItemCurrency = this.loadTypeEntry("settings.default-item-currency");
        this.cuboidDefiningType = this.loadTypeEntry("cuboid.defining-blocktype");
        this.cuboidVisualizationType = this.loadTypeEntry("cuboid.visualization-blocktype");
        this.purgeAfterDays = this.loadInt("cleanup.player-inactivity-purge-days");
        this.purgeBannedPlayers = this.loadBoolean("cleanup.purge-banned-players");
        this.saveFrequency = this.loadInt("saving.frequency-seconds");
        this.maxSnitchRecords = this.loadInt("saving.max-records-per-snitch");
        this.visualizeFrameBlock = this.loadTypeEntry("visualization.frame-block-type");
        this.visualizeBlock = this.loadTypeEntry("visualization.block-type");
        this.visualizeSeconds = this.loadInt("visualization.seconds");
        this.visualizationNewStyle = this.loadBoolean("visualization.new-dotted-style");
        this.visualizeEndOnMove = this.loadBoolean("visualization.end-on-player-move");
        this.visualizeMarkBlock = this.loadTypeEntry("visualization.mark-block-type");
        this.visualizeDensity = this.loadInt("visualization.default-density");
        this.visualizeSendSize = this.loadInt("visualization.blocks-to-send");
        this.visualizeMaxFields = this.loadInt("visualization.max-fields-to-visualize-at-once");
        this.visualizeTicksBetweenSends = this.loadInt("visualization.ticks-between-sends");
        this.visualizeOnExpand = this.loadBoolean("visualization.visualize-on-expand");
        this.griefRevertMinInterval = this.loadInt("grief-revert.min-interval-secs");
        this.griefUndoBlackList = this.loadStringList("grief-revert.black-list");
        this.useMysql = this.loadBoolean("mysql.enable");
        this.host = this.loadString("mysql.host");
        this.port = this.loadInt("mysql.port");
        this.database = this.loadString("mysql.database");
        this.username = this.loadString("mysql.username");
        this.password = this.loadString("mysql.password");
        this.addForceFieldStones(this.forceFieldBlocks);
        this.save();
    }

    private Boolean loadBoolean(String path) {
        if (this.config.isBoolean(path)) {
            boolean value = this.config.getBoolean(path);
            this.cleanConfig.set(path, (Object)value);
            return value;
        }
        return false;
    }

    private String loadString(String path) {
        if (this.config.isString(path)) {
            String value = this.config.getString(path);
            this.cleanConfig.set(path, (Object)value);
            return value;
        }
        return "";
    }

    private int loadInt(String path) {
        if (this.config.isInt(path)) {
            int value = this.config.getInt(path);
            this.cleanConfig.set(path, (Object)value);
            return value;
        }
        return 0;
    }

    private double loadDouble(String path) {
        if (this.config.isDouble(path)) {
            double value = this.config.getDouble(path);
            this.cleanConfig.set(path, (Object)value);
            return value;
        }
        return 0.0;
    }

    private BlockTypeEntry loadTypeEntry(String path) {
        String value = this.config.getString(path);
        this.cleanConfig.set(path, (Object)value);
        return new BlockTypeEntry(value);
    }

    private List<Integer> loadIntList(String path) {
        if (this.config.isList(path)) {
            List value = this.config.getIntegerList(path);
            this.cleanConfig.set(path, (Object)value);
            return value;
        }
        return new ArrayList<Integer>();
    }

    private List<String> loadStringList(String path) {
        if (this.config.isList(path)) {
            List value = this.config.getStringList(path);
            this.cleanConfig.set(path, (Object)value);
            return value;
        }
        return new ArrayList<String>();
    }

    private Object loadObject(String path) {
        Object value = this.config.get(path);
        this.cleanConfig.set(path, value);
        return value;
    }

    public void save() {
        try {
            this.cleanConfig.save(this.main);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addForceFieldStones(List<LinkedHashMap<String, Object>> maps) {
        if (maps == null) {
            return;
        }
        for (LinkedHashMap<String, Object> map : maps) {
            FieldSettings fs = new FieldSettings(map);
            if (!fs.isValidField()) continue;
            this.fieldDefinitions.put(fs.getTypeEntry(), fs);
            if (fs.getGroupOnEntry().isEmpty()) continue;
            this.allEntryGroups.add(fs.getGroupOnEntry());
        }
    }

    public boolean haveNameable() {
        for (FieldSettings fs : this.fieldDefinitions.values()) {
            if (!fs.hasNameableFlag()) continue;
            return true;
        }
        return false;
    }

    public boolean haveVelocity() {
        for (FieldSettings fs : this.fieldDefinitions.values()) {
            if (!fs.hasVeocityFlag()) continue;
            return true;
        }
        return false;
    }

    public boolean haveGriefRevert() {
        for (FieldSettings fs : this.fieldDefinitions.values()) {
            if (!fs.hasDefaultFlag(FieldFlag.GRIEF_REVERT)) continue;
            return true;
        }
        return false;
    }

    public boolean haveSnitch() {
        for (FieldSettings fs : this.fieldDefinitions.values()) {
            if (!fs.hasDefaultFlag(FieldFlag.SNITCH)) continue;
            return true;
        }
        return false;
    }

    public boolean haveLimits() {
        for (FieldSettings fs : this.fieldDefinitions.values()) {
            if (!fs.hasLimit()) continue;
            return true;
        }
        return false;
    }

    public boolean isHarmfulPotion(PotionEffectType pot) {
        return pot.equals((Object)PotionEffectType.SLOW) || pot.equals((Object)PotionEffectType.SLOW_DIGGING) || pot.equals((Object)PotionEffectType.WEAKNESS) || pot.equals((Object)PotionEffectType.BLINDNESS) || pot.equals((Object)PotionEffectType.CONFUSION) || pot.equals((Object)PotionEffectType.HARM) || pot.equals((Object)PotionEffectType.POISON) || pot.equals((Object)PotionEffectType.HUNGER) || pot.equals((Object)PotionEffectType.INCREASE_DAMAGE);
    }

    public boolean isCrop(Block block) {
        return block.getType().equals((Object)Material.SOIL) || block.getType().equals((Object)Material.WHEAT) || block.getType().equals((Object)Material.SUGAR_CANE) || block.getType().equals((Object)Material.CARROT) || block.getType().equals((Object)Material.POTATO) || block.getType().equals((Object)Material.PUMPKIN_STEM) || block.getType().equals((Object)Material.MELON_STEM);
    }

    public boolean isDependentBlock(int type) {
        return type == 26 || type == 27 || type == 28 || type == 30 || type == 31 || type == 32 || type == 37 || type == 38 || type == 39 || type == 40 || type == 50 || type == 55 || type == 63 || type == 64 || type == 65 || type == 66 || type == 68 || type == 69 || type == 70 || type == 71 || type == 72 || type == 75 || type == 76 || type == 77 || type == 78 || type == 85 || type == 96 || type == 99 || type == 100 || type == 101 || type == 102 || type == 104 || type == 105 || type == 106 || type == 107 || type == 111 || type == 113 || type == 115 || type == 119 || type == 127 || type == 131 || type == 132;
    }

    public boolean isBlacklistedWorld(World world) {
        return this.getBlacklistedWorlds().contains(world.getName());
    }

    public boolean isUnprotectableType(BlockTypeEntry type) {
        return this.getUnprotectableBlocks().contains(type);
    }

    public boolean isHidingMaskType(BlockTypeEntry type) {
        return this.hidingMaskBlocs.contains(type);
    }

    public BlockTypeEntry getFirstHidingMask() {
        return this.hidingMaskBlocs.get(0);
    }

    public boolean isUnprotectableType(Block block) {
        return this.getUnprotectableBlocks().contains(new BlockTypeEntry(block));
    }

    public boolean isGriefUndoBlackListType(int id) {
        return this.getGriefUndoBlackList().contains(id);
    }

    public boolean isThroughType(int type) {
        return this.throughFieldsSet.contains(type);
    }

    public boolean isNaturalThroughType(int type) {
        return this.naturalThroughFieldSet.contains(type);
    }

    public boolean isToolItemType(BlockTypeEntry entry) {
        if (!entry.isValid()) {
            return false;
        }
        return this.toolItems.contains(entry);
    }

    public boolean isRepairableItemType(BlockTypeEntry entry) {
        if (!entry.isValid()) {
            return false;
        }
        return this.repairableItems.contains(entry);
    }

    public boolean isSnitchType(Block block) {
        for (FieldSettings fs : this.fieldDefinitions.values()) {
            if (!fs.hasDefaultFlag(FieldFlag.SNITCH) || !fs.getTypeEntry().equals(new BlockTypeEntry(block))) continue;
            return true;
        }
        return false;
    }

    public boolean isUnbreakableType(BlockTypeEntry type) {
        return this.getUnbreakableBlocks().contains(type);
    }

    public boolean isUnbreakableType(Block block) {
        return this.isUnbreakableType(new BlockTypeEntry(block));
    }

    public boolean isFieldType(Block block) {
        return this.fieldDefinitions.containsKey(new BlockTypeEntry(block));
    }

    public boolean isFieldType(Block block, ItemStack handItem) {
        return this.isFieldType(new BlockTypeEntry(block), handItem);
    }

    public boolean isFieldType(BlockTypeEntry type, ItemStack handItem) {
        if (!handItem.hasItemMeta()) {
            FieldSettings settings = this.fieldDefinitions.get(type);
            if (settings == null) {
                return false;
            }
            return settings.getMetaName().isEmpty();
        }
        for (FieldSettings fs : this.fieldDefinitions.values()) {
            if (!fs.matchesMetaName(handItem)) continue;
            return true;
        }
        return false;
    }

    public boolean isMetaFieldType(ItemStack item) {
        return item != null && item.getType() != Material.AIR && item.hasItemMeta() && this.isFieldType(new BlockTypeEntry(item), item);
    }

    public boolean isBypassBlock(Block block) {
        return this.getBypassBlocks().contains(new BlockTypeEntry(block));
    }

    public FieldSettings getFieldSettings(Block block) {
        return this.getFieldSettings(new BlockTypeEntry(block));
    }

    public FieldSettings getFieldSettings(Field field) {
        return this.getFieldSettings(field.getTypeEntry());
    }

    public FieldSettings getFieldSettings(BlockTypeEntry type) {
        return this.fieldDefinitions.get(type);
    }

    public HashMap<BlockTypeEntry, FieldSettings> getFieldSettings() {
        HashMap<BlockTypeEntry, FieldSettings> fs = new HashMap<BlockTypeEntry, FieldSettings>();
        fs.putAll(this.fieldDefinitions);
        return fs;
    }

    public FieldSettings getFieldSettings(String name) {
        for (FieldSettings fs : this.fieldDefinitions.values()) {
            if (!fs.getTitle().equals(name)) continue;
            return fs;
        }
        for (FieldSettings fs : this.fieldDefinitions.values()) {
            if (!fs.getTitle().startsWith(name)) continue;
            return fs;
        }
        for (FieldSettings fs : this.fieldDefinitions.values()) {
            if (!fs.getTitle().contains(name)) continue;
            return fs;
        }
        return null;
    }

    public List<String> getBlacklistedWorlds() {
        return Collections.unmodifiableList(this.blacklistedWorlds);
    }

    public int getMaxSnitchRecords() {
        return this.maxSnitchRecords;
    }

    public int getSaveFrequency() {
        return this.saveFrequency;
    }

    public List<String> getGriefUndoBlackList() {
        return Collections.unmodifiableList(this.griefUndoBlackList);
    }

    public BlockTypeEntry getVisualizeMarkBlock() {
        return this.visualizeMarkBlock;
    }

    public BlockTypeEntry getVisualizeBlock() {
        return this.visualizeBlock;
    }

    public int getVisualizeSeconds() {
        return this.visualizeSeconds;
    }

    public boolean isVisualizeEndOnMove() {
        return this.visualizeEndOnMove;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public List<LinkedHashMap<String, Object>> getForceFieldBlocks() {
        return Collections.unmodifiableList(this.forceFieldBlocks);
    }

    public List<BlockTypeEntry> getUnbreakableBlocks() {
        return Collections.unmodifiableList(this.unbreakableBlocks);
    }

    public List<BlockTypeEntry> getBypassBlocks() {
        return Collections.unmodifiableList(this.bypassBlocks);
    }

    public List<BlockTypeEntry> getUnprotectableBlocks() {
        return Collections.unmodifiableList(this.unprotectableBlocks);
    }

    public boolean isLogFire() {
        return this.logFire;
    }

    public boolean isLogEntry() {
        return this.logEntry;
    }

    public boolean isLogPlace() {
        return this.logPlace;
    }

    public boolean isLogUse() {
        return this.logUse;
    }

    public boolean isLogDestroy() {
        return this.logDestroy;
    }

    public boolean isLogDestroyArea() {
        return this.logDestroyArea;
    }

    public boolean isLogUnprotectable() {
        return this.logUnprotectable;
    }

    public boolean isLogPvp() {
        return this.logPvp;
    }

    public boolean isLogBypassPvp() {
        return this.logBypassPvp;
    }

    public boolean isLogBypassDelete() {
        return this.logBypassDelete;
    }

    public boolean isLogBypassPlace() {
        return this.logBypassPlace;
    }

    public boolean isLogBypassDestroy() {
        return this.logBypassDestroy;
    }

    public boolean isLogConflictPlace() {
        return this.logConflictPlace;
    }

    public boolean isNotifyPlace() {
        return this.notifyPlace;
    }

    public boolean isNotifyDestroy() {
        return this.notifyDestroy;
    }

    public boolean isNotifyBypassPvp() {
        return this.notifyBypassPvp;
    }

    public boolean isNotifyBypassPlace() {
        return this.notifyBypassPlace;
    }

    public boolean isNotifyBypassDestroy() {
        return this.notifyBypassDestroy;
    }

    public boolean isNotifyBypassUnprotectable() {
        return this.notifyBypassUnprotectable;
    }

    public boolean isWarnInstantHeal() {
        return this.warnInstantHeal;
    }

    public boolean isWarnSlowFeeding() {
        return this.warnSlowFeeding;
    }

    public boolean isWarnSlowRepair() {
        return this.warnSlowRepair;
    }

    public boolean isWarnSlowHeal() {
        return this.warnSlowHeal;
    }

    public boolean isWarnSlowDamage() {
        return this.warnSlowDamage;
    }

    public boolean isWarnFastDamage() {
        return this.warnFastDamage;
    }

    public boolean isWarnGiveAir() {
        return this.warnGiveAir;
    }

    public boolean isWarnPlace() {
        return this.warnPlace;
    }

    public boolean isWarnUse() {
        return this.warnUse;
    }

    public boolean isWarnDestroy() {
        return this.warnDestroy;
    }

    public boolean isWarnDestroyArea() {
        return this.warnDestroyArea;
    }

    public boolean isWarnUnprotectable() {
        return this.warnUnprotectable;
    }

    public boolean isWarnEntry() {
        return this.warnEntry;
    }

    public boolean isWarnPvp() {
        return this.warnPvp;
    }

    public boolean isWarnFire() {
        return this.warnFire;
    }

    public boolean isWarnLaunch() {
        return this.warnLaunch;
    }

    public boolean isWarnCannon() {
        return this.warnCannon;
    }

    public boolean isWarnMine() {
        return this.warnMine;
    }

    public boolean isPublicBlockDetails() {
        return this.publicBlockDetails;
    }

    public boolean isDropOnDelete() {
        return this.dropOnDelete;
    }

    public boolean isDisableAlertsForAdmins() {
        return this.disableAlertsForAdmins;
    }

    public boolean isDisableBypassAlertsForAdmins() {
        return this.disableBypassAlertsForAdmins;
    }

    public boolean isOffByDefault() {
        return this.offByDefault;
    }

    public int getLinesPerPage() {
        return this.linesPerPage;
    }

    public boolean isUseMysql() {
        return this.useMysql;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public List<Integer> getThroughFieldsSet() {
        return new ArrayList<Integer>(this.throughFieldsSet);
    }

    public HashSet<Byte> getThroughFieldsByteSet() {
        return this.throughFieldsByteSet;
    }

    public BlockTypeEntry getCuboidDefiningType() {
        return this.cuboidDefiningType;
    }

    public BlockTypeEntry getCuboidVisualizationType() {
        return this.cuboidVisualizationType;
    }

    public BlockTypeEntry getVisualizeFrameBlock() {
        return this.visualizeFrameBlock;
    }

    public int getVisualizeTicksBetweenSends() {
        return this.visualizeTicksBetweenSends;
    }

    public int getVisualizeSendSize() {
        return this.visualizeSendSize;
    }

    public int getPort() {
        return this.port;
    }

    public int getVisualizeDensity() {
        return this.visualizeDensity;
    }

    public int getGriefRevertMinInterval() {
        return this.griefRevertMinInterval;
    }

    public boolean isLogRollback() {
        return this.logRollback;
    }

    public boolean isNotifyRollback() {
        return this.notifyRollback;
    }

    public boolean isLogPlaceArea() {
        return this.logPlaceArea;
    }

    public void setVisualizeSendSize(int visualizeSendSize) {
        this.visualizeSendSize = visualizeSendSize;
    }

    public int getVisualizeMaxFields() {
        return this.visualizeMaxFields;
    }

    public void setVisualizeMaxFields(int visualizeMaxFields) {
        this.visualizeMaxFields = visualizeMaxFields;
    }

    public List<String> getAllEntryGroups() {
        return Collections.unmodifiableList(this.allEntryGroups);
    }

    public boolean isNotifyFlyZones() {
        return this.notifyFlyZones;
    }

    public boolean isNoRefunds() {
        return this.noRefunds;
    }

    public int getGlobalFieldLimit() {
        return this.globalFieldLimit;
    }

    public boolean isDisableGroundInfo() {
        return this.disableGroundInfo;
    }

    public boolean isSneakNormalBlock() {
        return this.sneakNormalBlock;
    }

    public boolean isShowDefaultWelcomeFarewellMessages() {
        return this.showDefaultWelcomeFarewellMessages;
    }

    public boolean isSneakPlaceFields() {
        return this.sneakPlaceFields;
    }

    public boolean isPreventDestroyEverywhere(String world) {
        return this.preventDestroyEverywhere.contains(world);
    }

    public boolean isPreventPlaceEverywhere(String world) {
        return this.preventPlaceEverywhere.contains(world);
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.config.set("settings.version", (Object)version);
        this.cleanConfig.set("settings.version", (Object)version);
        this.save();
        this.version = version;
    }

    public boolean isLogTranslocation() {
        return this.logTranslocation;
    }

    public boolean isNotifyTranslocation() {
        return this.notifyTranslocation;
    }

    public int getMaxSizeTranslocation() {
        return this.maxSizeTranslocation;
    }

    public void setMaxSizeTranslocation(int maxSizeTranslocation) {
        this.maxSizeTranslocation = maxSizeTranslocation;
    }

    public int getMaxSizeTranslocationForRedstone() {
        return this.maxSizeTranslocationForRedstone;
    }

    public void setMaxSizeTranslocationForRedstone(int maxSizeTranslocationForRedstone) {
        this.maxSizeTranslocationForRedstone = maxSizeTranslocationForRedstone;
    }

    public boolean isDisableSimpleClanHook() {
        return this.disableSimpleClanHook;
    }

    public boolean isLogRentsAndPurchases() {
        return this.logRentsAndPurchases;
    }

    public boolean isAutoAddClan() {
        return this.autoAddClan;
    }

    public boolean isNaturalFloorType(int type) {
        return type == 1 || type == 2 || type == 3 || type == 4 || type == 7 || type == 12 || type == 13 || type == 14 || type == 15 || type == 16 || type == 17 || type == 21 || type == 60 || type == 73 || type == 74 || type == 80 || type == 82 || type == 87 || type == 88 || type == 110 || type == 97 || type == 82 || type == 129;
    }

    public boolean isOncePerBlockOnMove() {
        return this.oncePerBlockOnMove;
    }

    public boolean isUseIdInSnitches() {
        return this.useIdInSnitches;
    }

    public int getFenceMaxDepth() {
        return this.fenceMaxDepth;
    }

    public boolean isCommandsToRentBuy() {
        return this.commandsToRentBuy;
    }

    public boolean isVisualizationNewStyle() {
        return this.visualizationNewStyle;
    }

    public boolean isPreventRemovalIfPlayerInField() {
        return this.preventRemovalIfPlayerInField;
    }

    public boolean isWarAllow() {
        return this.warAllow;
    }

    public void setWarAllow(boolean warAllow) {
        this.warAllow = warAllow;
    }

    public boolean isDisableMessages() {
        return this.disableMessages;
    }

    public int getMaxTargetDistance() {
        return this.maxTargetDistance;
    }

    public BlockTypeEntry getDefaulItemCurrency() {
        return this.defaulItemCurrency;
    }

    public boolean isVisualizeOnExpand() {
        return this.visualizeOnExpand;
    }

    public boolean isAutoAddTeam() {
        return this.autoAddTeam;
    }

    public int getPurgeAfterDays() {
        return this.purgeAfterDays;
    }

    public boolean isPurgeBannedPlayers() {
        return this.purgeBannedPlayers;
    }
}

