/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sacredlabyrinth.Phaed.PreciousStones.DirtyFieldReason;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.GriefBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.TranslocationBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.Unbreakable;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PurchaseEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.SnitchEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldSettings;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.DBCore;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.MySQLCore;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.SQLiteCore;
import net.sacredlabyrinth.Phaed.PreciousStones.uuid.UUIDMigration;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import ps.org.joda.time.DateTime;
import ps.org.joda.time.Days;

public class StorageManager {
    private DBCore core;
    private PreciousStones plugin;
    private final Map<Vec, Field> pending = new HashMap<Vec, Field>();
    private final Set<Field> pendingGrief = new HashSet<Field>();
    private final Map<Unbreakable, Boolean> pendingUb = new HashMap<Unbreakable, Boolean>();
    private final Map<String, Boolean> pendingPlayers = new HashMap<String, Boolean>();
    private final List<SnitchEntry> pendingSnitchEntries = new ArrayList<SnitchEntry>();
    private boolean haltUpdates;

    public StorageManager() {
        this.plugin = PreciousStones.getInstance();
        this.initiateDB();
        this.loadWorldData();
        this.saverScheduler();
        this.purgePlayers();
    }

    private void initiateDB() {
        if (this.plugin.getSettingsManager().isUseMysql()) {
            this.core = new MySQLCore(this.plugin.getSettingsManager().getHost(), this.plugin.getSettingsManager().getPort(), this.plugin.getSettingsManager().getDatabase(), this.plugin.getSettingsManager().getUsername(), this.plugin.getSettingsManager().getPassword());
            if (this.core.checkConnection().booleanValue()) {
                PreciousStones.log("dbMysqlConnected", new Object[0]);
                if (!this.core.existsTable("pstone_cuboids").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_cuboids", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_cuboids` (  `id` bigint(20) NOT NULL auto_increment, `parent` bigint(20) NOT NULL, `x` int(11) default NULL,  `y` int(11) default NULL, `z` int(11) default NULL,  `world` varchar(25) default NULL,  `minx` int(11) default NULL,  `maxx` int(11) default NULL,  `miny` int(11) default NULL,  `maxy` int(11) default NULL,  `minz` int(11) default NULL,  `maxz` int(11) default NULL,  `velocity` float default NULL,  `type_id` int(11) default NULL, `data` tinyint default 0,  `owner` varchar(16) NOT NULL,  `name` varchar(50) NOT NULL,  `packed_allowed` text NOT NULL, `last_used` bigint(20) Default NULL, `flags` TEXT NOT NULL, PRIMARY KEY  (`id`),  UNIQUE KEY `uq_cuboid_fields_1`  (`x`,`y`,`z`,`world`));");
                }
                if (!this.core.existsTable("pstone_fields").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_fields", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_fields` (  `id` bigint(20) NOT NULL auto_increment,  `x` int(11) default NULL,  `y` int(11) default NULL, `z` int(11) default NULL,  `world` varchar(25) default NULL,  `radius` int(11) default NULL,  `height` int(11) default NULL,  `velocity` float default NULL,  `type_id` int(11) default NULL,  `data` tinyint default 0, `owner` varchar(16) NOT NULL,  `name` varchar(50) NOT NULL,  `packed_allowed` text NOT NULL, `last_used` bigint(20) Default NULL, `flags` TEXT NOT NULL, PRIMARY KEY  (`id`),  UNIQUE KEY `uq_pstone_fields_1` (`x`,`y`,`z`,`world`));");
                }
                if (!this.core.existsTable("pstone_unbreakables").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_unbreakables", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_unbreakables` (  `id` bigint(20) NOT NULL auto_increment,  `x` int(11) default NULL,  `y` int(11) default NULL,  `z` int(11) default NULL,  `world` varchar(25) default NULL,  `owner` varchar(16) NOT NULL,  `type_id` int(11) default NULL,  `data` tinyint default 0, PRIMARY KEY  (`id`),  UNIQUE KEY `uq_pstone_unbreakables_1` (`x`,`y`,`z`,`world`));");
                }
                if (!this.core.existsTable("pstone_grief_undo").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_grief_undo", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_grief_undo` (  `id` bigint(20) NOT NULL auto_increment,  `date_griefed` bigint(20), `field_x` int(11) default NULL,  `field_y` int(11) default NULL, `field_z` int(11) default NULL, `world` varchar(25) NOT NULL, `x` int(11) default NULL,  `y` int(11) default NULL, `z` int(11) default NULL,  `type_id` int(11) NOT NULL,  `data` TINYINT NOT NULL,  `sign_text` varchar(75) NOT NULL, PRIMARY KEY  (`id`));");
                }
                if (!this.core.existsTable("pstone_translocations").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_translocations", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_translocations` (  `id` bigint(20) NOT NULL auto_increment,  `name` varchar(36) NOT NULL, `player_name` varchar(16) NOT NULL,  `minx` int(11) default NULL,  `maxx` int(11) default NULL, `miny` int(11) default NULL,  `maxy` int(11) default NULL,  `minz` int(11) default NULL,  `maxz` int(11) default NULL, PRIMARY KEY  (`id`),  UNIQUE KEY `uq_trans_1` (`name`,`player_name`));");
                }
                if (!this.core.existsTable("pstone_storedblocks").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_storedblocks", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_storedblocks` (  `id` bigint(20) NOT NULL auto_increment, `name` varchar(36) NOT NULL, `player_name` varchar(16) NOT NULL, `x` int(11) default NULL,  `y` int(11) default NULL, `z` int(11) default NULL, `world` varchar(25) NOT NULL, `type_id` int(11) NOT NULL,  `data` TINYINT NOT NULL,  `sign_text` varchar(75) NOT NULL, `applied` bit default 0, `contents` TEXT NOT NULL, PRIMARY KEY  (`id`),  UNIQUE KEY `uq_trans_2` (`x`,`y`,`z`,`world`));");
                }
                if (!this.core.existsTable("pstone_players").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_players", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_players` ( `id` bigint(20), `uuid` varchar(255) default NULL, `player_name` varchar(16) NOT NULL, `last_seen` bigint(20) default NULL, flags TEXT default NULL, PRIMARY KEY  (`player_name`));");
                }
                if (!this.core.existsTable("pstone_snitches").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_snitches", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_snitches` ( `id` bigint(20), `x` int(11) default NULL,  `y` int(11) default NULL, `z` int(11) default NULL,  `world` varchar(25) default NULL, `name` varchar(16) NOT NULL, `reason` varchar(20) default NULL, `details` varchar(50) default NULL, `count` int(11) default NULL, `date` varchar(25) default NULL, PRIMARY KEY  (`x`, `y`, `z`, `world`, `name`, `reason`, `details`));");
                    this.addIndexes();
                }
                if (!this.core.existsTable("pstone_purchase_payments").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_purchase_payments", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_purchase_payments` ( `id` bigint(20), `buyer` varchar(16) default NULL, `owner` varchar(16) NOT NULL, `item` varchar(20) default NULL,  `amount` int(11) default NULL, `fieldName` varchar(255) default NULL, `coords` varchar(255) default NULL);");
                    this.addIndexes();
                }
            } else {
                PreciousStones.log("dbMysqlFailed", new Object[0]);
            }
        } else {
            this.core = new SQLiteCore("PreciousStones", this.plugin.getDataFolder().getPath());
            if (this.core.checkConnection().booleanValue()) {
                PreciousStones.log("dbSqliteConnected", new Object[0]);
                if (!this.core.existsTable("pstone_cuboids").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_cuboids", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_cuboids` (  `id` INTEGER PRIMARY KEY,  `parent` bigint(20) NOT NULL, `x` int(11) default NULL,  `y` int(11) default NULL, `z` int(11) default NULL,  `world` varchar(25) default NULL,  `minx` int(11) default NULL,  `maxx` int(11) default NULL,  `miny` int(11) default NULL,  `maxy` int(11) default NULL,  `minz` int(11) default NULL,  `maxz` int(11) default NULL,  `velocity` float default NULL,  `type_id` int(11) default NULL,  `data` tinyint default 0, `owner` varchar(16) NOT NULL,  `name` varchar(50) NOT NULL,  `packed_allowed` text NOT NULL, `last_used` bigint(20) Default NULL, `flags` TEXT NOT NULL, UNIQUE (`x`,`y`,`z`,`world`));");
                }
                if (!this.core.existsTable("pstone_fields").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_fields", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_fields` (  `id` INTEGER PRIMARY KEY, `x` int(11) default NULL,  `y` int(11) default NULL, `z` int(11) default NULL,  `world` varchar(25) default NULL,  `radius` int(11) default NULL,  `height` int(11) default NULL,  `velocity` float default NULL,  `type_id` int(11) default NULL,  `data` tinyint default 0, `owner` varchar(16) NOT NULL,  `name` varchar(50) NOT NULL,  `packed_allowed` text NOT NULL, `last_used` bigint(20) Default NULL, `flags` TEXT NOT NULL, UNIQUE (`x`,`y`,`z`,`world`));");
                }
                if (!this.core.existsTable("pstone_unbreakables").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_unbreakables", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_unbreakables` (  `id` INTEGER PRIMARY KEY, `x` int(11) default NULL,  `y` int(11) default NULL,  `z` int(11) default NULL,  `world` varchar(25) default NULL,  `owner` varchar(16) NOT NULL,  `type_id` int(11) default NULL,`data` tinyint default 0, UNIQUE (`x`,`y`,`z`,`world`));");
                }
                if (!this.core.existsTable("pstone_grief_undo").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_grief_undo", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_grief_undo` (  `id` INTEGER PRIMARY KEY,  `date_griefed` bigint(20), `field_x` int(11) default NULL,  `field_y` int(11) default NULL, `field_z` int(11) default NULL, `world` varchar(25) NOT NULL, `x` int(11) default NULL,  `y` int(11) default NULL, `z` int(11) default NULL, `type_id` int(11) NOT NULL,  `data` TINYINT NOT NULL,  `sign_text` varchar(75) NOT NULL);");
                }
                if (!this.core.existsTable("pstone_translocations").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_translocations", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_translocations` (  `id` INTEGER PRIMARY KEY,  `name` varchar(36) NOT NULL, `player_name` varchar(16) NOT NULL,  `minx` int(11) default NULL,  `maxx` int(11) default NULL, `miny` int(11) default NULL,  `maxy` int(11) default NULL,  `minz` int(11) default NULL,  `maxz` int(11) default NULL, UNIQUE (`name`,`player_name`));");
                }
                if (!this.core.existsTable("pstone_storedblocks").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_storedblocks", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_storedblocks` (  `id` INTEGER PRIMARY KEY,  `name` varchar(36) NOT NULL, `player_name` varchar(16) NOT NULL,  `x` int(11) default NULL,  `y` int(11) default NULL, `z` int(11) default NULL, `world` varchar(25) NOT NULL, `type_id` int(11) NOT NULL, `data` TINYINT NOT NULL, `sign_text` varchar(75) NOT NULL, `applied` bit default 0, `contents` TEXT NOT NULL, UNIQUE (`x`,`y`,`z`,`world`));");
                }
                if (!this.core.existsTable("pstone_players").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_players", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_players` ( `id` bigint(20), `uuid` varchar(255) default NULL, `player_name` varchar(16) NOT NULL, `last_seen` bigint(20) default NULL, flags TEXT default NULL, PRIMARY KEY (`player_name`));");
                }
                if (!this.core.existsTable("pstone_snitches").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_snitches", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_snitches` ( `id` bigint(20), `x` int(11) default NULL,  `y` int(11) default NULL, `z` int(11) default NULL,  `world` varchar(25) default NULL, `name` varchar(16) NOT NULL, `reason` varchar(20) default NULL, `details` varchar(50) default NULL, `count` int(11) default NULL, `date` varchar(25) default NULL, PRIMARY KEY  (`x`, `y`, `z`, `world`, `name`, `reason`, `details`));");
                    this.addIndexes();
                }
                if (!this.core.existsTable("pstone_purchase_payments").booleanValue()) {
                    PreciousStones.log("Creating table: pstone_purchase_payments", new Object[0]);
                    this.core.execute("CREATE TABLE IF NOT EXISTS `pstone_purchase_payments` ( `id` bigint(20), `buyer` varchar(16) default NULL, `owner` varchar(16) NOT NULL, `item` varchar(20) default NULL,  `amount` int(11) default NULL, `fieldName` varchar(255) default NULL, `coords` varchar(255) default NULL);");
                    this.addIndexes();
                }
            } else {
                PreciousStones.log("dbSqliteFailed", new Object[0]);
            }
        }
        if (this.plugin.getSettingsManager().getVersion() < 9.0) {
            this.addData();
            this.plugin.getSettingsManager().setVersion(9);
        }
        if (this.plugin.getSettingsManager().getVersion() < 10.0) {
            this.addSnitchDate();
            this.plugin.getSettingsManager().setVersion(10);
        }
        if (this.plugin.getSettingsManager().isUseMysql() && this.plugin.getSettingsManager().getVersion() < 12.0) {
            this.resetLastSeen();
            this.plugin.getSettingsManager().setVersion(12);
        }
        if (!this.core.existsColumn("pstone_players", "uuid").booleanValue()) {
            this.updateUUID();
            this.addIndexes();
        }
    }

    private void updateUUID() {
        String query = "ALTER TABLE `pstone_players` ADD `uuid` VARCHAR( 255 ) DEFAULT NULL;";
        this.core.execute(query);
        PreciousStones.log("Added UUID modification to database", new Object[0]);
    }

    public void addIndexes() {
        if (this.plugin.getSettingsManager().isUseMysql()) {
            String query = "ALTER TABLE `pstone_grief_undo` ADD UNIQUE KEY `key_grief_locs` (`x`, `y`, `z`, `world`);";
            this.core.execute(query);
            query = "ALTER TABLE `pstone_fields` ADD INDEX `indx_field_owner` (`owner`);";
            this.core.execute(query);
            query = "ALTER TABLE `pstone_players` ADD UNIQUE `unq_uuid` (uuid);";
            this.core.execute(query);
            query = "ALTER TABLE `pstone_players` ADD INDEX `inx_player_name` (player_name);";
            this.core.execute(query);
            query = "ALTER TABLE `pstone_cuboids` ADD INDEX `indx_cuboids_owner` (`owner`);";
            this.core.execute(query);
            query = "ALTER TABLE `pstone_cuboids` ADD INDEX `indx_cuboids_parent` (`parent`);";
            this.core.execute(query);
            query = "ALTER TABLE `pstone_unbreakables` ADD INDEX `indx_unbreakables_owner` (`owner`);";
            this.core.execute(query);
            query = "ALTER TABLE `pstone_storedblocks` ADD INDEX `indx_storedblocks_1` (`name`, `player_name`, `applied`);";
            this.core.execute(query);
            query = "ALTER TABLE `pstone_storedblocks` ADD INDEX `indx_storedblocks_2` (`name`, `player_name`, `applied`, `type_id`, `data`);";
            this.core.execute(query);
        } else {
            String query = "CREATE INDEX IF NOT EXISTS `indx_field_owner` ON `pstone_fields` (`owner`);";
            this.core.execute(query);
            query = "CREATE UNIQUE INDEX IF NOT EXISTS `indx_players_uuid` ON `pstone_players` (`uuid`);";
            this.core.execute(query);
            query = "CREATE UNIQUE INDEX IF NOT EXISTS `indx_player_name` ON `pstone_players` (`player_name`);";
            this.core.execute(query);
            query = "CREATE INDEX IF NOT EXISTS `indx_cuboids_owner` ON `pstone_cuboids` (`owner`);";
            this.core.execute(query);
            query = "CREATE INDEX IF NOT EXISTS `indx_cuboids_parent` ON `pstone_cuboids` (`parent`);";
            this.core.execute(query);
            query = "CREATE INDEX IF NOT EXISTS `indx_unbreakables_owner` ON `pstone_unbreakables` (`owner`);";
            this.core.execute(query);
        }
        PreciousStones.log("Added new indexes to database", new Object[0]);
    }

    private void resetLastSeen() {
        PreciousStones.log("Updating last seen dates to new time format", new Object[0]);
        if (!this.core.getDataType("pstone_grief_undo", "date_griefed").equals("bigint")) {
            this.core.execute("alter table pstone_grief_undo modify date_griefed bigint");
            this.core.execute("update pstone_grief_undo date_griefed = " + new DateTime().getMillis());
        }
        if (!this.core.getDataType("pstone_fields", "last_used").equals("bigint")) {
            this.core.execute("alter table pstone_fields modify last_used bigint");
            this.core.execute("update pstone_fields last_used = " + new DateTime().getMillis());
        }
        if (!this.core.getDataType("pstone_cuboids", "last_used").equals("bigint")) {
            this.core.execute("alter table pstone_cuboids modify last_used bigint");
            this.core.execute("update pstone_cuboids last_used = " + new DateTime().getMillis());
        }
        if (!this.core.getDataType("pstone_players", "last_seen").equals("bigint")) {
            this.core.execute("alter table pstone_players modify last_seen bigint");
            this.core.execute("update pstone_players last_seen = " + new DateTime().getMillis());
        }
    }

    private void addData() {
        if (!this.core.getDataType("pstone_fields", "data").equals("tinyint")) {
            this.core.execute("alter table pstone_fields add column data tinyint default 0");
        }
        if (!this.core.getDataType("pstone_cuboids", "data").equals("tinyint")) {
            this.core.execute("alter table pstone_cuboids add column data tinyint default 0");
        }
        if (!this.core.getDataType("pstone_unbreakables", "data").equals("tinyint")) {
            this.core.execute("alter table pstone_unbreakables add column data tinyint default 0");
        }
    }

    private void addSnitchDate() {
        if (!this.core.getDataType("pstone_snitches", "date").equals("varchar")) {
            this.core.execute("alter table pstone_snitches add column date varchar(25) default NULL");
        }
    }

    public void closeConnection() {
        this.core.close();
    }

    public void loadWorldData() {
        PreciousStones.debug("finalizing queue", new Object[0]);
        this.plugin.getForceFieldManager().offerAllDirtyFields();
        this.processQueue();
        PreciousStones.debug("clearing fields from memory", new Object[0]);
        this.plugin.getForceFieldManager().clearChunkLists();
        this.plugin.getUnbreakableManager().clearChunkLists();
        final List worlds = this.plugin.getServer().getWorlds();
        this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                PreciousStones.debug("loading fields by world", new Object[0]);
                for (World world : worlds) {
                    StorageManager.this.loadWorldFields(world);
                    StorageManager.this.loadWorldUnbreakables(world);
                }
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWorldFields(World world) {
        int cuboidCount;
        int fieldCount;
        List<Field> fields;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            fields = this.getFields(world.getName());
            fieldCount = fields.size();
            Collection<Field> cuboids = this.getCuboidFields(world.getName());
            cuboidCount = cuboids.size();
            fields.addAll(cuboids);
        }
        for (Field field : fields) {
            this.plugin.getForceFieldManager().addToCollection(field);
            if (field.hasFlag(FieldFlag.GRIEF_REVERT) && field.getRevertingModule().getRevertSecs() > 0) {
                this.plugin.getGriefUndoManager().register(field);
            }
            if (field.hasFlag(FieldFlag.TRANSLOCATION) && field.isNamed()) {
                boolean applied = this.isTranslocationApplied(field.getName(), field.getOwner());
                field.setDisabled(!applied, true);
                int count = this.totalTranslocationCount(field.getName(), field.getOwner());
                field.getTranslocatingModule().setTranslocationSize(count);
            }
            if (!field.hasFlag(FieldFlag.RENTABLE) && !field.hasFlag(FieldFlag.SHAREABLE)) continue;
            field.getRentingModule().scheduleNextRentUpdate();
        }
        if (fieldCount > 0) {
            PreciousStones.log("countsFields", world.getName(), fieldCount);
        }
        if (cuboidCount > 0) {
            PreciousStones.log("countsCuboids", world.getName(), cuboidCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enableAllFlags(String flagStr) {
        int changed = 0;
        ArrayList<Field> fields = new ArrayList<Field>();
        StorageManager storageManager = this;
        synchronized (storageManager) {
            List worlds = this.plugin.getServer().getWorlds();
            for (World world : worlds) {
                fields.addAll(this.getFields(world.getName()));
                fields.addAll(this.getCuboidFields(world.getName()));
            }
        }
        this.plugin.getForceFieldManager().clearChunkLists();
        for (Field field : fields) {
            if (field.hasFlag(flagStr)) {
                ++changed;
                field.getFlagsModule().disableFlag(flagStr, false);
                field.getFlagsModule().dirtyFlags("enableAllFlags");
            }
            this.plugin.getForceFieldManager().addToCollection(field);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int disableAllFlags(String flagStr) {
        int changed = 0;
        ArrayList<Field> fields = new ArrayList<Field>();
        StorageManager storageManager = this;
        synchronized (storageManager) {
            List worlds = this.plugin.getServer().getWorlds();
            for (World world : worlds) {
                fields.addAll(this.getFields(world.getName()));
                fields.addAll(this.getCuboidFields(world.getName()));
            }
        }
        this.plugin.getForceFieldManager().clearChunkLists();
        for (Field field : fields) {
            if (field.getFlagsModule().hasDisabledFlag(flagStr)) {
                ++changed;
                field.getFlagsModule().enableFlag(flagStr);
                field.getFlagsModule().dirtyFlags("disableAllFlags");
            }
            this.plugin.getForceFieldManager().addToCollection(field);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWorldUnbreakables(World world) {
        List<Unbreakable> unbreakables;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            unbreakables = this.getUnbreakables(world.getName());
        }
        for (Unbreakable ub : unbreakables) {
            this.plugin.getUnbreakableManager().addToCollection(ub);
        }
        if (unbreakables.size() > 0) {
            PreciousStones.log("countsUnbreakables", world, unbreakables.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerField(Field field) {
        Map<Vec, Field> map = this.pending;
        synchronized (map) {
            this.pending.put(field.toVec(), field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerGrief(Field field) {
        Set<Field> set = this.pendingGrief;
        synchronized (set) {
            this.pendingGrief.add(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerUnbreakable(Unbreakable ub, boolean insert) {
        Map<Unbreakable, Boolean> map = this.pendingUb;
        synchronized (map) {
            this.pendingUb.put(ub, insert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerPlayer(String playerName) {
        Map<String, Boolean> map = this.pendingPlayers;
        synchronized (map) {
            this.pendingPlayers.put(playerName, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerDeletePlayer(String playerName) {
        Map<String, Boolean> map = this.pendingPlayers;
        synchronized (map) {
            this.pendingPlayers.put(playerName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerSnitchEntry(SnitchEntry se) {
        List<SnitchEntry> list = this.pendingSnitchEntries;
        synchronized (list) {
            this.pendingSnitchEntries.add(se);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Field> getFields(String worldName) {
        ArrayList<Field> out = new ArrayList<Field>();
        boolean foundInWrongTable = false;
        String query = "SELECT pstone_fields.id as id, x, y, z, radius, height, type_id, data, velocity, world, owner, name, packed_allowed, last_used, flags FROM pstone_fields WHERE world = '" + Helper.escapeQuotes(worldName) + "';";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        long id = res.getLong("id");
                        int x = res.getInt("x");
                        int y = res.getInt("y");
                        int z = res.getInt("z");
                        int radius = res.getInt("radius");
                        int height = res.getInt("height");
                        int type_id = res.getInt("type_id");
                        byte data = res.getByte("data");
                        float velocity = res.getFloat("velocity");
                        String world = res.getString("world");
                        String owner = res.getString("owner");
                        String name = res.getString("name");
                        String flags = res.getString("flags");
                        String packed_allowed = res.getString("packed_allowed");
                        long last_used = res.getLong("last_used");
                        BlockTypeEntry type = new BlockTypeEntry(type_id, data);
                        Field field = new Field(x, y, z, radius, height, velocity, world, type, owner, name, last_used);
                        field.setPackedAllowed(packed_allowed);
                        field.setId(id);
                        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(field);
                        if (fs == null) continue;
                        field.setSettings(fs);
                        field.getFlagsModule().setFlags(flags);
                        if (fs.getAutoDisableTime() > 0) {
                            field.setDisabled(true, true);
                        }
                        out.add(field);
                        if (!fs.hasDefaultFlag(FieldFlag.CUBOID)) continue;
                        this.deleteFieldFromBothTables(field);
                        this.insertField(field);
                        foundInWrongTable = true;
                    }
                    catch (Exception ex) {
                        System.out.print(ex.getMessage());
                        ex.printStackTrace();
                    }
                }
            }
            catch (SQLException ex) {
                System.out.print(ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (foundInWrongTable) {
            System.out.print("[PreciousStones] Fields found in wrong table, moving...");
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Field> getCuboidFields(String worldName) {
        long id;
        HashMap<Long, Field> out = new HashMap<Long, Field>();
        boolean foundInWrongTable = false;
        String query = "SELECT pstone_cuboids.id as id, x, y, z, minx, miny, minz, maxx, maxy, maxz, type_id, data, velocity, world, owner, name, packed_allowed, last_used, flags  FROM  pstone_cuboids WHERE pstone_cuboids.parent = 0 AND world = '" + Helper.escapeQuotes(worldName) + "';";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        id = res.getLong("id");
                        int x = res.getInt("x");
                        int y = res.getInt("y");
                        int z = res.getInt("z");
                        int minx = res.getInt("minx");
                        int miny = res.getInt("miny");
                        int minz = res.getInt("minz");
                        int maxx = res.getInt("maxx");
                        int maxy = res.getInt("maxy");
                        int maxz = res.getInt("maxz");
                        int type_id = res.getInt("type_id");
                        byte data = res.getByte("data");
                        float velocity = res.getFloat("velocity");
                        String world = res.getString("world");
                        String owner = res.getString("owner");
                        String name = res.getString("name");
                        String flags = res.getString("flags");
                        String packed_allowed = res.getString("packed_allowed");
                        long last_used = res.getLong("last_used");
                        BlockTypeEntry type = new BlockTypeEntry(type_id, data);
                        Field field = new Field(x, y, z, minx, miny, minz, maxx, maxy, maxz, velocity, world, type, owner, name, last_used);
                        field.setPackedAllowed(packed_allowed);
                        field.setId(id);
                        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(field);
                        if (fs == null) continue;
                        field.setSettings(fs);
                        field.getFlagsModule().setFlags(flags);
                        if (fs.getAutoDisableTime() > 0) {
                            field.setDisabled(true, true);
                        }
                        out.put(id, field);
                        if (fs.hasDefaultFlag(FieldFlag.CUBOID)) continue;
                        this.deleteFieldFromBothTables(field);
                        this.insertField(field);
                        foundInWrongTable = true;
                    }
                    catch (Exception ex) {
                        System.out.print(ex.getMessage());
                        ex.printStackTrace();
                    }
                }
            }
            catch (SQLException ex) {
                System.out.print(ex.getMessage());
                ex.printStackTrace();
            }
        }
        if ((res = this.core.select(query = "SELECT pstone_cuboids.id as id, parent, x, y, z, minx, miny, minz, maxx, maxy, maxz, type_id, data, velocity, world, owner, name, packed_allowed, last_used, flags FROM  pstone_cuboids WHERE pstone_cuboids.parent > 0 AND world = '" + Helper.escapeQuotes(worldName) + "';")) != null) {
            try {
                while (res.next()) {
                    try {
                        id = res.getLong("id");
                        long parent = res.getLong("parent");
                        int x = res.getInt("x");
                        int y = res.getInt("y");
                        int z = res.getInt("z");
                        int minx = res.getInt("minx");
                        int miny = res.getInt("miny");
                        int minz = res.getInt("minz");
                        int maxx = res.getInt("maxx");
                        int maxy = res.getInt("maxy");
                        int maxz = res.getInt("maxz");
                        int type_id = res.getInt("type_id");
                        byte data = res.getByte("data");
                        float velocity = res.getFloat("velocity");
                        String world = res.getString("world");
                        String owner = res.getString("owner");
                        String name = res.getString("name");
                        String flags = res.getString("flags");
                        String packed_allowed = res.getString("packed_allowed");
                        long last_used = res.getLong("last_used");
                        BlockTypeEntry type = new BlockTypeEntry(type_id, data);
                        Field field = new Field(x, y, z, minx, miny, minz, maxx, maxy, maxz, velocity, world, type, owner, name, last_used);
                        field.setPackedAllowed(packed_allowed);
                        Field parentField = (Field)out.get(parent);
                        if (parentField != null) {
                            field.setParent(parentField);
                            parentField.addChild(field);
                        } else {
                            field.markForDeletion();
                            this.offerField(field);
                        }
                        field.setId(id);
                        FieldSettings fs = this.plugin.getSettingsManager().getFieldSettings(field);
                        if (fs == null) continue;
                        field.setSettings(fs);
                        field.getFlagsModule().setFlags(flags);
                        out.put(id, field);
                    }
                    catch (Exception ex) {
                        System.out.print(ex.getMessage());
                        ex.printStackTrace();
                    }
                }
            }
            catch (SQLException ex) {
                System.out.print(ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (foundInWrongTable) {
            PreciousStones.log("fieldsInWrongTable", new Object[0]);
        }
        return out.values();
    }

    public void migrate(String oldUsername, String newUsername) {
        this.plugin.getForceFieldManager().migrateUsername(oldUsername, newUsername);
        this.plugin.getUnbreakableManager().migrateUsername(oldUsername, newUsername);
        String updateQuery = "UPDATE `pstone_storedblocks` SET player_name = '" + newUsername + "' WHERE player_name = '" + oldUsername + "';";
        this.core.execute(updateQuery);
        updateQuery = "UPDATE `pstone_translocations` SET player_name = '" + newUsername + "' WHERE player_name = '" + oldUsername + "';";
        this.core.execute(updateQuery);
        updateQuery = "UPDATE `pstone_players` SET player_name = '" + newUsername + "' WHERE player_name = '" + oldUsername + "';";
        this.core.execute(updateQuery);
        PreciousStones.log("[Username Changed] From: " + oldUsername + " To: " + newUsername, new Object[0]);
        Player player = this.plugin.getServer().getPlayerExact(newUsername);
        if (player != null) {
            ChatHelper.send((CommandSender)player, "usernameChanged", new Object[0]);
        }
    }

    public void deletePlayerAndData(String playerName) {
        int purged = this.plugin.getForceFieldManager().deleteBelonging(playerName);
        if (purged > 0) {
            PreciousStones.log("countsPurgedFields", playerName, purged);
        }
        if ((purged = this.plugin.getUnbreakableManager().deleteBelonging(playerName)) > 0) {
            PreciousStones.log("countsPurgedUnbreakables", playerName, purged);
        }
        this.offerDeletePlayer(playerName);
    }

    protected PlayerEntry extractPlayer(ResultSet res) {
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        PlayerEntry data = new PlayerEntry();
                        String uuid = res.getString("uuid");
                        if (uuid != null && uuid.equalsIgnoreCase("null")) {
                            uuid = null;
                        }
                        String name = res.getString("player_name");
                        long last_seen = res.getLong("last_seen");
                        String flags = res.getString("flags");
                        if (last_seen > 0L) {
                            int lastSeenDays = Days.daysBetween(new DateTime(last_seen), new DateTime()).getDays();
                            PreciousStones.debug("Player last seen: %s [%s]", lastSeenDays, name);
                        }
                        data.setName(name);
                        data.setFlags(flags);
                        if (uuid != null) {
                            data.setOnlineUUID(UUID.fromString(uuid));
                        } else {
                            UUID pulledUUID = UUIDMigration.findPlayerUUID(name);
                            if (pulledUUID != null) {
                                data.setOnlineUUID(pulledUUID);
                                PreciousStones.log("[Online UUID Found] Player: " + name + " UUID: " + pulledUUID.toString(), new Object[0]);
                                this.plugin.getStorageManager().updatePlayerUUID(name, pulledUUID);
                            }
                        }
                        return data;
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().log(Level.WARNING, "Error extracting player data", ex);
                    }
                }
            }
            catch (SQLException ex) {
                PreciousStones.getLog().log(Level.WARNING, "Error querying for player data", ex);
            }
        }
        return null;
    }

    public PlayerEntry extractPlayer(String playerName) {
        String query = "SELECT * FROM pstone_players WHERE player_name = '" + Helper.escapeQuotes(playerName) + "';";
        ResultSet res = this.core.select(query);
        return this.extractPlayer(res);
    }

    public PlayerEntry extractPlayer(UUID uuid) {
        String query = "SELECT * FROM pstone_players WHERE uuid = '" + uuid + "';";
        ResultSet res = this.core.select(query);
        return this.extractPlayer(res);
    }

    public PlayerEntry createPlayer(String playerName, UUID uuid) {
        PlayerEntry data = new PlayerEntry();
        data.setName(playerName);
        data.setOnlineUUID(uuid);
        PreciousStones.log("[New Player]: " + playerName + " UUID: " + uuid, new Object[0]);
        return data;
    }

    public void purgePlayers() {
        int purgeDays = this.plugin.getSettingsManager().getPurgeAfterDays();
        long lastSeen = new DateTime().minusDays(purgeDays).getMillis();
        String query = "SELECT player_name FROM pstone_players WHERE last_seen < " + lastSeen + ";";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String name = res.getString("player_name");
                        this.deletePlayerAndData(name);
                    }
                    catch (Exception ex) {}
                }
            }
            catch (SQLException ex) {
                System.out.print(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public List<Unbreakable> getUnbreakables(String worldName) {
        ArrayList<Unbreakable> out = new ArrayList<Unbreakable>();
        String query = "SELECT * FROM  `pstone_unbreakables` WHERE world = '" + Helper.escapeQuotes(worldName) + "';";
        ResultSet res = this.core.select(query);
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        int x = res.getInt("x");
                        int y = res.getInt("y");
                        int z = res.getInt("z");
                        int type_id = res.getInt("type_id");
                        byte data = res.getByte("data");
                        String world = res.getString("world");
                        String owner = res.getString("owner");
                        BlockTypeEntry type = new BlockTypeEntry(type_id, data);
                        Unbreakable ub = new Unbreakable(x, y, z, world, type, owner);
                        out.add(ub);
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                System.out.print(ex.getMessage());
                ex.printStackTrace();
            }
        }
        return out;
    }

    private void updateGrief(Field field) {
        if (field.isDirty(DirtyFieldReason.GRIEF_BLOCKS)) {
            Queue<GriefBlock> grief = field.getRevertingModule().getGrief();
            for (GriefBlock gb : grief) {
                this.insertBlockGrief(field, gb);
            }
        }
    }

    public void updateField(Field field) {
        String subQuery = "";
        if (field.isDirty(DirtyFieldReason.OWNER)) {
            subQuery = subQuery + "owner = '" + Helper.escapeQuotes(field.getOwner()) + "',";
        }
        if (field.isDirty(DirtyFieldReason.RADIUS)) {
            subQuery = subQuery + "radius = " + field.getRadius() + ",";
        }
        if (field.isDirty(DirtyFieldReason.HEIGHT)) {
            subQuery = subQuery + "height = " + field.getHeight() + ",";
        }
        if (field.isDirty(DirtyFieldReason.VELOCITY)) {
            subQuery = subQuery + "velocity = " + field.getVelocity() + ",";
        }
        if (field.isDirty(DirtyFieldReason.NAME)) {
            subQuery = subQuery + "name = '" + Helper.escapeQuotes(field.getName()) + "',";
        }
        if (field.isDirty(DirtyFieldReason.ALLOWED)) {
            subQuery = subQuery + "packed_allowed = '" + Helper.escapeQuotes(field.getPackedAllowed()) + "',";
        }
        if (field.isDirty(DirtyFieldReason.LASTUSED)) {
            subQuery = subQuery + "last_used = " + new DateTime().getMillis() + ",";
        }
        if (field.isDirty(DirtyFieldReason.FLAGS)) {
            subQuery = subQuery + "flags = '" + Helper.escapeQuotes(field.getFlagsModule().getFlagsAsString()) + "',";
        }
        if (field.isDirty(DirtyFieldReason.DIMENSIONS)) {
            subQuery = subQuery + "minx = " + field.getMinx() + "," + "miny = " + field.getMiny() + "," + "minz = " + field.getMinz() + "," + "maxx = " + field.getMaxx() + "," + "maxy = " + field.getMaxy() + "," + "maxz = " + field.getMaxz() + ",";
        }
        if (!subQuery.isEmpty()) {
            String query = "UPDATE `pstone_fields` SET " + Helper.stripTrailing(subQuery, ",") + " WHERE x = " + field.getX() + " AND y = " + field.getY() + " AND z = " + field.getZ() + " AND world = '" + Helper.escapeQuotes(field.getWorld()) + "';";
            if (field.hasFlag(FieldFlag.CUBOID)) {
                query = "UPDATE `pstone_cuboids` SET " + Helper.stripTrailing(subQuery, ",") + " WHERE x = " + field.getX() + " AND y = " + field.getY() + " AND z = " + field.getZ() + " AND world = '" + Helper.escapeQuotes(field.getWorld()) + "';";
            }
            this.core.execute(query);
        }
        field.clearDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertField(Field field) {
        Vec vec = field.toVec();
        if (this.pending.containsKey(vec)) {
            this.processSingleField(this.pending.get(field.toVec()));
        }
        String query = "INSERT INTO `pstone_fields` (  `x`,  `y`, `z`, `world`, `radius`, `height`, `velocity`, `type_id`, `data`, `owner`, `name`, `packed_allowed`, `last_used`, `flags`) ";
        String values = "VALUES ( " + field.getX() + "," + field.getY() + "," + field.getZ() + ",'" + Helper.escapeQuotes(field.getWorld()) + "'," + field.getRadius() + "," + field.getHeight() + "," + field.getVelocity() + "," + field.getTypeId() + "," + field.getData() + ",'" + field.getOwner() + "','" + Helper.escapeQuotes(field.getName()) + "','" + Helper.escapeQuotes(field.getPackedAllowed()) + "','" + new DateTime().getMillis() + "','" + Helper.escapeQuotes(field.getFlagsModule().getFlagsAsString()) + "');";
        if (field.hasFlag(FieldFlag.CUBOID)) {
            query = "INSERT INTO `pstone_cuboids` ( `parent`, `x`,  `y`, `z`, `world`, `minx`, `miny`, `minz`, `maxx`, `maxy`, `maxz`, `velocity`, `type_id`, `data`, `owner`, `name`, `packed_allowed`, `last_used`, `flags`) ";
            values = "VALUES ( " + (field.getParent() == null ? 0L : field.getParent().getId()) + "," + field.getX() + "," + field.getY() + "," + field.getZ() + ",'" + Helper.escapeQuotes(field.getWorld()) + "'," + field.getMinx() + "," + field.getMiny() + "," + field.getMinz() + "," + field.getMaxx() + "," + field.getMaxy() + "," + field.getMaxz() + "," + field.getVelocity() + "," + field.getTypeId() + "," + field.getData() + ",'" + field.getOwner() + "','" + Helper.escapeQuotes(field.getName()) + "','" + Helper.escapeQuotes(field.getPackedAllowed()) + "','" + new DateTime().getMillis() + "','" + Helper.escapeQuotes(field.getFlagsModule().getFlagsAsString()) + "');";
        }
        StorageManager storageManager = this;
        synchronized (storageManager) {
            field.setId(this.core.insert(query + values));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteField(Field field) {
        String query = "DELETE FROM `pstone_fields` WHERE x = " + field.getX() + " AND y = " + field.getY() + " AND z = " + field.getZ() + " AND world = '" + Helper.escapeQuotes(field.getWorld()) + "';";
        if (field.hasFlag(FieldFlag.CUBOID)) {
            query = "DELETE FROM `pstone_cuboids` WHERE x = " + field.getX() + " AND y = " + field.getY() + " AND z = " + field.getZ() + " AND world = '" + Helper.escapeQuotes(field.getWorld()) + "';";
        }
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFieldFromBothTables(Field field) {
        String query = "DELETE FROM `pstone_fields` WHERE x = " + field.getX() + " AND y = " + field.getY() + " AND z = " + field.getZ() + " AND world = '" + Helper.escapeQuotes(field.getWorld()) + "';";
        String query2 = "DELETE FROM `pstone_cuboids` WHERE x = " + field.getX() + " AND y = " + field.getY() + " AND z = " + field.getZ() + " AND world = '" + Helper.escapeQuotes(field.getWorld()) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
            this.core.delete(query2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFields(String playerName) {
        String query = "DELETE FROM `pstone_fields` WHERE owner = '" + Helper.escapeQuotes(playerName) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUnbreakables(String playerName) {
        String query = "DELETE FROM `pstone_unbreakables` WHERE owner = '" + Helper.escapeQuotes(playerName) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUnbreakable(Unbreakable ub) {
        String query = "INSERT INTO `pstone_unbreakables` (  `x`,  `y`, `z`, `world`, `owner`, `type_id`, `data`) ";
        String values = "VALUES ( " + ub.getX() + "," + ub.getY() + "," + ub.getZ() + ",'" + Helper.escapeQuotes(ub.getWorld()) + "','" + ub.getOwner() + "'," + ub.getTypeId() + "," + ub.getData() + ");";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.insert(query + values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUnbreakable(Unbreakable ub) {
        String query = "DELETE FROM `pstone_unbreakables` WHERE x = " + ub.getX() + " AND y = " + ub.getY() + " AND z = " + ub.getZ() + " AND world = '" + Helper.escapeQuotes(ub.getWorld()) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPendingPurchasePayment(PurchaseEntry purchase) {
        BlockTypeEntry item = purchase.getItem();
        String itemName = item == null ? null : item.toString();
        String query = "INSERT INTO `pstone_purchase_payments` (  `id`,  `buyer`, `owner`, `item`, `amount`, `fieldName`, `coords`) ";
        String values = "VALUES ( " + purchase.getId() + ",'" + purchase.getBuyer() + "','" + purchase.getOwner() + "','" + itemName + "'," + purchase.getAmount() + ",'" + purchase.getFieldName() + "','" + purchase.getCoords() + "');";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.insert(query + values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePendingPurchasePayment(PurchaseEntry purchase) {
        String query = "DELETE FROM `pstone_purchase_payments` WHERE id = " + purchase.getId() + ";";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PurchaseEntry> getPendingPurchases(String owner) {
        ResultSet res;
        ArrayList<PurchaseEntry> out = new ArrayList<PurchaseEntry>();
        String query = "SELECT * FROM  `pstone_purchase_payments` WHERE owner = '" + owner + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        int id = res.getInt("id");
                        String buyer = res.getString("buyer");
                        String item = res.getString("item");
                        String fieldName = res.getString("fieldName");
                        String coords = res.getString("coords");
                        int amount = res.getInt("amount");
                        out.add(new PurchaseEntry(id, buyer, owner, fieldName, coords, new BlockTypeEntry(item), amount));
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSnitchEntry(Field snitch, SnitchEntry se) {
        if (this.plugin.getSettingsManager().isUseMysql()) {
            String query = "INSERT INTO `pstone_snitches` (`x`, `y`, `z`, `world`, `name`, `reason`, `details`, `count`, `date`) ";
            String values = "VALUES ( " + snitch.getX() + "," + snitch.getY() + "," + snitch.getZ() + ",'" + Helper.escapeQuotes(snitch.getWorld()) + "','" + Helper.escapeQuotes(se.getName()) + "','" + Helper.escapeQuotes(se.getReason()) + "','" + Helper.escapeQuotes(se.getDetails()) + "',1, '" + new DateTime().getMillis() + "') ";
            String update = "ON DUPLICATE KEY UPDATE count = count+1;";
            StorageManager storageManager = this;
            synchronized (storageManager) {
                this.core.insert(query + values + update);
            }
        }
        String query = "INSERT OR IGNORE INTO `pstone_snitches` (`x`, `y`, `z`, `world`, `name`, `reason`, `details`, `count`, `date`) ";
        String values = "VALUES ( " + snitch.getX() + "," + snitch.getY() + "," + snitch.getZ() + ",'" + Helper.escapeQuotes(snitch.getWorld()) + "','" + Helper.escapeQuotes(se.getName()) + "','" + Helper.escapeQuotes(se.getReason()) + "','" + Helper.escapeQuotes(se.getDetails()) + "',1, '" + new DateTime().getMillis() + "');";
        String update = "UPDATE `pstone_snitches` SET count = count+1;";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.insert(query + values + update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSnitchEntries(Field snitch) {
        String query = "DELETE FROM `pstone_snitches` WHERE x = " + snitch.getX() + " AND y = " + snitch.getY() + " AND z = " + snitch.getZ() + " AND world = '" + Helper.escapeQuotes(snitch.getWorld()) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SnitchEntry> getSnitchEntries(Field snitch) {
        ResultSet res;
        ArrayList<SnitchEntry> workingSnitchEntries = new ArrayList<SnitchEntry>();
        List<SnitchEntry> list = this.pendingSnitchEntries;
        synchronized (list) {
            workingSnitchEntries.addAll(this.pendingSnitchEntries);
            this.pendingSnitchEntries.clear();
        }
        this.processSnitches(workingSnitchEntries);
        ArrayList<SnitchEntry> out = new ArrayList<SnitchEntry>();
        String query = "SELECT * FROM  `pstone_snitches` WHERE x = " + snitch.getX() + " AND y = " + snitch.getY() + " AND z = " + snitch.getZ() + " AND world = '" + Helper.escapeQuotes(snitch.getWorld()) + "' ORDER BY `date` DESC;";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String name = res.getString("name");
                        String reason = res.getString("reason");
                        String details = res.getString("details");
                        int count = res.getInt("count");
                        SnitchEntry ub = new SnitchEntry(null, name, reason, details, count);
                        out.add(ub);
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlayer(String playerName) {
        String query = "DELETE FROM `pstone_players` WHERE player_name = '" + playerName + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayer(String playerName) {
        long time = new DateTime().getMillis();
        PlayerEntry data = this.plugin.getPlayerManager().getPlayerEntry(playerName);
        if (this.plugin.getSettingsManager().isUseMysql()) {
            String query = "INSERT INTO `pstone_players` (`player_name`,  `uuid`,  `last_seen`, `flags`) ";
            String values = "VALUES ( '" + playerName + "', '" + data.getOnlineUUID() + "', " + time + ",'" + Helper.escapeQuotes(data.getFlags()) + "') ";
            String update = "ON DUPLICATE KEY UPDATE last_seen = " + time + ", flags = '" + Helper.escapeQuotes(data.getFlags()) + "'";
            StorageManager storageManager = this;
            synchronized (storageManager) {
                this.core.insert(query + values + update);
            }
        }
        String query = "INSERT OR IGNORE INTO `pstone_players` ( `player_name`,  `uuid`,  `last_seen`, `flags`) ";
        String values = "VALUES ( '" + playerName + "', '" + data.getOnlineUUID() + "', " + time + ",'" + Helper.escapeQuotes(data.getFlags()) + "');";
        String update = "UPDATE `pstone_players` SET last_seen = " + time + ", flags = '" + Helper.escapeQuotes(data.getFlags()) + "' WHERE player_name = '" + playerName + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.insert(query + values + update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayerUUID(String playerName, UUID uuid) {
        String update = "UPDATE `pstone_players` SET `uuid` = '" + uuid.toString() + "' WHERE `player_name` = '" + playerName + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.update(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBlockGrief(Field field, GriefBlock gb) {
        String query = "INSERT INTO `pstone_grief_undo` ( `date_griefed`, `field_x`, `field_y` , `field_z`, `world`, `x` , `y`, `z`, `type_id`, `data`, `sign_text`) ";
        String values = "VALUES ( '" + new DateTime().getMillis() + "'," + field.getX() + "," + field.getY() + "," + field.getZ() + ",'" + Helper.escapeQuotes(field.getWorld()) + "'," + gb.getX() + "," + gb.getY() + "," + gb.getZ() + "," + gb.getTypeId() + "," + gb.getData() + ",'" + Helper.escapeQuotes(gb.getSignText()) + "');";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.insert(query + values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<GriefBlock> retrieveBlockGrief(Field field) {
        ResultSet res;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.haltUpdates = true;
        }
        HashSet<Field> workingGrief = new HashSet<Field>();
        Set<Field> set = this.pendingGrief;
        synchronized (set) {
            workingGrief.addAll(this.pendingGrief);
            this.pendingGrief.clear();
        }
        this.processGrief(workingGrief);
        LinkedList<GriefBlock> out = new LinkedList<GriefBlock>();
        String query = "SELECT * FROM  `pstone_grief_undo` WHERE field_x = " + field.getX() + " AND field_y = " + field.getY() + " AND field_z = " + field.getZ() + " AND world = '" + Helper.escapeQuotes(field.getWorld()) + "' ORDER BY y ASC;";
        StorageManager storageManager2 = this;
        synchronized (storageManager2) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        int x = res.getInt("x");
                        int y = res.getInt("y");
                        int z = res.getInt("z");
                        int type_id = res.getInt("type_id");
                        byte data = res.getByte("data");
                        String signText = res.getString("sign_text");
                        BlockTypeEntry type = new BlockTypeEntry(type_id, data);
                        GriefBlock gb = new GriefBlock(x, y, z, field.getWorld(), type);
                        if (type_id == 0 || type_id == 8 || type_id == 9 || type_id == 10 || type_id == 11) {
                            gb.setEmpty(true);
                        }
                        gb.setSignText(signText);
                        out.add(gb);
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            PreciousStones.debug("Extracted %s griefed blocks from the db", out.size());
            if (!out.isEmpty()) {
                PreciousStones.debug("Deleting grief from the db", new Object[0]);
                this.deleteBlockGrief(field);
            }
        }
        storageManager2 = this;
        synchronized (storageManager2) {
            this.haltUpdates = false;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBlockGrief(Field field) {
        Set<Field> set = this.pendingGrief;
        synchronized (set) {
            this.pendingGrief.remove(field);
        }
        String query = "DELETE FROM `pstone_grief_undo` WHERE field_x = " + field.getX() + " AND field_y = " + field.getY() + " AND field_z = " + field.getZ() + " AND world = '" + Helper.escapeQuotes(field.getWorld()) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBlockGrief(Block block) {
        String query = "DELETE FROM `pstone_grief_undo` WHERE x = " + block.getX() + " AND y = " + block.getY() + " AND z = " + block.getZ() + " AND world = '" + Helper.escapeQuotes(block.getWorld().getName()) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsTranslocatior(String name, String playerName) {
        ResultSet res;
        String query = "SELECT COUNT(*) FROM `pstone_translocations` WHERE `name` ='" + Helper.escapeQuotes(name) + "' AND `player_name` = '" + Helper.escapeQuotes(playerName) + "'";
        boolean exists = false;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    exists = res.getInt(1) > 0;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeSizeTranslocatiorField(Field field, String fieldName) {
        ResultSet res;
        String query = "SELECT * FROM `pstone_translocations` WHERE `name` ='" + Helper.escapeQuotes(fieldName) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' LIMIT 1";
        boolean exists = false;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        field.setRelativeCuboidDimensions(res.getInt("minx"), res.getInt("miny"), res.getInt("minz"), res.getInt("maxx"), res.getInt("maxy"), res.getInt("maxz"));
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTranslocationHead(Field field, String name) {
        boolean exists = this.existsTranslocatior(name, field.getOwner());
        if (exists) {
            return;
        }
        String query = "INSERT INTO `pstone_translocations` ( `name`, `player_name`, `minx`, `miny`, `minz`, `maxx`, `maxy`, `maxz`) ";
        String values = "VALUES ( '" + Helper.escapeQuotes(name) + "','" + Helper.escapeQuotes(field.getOwner()) + "'," + field.getRelativeMin().getBlockX() + "," + field.getRelativeMin().getBlockY() + "," + field.getRelativeMin().getBlockZ() + "," + field.getRelativeMax().getBlockX() + "," + field.getRelativeMax().getBlockY() + "," + field.getRelativeMax().getBlockZ() + ");";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.insert(query + values);
        }
    }

    public void insertTranslocationBlock(Field field, TranslocationBlock tb) {
        this.insertTranslocationBlock(field, tb, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTranslocationBlock(Field field, TranslocationBlock tb, boolean applied) {
        String query = "INSERT INTO `pstone_storedblocks` ( `name`, `player_name`, `world`, `x` , `y`, `z`, `type_id`, `data`, `contents`, `sign_text`, `applied`) ";
        String values = "VALUES ( '" + Helper.escapeQuotes(field.getName()) + "','" + Helper.escapeQuotes(field.getOwner()) + "','" + Helper.escapeQuotes(field.getWorld()) + "'," + tb.getRx() + "," + tb.getRy() + "," + tb.getRz() + "," + tb.getTypeId() + "," + tb.getData() + ",'" + tb.getContents() + "','" + Helper.escapeQuotes(tb.getSignText()) + "', " + (applied ? 1 : 0) + ");";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.insert(query + values);
        }
    }

    public int appliedTranslocationCount(Field field) {
        return this.appliedTranslocationCount(field.getName(), field.getOwner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appliedTranslocationCount(String name, String playerName) {
        ResultSet res;
        String query = "SELECT COUNT(*) FROM `pstone_storedblocks` WHERE `name` ='" + Helper.escapeQuotes(name) + "' AND `player_name` = '" + Helper.escapeQuotes(playerName) + "' AND `applied` = 1";
        int count = 0;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    count = res.getInt(1);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalTranslocationCount(String name, String playerName) {
        ResultSet res;
        String query = "SELECT COUNT(*) FROM `pstone_storedblocks` WHERE `name` ='" + Helper.escapeQuotes(name) + "' AND `player_name` = '" + Helper.escapeQuotes(playerName) + "'";
        int count = 0;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    count = res.getInt(1);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return count;
    }

    public int unappliedTranslocationCount(Field field) {
        return this.unappliedTranslocationCount(field.getName(), field.getOwner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unappliedTranslocationCount(String name, String playerName) {
        ResultSet res;
        String query = "SELECT COUNT(*) FROM `pstone_storedblocks` WHERE `name` ='" + Helper.escapeQuotes(name) + "' AND `player_name` = '" + Helper.escapeQuotes(playerName) + "' AND `applied` = 0";
        int count = 0;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    count = res.getInt(1);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<TranslocationBlock> retrieveClearTranslocation(Field field) {
        ResultSet res;
        LinkedList<TranslocationBlock> out = new LinkedList<TranslocationBlock>();
        String query = "SELECT * FROM  `pstone_storedblocks` WHERE `name` ='" + Helper.escapeQuotes(field.getName()) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' AND `applied` = 1 ORDER BY y ASC;";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        int x = res.getInt("x");
                        int y = res.getInt("y");
                        int z = res.getInt("z");
                        World world = this.plugin.getServer().getWorld(field.getWorld());
                        Location location = new Location(world, (double)x, (double)y, (double)z);
                        location = location.add(field.getLocation());
                        int type_id = res.getInt("type_id");
                        byte data = res.getByte("data");
                        String signText = res.getString("sign_text");
                        String contents = res.getString("contents");
                        BlockTypeEntry type = new BlockTypeEntry(type_id, data);
                        TranslocationBlock tb = new TranslocationBlock(location, type);
                        if (type_id == 0 || type_id == 8 || type_id == 9 || type_id == 10 || type_id == 11) {
                            tb.setEmpty(true);
                        }
                        tb.setContents(contents);
                        tb.setRelativeCoords(x, y, z);
                        tb.setSignText(signText);
                        out.add(tb);
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.clearTranslocation(field);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<TranslocationBlock> retrieveTranslocation(Field field) {
        ResultSet res;
        LinkedList<TranslocationBlock> out = new LinkedList<TranslocationBlock>();
        String query = "SELECT * FROM  `pstone_storedblocks` WHERE `name` ='" + Helper.escapeQuotes(field.getName()) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' AND `applied` = 0 ORDER BY y ASC;";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        int x = res.getInt("x");
                        int y = res.getInt("y");
                        int z = res.getInt("z");
                        World world = this.plugin.getServer().getWorld(field.getWorld());
                        Location location = new Location(world, (double)x, (double)y, (double)z);
                        location = location.add(field.getLocation());
                        int type_id = res.getInt("type_id");
                        byte data = res.getByte("data");
                        String signText = res.getString("sign_text");
                        String contents = res.getString("contents");
                        BlockTypeEntry type = new BlockTypeEntry(type_id, data);
                        TranslocationBlock tb = new TranslocationBlock(location, type);
                        if (type_id == 0 || type_id == 8 || type_id == 9 || type_id == 10 || type_id == 11) {
                            tb.setEmpty(true);
                        }
                        tb.setContents(contents);
                        tb.setRelativeCoords(x, y, z);
                        tb.setSignText(signText);
                        out.add(tb);
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.applyTranslocation(field);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getTranslocationDetails(String playerName) {
        ResultSet res;
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        String query = "SELECT name, COUNT(name) FROM  `pstone_storedblocks` WHERE `player_name` = '" + Helper.escapeQuotes(playerName) + "' GROUP BY `name`;";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        String name = res.getString(1);
                        int count = res.getInt(2);
                        out.put(name, count);
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsFieldWithName(String name, String playerName) {
        ResultSet res;
        String query = "SELECT COUNT(*) FROM  `pstone_fields` WHERE `owner` = '" + Helper.escapeQuotes(playerName) + "' AND `name` ='" + Helper.escapeQuotes(name) + "'";
        boolean exists = false;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        int count = res.getInt(1);
                        exists = count > 0;
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        query = "SELECT COUNT(*) FROM  `pstone_cuboids` WHERE `owner` = '" + Helper.escapeQuotes(playerName) + "' AND `name` ='" + Helper.escapeQuotes(name) + "'";
        StorageManager ex = this;
        synchronized (ex) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        int count = res.getInt(1);
                        exists = exists || count > 0;
                    }
                    catch (Exception ex2) {
                        PreciousStones.getLog().info(ex2.getMessage());
                    }
                }
            }
            catch (SQLException ex3) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex3);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsTranslocationDataWithName(String name, String playerName) {
        ResultSet res;
        String query = "SELECT COUNT(*) FROM  `pstone_storedblocks` WHERE `player_name` = '" + Helper.escapeQuotes(playerName) + "' AND `name` ='" + Helper.escapeQuotes(name) + "'";
        boolean exists = false;
        StorageManager storageManager = this;
        synchronized (storageManager) {
            res = this.core.select(query);
        }
        if (res != null) {
            try {
                while (res.next()) {
                    try {
                        int count = res.getInt(1);
                        exists = count > 0;
                    }
                    catch (Exception ex) {
                        PreciousStones.getLog().info(ex.getMessage());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StorageManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTranslocation(Field field) {
        String query = "UPDATE `pstone_storedblocks` SET `applied` = 1 WHERE `name` ='" + Helper.escapeQuotes(field.getName()) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' AND `applied` = 0;";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.update(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTranslocation(Field field) {
        String query = "UPDATE `pstone_storedblocks` SET `applied` = 0 WHERE `name` ='" + Helper.escapeQuotes(field.getName()) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' AND `applied` = 1;";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.update(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAppliedTranslocation(Field field) {
        String query = "DELETE FROM `pstone_storedblocks` WHERE `name` ='" + Helper.escapeQuotes(field.getName()) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' AND `applied` = 1;";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranslocation(Field field, TranslocationBlock tb) {
        Location location = tb.getRelativeLocation();
        String query = "DELETE FROM `pstone_storedblocks` WHERE x = " + location.getBlockX() + " AND y = " + location.getBlockY() + " AND z = " + location.getBlockZ() + " AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' AND `name` = '" + Helper.escapeQuotes(field.getName()) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranslocation(String playerName) {
        String query = "DELETE FROM `pstone_storedblocks` WHERE `player_name` = '" + Helper.escapeQuotes(playerName) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranslocation(String name, String playerName) {
        String query = "DELETE FROM `pstone_storedblocks` WHERE `player_name` = '" + Helper.escapeQuotes(playerName) + "' AND `name` = '" + Helper.escapeQuotes(name) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTranslocationHead(String name, String playerName) {
        String query = "DELETE FROM `pstone_translocations` WHERE `player_name` = '" + Helper.escapeQuotes(playerName) + "' AND `name` = '" + Helper.escapeQuotes(name) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteBlockTypeFromTranslocation(String name, String playerName, BlockTypeEntry block) {
        int beforeCount = this.totalTranslocationCount(name, playerName);
        String query = "DELETE FROM `pstone_storedblocks` WHERE `player_name` = '" + Helper.escapeQuotes(playerName) + "' AND `name` = '" + Helper.escapeQuotes(name) + "' AND `type_id` = " + block.getTypeId() + ";";
        if (block.getData() > 0) {
            query = "DELETE FROM `pstone_storedblocks` WHERE `player_name` = '" + Helper.escapeQuotes(playerName) + "' AND `name` = '" + Helper.escapeQuotes(name) + "' AND `type_id` = " + block.getTypeId() + " AND `data` = " + block.getData() + ";";
        }
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.delete(query);
        }
        int afterCount = this.totalTranslocationCount(name, playerName);
        return beforeCount - afterCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeTranslocationOwner(Field field, String newOwner) {
        String query = "UPDATE `pstone_storedblocks` SET `player_name` = '" + Helper.escapeQuotes(newOwner) + "' WHERE `name` ='" + Helper.escapeQuotes(field.getName()) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "';";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.update(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTranslocationBlockApplied(Field field, TranslocationBlock tb, boolean applied) {
        Location location = tb.getRelativeLocation();
        String query = "UPDATE `pstone_storedblocks` SET `applied` = " + (applied ? 1 : 0) + " WHERE `name` ='" + Helper.escapeQuotes(field.getName()) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' AND `x` = " + location.getBlockX() + " AND `y` = " + location.getBlockY() + " AND `z` = " + location.getBlockZ() + ";";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.update(query);
        }
    }

    public boolean isTranslocationApplied(String name, String playerName) {
        return this.appliedTranslocationCount(name, playerName) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTranslocationBlockData(Field field, TranslocationBlock tb) {
        Location location = tb.getRelativeLocation();
        String query = "UPDATE `pstone_storedblocks` SET `data` = " + tb.getData() + " WHERE `name` ='" + Helper.escapeQuotes(field.getName()) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' AND `x` = " + location.getBlockX() + " AND `y` = " + location.getBlockY() + " AND `z` = " + location.getBlockZ() + ";";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.update(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTranslocationBlockContents(Field field, TranslocationBlock tb) {
        Location location = tb.getRelativeLocation();
        String query = "UPDATE `pstone_storedblocks` SET `contents` = '" + tb.getContents() + "' WHERE `name` ='" + Helper.escapeQuotes(field.getName()) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' AND `x` = " + location.getBlockX() + " AND `y` = " + location.getBlockY() + " AND `z` = " + location.getBlockZ() + ";";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.update(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTranslocationSignText(Field field, TranslocationBlock tb) {
        Location location = tb.getRelativeLocation();
        String query = "UPDATE `pstone_storedblocks` SET `sign_text` = '" + tb.getSignText() + "' WHERE `name` ='" + Helper.escapeQuotes(field.getName()) + "' AND `player_name` = '" + Helper.escapeQuotes(field.getOwner()) + "' AND `x` = " + location.getBlockX() + " AND `y` = " + location.getBlockY() + " AND `z` = " + location.getBlockZ() + ";";
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.core.update(query);
        }
    }

    public BukkitTask saverScheduler() {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                StorageManager.this.processQueue();
            }
        }, 0L, 20L * (long)this.plugin.getSettingsManager().getSaveFrequency());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueue() {
        StorageManager storageManager = this;
        synchronized (storageManager) {
            if (this.haltUpdates) {
                return;
            }
        }
        HashMap<Vec, Field> working = new HashMap<Vec, Field>();
        HashMap<Unbreakable, Boolean> workingUb = new HashMap<Unbreakable, Boolean>();
        HashMap<String, Boolean> workingPlayers = new HashMap<String, Boolean>();
        HashSet<Field> workingGrief = new HashSet<Field>();
        ArrayList<SnitchEntry> workingSnitchEntries = new ArrayList<SnitchEntry>();
        Object object = this.pending;
        synchronized (object) {
            working.putAll(this.pending);
            this.pending.clear();
        }
        object = this.pendingUb;
        synchronized (object) {
            workingUb.putAll(this.pendingUb);
            this.pendingUb.clear();
        }
        object = this.pendingGrief;
        synchronized (object) {
            workingGrief.addAll(this.pendingGrief);
            this.pendingGrief.clear();
        }
        object = this.pendingPlayers;
        synchronized (object) {
            workingPlayers.putAll(this.pendingPlayers);
            this.pendingPlayers.clear();
        }
        object = this.pendingSnitchEntries;
        synchronized (object) {
            workingSnitchEntries.addAll(this.pendingSnitchEntries);
            this.pendingSnitchEntries.clear();
        }
        if (!working.isEmpty()) {
            this.processFields(working);
        }
        if (!workingUb.isEmpty()) {
            this.processUnbreakable(workingUb);
        }
        if (!workingGrief.isEmpty()) {
            this.processGrief(workingGrief);
        }
        if (!workingPlayers.isEmpty()) {
            this.processPlayers(workingPlayers);
        }
        if (!workingSnitchEntries.isEmpty()) {
            this.processSnitches(workingSnitchEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSingleField(Field field) {
        if (this.plugin.getSettingsManager().isDebug()) {
            PreciousStones.getLog().info("[Queue] processing single query");
        }
        if (field.isDirty(DirtyFieldReason.DELETE)) {
            this.deleteField(field);
        } else {
            this.updateField(field);
        }
        StorageManager storageManager = this;
        synchronized (storageManager) {
            this.pending.remove(field.toVec());
        }
    }

    public void processFields(Map<Vec, Field> working) {
        if (this.plugin.getSettingsManager().isDebug() && !working.isEmpty()) {
            PreciousStones.getLog().info("[Queue] processing " + working.size() + " pstone queries...");
        }
        for (Field field : working.values()) {
            if (field.isDirty(DirtyFieldReason.DELETE)) {
                this.deleteField(field);
                continue;
            }
            this.updateField(field);
        }
    }

    public void processUnbreakable(Map<Unbreakable, Boolean> workingUb) {
        if (this.plugin.getSettingsManager().isDebug() && !workingUb.isEmpty()) {
            PreciousStones.getLog().info("[Queue] processing " + workingUb.size() + " unbreakable queries...");
        }
        for (Unbreakable ub : workingUb.keySet()) {
            if (workingUb.get(ub).booleanValue()) {
                this.insertUnbreakable(ub);
                continue;
            }
            this.deleteUnbreakable(ub);
        }
    }

    public void processPlayers(Map<String, Boolean> workingPlayers) {
        if (this.plugin.getSettingsManager().isDebug() && !workingPlayers.isEmpty()) {
            PreciousStones.getLog().info("[Queue] processing " + workingPlayers.size() + " player queries...");
        }
        for (String playerName : workingPlayers.keySet()) {
            if (workingPlayers.get(playerName).booleanValue()) {
                this.updatePlayer(playerName);
                continue;
            }
            this.deletePlayer(playerName);
            this.deleteTranslocation(playerName);
            this.deleteFields(playerName);
            this.deleteUnbreakables(playerName);
        }
    }

    public void processSnitches(List<SnitchEntry> workingSnitchEntries) {
        if (this.plugin.getSettingsManager().isDebug() && !workingSnitchEntries.isEmpty()) {
            PreciousStones.getLog().info("[Queue] sending " + workingSnitchEntries.size() + " snitch queries...");
        }
        for (SnitchEntry se : workingSnitchEntries) {
            this.insertSnitchEntry(se.getField(), se);
        }
    }

    public void processGrief(Set<Field> workingGrief) {
        if (this.plugin.getSettingsManager().isDebug() && !workingGrief.isEmpty()) {
            PreciousStones.getLog().info("[Queue] processing " + workingGrief.size() + " grief queries...");
        }
        for (Field field : workingGrief) {
            this.updateGrief(field);
        }
    }
}

