/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.Unbreakable;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.AbstractVec;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.ChunkVec;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public final class UnbreakableManager {
    private final HashMap<String, HashMap<ChunkVec, HashMap<Vec, Unbreakable>>> chunkLists = new HashMap();
    private Queue<Unbreakable> deletionQueue = new LinkedList<Unbreakable>();
    private PreciousStones plugin = PreciousStones.getInstance();

    public void clearChunkLists() {
        this.chunkLists.clear();
    }

    public boolean add(Block unbreakableblock, Player owner) {
        if (this.plugin.getPlayerManager().getPlayerEntry(owner.getName()).isDisabled()) {
            return false;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(unbreakableblock.getWorld())) {
            return false;
        }
        Unbreakable unbreakable = new Unbreakable(unbreakableblock, owner.getName());
        this.addToCollection(unbreakable);
        this.plugin.getStorageManager().offerUnbreakable(unbreakable, true);
        return true;
    }

    public void addToCollection(Unbreakable ub) {
        String world = ub.getWorld();
        ChunkVec chunkvec = ub.toChunkVec();
        HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w = this.chunkLists.get(world);
        if (w != null) {
            HashMap<Vec, Unbreakable> c = w.get(chunkvec);
            if (c != null) {
                c.put(ub.toVec(), ub);
            } else {
                HashMap<Vec, Unbreakable> newc = new HashMap<Vec, Unbreakable>();
                newc.put(ub.toVec(), ub);
                w.put(chunkvec, newc);
            }
        } else {
            HashMap _w = new HashMap();
            HashMap<Vec, Unbreakable> _c = new HashMap<Vec, Unbreakable>();
            _c.put(ub.toVec(), ub);
            _w.put(chunkvec, _c);
            this.chunkLists.put(world, _w);
        }
    }

    public boolean hasUnbreakables(ChunkVec cv) {
        HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w = this.chunkLists.get(cv.getWorld());
        if (w != null) {
            HashMap<Vec, Unbreakable> c = w.get(cv);
            if (c != null) {
                return !c.isEmpty();
            }
            return false;
        }
        return false;
    }

    public Collection<Unbreakable> retrieveUnbreakables(ChunkVec cv) {
        if (this.chunkLists.get(cv.getWorld()) == null) {
            return null;
        }
        if (this.chunkLists.get(cv.getWorld()).get(cv) == null) {
            return null;
        }
        return this.chunkLists.get(cv.getWorld()).get(cv).values();
    }

    public HashMap<ChunkVec, HashMap<Vec, Unbreakable>> retrieveUnbreakables(String world) {
        return this.chunkLists.get(world);
    }

    public Unbreakable getUnbreakable(Location location) {
        HashMap<Vec, Unbreakable> c;
        HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w = this.chunkLists.get(location.getWorld().getName());
        if (w != null && (c = w.get(new ChunkVec(location))) != null) {
            return c.get(new Vec(location));
        }
        return null;
    }

    public Unbreakable getUnbreakable(Block block) {
        HashMap<Vec, Unbreakable> c;
        HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w = this.chunkLists.get(block.getLocation().getWorld().getName());
        if (w != null && (c = w.get(new ChunkVec(block))) != null) {
            Unbreakable ub = c.get(new Vec(block));
            if (ub != null && ub.getTypeId() != block.getTypeId()) {
                this.deleteUnbreakable(ub);
                return null;
            }
            return ub;
        }
        return null;
    }

    public boolean isUnbreakable(Block unbreakableblock) {
        return this.getUnbreakable(unbreakableblock) != null;
    }

    public int getCount() {
        int size = 0;
        for (HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w : this.chunkLists.values()) {
            if (w == null) continue;
            for (HashMap<Vec, Unbreakable> c : w.values()) {
                size += c.size();
            }
        }
        return size;
    }

    public int cleanOrphans(World world) {
        int cleanedCount = 0;
        boolean currentChunkLoaded = false;
        Object currentChunk = null;
        HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w = this.retrieveUnbreakables(world.getName());
        if (w != null) {
            for (HashMap<Vec, Unbreakable> ubs : w.values()) {
                if (ubs == null) continue;
                for (Unbreakable unbreakable : ubs.values()) {
                    int type = world.getBlockTypeIdAt(unbreakable.getX(), unbreakable.getY(), unbreakable.getZ());
                    if (type == unbreakable.getTypeId()) continue;
                    ++cleanedCount;
                    this.queueRelease(unbreakable);
                }
            }
        }
        this.flush();
        if (cleanedCount != 0) {
            PreciousStones.log("countsOrphanedUnbreakables", world.getName(), cleanedCount);
        }
        return cleanedCount;
    }

    public int revertOrphans(World world) {
        int revertedCount = 0;
        boolean currentChunkLoaded = false;
        AbstractVec currentChunk = null;
        HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w = this.retrieveUnbreakables(world.getName());
        if (w != null) {
            for (HashMap<Vec, Unbreakable> ubs : w.values()) {
                for (Unbreakable unbreakable : ubs.values()) {
                    ChunkVec cv = unbreakable.toChunkVec();
                    if (!cv.equals(currentChunk)) {
                        if (!currentChunkLoaded && currentChunk != null) {
                            world.unloadChunk(currentChunk.getX(), currentChunk.getZ());
                        }
                        if (!(currentChunkLoaded = world.isChunkLoaded(cv.getX(), cv.getZ()))) {
                            world.loadChunk(cv.getX(), cv.getZ());
                        }
                        currentChunk = cv;
                    }
                    Block block = world.getBlockAt(unbreakable.getX(), unbreakable.getY(), unbreakable.getZ());
                    if (this.plugin.getSettingsManager().isUnbreakableType(block)) continue;
                    ++revertedCount;
                    block.setTypeId(unbreakable.getTypeId());
                    block.setData(unbreakable.getData());
                }
            }
        }
        return revertedCount;
    }

    public boolean isOwner(Block unbreakableblock, String playerName) {
        Unbreakable unbreakable = this.getUnbreakable(unbreakableblock);
        if (unbreakable != null) {
            return unbreakable.isOwner(playerName);
        }
        return false;
    }

    public String getOwner(Block unbreakableblock) {
        Unbreakable unbreakable = this.getUnbreakable(unbreakableblock);
        if (unbreakable != null) {
            return unbreakable.getOwner();
        }
        return "";
    }

    public ArrayList<Unbreakable> getUnbreakablesInArea(Vec vec, int chunkradius) {
        ArrayList<Unbreakable> out = new ArrayList<Unbreakable>();
        int xlow = (vec.getX() >> 4) - chunkradius;
        int xhigh = (vec.getX() >> 4) + chunkradius;
        int zlow = (vec.getZ() >> 4) - chunkradius;
        int zhigh = (vec.getZ() >> 4) + chunkradius;
        for (int x = xlow; x <= xhigh; ++x) {
            for (int z = zlow; z <= zhigh; ++z) {
                Collection<Unbreakable> ubs = this.retrieveUnbreakables(new ChunkVec(x, z, vec.getWorld()));
                if (ubs == null) continue;
                out.addAll(ubs);
            }
        }
        return out;
    }

    public ArrayList<Unbreakable> getUnbreakablesInArea(Player player, int chunkradius) {
        return this.getUnbreakablesInArea(new Vec(player.getLocation()), chunkradius);
    }

    public Block touchingUnbrakableBlock(Block block) {
        if (block == null) {
            return null;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Block surroundingblock = block.getWorld().getBlockAt(block.getX() + x, block.getY() + y, block.getZ() + z);
                    if (!this.plugin.getSettingsManager().isUnbreakableType(surroundingblock) || !this.plugin.getUnbreakableManager().isUnbreakable(surroundingblock)) continue;
                    return surroundingblock;
                }
            }
        }
        return null;
    }

    public int deleteBelonging(String playerName) {
        int deletedUbs = 0;
        for (HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w : this.chunkLists.values()) {
            for (HashMap<Vec, Unbreakable> ubs : w.values()) {
                for (Unbreakable ub : ubs.values()) {
                    if (!ub.getOwner().equalsIgnoreCase(playerName)) continue;
                    this.queueRelease(ub);
                    ++deletedUbs;
                }
            }
        }
        this.flush();
        return deletedUbs;
    }

    public int deleteUnbreakablesOfType(BlockTypeEntry type) {
        int deletedCount = 0;
        for (HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w : this.chunkLists.values()) {
            if (w == null) continue;
            for (HashMap<Vec, Unbreakable> c : w.values()) {
                if (c == null) continue;
                for (Unbreakable ub : c.values()) {
                    if (!ub.getTypeEntry().equals(type)) continue;
                    this.queueRelease(ub);
                    ++deletedCount;
                }
            }
        }
        if (deletedCount > 0) {
            this.flush();
        }
        return deletedCount;
    }

    public void release(Block unbreakableblock) {
        Unbreakable ub = this.getUnbreakable(unbreakableblock);
        this.deleteUnbreakable(ub);
    }

    public void queueRelease(Block unbreakableblock) {
        this.deletionQueue.add(this.getUnbreakable(unbreakableblock));
    }

    public void queueRelease(Unbreakable unbreakable) {
        this.deletionQueue.add(unbreakable);
    }

    public void flush() {
        while (this.deletionQueue.size() > 0) {
            Unbreakable pending = this.deletionQueue.poll();
            this.deleteUnbreakable(pending);
        }
    }

    public void deleteUnbreakable(Unbreakable ub) {
        HashMap<Vec, Unbreakable> c;
        HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w = this.chunkLists.get(ub.getWorld());
        if (w != null && (c = w.get(ub.toChunkVec())) != null) {
            c.remove(ub);
        }
        this.plugin.getStorageManager().offerUnbreakable(ub, false);
    }

    public void migrateUsername(String oldName, String newName) {
        for (HashMap<ChunkVec, HashMap<Vec, Unbreakable>> w : this.chunkLists.values()) {
            for (HashMap<Vec, Unbreakable> ubs : w.values()) {
                for (Unbreakable ub : ubs.values()) {
                    if (!ub.getOwner().equalsIgnoreCase(oldName)) continue;
                    ub.setOwner(newName);
                    this.plugin.getStorageManager().offerUnbreakable(ub, false);
                }
            }
        }
    }
}

