/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.storage;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.storage.DBCore;

public class MySQLCore
implements DBCore {
    private Logger log;
    private Connection connection;
    private String host;
    private String username;
    private String password;
    private String database;
    private int port;

    public MySQLCore(String host, int port, String database, String username, String password) {
        this.database = database;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.log = PreciousStones.getLog();
    }

    private void initialize() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database, this.username, this.password);
        }
        catch (ClassNotFoundException e) {
            this.log.severe("ClassNotFoundException! " + e.getMessage());
        }
        catch (SQLException e) {
            this.log.severe("SQLException! " + e.getMessage());
        }
    }

    @Override
    public Connection getConnection() {
        block3: {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    this.initialize();
                }
            }
            catch (SQLException e) {
                if (this.connection != null) break block3;
                this.initialize();
            }
        }
        return this.connection;
    }

    @Override
    public Boolean checkConnection() {
        return this.getConnection() != null;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            this.log.severe("Failed to close database connection! " + e.getMessage());
        }
    }

    @Override
    public ResultSet select(String query) {
        try {
            Statement statement = this.getConnection().createStatement();
            return statement.executeQuery(query);
        }
        catch (SQLException ex) {
            this.log.severe("Error at SQL Query: " + ex.getMessage());
            this.log.severe("Query: " + query);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(String query) {
        PreciousStones.debug(query, new Object[0]);
        long key = 0L;
        try {
            Statement statement = this.getConnection().createStatement();
            ResultSet keys = null;
            try {
                statement.executeUpdate(query, 1);
                keys = statement.getGeneratedKeys();
            }
            catch (SQLException ex) {
                if (!ex.toString().contains("not return ResultSet")) {
                    this.log.severe("Error at SQL INSERT Query: " + ex);
                }
            }
            finally {
                if (keys != null && keys.next()) {
                    key = keys.getLong(1);
                }
                statement.close();
            }
            return key;
        }
        catch (SQLException ex) {
            if (!ex.toString().contains("not return ResultSet")) {
                this.log.severe("Error at SQL INSERT Query: " + ex);
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String query) {
        block5: {
            PreciousStones.debug(query, new Object[0]);
            try (Statement statement = this.getConnection().createStatement();){
                statement.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.toString().contains("not return ResultSet")) break block5;
                this.log.severe("Error at SQL UPDATE Query: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String query) {
        block5: {
            PreciousStones.debug(query, new Object[0]);
            try (Statement statement = this.getConnection().createStatement();){
                statement.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.toString().contains("not return ResultSet")) break block5;
                this.log.severe("Error at SQL DELETE Query: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(String query) {
        PreciousStones.debug(query, new Object[0]);
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute(query);
        }
        catch (SQLException ex) {
            this.log.severe("Error at SQL Query: " + ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public Boolean existsTable(String table) {
        try {
            ResultSet tables = this.getConnection().getMetaData().getTables(null, null, table, null);
            return tables.next();
        }
        catch (SQLException e) {
            this.log.severe("Failed to check if table " + table + " exists: " + e.getMessage());
            return false;
        }
    }

    @Override
    public Boolean existsColumn(String table, String column) {
        try {
            ResultSet col = this.getConnection().getMetaData().getColumns(null, null, table, column);
            return col.next();
        }
        catch (Exception e) {
            this.log.severe("Failed to check if column " + column + " exists in table " + table + " : " + e.getMessage());
            return false;
        }
    }

    @Override
    public String getDataType(String table, String column) {
        String query = "SELECT DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '" + table + "' AND COLUMN_NAME = '" + column + "';";
        String dataType = "";
        try {
            Statement statement = this.getConnection().createStatement();
            ResultSet res = statement.executeQuery(query);
            if (res != null) {
                while (res.next()) {
                    dataType = res.getString("DATA_TYPE");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        PreciousStones.debug("Column %s in table %s has datatype: %s", column, table, dataType);
        if (dataType == null) {
            return "";
        }
        return dataType;
    }
}

