/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.translocation;

import java.util.LinkedList;
import java.util.Queue;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.TranslocationBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TranslocationImporter
implements Runnable {
    private PreciousStones plugin;
    private Queue<TranslocationBlock> translocationQueue = new LinkedList<TranslocationBlock>();
    private Queue<TranslocationBlock> dependentQueue = new LinkedList<TranslocationBlock>();
    private Queue<TranslocationBlock> clearDependentQueue = new LinkedList<TranslocationBlock>();
    private final int timerID;
    private final Player player;
    private final Field field;
    private int count;

    public TranslocationImporter(Field field, Queue<TranslocationBlock> translocationQueue, Player player) {
        this.plugin = PreciousStones.getInstance();
        for (TranslocationBlock tb : translocationQueue) {
            if (tb == null) continue;
            if (this.plugin.getSettingsManager().isDependentBlock(tb.getTypeId())) {
                this.dependentQueue.add(tb);
                continue;
            }
            this.translocationQueue.add(tb);
        }
        this.field = field;
        this.player = player;
        field.getTranslocatingModule().setTranslocating(true);
        this.timerID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 2L, 1L);
    }

    @Override
    public void run() {
        boolean cleared;
        TranslocationBlock tb;
        int i;
        for (i = 0; i < 500 && !this.dependentQueue.isEmpty(); ++i) {
            tb = this.dependentQueue.poll();
            cleared = this.plugin.getTranslocationManager().wipeTranslocationBlock(this.field, tb);
            if (cleared) {
                this.clearDependentQueue.add(tb);
                ++this.count;
                this.announce();
                continue;
            }
            this.plugin.getStorageManager().deleteTranslocation(this.field, tb);
        }
        if (this.dependentQueue.isEmpty()) {
            while (i < 500 && !this.clearDependentQueue.isEmpty()) {
                tb = this.clearDependentQueue.poll();
                this.plugin.getTranslocationManager().zeroOutBlock(tb);
                ++i;
            }
            if (this.clearDependentQueue.isEmpty()) {
                while (i < 500 && !this.translocationQueue.isEmpty()) {
                    tb = this.translocationQueue.poll();
                    cleared = this.plugin.getTranslocationManager().wipeTranslocationBlock(this.field, tb);
                    if (!cleared) {
                        this.plugin.getStorageManager().deleteTranslocation(this.field, tb);
                    } else {
                        ++this.count;
                        this.announce();
                    }
                    ++i;
                }
                if (!this.translocationQueue.iterator().hasNext()) {
                    Bukkit.getServer().getScheduler().cancelTask(this.timerID);
                    this.field.setDisabled(true);
                    this.field.getTranslocatingModule().setTranslocating(false);
                    this.field.getFlagsModule().dirtyFlags("TranslocationImporter");
                    ChatHelper.send((CommandSender)this.player, "importComplete", new Object[0]);
                }
            }
        }
    }

    public void announce() {
        if (this.count % 25 == 0 && this.count != 0 && this.player != null) {
            ChatHelper.send((CommandSender)this.player, "importedBlocks", this.count);
        }
    }
}

