/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;

public class RentEntry {
    private String playerName;
    private ZonedDateTime endDate;
    private int periodSeconds;

    public RentEntry(String playerName, int periodSeconds) {
        this.playerName = playerName;
        this.periodSeconds = periodSeconds;
        this.endDate = LocalDateTime.now().plusSeconds(periodSeconds).atZone(ZoneId.systemDefault());
    }

    public RentEntry(String packed) {
        String[] unpacked = packed.split("[|]");
        this.playerName = unpacked[0];
        this.periodSeconds = Integer.parseInt(unpacked[1]);
        this.endDate = Instant.ofEpochMilli(Long.parseLong(unpacked[2])).atZone(ZoneId.systemDefault());
    }

    public void addSeconds(int seconds) {
        this.periodSeconds += seconds;
        this.endDate = this.endDate.plusSeconds(seconds);
    }

    public int getPeriodSeconds() {
        return this.periodSeconds;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean isDone() {
        ZonedDateTime now = LocalDateTime.now().atZone(ZoneId.systemDefault());
        return ChronoUnit.SECONDS.between(now, this.endDate) <= 0L;
    }

    public int remainingRent() {
        ZonedDateTime now = LocalDateTime.now().atZone(ZoneId.systemDefault());
        return (int)ChronoUnit.SECONDS.between(now, this.endDate);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RentEntry)) {
            return false;
        }
        RentEntry other = (RentEntry)obj;
        return other.getPlayerName().equals(this.getPlayerName());
    }

    public int hashCode() {
        return this.getPlayerName().hashCode();
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public String serialize() {
        long millis = Helper.getMillis();
        return this.playerName + "|" + this.periodSeconds + "|" + millis;
    }
}

