/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.listeners;

import java.util.Collection;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.TargetBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.FieldSign;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.ForesterEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PurchaseEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.SignHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.StackHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.modules.BuyingModule;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PSPlayerListener
implements Listener {
    private final PreciousStones plugin = PreciousStones.getInstance();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.ALL);
        if (field != null && field.getListingModule().isBlacklistedCommand(event.getMessage()) && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.commandblacklist")) {
            ChatHelper.send((CommandSender)player, "commandCanceled", new Object[0]);
            event.setCancelled(true);
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.COMMAND_BLACKLIST)) != null && FieldFlag.COMMAND_BLACKLIST.applies(field, player) && field.getSettings().isCanceledCommand(event.getMessage()) && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.commandblacklist")) {
            ChatHelper.send((CommandSender)player, "commandCanceled", new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String playerName = event.getPlayer().getName();
        this.plugin.getPlayerManager().playerLogin(player);
        this.plugin.getStorageManager().offerPlayer(playerName);
        this.plugin.getEntryManager().reevaluateEnteredFields(player);
        this.plugin.getForceFieldManager().enableFieldsOnLogon(playerName);
        this.plugin.getForceFieldManager().removeFieldsIfNoPermission(playerName);
        List<PurchaseEntry> purchases = this.plugin.getStorageManager().getPendingPurchases(playerName);
        for (PurchaseEntry purchase : purchases) {
            new BuyingModule().giveMoney(player, purchase);
            this.plugin.getStorageManager().deletePendingPurchasePayment(purchase);
        }
        if (event.getPlayer().isOp()) {
            for (String message : this.plugin.getMessages()) {
                event.getPlayer().sendMessage(ChatColor.YELLOW + message);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getPlayerManager().playerLogoff(event.getPlayer());
        this.plugin.getStorageManager().offerPlayer(event.getPlayer().getName());
        this.plugin.getEntryManager().leaveAllFields(event.getPlayer());
        this.plugin.getForceFieldManager().disableFieldsOnLogoff(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerKick(PlayerKickEvent event) {
        if (this.plugin.getSettingsManager().isPurgeBannedPlayers() && event.getPlayer().isBanned()) {
            this.plugin.getStorageManager().deletePlayerAndData(event.getPlayer().getName());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.TELEPORT_ON_SNEAK);
        if (field != null && FieldFlag.TELEPORT_ON_SNEAK.applies(field, player)) {
            this.plugin.getTeleportationManager().teleport((Entity)player, field);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        List<Field> currentFields;
        if (event.isCancelled()) {
            return;
        }
        if (event.getFrom() == null || event.getTo() == null) {
            return;
        }
        if (Helper.isSameLocation(event.getFrom(), event.getTo())) {
            return;
        }
        Player player = event.getPlayer();
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(event.getTo(), FieldFlag.PREVENT_TELEPORT);
        if (field != null && FieldFlag.PREVENT_TELEPORT.applies(field, player) && !this.plugin.getPermissionsManager().has(event.getPlayer(), "preciousstones.bypass.teleport")) {
            event.setCancelled(true);
            ChatHelper.send((CommandSender)player, "cannotTeleportInsideField", new Object[0]);
            return;
        }
        if (!Helper.isSameBlock(event.getFrom(), event.getTo()) && this.plugin.getSettingsManager().isVisualizeEndOnMove() && !this.plugin.getPermissionsManager().has(player, "preciousstones.admin.visualize") && !this.plugin.getCuboidManager().hasOpenCuboid(player)) {
            this.plugin.getVisualizationManager().revert(player);
        }
        if ((currentFields = this.plugin.getEntryManager().getPlayerEntryFields(player)) != null) {
            for (Field entryField : currentFields) {
                if (entryField.envelops(event.getTo())) continue;
                this.plugin.getEntryManager().leaveField(player, entryField);
                if (this.plugin.getEntryManager().containsSameNameOwnedField(player, entryField)) continue;
                this.plugin.getEntryManager().leaveOverlappedArea(player, entryField);
            }
        }
        List<Field> futureFields = this.plugin.getForceFieldManager().getEnabledSourceFields(event.getTo(), FieldFlag.ALL);
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.entry")) {
            for (Field futureField : futureFields) {
                Field f;
                if (!FieldFlag.PREVENT_ENTRY.applies(futureField, player)) continue;
                Location loc = this.plugin.getPlayerManager().getOutsideFieldLocation(futureField, player);
                Location outside = this.plugin.getPlayerManager().getOutsideLocation(player);
                if (outside != null && (f = this.plugin.getForceFieldManager().getEnabledSourceField(outside, FieldFlag.PREVENT_ENTRY)) != null) {
                    loc = outside;
                }
                event.setTo(loc);
                this.plugin.getCommunicationManager().warnEntry(player, field);
                return;
            }
        }
        this.plugin.getPlayerManager().updateOutsideLocation(player);
        for (Field futureField : futureFields) {
            if (this.plugin.getEntryManager().enteredField(player, futureField)) continue;
            if (!this.plugin.getEntryManager().containsSameNameOwnedField(player, futureField)) {
                this.plugin.getEntryManager().enterOverlappedArea(player, futureField);
            }
            this.plugin.getEntryManager().enterField(player, futureField);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerMove(PlayerMoveEvent event) {
        List<Field> currentFields;
        if (event.isCancelled()) {
            return;
        }
        if (event.getFrom() == null || event.getTo() == null) {
            return;
        }
        if (Helper.isSameLocation(event.getFrom(), event.getTo())) {
            return;
        }
        if (this.plugin.getSettingsManager().isOncePerBlockOnMove() && Helper.isSameBlock(event.getFrom(), event.getTo())) {
            return;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getPlayer().getLocation().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (!Helper.isSameBlock(event.getFrom(), event.getTo()) && this.plugin.getSettingsManager().isVisualizeEndOnMove() && !this.plugin.getPermissionsManager().has(player, "preciousstones.admin.visualize") && !this.plugin.getCuboidManager().hasOpenCuboid(player)) {
            this.plugin.getVisualizationManager().revert(player);
        }
        if ((currentFields = this.plugin.getEntryManager().getPlayerEntryFields(player)) != null) {
            for (Field entryField : currentFields) {
                if (entryField.envelops(event.getTo())) continue;
                this.plugin.getEntryManager().leaveField(player, entryField);
                if (this.plugin.getEntryManager().containsSameNameOwnedField(player, entryField)) continue;
                this.plugin.getEntryManager().leaveOverlappedArea(player, entryField);
            }
        }
        List<Field> futureFields = this.plugin.getForceFieldManager().getEnabledSourceFields(event.getTo(), FieldFlag.ALL);
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.entry")) {
            for (Field field : futureFields) {
                Field f;
                if (!FieldFlag.PREVENT_ENTRY.applies(field, player)) continue;
                Location loc = this.plugin.getPlayerManager().getOutsideFieldLocation(field, player);
                Location outside = this.plugin.getPlayerManager().getOutsideLocation(player);
                if (outside != null && (f = this.plugin.getForceFieldManager().getEnabledSourceField(outside, FieldFlag.PREVENT_ENTRY)) != null) {
                    loc = outside;
                }
                event.setTo(loc);
                this.plugin.getCommunicationManager().warnEntry(player, field);
                return;
            }
        }
        for (Field field : futureFields) {
            if (!field.hasFlag(FieldFlag.TELEPORT_IF_NOT_WALKING_ON) && !field.hasFlag(FieldFlag.TELEPORT_IF_WALKING_ON) || !field.getSettings().teleportDueToWalking(event.getTo(), field, player)) continue;
            this.plugin.getTeleportationManager().teleport((Entity)player, field, "teleportAnnounceWalking");
        }
        this.plugin.getPlayerManager().updateOutsideLocation(player);
        for (Field futureField : futureFields) {
            PlayerEntry entry;
            ItemStack itemInHand;
            if (!this.plugin.getEntryManager().enteredField(player, futureField)) {
                if (!this.plugin.getEntryManager().containsSameNameOwnedField(player, futureField)) {
                    this.plugin.getEntryManager().enterOverlappedArea(player, futureField);
                }
                this.plugin.getEntryManager().enterField(player, futureField);
            }
            if (futureField.hasFlag(FieldFlag.TELEPORT_IF_HAS_ITEMS) || futureField.hasFlag(FieldFlag.TELEPORT_IF_NOT_HAS_ITEMS)) {
                PlayerInventory inventory = player.getInventory();
                ItemStack[] contents = inventory.getContents();
                boolean hasItem = false;
                for (ItemStack stack : contents) {
                    if (stack == null || stack.getType() == Material.AIR) continue;
                    if (futureField.getSettings().isTeleportHasItem(new BlockTypeEntry(stack.getType())) && FieldFlag.TELEPORT_IF_HAS_ITEMS.applies(futureField, player)) {
                        PlayerEntry entry2 = this.plugin.getPlayerManager().getPlayerEntry(player);
                        if (!entry2.isTeleporting()) {
                            entry2.setTeleporting(true);
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getTeleportationManager().teleport((Entity)player, futureField, "teleportAnnounceHasItems"), 0L);
                        }
                        return;
                    }
                    if (!FieldFlag.TELEPORT_IF_NOT_HAS_ITEMS.applies(futureField, player) || !futureField.getSettings().isTeleportHasNotItem(new BlockTypeEntry(stack.getType()))) continue;
                    hasItem = true;
                }
                if (!hasItem && FieldFlag.TELEPORT_IF_NOT_HAS_ITEMS.applies(futureField, player)) {
                    PlayerEntry entry3 = this.plugin.getPlayerManager().getPlayerEntry(player);
                    if (!entry3.isTeleporting()) {
                        entry3.setTeleporting(true);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getTeleportationManager().teleport((Entity)player, futureField, "teleportAnnounceNotHasItems"), 0L);
                    }
                    return;
                }
            }
            if ((itemInHand = player.getInventory().getItemInMainHand()) != null && itemInHand.getType() != Material.AIR && futureField.getSettings().isTeleportHoldingItem(new BlockTypeEntry(itemInHand.getType())) && FieldFlag.TELEPORT_IF_HOLDING_ITEMS.applies(futureField, player)) {
                entry = this.plugin.getPlayerManager().getPlayerEntry(player);
                if (!entry.isTeleporting()) {
                    entry.setTeleporting(true);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getTeleportationManager().teleport((Entity)player, futureField, "teleportAnnounceHoldingItems"), 0L);
                }
                return;
            }
            itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand == null || itemInHand.getType() == Material.AIR || futureField.getSettings().isTeleportNotHoldingItem(new BlockTypeEntry(itemInHand.getType())) || !FieldFlag.TELEPORT_IF_NOT_HOLDING_ITEMS.applies(futureField, player) || (entry = this.plugin.getPlayerManager().getPlayerEntry(player)).isTeleporting()) continue;
            entry.setTeleporting(true);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getTeleportationManager().teleport((Entity)player, futureField, "teleportAnnounceNotHoldingItems"), 0L);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Field field;
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getPlayer().getLocation().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (entity.getType().equals((Object)EntityType.ITEM_FRAME) && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.item-frame-take") && (field = this.plugin.getForceFieldManager().getEnabledSourceField(entity.getLocation(), FieldFlag.PREVENT_ITEM_FRAME_TAKE)) != null && FieldFlag.PREVENT_ITEM_FRAME_TAKE.applies(field, player)) {
            event.setCancelled(true);
        }
        if (entity.getType().equals((Object)EntityType.ARMOR_STAND) && player != null && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.armor-stand-take") && (field = this.plugin.getForceFieldManager().getEnabledSourceField(entity.getLocation(), FieldFlag.PROTECT_ARMOR_STANDS)) != null && FieldFlag.PROTECT_ARMOR_STANDS.applies(field, player)) {
            event.setCancelled(true);
        }
        if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.entity-interact") && (field = this.plugin.getForceFieldManager().getEnabledSourceField(entity.getLocation(), FieldFlag.PREVENT_ENTITY_INTERACT)) != null && FieldFlag.PREVENT_ENTITY_INTERACT.applies(field, player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        TargetBlock aiming2;
        boolean hasCuboidHand;
        Field field;
        Block fireBlock;
        Field useField;
        Field field2;
        if (this.plugin.getSettingsManager().isBlacklistedWorld(event.getPlayer().getLocation().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        EquipmentSlot hand = event.getHand();
        ItemStack is = player.getInventory().getItemInMainHand();
        if (hand != null && !hand.equals((Object)EquipmentSlot.HAND)) {
            return;
        }
        if (block != null && is.getType().equals((Object)Material.ARMOR_STAND) && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.armor-stand-take") && (field2 = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PROTECT_ARMOR_STANDS)) != null && FieldFlag.PROTECT_ARMOR_STANDS.applies(field2, player)) {
            event.setCancelled(true);
            this.plugin.getCommunicationManager().warnPlaceItem(player, is, block.getLocation(), field2);
            return;
        }
        if (block != null && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.use") && (useField = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_USE)) != null && FieldFlag.PREVENT_USE.applies(useField, player) && !useField.getSettings().canUse(new BlockTypeEntry(block))) {
            this.plugin.getCommunicationManager().warnUse(player, block, useField);
            event.setCancelled(true);
            return;
        }
        if (block != null && (fireBlock = block.getRelative(BlockFace.UP)).getType().equals((Object)Material.FIRE) && (field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_FIRE)) != null && FieldFlag.PREVENT_FIRE.applies(field, player)) {
            event.setCancelled(true);
            fireBlock.setType(Material.FIRE);
            return;
        }
        if (block != null && SignHelper.isSign(block)) {
            Block attachedBlock = SignHelper.getAttachedBlock(block);
            field = PreciousStones.getInstance().getForceFieldManager().getField(attachedBlock);
            if (field != null) {
                PreciousStones.debug("clicked sign on field", new Object[0]);
                FieldSign s = new FieldSign(block);
                if (s.isValid()) {
                    PreciousStones.debug("sign is a valid field sign", new Object[0]);
                    if (!field.isOwner(player.getName())) {
                        PreciousStones.debug("player is a customer", new Object[0]);
                        if (field.isDisabled()) {
                            ChatHelper.send((CommandSender)player, "fieldSignCannotRentDisabled", new Object[0]);
                            event.setCancelled(true);
                            return;
                        }
                        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                            if (this.plugin.getSettingsManager().isCommandsToRentBuy()) {
                                if (s.isRentable() || s.isShareable()) {
                                    ChatHelper.send((CommandSender)player, "rentQuestion", new Object[0]);
                                } else if (s.isBuyable()) {
                                    ChatHelper.send((CommandSender)player, "buyQuestion", new Object[0]);
                                }
                                event.setCancelled(true);
                                return;
                            }
                            if (s.isRentable() || s.isShareable()) {
                                if (s.isRentable()) {
                                    PreciousStones.debug("customer right-clicked on rentable", new Object[0]);
                                    if (field.isRented()) {
                                        PreciousStones.debug("field is rented", new Object[0]);
                                        if (!field.isRenter(player.getName())) {
                                            PreciousStones.debug("but player is not the renter", new Object[0]);
                                            ChatHelper.send((CommandSender)player, "fieldSignAlreadyRented", new Object[0]);
                                            this.plugin.getCommunicationManager().showRenterInfo(player, field);
                                            event.setCancelled(true);
                                            return;
                                        }
                                        PreciousStones.debug("and player is the renter", new Object[0]);
                                        if (player.isSneaking()) {
                                            PreciousStones.debug("and sneaking", new Object[0]);
                                            ChatHelper.send((CommandSender)player, "fieldSignRentAbandoned", new Object[0]);
                                            event.setCancelled(true);
                                            return;
                                        }
                                    }
                                }
                                PreciousStones.debug("time to rent (shareable or rentable)", new Object[0]);
                                if (field.getRentingModule().rent(player, s)) {
                                    PreciousStones.debug("renting was successful", new Object[0]);
                                    event.setCancelled(true);
                                    return;
                                }
                                PreciousStones.debug("rent failed", new Object[0]);
                                return;
                            }
                            if (s.isBuyable()) {
                                PreciousStones.debug("customer right clicked on buyable", new Object[0]);
                                if (field.getBuyingModule().buy(player, s)) {
                                    ChatHelper.send((CommandSender)player, "fieldSignBought", new Object[0]);
                                }
                                event.setCancelled(true);
                                return;
                            }
                        }
                        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
                            if (s.isRentable()) {
                                PreciousStones.debug("customer right left clicked on rentable", new Object[0]);
                                if (field.isRented() && !field.isRenter(player.getName())) {
                                    PreciousStones.debug("but hes not the renter so show him who rents it", new Object[0]);
                                    ChatHelper.send((CommandSender)player, "fieldSignAlreadyRented", new Object[0]);
                                    this.plugin.getCommunicationManager().showRenterInfo(player, field);
                                }
                            } else {
                                PreciousStones.debug("show field details", new Object[0]);
                                this.plugin.getCommunicationManager().showFieldDetails(player, field);
                                this.plugin.getCommunicationManager().showRenterInfo(player, field);
                            }
                        }
                        event.setCancelled(true);
                        return;
                    }
                    PreciousStones.debug("player is the owner", new Object[0]);
                    if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                        PreciousStones.debug("owner right clicked on sign", new Object[0]);
                        if (field.isRented()) {
                            if (field.getRentingModule().hasPendingPayments()) {
                                PreciousStones.debug("field is has pending payments, take them", new Object[0]);
                                field.getRentingModule().takePayment(player);
                            } else {
                                PreciousStones.debug("no pending payments, just show info", new Object[0]);
                                this.plugin.getCommunicationManager().showRenterInfo(player, field);
                            }
                        } else {
                            PreciousStones.debug("field hasn't been rented", new Object[0]);
                            ChatHelper.send((CommandSender)player, "fieldSignNoTennant", new Object[0]);
                        }
                        event.setCancelled(true);
                        return;
                    }
                } else {
                    PreciousStones.debug("could not validate the field sign", new Object[0]);
                    if (s.getFailReason() != null) {
                        ChatHelper.send((CommandSender)player, s.getFailReason(), new Object[0]);
                    }
                }
            }
        }
        if (block != null && this.plugin.getSettingsManager().isCrop(block) && (field2 = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.PROTECT_CROPS)) != null && FieldFlag.PROTECT_CROPS.applies(field2, player)) {
            event.setCancelled(true);
        }
        boolean bl = hasCuboidHand = is == null || is.getType() == Material.AIR || this.plugin.getSettingsManager().isToolItemType(new BlockTypeEntry(is.getType())) || this.plugin.getSettingsManager().isFieldType(new BlockTypeEntry(is.getType()), is);
        if (hasCuboidHand) {
            Block target;
            if (this.plugin.getCuboidManager().hasOpenCuboid(player)) {
                if (event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
                    this.plugin.getCuboidManager().expandDirection(player);
                    return;
                }
                if (event.getAction().equals((Object)Action.LEFT_CLICK_AIR) || event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
                    aiming2 = new TargetBlock(player, this.plugin.getSettingsManager().getMaxTargetDistance(), 0.2, this.plugin.getSettingsManager().getThroughFieldsSet());
                    target = aiming2.getTargetBlock();
                    if (target == null) {
                        return;
                    }
                    if (player.isSneaking()) {
                        event.setCancelled(true);
                        this.plugin.getCuboidManager().closeCuboid(player);
                        return;
                    }
                    if (this.plugin.getCuboidManager().isOpenCuboid(player, target)) {
                        event.setCancelled(true);
                        this.plugin.getCuboidManager().closeCuboid(player);
                        return;
                    }
                    if (this.plugin.getForceFieldManager().getField(target) != null) {
                        return;
                    }
                    Field field3 = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.PREVENT_DESTROY);
                    if (field3 == null) {
                        field3 = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.GRIEF_REVERT);
                    }
                    if (field3 != null) {
                        boolean applies = FieldFlag.PROTECT_CROPS.applies(field3, player);
                        boolean applies2 = FieldFlag.GRIEF_REVERT.applies(field3, player);
                        if ((applies || applies2) && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.destroy")) {
                            return;
                        }
                    }
                    if (this.plugin.getCuboidManager().processSelectedBlock(player, target)) {
                        event.setCancelled(true);
                    }
                    return;
                }
            } else if (event.getAction().equals((Object)Action.LEFT_CLICK_AIR) || event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
                try {
                    Field field4;
                    aiming2 = new TargetBlock(player, this.plugin.getSettingsManager().getMaxTargetDistance(), 0.2, this.plugin.getSettingsManager().getThroughFieldsSet());
                    target = aiming2.getTargetBlock();
                    if (target == null) {
                        return;
                    }
                    if (player.isSneaking() && (field4 = this.plugin.getForceFieldManager().getField(target)) != null) {
                        if (field4.getBlock().getType().equals((Object)Material.AIR)) {
                            return;
                        }
                        if (field4.hasFlag(FieldFlag.CUBOID)) {
                            if (field4.getParent() != null) {
                                field4 = field4.getParent();
                            }
                            if (field4.isOwner(player.getName()) || this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.cuboid")) {
                                if (field4.hasFlag(FieldFlag.TRANSLOCATION) && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.cuboid") && field4.isNamed() && this.plugin.getStorageManager().existsTranslocatior(field4.getName(), field4.getOwner())) {
                                    ChatHelper.send((CommandSender)player, "cannotReshapeWhileCuboid", new Object[0]);
                                    return;
                                }
                                if (this.plugin.getForceFieldManager().hasSubFields(field4)) {
                                    ChatHelper.send((CommandSender)player, "cannotRedefineWhileCuboid", new Object[0]);
                                    return;
                                }
                                if (!this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.on-disabled") && field4.hasFlag(FieldFlag.REDEFINE_ON_DISABLED) && !field4.isDisabled()) {
                                    ChatHelper.send((CommandSender)player, "redefineWhileDisabled", new Object[0]);
                                    return;
                                }
                                if (field4.isRented() && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.destroy")) {
                                    ChatHelper.send((CommandSender)player, "fieldSignCannotChange", new Object[0]);
                                    return;
                                }
                                if (field4.hasFlag(FieldFlag.NO_RESIZE) && !this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.no-resize")) {
                                    ChatHelper.send((CommandSender)player, "noResize", new Object[0]);
                                    return;
                                }
                                event.setCancelled(true);
                                this.plugin.getCuboidManager().openCuboid(player, field4);
                            }
                            return;
                        }
                    }
                }
                catch (Exception aiming2) {
                    // empty catch block
                }
            }
        }
        if (block != null) {
            if (event.getAction().equals((Object)Action.PHYSICAL)) {
                this.plugin.getSnitchManager().recordSnitchUsed(player, block);
            }
            if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                if (block.getType() == Material.WALL_SIGN) {
                    this.plugin.getSnitchManager().recordSnitchShop(player, block);
                }
                if (block.getType() == Material.CRAFTING_TABLE || block.getType() == Material.RED_BED || block.getType() == Material.OAK_DOOR || block.getType() == Material.LEVER || block.getType() == Material.MINECART || block.getType() == Material.NOTE_BLOCK || block.getType() == Material.JUKEBOX || block.getType() == Material.STONE_BUTTON || block.getType() == Material.OAK_BUTTON) {
                    this.plugin.getSnitchManager().recordSnitchUsed(player, block);
                }
                if (block.getState() instanceof InventoryHolder) {
                    this.plugin.getSnitchManager().recordSnitchUsed(player, block);
                }
                if (is != null && this.plugin.getSettingsManager().isToolItemType(new BlockTypeEntry(is.getType()))) {
                    Object targetBlock;
                    if (this.plugin.getSettingsManager().isBypassBlock(block)) {
                        return;
                    }
                    try {
                        aiming2 = new TargetBlock(player, this.plugin.getSettingsManager().getMaxTargetDistance(), 0.2, new Material[]{Material.AIR});
                        targetBlock = aiming2.getTargetBlock();
                        if (targetBlock != null && this.plugin.getForceFieldManager().isField((Block)targetBlock)) {
                            block = targetBlock;
                        }
                    }
                    catch (Exception aiming3) {
                        // empty catch block
                    }
                    if (this.plugin.getForceFieldManager().isField(block)) {
                        field = this.plugin.getForceFieldManager().getField(block);
                        if (field.isChild()) {
                            field = field.getParent();
                        }
                        if (!(field.getSettings().getRequiredPermissionUse().isEmpty() || this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.required-permission") || this.plugin.getPermissionsManager().has(player, field.getSettings().getRequiredPermissionUse()))) {
                            return;
                        }
                        if (field.hasFlag(FieldFlag.FORESTER) && field.getForestingModule().hasForesterUse() && !field.getForestingModule().isForesting()) {
                            targetBlock = new ForesterEntry(field, (CommandSender)player);
                        }
                        if (field.getNewOwner() != null) {
                            if (field.getNewOwner().equalsIgnoreCase(player.getName())) {
                                this.plugin.getStorageManager().changeTranslocationOwner(field, field.getNewOwner());
                                String oldOwnerName = field.getOwner();
                                field.changeOwner();
                                this.plugin.getStorageManager().offerPlayer(field.getOwner());
                                this.plugin.getStorageManager().offerPlayer(oldOwnerName);
                                this.plugin.getStorageManager().offerField(field);
                                ChatHelper.send((CommandSender)player, "takenFieldOwnership", oldOwnerName);
                                Player oldOwner = Bukkit.getServer().getPlayerExact(oldOwnerName);
                                if (oldOwner != null) {
                                    ChatHelper.send((CommandSender)oldOwner, "tookOwnership", player.getName());
                                }
                                return;
                            }
                            ChatHelper.send((CommandSender)player, "cannotTakeOwnership", field.getNewOwner());
                        }
                        if (player.isSneaking()) {
                            if (FieldFlag.VISUALIZE_ON_SRC.applies(field, player)) {
                                if (this.plugin.getCuboidManager().hasOpenCuboid(player)) {
                                    ChatHelper.send((CommandSender)player, "visualizationNotWhileCuboid", new Object[0]);
                                } else if (this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.visualize")) {
                                    ChatHelper.send((CommandSender)player, "visualizing", new Object[0]);
                                    this.plugin.getVisualizationManager().visualizeSingleField(player, field);
                                }
                            }
                            if (!field.hasFlag(FieldFlag.TRANSLOCATION) && FieldFlag.ENABLE_ON_SRC.applies(field, player)) {
                                if (field.isDisabled()) {
                                    ChatHelper.send((CommandSender)player, "fieldTypeEnabled", field.getSettings().getTitle());
                                    boolean disabled = field.setDisabled(false, player);
                                    if (!disabled) {
                                        ChatHelper.send((CommandSender)player, "cannotEnable", new Object[0]);
                                        return;
                                    }
                                    field.getFlagsModule().dirtyFlags("visualize/enable on sneaking right click1");
                                } else {
                                    ChatHelper.send((CommandSender)player, "fieldTypeDisabled", field.getSettings().getTitle());
                                    field.setDisabled(true, player);
                                    field.getFlagsModule().dirtyFlags("visualize/enable on sneaking right click2");
                                }
                            }
                        } else {
                            if (this.plugin.getSettingsManager().isSnitchType(block) && (this.plugin.getForceFieldManager().isAllowed(field, player.getName()) || this.plugin.getPermissionsManager().has(player, "preciousstones.admin.details"))) {
                                if (!this.plugin.getCommunicationManager().showSnitchList(player, this.plugin.getForceFieldManager().getField(block))) {
                                    this.showInfo(field, player);
                                    ChatHelper.send((CommandSender)player, "noIntruders", new Object[0]);
                                    ChatHelper.sendBlank((CommandSender)player);
                                }
                                return;
                            }
                            if (field.hasFlag(FieldFlag.GRIEF_REVERT) && (this.plugin.getForceFieldManager().isAllowed(block, player.getName()) || this.plugin.getPermissionsManager().has(player, "preciousstones.admin.undo"))) {
                                int size = this.plugin.getGriefUndoManager().undoGrief(field);
                                if (size == 0) {
                                    this.showInfo(field, player);
                                    ChatHelper.send((CommandSender)player, "noGriefRecorded", new Object[0]);
                                    ChatHelper.sendBlank((CommandSender)player);
                                }
                                return;
                            }
                            boolean showTranslocations = false;
                            if (this.plugin.getPermissionsManager().has(player, "preciousstones.translocation.use") && field.hasFlag(FieldFlag.TRANSLOCATION) && this.plugin.getForceFieldManager().isAllowed(block, player.getName()) && !field.getTranslocatingModule().isTranslocating()) {
                                if (field.isNamed()) {
                                    if (!field.isDisabled()) {
                                        if (this.plugin.getStorageManager().appliedTranslocationCount(field) > 0) {
                                            PreciousStones.debug("clearing", new Object[0]);
                                            int size = this.plugin.getTranslocationManager().clearTranslocation(field);
                                            this.plugin.getCommunicationManager().notifyClearTranslocation(field, player, size);
                                            return;
                                        }
                                        PreciousStones.debug("disabled", new Object[0]);
                                        field.setDisabled(true, player);
                                        field.getFlagsModule().dirtyFlags("right click translocation1");
                                        return;
                                    }
                                    if (this.plugin.getStorageManager().unappliedTranslocationCount(field) > 0) {
                                        PreciousStones.debug("applying", new Object[0]);
                                        int size = this.plugin.getTranslocationManager().applyTranslocation(field);
                                        this.plugin.getCommunicationManager().notifyApplyTranslocation(field, player, size);
                                        return;
                                    }
                                    PreciousStones.debug("recording", new Object[0]);
                                    boolean disabled = field.setDisabled(false, player);
                                    if (!disabled) {
                                        ChatHelper.send((CommandSender)player, "cannotEnable", new Object[0]);
                                        return;
                                    }
                                    field.getFlagsModule().dirtyFlags("right click translocation2");
                                    return;
                                }
                                showTranslocations = true;
                            }
                            if (this.showInfo(field, player) && this.plugin.getPermissionsManager().has(player, "preciousstones.benefit.toggle")) {
                                if (showTranslocations) {
                                    this.plugin.getCommunicationManager().notifyStoredTranslocations(player);
                                } else if (!field.isDisabled() && !field.hasFlag(FieldFlag.TOGGLE_ON_DISABLED)) {
                                    ChatHelper.send((CommandSender)player, "usageToggle", new Object[0]);
                                }
                                ChatHelper.sendBlank((CommandSender)player);
                            }
                        }
                    } else if (this.plugin.getUnbreakableManager().isUnbreakable(block)) {
                        if (this.plugin.getUnbreakableManager().isOwner(block, player.getName()) || this.plugin.getSettingsManager().isPublicBlockDetails() || this.plugin.getPermissionsManager().has(player, "preciousstones.admin.details")) {
                            this.plugin.getCommunicationManager().showUnbreakableDetails(this.plugin.getUnbreakableManager().getUnbreakable(block), player);
                        } else {
                            this.plugin.getCommunicationManager().showUnbreakableDetails(player, block);
                        }
                    } else {
                        field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.ALL);
                        if (field != null && (this.plugin.getForceFieldManager().isAllowed(field, player.getName()) || this.plugin.getSettingsManager().isPublicBlockDetails()) && !this.plugin.getSettingsManager().isDisableGroundInfo()) {
                            this.plugin.getCommunicationManager().showProtectedLocation(player, block);
                        }
                    }
                }
            }
        }
    }

    private boolean showInfo(Field field, Player player) {
        Block block = field.getBlock();
        if (this.plugin.getForceFieldManager().isAllowed(block, player.getName()) || this.plugin.getSettingsManager().isPublicBlockDetails() || this.plugin.getPermissionsManager().has(player, "preciousstones.admin.details")) {
            return this.plugin.getCommunicationManager().showFieldDetails(player, field);
        }
        this.plugin.getCommunicationManager().showFieldOwner(player, block);
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlockClicked();
        Block liquid = block.getRelative(event.getBlockFace());
        if (block == null) {
            return;
        }
        if (this.plugin.getSettingsManager().isBlacklistedWorld(player.getLocation().getWorld())) {
            return;
        }
        this.plugin.getSnitchManager().recordSnitchBucketFill(player, block);
        if (this.plugin.getForceFieldManager().isField(block)) {
            event.setCancelled(true);
            return;
        }
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_DESTROY);
        if (field != null && !field.getSettings().inDestroyBlacklist(block) && FieldFlag.PREVENT_DESTROY.applies(field, player)) {
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.destroy")) {
                this.plugin.getCommunicationManager().notifyBypassDestroy(player, block, field);
            } else {
                event.setCancelled(true);
                this.plugin.getCommunicationManager().warnDestroyArea(player, block, field);
            }
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.GRIEF_REVERT)) != null && FieldFlag.GRIEF_REVERT.applies(field, player)) {
            if (field.getSettings().canGrief(new BlockTypeEntry(block))) {
                return;
            }
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.destroy")) {
                this.plugin.getCommunicationManager().notifyBypassPlace(player, block, field);
            } else {
                event.setCancelled(true);
                this.plugin.getCommunicationManager().warnDestroyArea(player, block, field);
                return;
            }
        }
        if (liquid.isLiquid() && (field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.TRANSLOCATION)) != null && field.isNamed()) {
            this.plugin.getTranslocationManager().removeBlock(field, block);
            this.plugin.getTranslocationManager().flashFieldBlock(field, player);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        Field field;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlockClicked();
        Block liquid = block.getRelative(event.getBlockFace());
        Material mat = event.getBucket();
        if (this.plugin.getSettingsManager().isBlacklistedWorld(player.getLocation().getWorld())) {
            return;
        }
        if (mat.equals((Object)Material.LAVA_BUCKET)) {
            this.plugin.getSnitchManager().recordSnitchBucketEmpty(player, block, "LAVA");
        }
        if (mat.equals((Object)Material.WATER_BUCKET)) {
            this.plugin.getSnitchManager().recordSnitchBucketEmpty(player, block, "WATER");
        }
        if (mat.equals((Object)Material.MILK_BUCKET)) {
            this.plugin.getSnitchManager().recordSnitchBucketEmpty(player, block, "MILK");
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.PREVENT_PLACE)) != null && !field.getSettings().inPlaceBlacklist(block) && FieldFlag.PREVENT_PLACE.applies(field, player)) {
            if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place")) {
                this.plugin.getCommunicationManager().notifyBypassPlace(player, block, field);
            } else {
                event.setCancelled(true);
                this.plugin.getCommunicationManager().warnEmpty(player, block, field);
            }
        }
        if ((field = this.plugin.getForceFieldManager().getEnabledSourceField(block.getLocation(), FieldFlag.GRIEF_REVERT)) != null && FieldFlag.GRIEF_REVERT.applies(field, player)) {
            if (field.hasFlag(FieldFlag.PLACE_GRIEF)) {
                if (!this.plugin.getSettingsManager().isGriefUndoBlackListType(block.getType())) {
                    this.plugin.getGriefUndoManager().addBlock(field, block, true);
                    this.plugin.getStorageManager().offerGrief(field);
                }
            } else if (this.plugin.getPermissionsManager().has(player, "preciousstones.bypass.place")) {
                this.plugin.getCommunicationManager().notifyBypassPlace(player, block, field);
            } else {
                event.setCancelled(true);
                this.plugin.getCommunicationManager().warnPlace(player, block, field);
                return;
            }
        }
        if (!liquid.isLiquid()) {
            return;
        }
        field = this.plugin.getForceFieldManager().getEnabledSourceField(liquid.getLocation(), FieldFlag.TRANSLOCATION);
        if (field != null && FieldFlag.TRANSLOCATION.applies(field, player) && field.getSettings().canTranslocate(new BlockTypeEntry(liquid))) {
            if (field.getName().length() == 0) {
                ChatHelper.send((CommandSender)player, "translocatorNameToBegin", new Object[0]);
                event.setCancelled(true);
            }
            if (field.getTranslocatingModule().isOverTranslocationMax(1)) {
                ChatHelper.send((CommandSender)player, "translocationReachedSize", new Object[0]);
                event.setCancelled(true);
                return;
            }
            Field finalField = field;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                this.plugin.getTranslocationManager().addBlock(finalField, liquid);
                this.plugin.getTranslocationManager().flashFieldBlock(finalField, player);
            }, 5L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerGameModeChangeEvent(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        GameMode gameMode = event.getNewGameMode();
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.ALL);
        if (field != null && field.getSettings().getForceEntryGameMode() != null && FieldFlag.ENTRY_GAME_MODE.applies(field, player) && !gameMode.equals((Object)field.getSettings().getForceEntryGameMode())) {
            ChatHelper.send((CommandSender)player, "cannotChangeGameMode", new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPotionSplash(PotionSplashEvent event) {
        boolean hasHarm = false;
        ThrownPotion potion = event.getPotion();
        Collection effects = potion.getEffects();
        for (PotionEffect effect : effects) {
            if (!effect.getType().equals((Object)PotionEffectType.BLINDNESS) && !effect.getType().equals((Object)PotionEffectType.CONFUSION) && !effect.getType().equals((Object)PotionEffectType.HARM) && !effect.getType().equals((Object)PotionEffectType.POISON) && !effect.getType().equals((Object)PotionEffectType.WEAKNESS) && !effect.getType().equals((Object)PotionEffectType.SLOW) && !effect.getType().equals((Object)PotionEffectType.SLOW_DIGGING)) continue;
            hasHarm = true;
        }
        if (hasHarm) {
            Collection entities = event.getAffectedEntities();
            for (LivingEntity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.PREVENT_PVP);
                if (field == null) continue;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPortalEnter(PlayerPortalEvent event) {
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(event.getPlayer().getLocation(), FieldFlag.PREVENT_PORTAL_ENTER);
        if (field != null && FieldFlag.PREVENT_PORTAL_ENTER.applies(field, event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPortalExit(EntityPortalExitEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getEntryManager().reevaluateEnteredFields(player), 1L);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getEntryManager().reevaluateEnteredFields(player), 5L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerSprint(PlayerToggleSprintEvent event) {
        if (event.isSprinting()) {
            return;
        }
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(event.getPlayer().getLocation(), FieldFlag.NO_PLAYER_SPRINT);
        if (field != null && FieldFlag.NO_PLAYER_SPRINT.applies(field, event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerItemHeldEvent(PlayerItemHeldEvent event) {
        int slot;
        PlayerInventory inv;
        ItemStack item;
        if (event == null) {
            return;
        }
        Player player = event.getPlayer();
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.UNUSABLE_ITEMS);
        if (field != null && FieldFlag.UNUSABLE_ITEMS.applies(field, player) && (item = (inv = player.getInventory()).getItem(slot = event.getNewSlot())) != null && field.getSettings().isUnusableItem(item.getType())) {
            StackHelper.unHoldItem(player, slot);
            ChatHelper.send((CommandSender)player, "cannotUseItemMoved", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemPickup(PlayerPickupItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.UNUSABLE_ITEMS);
        if (field != null && FieldFlag.UNUSABLE_ITEMS.applies(field, player) && player.getInventory().getItemInMainHand().getType() == event.getItem().getItemStack().getType() && field.getSettings().isUnusableItem(event.getItem().getItemStack().getType())) {
            ChatHelper.send((CommandSender)player, "cannotUseItemHere", new Object[0]);
            StackHelper.unHoldItem(player, player.getInventory().getHeldItemSlot());
        }
    }

    @EventHandler
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            Player player = (Player)event.getPlayer();
            Field field = this.plugin.getForceFieldManager().getEnabledSourceField(player.getLocation(), FieldFlag.UNUSABLE_ITEMS);
            if (field != null && FieldFlag.UNUSABLE_ITEMS.applies(field, player) && field.getSettings().isUnusableItem(player.getInventory().getItemInMainHand().getType())) {
                ChatHelper.send((CommandSender)player, "cannotUseItemHere", new Object[0]);
                StackHelper.unHoldItem(player, player.getInventory().getHeldItemSlot());
            }
        }
    }
}

