/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones;

import java.util.HashMap;
import java.util.Map;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import org.apache.commons.lang.time.DurationFormatUtils;

public class Timing {
    private String title;
    private Map<String, Long> times = new HashMap<String, Long>();

    public Timing(String title) {
        this.title = title;
        this.poll("start");
    }

    public void poll(String name) {
        this.times.put(name, System.currentTimeMillis());
    }

    public void last(String name) {
        this.poll(name);
        this.printResults();
    }

    public void printResults() {
        Long previousTime = -9999L;
        PreciousStones.debug("----------------------------------------------------------------------", new Object[0]);
        PreciousStones.debug(this.title + " Timings", new Object[0]);
        PreciousStones.debug("----------------------------------------------------------------------", new Object[0]);
        for (Map.Entry<String, Long> timeObj : this.times.entrySet()) {
            Long time = timeObj.getValue();
            if (previousTime == -9999L) {
                previousTime = time;
                continue;
            }
            long duration = Math.max(time - previousTime, 0L);
            String friendlyDuration = DurationFormatUtils.formatDuration((long)duration, (String)"ss.SSS");
            PreciousStones.debug(friendlyDuration + "  " + timeObj.getKey(), new Object[0]);
            previousTime = time;
        }
        PreciousStones.debug("----------------------------------------------------------------------", new Object[0]);
        this.times.clear();
    }

    public void finalize() throws Throwable {
        if (!this.times.isEmpty()) {
            this.printResults();
        }
        super.finalize();
    }
}

