/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONObject;

public class ItemStackEntry {
    private final Material type;
    private final short durability;
    private final int amount;
    private Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();

    public ItemStackEntry(ItemStack item) {
        this.type = item.getType();
        this.durability = item.getDurability();
        this.enchantments = item.getEnchantments();
        this.amount = item.getAmount();
    }

    public ItemStackEntry(JSONObject o) {
        this.type = Material.valueOf((String)o.get((Object)"type").toString());
        this.durability = Short.parseShort(o.get((Object)"dmg").toString());
        this.amount = Integer.parseInt(o.get((Object)"a").toString());
        JSONObject ench = (JSONObject)o.get((Object)"e");
        if (ench != null) {
            for (Object enchId : ench.keySet()) {
                Integer level = Integer.parseInt(ench.get(enchId).toString());
                this.enchantments.put(Enchantment.getByName((String)enchId.toString()), level);
            }
        }
    }

    public JSONObject serialize() {
        JSONObject ench = new JSONObject();
        for (Enchantment e : this.enchantments.keySet()) {
            Integer integer = this.enchantments.get(e);
            ench.put((Object)e.getName(), (Object)integer);
        }
        JSONObject out = new JSONObject();
        out.put((Object)"type", (Object)this.getType().name());
        out.put((Object)"dmg", (Object)this.getDurability());
        out.put((Object)"a", (Object)this.getAmount());
        out.put((Object)"e", (Object)ench);
        return out;
    }

    public Material getType() {
        return this.type;
    }

    public short getDurability() {
        return this.durability;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean equals(Object obj) {
        Material id2;
        if (!(obj instanceof ItemStackEntry)) {
            return false;
        }
        ItemStackEntry other = (ItemStackEntry)obj;
        Material id1 = this.getType();
        return id1 == (id2 = other.getType());
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.getType().ordinal();
        return hash;
    }

    public ItemStack toItemStack() {
        ItemStack is = new ItemStack(this.getType(), this.getAmount(), this.getDurability());
        for (Map.Entry<Enchantment, Integer> ench : this.enchantments.entrySet()) {
            is.addUnsafeEnchantment(ench.getKey(), Math.min(ench.getValue(), ench.getKey().getMaxLevel()));
        }
        return is;
    }

    public String toString() {
        if (this.getDurability() == 0) {
            return this.getType().name();
        }
        return this.getType().name() + ":" + this.getDurability();
    }
}

