/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.blocks.TranslocationBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.ChatHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.helpers.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.translocation.TranslocationApplier;
import net.sacredlabyrinth.Phaed.PreciousStones.translocation.TranslocationImporter;
import net.sacredlabyrinth.Phaed.PreciousStones.translocation.TranslocationRemover;
import net.sacredlabyrinth.Phaed.PreciousStones.translocation.TranslocationUpdater;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public final class TranslocationManager {
    private PreciousStones plugin = PreciousStones.getInstance();

    public void addBlock(Field field, Block block) {
        this.addBlock(field, block, false);
    }

    public void addBlock(Field field, Block block, boolean isImport) {
        if (!this.plugin.getSettingsManager().isDependentBlock(block.getType())) {
            BlockFace[] faces;
            for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
                Block rel = block.getRelative(face);
                if (!this.plugin.getSettingsManager().isDependentBlock(rel.getType())) continue;
                this.addBlock(field, rel, isImport);
            }
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (Helper.isDoor(block)) {
                Block bottom = block.getRelative(BlockFace.DOWN);
                Block top = block.getRelative(BlockFace.UP);
                if (Helper.isDoor(bottom)) {
                    this.plugin.getStorageManager().insertTranslocationBlock(field, new TranslocationBlock(field, bottom));
                }
                if (Helper.isDoor(top)) {
                    this.plugin.getStorageManager().insertTranslocationBlock(field, new TranslocationBlock(field, top));
                }
                if (isImport) {
                    if (Helper.isDoor(block)) {
                        block.setType(Material.AIR, true);
                    }
                    if (Helper.isDoor(bottom)) {
                        bottom.setType(Material.AIR, true);
                    }
                    if (Helper.isDoor(top)) {
                        top.setType(Material.AIR, true);
                    }
                }
                return;
            }
        }, 5L);
        TranslocationBlock tb = new TranslocationBlock(field, block);
        if (block.getType().equals((Object)Material.WALL_SIGN) || block.getType().equals((Object)Material.SIGN)) {
            tb.setSignText(this.getSignText(block));
        }
        if (block.getState() instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)block.getState();
            Inventory inv = holder.getInventory();
            tb.setContents(inv.getContents());
        }
        boolean isApplied = !isImport;
        this.plugin.getStorageManager().insertTranslocationBlock(field, tb, isApplied);
        if (!isImport) {
            int count = this.plugin.getStorageManager().totalTranslocationCount(field.getName(), field.getOwner());
            field.getTranslocatingModule().setTranslocationSize(count);
        } else if (!Helper.isDoor(block)) {
            block.setType(Material.AIR, true);
        }
    }

    public void removeBlock(Field field, Block block) {
        TranslocationBlock tb = new TranslocationBlock(block);
        tb.setRelativeCoords(field);
        this.plugin.getStorageManager().deleteTranslocation(field, tb);
        int count = this.plugin.getStorageManager().totalTranslocationCount(field.getName(), field.getOwner());
        field.getTranslocatingModule().setTranslocationSize(count);
    }

    private String getSignText(Block block) {
        String signText = "";
        Sign sign = (Sign)block.getState();
        for (String line : sign.getLines()) {
            signText = signText + line + "`";
        }
        signText = Helper.stripTrailing(signText, "`");
        return signText;
    }

    public int applyTranslocation(Field field) {
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world != null) {
            Queue<TranslocationBlock> tbs = this.plugin.getStorageManager().retrieveTranslocation(field);
            if (!tbs.isEmpty()) {
                TranslocationApplier translocationApplier = new TranslocationApplier(field, tbs, world);
            }
            return tbs.size();
        }
        return 0;
    }

    public boolean applyTranslocationBlock(TranslocationBlock tb, World world) {
        Material[] seeThrough;
        Block block = world.getBlockAt(tb.getX(), tb.getY(), tb.getZ());
        if (!(block.getType().equals((Object)Material.AIR) || block.getType().equals((Object)Material.WATER) || block.getType().equals((Object)Material.LAVA))) {
            return false;
        }
        if (tb.isEmpty()) {
            block.setType(tb.getType(), true);
            return true;
        }
        boolean noConflict = false;
        block0: for (Material st : seeThrough = new Material[]{Material.AIR, Material.OAK_SAPLING, Material.WATER, Material.DEAD_BUSH, Material.DEAD_BUSH, Material.DANDELION, Material.POPPY, Material.BROWN_MUSHROOM, Material.RED_MUSHROOM, Material.WATER, Material.LAVA, Material.LAVA, Material.SAND, Material.FIRE, Material.WHEAT, Material.SUGAR_CANE, Material.CACTUS}) {
            if (block.getType() != st) continue;
            noConflict = true;
            if (st != Material.SAND) break;
            for (int count = 1; count < 256; ++count) {
                Material type = world.getBlockAt(tb.getX(), tb.getY() + count, tb.getZ()).getType();
                if (type != Material.AIR && type != Material.WATER && type != Material.LAVA) continue;
                Block toSand = world.getBlockAt(tb.getX(), tb.getY() + count, tb.getZ());
                toSand.setType(Material.SAND, false);
                break block0;
            }
            break;
        }
        if (noConflict) {
            block.setType(tb.getType(), true);
            if (block.getState() instanceof Sign && !tb.getSignText().isEmpty()) {
                Sign sign = (Sign)block.getState();
                String[] lines = tb.getSignText().split("[`]");
                for (int i = 0; i < lines.length; ++i) {
                    sign.setLine(i, lines[i]);
                    sign.update();
                }
            }
            if (tb.hasItemStacks()) {
                InventoryHolder holder = (InventoryHolder)block.getState();
                Inventory inv = holder.getInventory();
                inv.setContents(tb.getItemStacks());
            }
        }
        return true;
    }

    public int clearTranslocation(Field field) {
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world != null) {
            Queue<TranslocationBlock> tbs = this.plugin.getStorageManager().retrieveClearTranslocation(field);
            if (!tbs.isEmpty()) {
                TranslocationUpdater translocationUpdater = new TranslocationUpdater(field, tbs, world);
            }
            return tbs.size();
        }
        return 0;
    }

    public boolean wipeTranslocationBlock(Field field, TranslocationBlock tb) {
        Block block = tb.getBlock();
        if ((tb = this.processBlock(tb)) != null) {
            this.addBlock(field, block, true);
            block.setType(Material.AIR, true);
            return true;
        }
        return false;
    }

    public boolean updateTranslationBlock(Field field, TranslocationBlock tb, boolean clear) {
        Block block = tb.getBlock();
        if ((tb = this.processBlock(tb)) != null) {
            if (tb.hasItemStacks()) {
                this.plugin.getStorageManager().updateTranslocationBlockContents(field, tb);
            }
            if (!tb.getSignText().isEmpty()) {
                this.plugin.getStorageManager().updateTranslocationSignText(field, tb);
            }
            if (clear) {
                block.setType(Material.AIR, true);
            }
            return true;
        }
        return false;
    }

    private TranslocationBlock processBlock(TranslocationBlock tb) {
        Material id2;
        boolean equal;
        Block block = tb.getBlock();
        Material id1 = block.getType();
        boolean bl = equal = id1 == (id2 = tb.getType());
        if (id1 == Material.DIRT && id2 == Material.GRASS_BLOCK || id1 == Material.GRASS_BLOCK && id2 == Material.DIRT) {
            equal = true;
        }
        if (!equal) {
            PreciousStones.debug("translocation block rejected, it's id changed since it was recorded: " + block.getType() + " " + tb.getType(), new Object[0]);
            return null;
        }
        if (block.getType().equals((Object)Material.WALL_SIGN) || block.getType().equals((Object)Material.SIGN)) {
            tb.setSignText(this.getSignText(block));
        }
        if (block.getState() instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)block.getState();
            Inventory inv = holder.getInventory();
            tb.setContents(inv.getContents());
            inv.clear();
        }
        return tb;
    }

    public void zeroOutBlock(TranslocationBlock tb) {
        Block block = tb.getBlock().getWorld().getBlockAt(tb.getX(), tb.getY(), tb.getZ());
        block.setType(Material.AIR, true);
    }

    public void flashFieldBlock(Field field, Player player) {
        Set<Player> inhabitants = this.plugin.getForceFieldManager().getFieldInhabitants(field);
        inhabitants.add(player);
        for (Player p : inhabitants) {
            p.sendBlockChange(field.getLocation(), Material.GLASS, (byte)0);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            for (Player p : inhabitants) {
                p.sendBlockChange(field.getLocation(), field.getMaterial(), (byte)0);
            }
        }, 20L);
    }

    public void importBlocks(Field field, Player player, List<BlockTypeEntry> entries) {
        ProcessResult result = this.processBlocks(field, player, entries);
        Queue<TranslocationBlock> tbs = result.tbs;
        int notImported = result.notImported;
        int imported = tbs.size();
        if (!tbs.isEmpty()) {
            TranslocationImporter importer = new TranslocationImporter(field, tbs, player);
            ChatHelper.send((CommandSender)player, "translocationImportingBlocks", imported);
            if (notImported > 0) {
                ChatHelper.send((CommandSender)player, "translocationSkippedDueToLimit", notImported);
            }
        } else {
            ChatHelper.send((CommandSender)player, "nothingToImport", new Object[0]);
        }
        field.setDisabled(true);
        field.getFlagsModule().dirtyFlags("importBlocks");
    }

    public void removeBlocks(Field field, Player player, List<BlockTypeEntry> entries) {
        ProcessResult result = this.processBlocks(field, player, entries);
        Queue<TranslocationBlock> tbs = result.tbs;
        int notImported = result.notImported;
        int imported = tbs.size();
        if (!tbs.isEmpty()) {
            TranslocationRemover remover = new TranslocationRemover(field, tbs, player);
            ChatHelper.send((CommandSender)player, "translocationRemovingBlocks", imported);
            if (notImported > 0) {
                ChatHelper.send((CommandSender)player, "translocationSkippedDueToLimit", notImported);
            }
        } else {
            ChatHelper.send((CommandSender)player, "nothingToRemove", new Object[0]);
        }
        field.setDisabled(true);
        field.getFlagsModule().dirtyFlags("removeBlocks");
    }

    private ProcessResult processBlocks(Field field, Player player, List<BlockTypeEntry> entries) {
        int minx = field.getMinx();
        int maxx = field.getMaxx();
        int minz = field.getMinz();
        int maxz = field.getMaxz();
        int miny = field.getMiny();
        int maxy = field.getMaxy();
        int count = this.plugin.getStorageManager().totalTranslocationCount(field.getName(), field.getOwner());
        int maxCount = this.plugin.getSettingsManager().getMaxSizeTranslocation();
        int notImported = 0;
        LinkedList<TranslocationBlock> tbs = new LinkedList<TranslocationBlock>();
        HashMap<Material, BlockTypeEntry> map = new HashMap<Material, BlockTypeEntry>();
        if (entries != null) {
            for (BlockTypeEntry e : entries) {
                map.put(e.getMaterial(), e);
            }
        }
        for (int x = minx; x <= maxx; ++x) {
            for (int z = minz; z <= maxz; ++z) {
                for (int y = miny; y <= maxy; ++y) {
                    if (field.getX() == x && field.getY() == y && field.getZ() == z) continue;
                    if (count <= maxCount) {
                        Block block;
                        Material id = player.getWorld().getBlockAt(x, y, z).getType();
                        if (entries != null) {
                            BlockTypeEntry actual;
                            if (!map.containsKey(id)) continue;
                            block = player.getWorld().getBlockAt(x, y, z);
                            BlockTypeEntry entry = (BlockTypeEntry)map.get(id);
                            if (!entry.equals(actual = new BlockTypeEntry(block)) || !field.getSettings().canTranslocate(actual)) continue;
                            tbs.add(new TranslocationBlock(field, block));
                            ++count;
                            continue;
                        }
                        if (id == Material.AIR) continue;
                        block = player.getWorld().getBlockAt(x, y, z);
                        if (!field.getSettings().canTranslocate(new BlockTypeEntry(block))) continue;
                        tbs.add(new TranslocationBlock(field, block));
                        ++count;
                        continue;
                    }
                    ++notImported;
                }
            }
        }
        return new ProcessResult(tbs, notImported);
    }

    private final class ProcessResult {
        public Queue<TranslocationBlock> tbs;
        public int notImported;

        public ProcessResult(Queue<TranslocationBlock> tbs, int notImported) {
            this.tbs = tbs;
            this.notImported = notImported;
        }
    }
}

