/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.CuboidEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.PlayerEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.field.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.field.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.visualization.Visualization;
import net.sacredlabyrinth.Phaed.PreciousStones.visualization.Visualize;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class VisualizationManager {
    private PreciousStones plugin;
    private HashMap<String, Integer> counts = new HashMap();
    private HashMap<String, Visualization> visualizations = new HashMap();

    public VisualizationManager() {
        this.plugin = PreciousStones.getInstance();
    }

    public void visualizeSingleField(Player player, Field field) {
        this.addVisualizationField(player, field);
        this.displayVisualization(player, false);
    }

    public void visualizeSingleFieldFast(Player player, Field field) {
        this.addVisualizationField(player, field);
        this.displayVisualization(player, false, 2);
    }

    public boolean pendingVisualization(Player player) {
        return this.visualizations.containsKey(player.getName());
    }

    public void revertAll() {
        for (Map.Entry<String, Visualization> visualization : this.visualizations.entrySet()) {
            Visualization vis = visualization.getValue();
            Player player = Bukkit.getServer().getPlayerExact(visualization.getKey());
            if (player == null) continue;
            Visualize visualize = new Visualize(vis.getBlocks(), player, true, false, 0);
        }
        this.visualizations.clear();
        this.counts.clear();
    }

    public void addVisualizationField(Player player, Field field) {
        Location loc;
        int z;
        int count;
        boolean yTurn;
        int y;
        Location loc2;
        Visualization vis = this.visualizations.get(player.getName());
        if (vis == null) {
            vis = new Visualization();
        }
        if (this.plugin.getCuboidManager().hasOpenCuboid(player)) {
            return;
        }
        PlayerEntry data = this.plugin.getPlayerManager().getPlayerEntry(player);
        if (data.getDensity() == 0) {
            return;
        }
        vis.addField(field);
        Material visualizationType = field.hasFlag(FieldFlag.CUBOID) ? this.plugin.getSettingsManager().getCuboidVisualizationType().getMaterial() : this.plugin.getSettingsManager().getVisualizeBlock().getMaterial();
        Material frameType = this.plugin.getSettingsManager().getVisualizeFrameBlock().getMaterial();
        int minx = field.getX() - field.getRadius() - 1;
        int maxx = field.getX() + field.getRadius() + 1;
        int minz = field.getZ() - field.getRadius() - 1;
        int maxz = field.getZ() + field.getRadius() + 1;
        int miny = field.getY() - Math.max(field.getHeight() - 1, 0) / 2 - 1;
        int maxy = field.getY() + Math.max(field.getHeight() - 1, 0) / 2 + 1;
        if (field.hasFlag(FieldFlag.CUBOID)) {
            minx = field.getMinx() - 1;
            maxx = field.getMaxx() + 1;
            minz = field.getMinz() - 1;
            maxz = field.getMaxz() + 1;
            miny = field.getMiny() - 1;
            maxy = field.getMaxy() + 1;
        }
        for (int x = minx; x <= maxx; ++x) {
            loc2 = new Location(player.getWorld(), (double)x, (double)miny, (double)maxz);
            vis.addBlock(loc2, frameType);
            loc2 = new Location(player.getWorld(), (double)x, (double)maxy, (double)minz);
            vis.addBlock(loc2, frameType);
            loc2 = new Location(player.getWorld(), (double)x, (double)miny, (double)minz);
            vis.addBlock(loc2, frameType);
            loc2 = new Location(player.getWorld(), (double)x, (double)maxy, (double)maxz);
            vis.addBlock(loc2, frameType);
        }
        for (int y2 = miny; y2 <= maxy; ++y2) {
            loc2 = new Location(player.getWorld(), (double)minx, (double)y2, (double)maxz);
            vis.addBlock(loc2, frameType);
            loc2 = new Location(player.getWorld(), (double)maxx, (double)y2, (double)minz);
            vis.addBlock(loc2, frameType);
            loc2 = new Location(player.getWorld(), (double)minx, (double)y2, (double)minz);
            vis.addBlock(loc2, frameType);
            loc2 = new Location(player.getWorld(), (double)maxx, (double)y2, (double)maxz);
            vis.addBlock(loc2, frameType);
        }
        for (int z2 = minz; z2 <= maxz; ++z2) {
            loc2 = new Location(player.getWorld(), (double)minx, (double)maxy, (double)z2);
            vis.addBlock(loc2, frameType);
            loc2 = new Location(player.getWorld(), (double)maxx, (double)miny, (double)z2);
            vis.addBlock(loc2, frameType);
            loc2 = new Location(player.getWorld(), (double)minx, (double)miny, (double)z2);
            vis.addBlock(loc2, frameType);
            loc2 = new Location(player.getWorld(), (double)maxx, (double)maxy, (double)z2);
            vis.addBlock(loc2, frameType);
        }
        int spacing = (Math.max(Math.max(maxx - minx, maxy - miny), maxz - minz) + 2) / data.getDensity() + 1;
        for (y = miny; y <= maxy; ++y) {
            yTurn = this.turnCounter(player.getName() + 1, spacing);
            if (maxy - y < spacing) {
                yTurn = false;
            }
            count = 0;
            for (z = minz; z <= maxz; ++z) {
                if (!yTurn && !this.turnCounter(player.getName() + 2, spacing)) continue;
                if (maxz - z < spacing && !yTurn || !yTurn && count >= data.getDensity() - 1) break;
                loc = new Location(player.getWorld(), (double)minx, (double)y, (double)z);
                vis.addBlock(loc, visualizationType);
                loc = new Location(player.getWorld(), (double)maxx, (double)y, (double)z);
                vis.addBlock(loc, visualizationType);
                ++count;
            }
            this.counts.put(player.getName() + 2, 0);
        }
        this.counts.put(player.getName() + 1, 0);
        for (int x = minx; x <= maxx; ++x) {
            boolean xTurn = this.turnCounter(player.getName() + 1, spacing);
            if (maxx - x < spacing) {
                xTurn = false;
            }
            count = 0;
            for (z = minz; z <= maxz; ++z) {
                if (!xTurn && !this.turnCounter(player.getName() + 2, spacing)) continue;
                if (maxz - z < spacing && !xTurn || !xTurn && count >= data.getDensity() - 1) break;
                loc = new Location(player.getWorld(), (double)x, (double)miny, (double)z);
                vis.addBlock(loc, visualizationType);
                loc = new Location(player.getWorld(), (double)x, (double)maxy, (double)z);
                vis.addBlock(loc, visualizationType);
                ++count;
            }
            this.counts.put(player.getName() + 2, 0);
        }
        this.counts.put(player.getName() + 1, 0);
        for (y = miny; y <= maxy; ++y) {
            yTurn = this.turnCounter(player.getName() + 1, spacing);
            if (maxy - y < spacing) {
                yTurn = false;
            }
            count = 0;
            for (int x = minx; x <= maxx && (maxx - x >= spacing || yTurn) && (yTurn || count < data.getDensity() - 1); ++x) {
                if (!yTurn && !this.turnCounter(player.getName() + 2, spacing)) continue;
                loc = new Location(player.getWorld(), (double)x, (double)y, (double)minz);
                vis.addBlock(loc, visualizationType);
                loc = new Location(player.getWorld(), (double)x, (double)y, (double)maxz);
                vis.addBlock(loc, visualizationType);
                ++count;
            }
            this.counts.put(player.getName() + 2, 0);
        }
        this.counts.put(player.getName() + 1, 0);
        this.visualizations.put(player.getName(), vis);
    }

    private boolean turnCounter(String name, int size) {
        if (this.counts.containsKey(name)) {
            int count = this.counts.get(name);
            if (++count >= size) {
                this.counts.put(name, 0);
                return true;
            }
            this.counts.put(name, count);
        } else {
            this.counts.put(name, 1);
        }
        return false;
    }

    public void visualizeSingleOutline(Player player, Field field, boolean revert) {
        Location loc;
        Material frame;
        Visualization vis = this.visualizations.get(player.getName());
        if (vis == null) {
            vis = new Visualization();
        }
        ArrayList<BlockEntry> newBlocks = new ArrayList<BlockEntry>();
        Material frameType = this.plugin.getSettingsManager().getVisualizeFrameBlock().getMaterial();
        int minx = field.getX() - field.getRadius() - 1;
        int maxx = field.getX() + field.getRadius() + 1;
        int minz = field.getZ() - field.getRadius() - 1;
        int maxz = field.getZ() + field.getRadius() + 1;
        int miny = field.getY() - Math.max(field.getHeight() - 1, 0) / 2 - 1;
        int maxy = field.getY() + Math.max(field.getHeight() - 1, 0) / 2 + 1;
        if (field.hasFlag(FieldFlag.CUBOID)) {
            minx = field.getMinx() - 1;
            maxx = field.getMaxx() + 1;
            minz = field.getMinz() - 1;
            maxz = field.getMaxz() + 1;
            miny = field.getMiny() - 1;
            maxy = field.getMaxy() + 1;
        }
        for (int x = minx; x <= maxx; ++x) {
            frame = x == minx || x == maxx ? Material.GLOWSTONE : frameType;
            loc = new Location(player.getWorld(), (double)x, (double)miny, (double)maxz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)x, (double)maxy, (double)minz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)x, (double)miny, (double)minz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)x, (double)maxy, (double)maxz);
            newBlocks.add(new BlockEntry(loc, frame));
        }
        for (int y = miny; y <= maxy; ++y) {
            frame = y == miny || y == maxy ? Material.GLOWSTONE : frameType;
            loc = new Location(player.getWorld(), (double)minx, (double)y, (double)maxz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)maxx, (double)y, (double)minz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)minx, (double)y, (double)minz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)maxx, (double)y, (double)maxz);
            newBlocks.add(new BlockEntry(loc, frame));
        }
        for (int z = minz; z <= maxz; ++z) {
            frame = z == minz || z == maxz ? Material.GLOWSTONE : frameType;
            loc = new Location(player.getWorld(), (double)minx, (double)maxy, (double)z);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)maxx, (double)miny, (double)z);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)minx, (double)miny, (double)z);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)maxx, (double)maxy, (double)z);
            newBlocks.add(new BlockEntry(loc, frame));
        }
        Visualize visualize = new Visualize(newBlocks, player, false, !revert, this.plugin.getSettingsManager().getVisualizeSeconds());
        this.visualizations.put(player.getName(), vis);
    }

    public void displayFieldOutline(Player player, CuboidEntry ce) {
        Location loc;
        Material frame;
        Visualization vis = this.visualizations.get(player.getName());
        if (vis == null) {
            vis = new Visualization();
        }
        ArrayList<BlockEntry> oldBlocks = new ArrayList<BlockEntry>(vis.getOutlineBlocks());
        ArrayList<BlockEntry> newBlocks = new ArrayList<BlockEntry>();
        Material frameType = this.plugin.getSettingsManager().getVisualizeFrameBlock().getMaterial();
        int offset = ce.selectedCount() > 1 ? 1 : 0;
        int minx = ce.getMinx() - offset;
        int miny = ce.getMiny() - offset;
        int minz = ce.getMinz() - offset;
        int maxx = ce.getMaxx() + offset;
        int maxy = ce.getMaxy() + offset;
        int maxz = ce.getMaxz() + offset;
        for (int x = minx; x <= maxx; ++x) {
            frame = x == minx || x == maxx ? Material.GLOWSTONE : frameType;
            loc = new Location(player.getWorld(), (double)x, (double)miny, (double)maxz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)x, (double)maxy, (double)minz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)x, (double)miny, (double)minz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)x, (double)maxy, (double)maxz);
            newBlocks.add(new BlockEntry(loc, frame));
        }
        for (int y = miny; y <= maxy; ++y) {
            frame = y == miny || y == maxy ? Material.GLOWSTONE : frameType;
            loc = new Location(player.getWorld(), (double)minx, (double)y, (double)maxz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)maxx, (double)y, (double)minz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)minx, (double)y, (double)minz);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)maxx, (double)y, (double)maxz);
            newBlocks.add(new BlockEntry(loc, frame));
        }
        for (int z = minz; z <= maxz; ++z) {
            frame = z == minz || z == maxz ? Material.GLOWSTONE : frameType;
            loc = new Location(player.getWorld(), (double)minx, (double)maxy, (double)z);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)maxx, (double)miny, (double)z);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)minx, (double)miny, (double)z);
            newBlocks.add(new BlockEntry(loc, frame));
            loc = new Location(player.getWorld(), (double)maxx, (double)maxy, (double)z);
            newBlocks.add(new BlockEntry(loc, frame));
        }
        ArrayList<BlockEntry> revertible = new ArrayList<BlockEntry>(oldBlocks);
        revertible.removeAll(newBlocks);
        Visualize revert = new Visualize(revertible, player, true, false, this.plugin.getSettingsManager().getVisualizeSeconds());
        ArrayList<BlockEntry> missing = new ArrayList<BlockEntry>(newBlocks);
        missing.removeAll(oldBlocks);
        Visualize visualize = new Visualize(missing, player, false, true, this.plugin.getSettingsManager().getVisualizeSeconds());
        vis.setOutlineBlocks(newBlocks);
        this.visualizations.put(player.getName(), vis);
    }

    public boolean isOutlineBlock(Player player, Block block) {
        Visualization vis = this.visualizations.get(player.getName());
        if (vis == null) {
            vis = new Visualization();
        }
        return vis.getOutlineBlocks().contains(new BlockEntry(block));
    }

    public void addFieldMark(Player player, Field field) {
        Visualization vis = this.visualizations.get(player.getName());
        if (vis == null) {
            vis = new Visualization();
        }
        vis.addField(field);
        World world = this.plugin.getServer().getWorld(field.getWorld());
        if (world != null) {
            for (int y = 0; y < 256; ++y) {
                Material typeId = world.getBlockAt(field.getX(), y, field.getZ()).getType();
                if (!this.plugin.getSettingsManager().isThroughType(typeId)) continue;
                vis.addBlock(new Location(world, (double)field.getX(), (double)y, (double)field.getZ()), this.plugin.getSettingsManager().getVisualizeMarkBlock().getMaterial());
            }
        }
        this.visualizations.put(player.getName(), vis);
    }

    public void displaySingle(Player player, Material material, Block block) {
        Visualization vis = this.visualizations.get(player.getName());
        if (vis == null) {
            vis = new Visualization();
        }
        vis.addBlock(block);
        this.visualizations.put(player.getName(), vis);
        player.sendBlockChange(block.getLocation(), material, (byte)0);
    }

    public void revertSingle(Player player, Block block) {
        Visualization vis = this.visualizations.get(player.getName());
        if (vis == null) {
            vis = new Visualization();
        }
        vis.addBlock(block);
        this.visualizations.put(player.getName(), vis);
        player.sendBlockChange(block.getLocation(), block.getBlockData());
    }

    public void displayVisualization(Player player, boolean minusOverlap) {
        this.displayVisualization(player, minusOverlap, this.plugin.getSettingsManager().getVisualizeSeconds());
    }

    public void displayVisualization(Player player, boolean minusOverlap, int seconds) {
        Visualization vis = this.visualizations.get(player.getName());
        if (vis != null) {
            if (minusOverlap) {
                Iterator<BlockEntry> iter = vis.getBlocks().iterator();
                block0: while (iter.hasNext()) {
                    BlockEntry bd = iter.next();
                    Location loc = bd.getLocation();
                    for (Field field : vis.getFields()) {
                        if (!field.envelops(loc)) continue;
                        iter.remove();
                        continue block0;
                    }
                }
                Visualize visualize = new Visualize(vis.getBlocks(), player, false, false, seconds);
            } else {
                Visualize visualize = new Visualize(vis.getBlocks(), player, false, false, seconds);
            }
        }
    }

    public void revert(Player player) {
        Visualization vis = this.visualizations.get(player.getName());
        if (vis != null) {
            this.visualizations.remove(player.getName());
            Visualize visualize = new Visualize(vis.getBlocks(), player, true, false, 0);
        }
    }

    public void revertOutline(Player player) {
        Visualization vis = this.visualizations.get(player.getName());
        if (vis != null) {
            this.visualizations.remove(player.getName());
            Visualize visualize = new Visualize(vis.getOutlineBlocks(), player, true, false, 0);
        }
    }
}

