/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatBlock {
    private final int colspacing = 12;
    private static final int lineLength = 320;
    private List<Double> columnSizes = new ArrayList<Double>();
    private List<Integer> columnSpaces = new ArrayList<Integer>();
    private List<String> columnAlignments = new ArrayList<String>();
    private LinkedList<String[]> rows = new LinkedList();
    private boolean prefix_used = false;
    private String color = "";
    public static final Logger log = Logger.getLogger("Minecraft");

    public void setAlignment(String ... columnAlignment) {
        this.columnAlignments.addAll(Arrays.asList(columnAlignment));
    }

    public void setSpacing(int ... columnSpacings) {
        for (int spacing : columnSpacings) {
            this.columnSpaces.add(spacing);
        }
    }

    public void setColumnSizes(String prefix, double ... columnPercentages) {
        int ll = 320;
        if (prefix != null) {
            ll = 320 - (int)ChatBlock.msgLength(prefix);
        }
        for (double percentage : columnPercentages) {
            this.columnSizes.add(Math.floor(percentage / 100.0 * (double)ll));
        }
    }

    public boolean hasContent() {
        return this.rows.size() > 0;
    }

    public void addRow(String ... contents) {
        ArrayList<String> out = new ArrayList<String>();
        for (String content : contents) {
            out.add(ChatBlock.format(content, new Object[0]));
        }
        this.rows.add(out.toArray(new String[out.size()]));
    }

    public int size() {
        return this.rows.size();
    }

    public void clear() {
        this.rows.clear();
    }

    public boolean sendBlock(CommandSender sender, int amount) {
        if (sender == null) {
            return false;
        }
        if (this.rows.size() == 0) {
            return false;
        }
        if (!(sender instanceof Player)) {
            amount = 999;
        }
        if (this.columnSizes.isEmpty()) {
            int col_count = this.rows.get(0).length;
            for (int i = 0; i < col_count; ++i) {
                int spacing = 12;
                if (this.columnSpaces.size() >= i + 1) {
                    spacing = this.columnSpaces.get(i);
                }
                this.columnSizes.add(this.getMaxWidth(i) + (double)spacing);
            }
        }
        for (int i = 0; i < amount; ++i) {
            if (this.rows.size() == 0) continue;
            String rowstring = "";
            String[] row = this.rows.pollFirst();
            for (int sid = 0; sid < row.length; ++sid) {
                String align;
                String section = row[sid];
                double colsize = this.columnSizes.size() >= sid + 1 ? this.columnSizes.get(sid) : 0.0;
                String string = align = this.columnAlignments.size() >= sid + 1 ? this.columnAlignments.get(sid) : "l";
                if (align.equalsIgnoreCase("r")) {
                    if (ChatBlock.msgLength(section) > colsize) {
                        rowstring = rowstring + ChatBlock.cropLeftToFit(section, colsize);
                        continue;
                    }
                    if (!(ChatBlock.msgLength(section) < colsize)) continue;
                    rowstring = rowstring + ChatBlock.padLeftToFit(section, colsize);
                    continue;
                }
                if (align.equalsIgnoreCase("l")) {
                    if (ChatBlock.msgLength(section) > colsize) {
                        rowstring = rowstring + ChatBlock.cropRightToFit(section, colsize);
                        continue;
                    }
                    if (!(ChatBlock.msgLength(section) < colsize)) continue;
                    rowstring = rowstring + ChatBlock.padRightToFit(section, colsize);
                    continue;
                }
                if (align.equalsIgnoreCase("c")) {
                    if (ChatBlock.msgLength(section) > colsize) {
                        rowstring = rowstring + ChatBlock.cropRightToFit(section, colsize);
                        continue;
                    }
                    if (!(ChatBlock.msgLength(section) < colsize)) continue;
                    rowstring = rowstring + ChatBlock.centerInLineOf(section, colsize);
                    continue;
                }
                if (!align.equalsIgnoreCase("w")) continue;
                if (ChatBlock.msgLength(section) > colsize) {
                    rowstring = rowstring + section;
                    continue;
                }
                if (!(ChatBlock.msgLength(section) < colsize)) continue;
                rowstring = rowstring + ChatBlock.padRightToFit(section, colsize);
            }
            String msg = ChatBlock.cropRightToFit(rowstring, 320.0);
            if (this.color.length() > 0) {
                msg = this.color + msg;
            }
            sender.sendMessage(msg);
        }
        return this.rows.size() > 0;
    }

    public void sendBlock(CommandSender sender, String prefix) {
        if (sender == null) {
            return;
        }
        if (this.rows.size() == 0) {
            return;
        }
        this.prefix_used = prefix == null;
        String empty_prefix = ChatBlock.makeEmpty(prefix);
        if (this.columnSizes.isEmpty()) {
            int col_count = this.rows.get(0).length;
            for (int i = 0; i < col_count; ++i) {
                int spacing = 12;
                if (this.columnSpaces.size() >= i + 1) {
                    spacing = this.columnSpaces.get(i);
                }
                this.columnSizes.add(this.getMaxWidth(i) + (double)spacing);
            }
        }
        for (String[] row : this.rows) {
            String rowstring = "";
            for (int sid = 0; sid < row.length; ++sid) {
                String align;
                String section = row[sid];
                double colsize = this.columnSizes.size() >= sid + 1 ? this.columnSizes.get(sid) : 0.0;
                String string = align = this.columnAlignments.size() >= sid + 1 ? this.columnAlignments.get(sid) : "l";
                if (align.equalsIgnoreCase("r")) {
                    if (ChatBlock.msgLength(section) > colsize) {
                        rowstring = rowstring + ChatBlock.cropLeftToFit(section, colsize);
                        continue;
                    }
                    if (!(ChatBlock.msgLength(section) < colsize)) continue;
                    rowstring = rowstring + ChatBlock.padLeftToFit(section, colsize);
                    continue;
                }
                if (align.equalsIgnoreCase("l")) {
                    if (ChatBlock.msgLength(section) > colsize) {
                        rowstring = rowstring + ChatBlock.cropRightToFit(section, colsize);
                        continue;
                    }
                    if (!(ChatBlock.msgLength(section) < colsize)) continue;
                    rowstring = rowstring + ChatBlock.padRightToFit(section, colsize);
                    continue;
                }
                if (!align.equalsIgnoreCase("c")) continue;
                if (ChatBlock.msgLength(section) > colsize) {
                    rowstring = rowstring + ChatBlock.cropRightToFit(section, colsize);
                    continue;
                }
                if (!(ChatBlock.msgLength(section) < colsize)) continue;
                rowstring = rowstring + ChatBlock.centerInLineOf(section, colsize);
            }
            String msg = ChatBlock.cropRightToFit((this.prefix_used ? empty_prefix : prefix) + " " + rowstring, 320.0);
            if (this.color.length() > 0) {
                msg = this.color + msg;
            }
            sender.sendMessage(msg);
            this.prefix_used = true;
        }
    }

    public void sendBlock(CommandSender sender) {
        this.sendBlock(sender, null);
    }

    public static void sendMessageAll(CommandSender sender, String msg) {
        ChatBlock.sendMessageAll(sender, msg);
    }

    public double getMaxWidth(double col) {
        double maxWidth = 0.0;
        for (String[] row : this.rows) {
            if (!(col < (double)row.length)) continue;
            maxWidth = Math.max(maxWidth, ChatBlock.msgLength(row[(int)col]));
        }
        return maxWidth;
    }

    public static String centerInLine(String msg) {
        return ChatBlock.centerInLineOf(msg, 320.0);
    }

    public static String centerInLineOf(String msg, double lineLength) {
        double length = ChatBlock.msgLength(msg);
        double diff = lineLength - length;
        if (diff < 0.0) {
            return msg;
        }
        double sideSpace = diff / 2.0;
        msg = ChatBlock.padLeftToFit(msg, length + sideSpace);
        msg = ChatBlock.padRightToFit(msg, length + sideSpace + sideSpace);
        return msg;
    }

    public static String makeEmpty(String str) {
        if (str == null) {
            return "";
        }
        return ChatBlock.padLeftToFit("", ChatBlock.msgLength(str));
    }

    public static String cropRightToFit(String msg, double length) {
        if (msg == null || msg.length() == 0 || length == 0.0) {
            return "";
        }
        while (ChatBlock.msgLength(msg) >= length) {
            msg = msg.substring(0, msg.length() - 2);
        }
        return msg;
    }

    public static String cropLeftToFit(String msg, double length) {
        if (msg == null || msg.length() == 0 || length == 0.0) {
            return "";
        }
        while (ChatBlock.msgLength(msg) >= length) {
            msg = msg.substring(1);
        }
        return msg;
    }

    public static String padLeftToFit(String msg, double length) {
        if (ChatBlock.msgLength(msg) > length) {
            return msg;
        }
        while (ChatBlock.msgLength(msg) < length) {
            msg = " " + msg;
        }
        return msg;
    }

    public static String padRightToFit(String msg, double length) {
        if (ChatBlock.msgLength(msg) > length) {
            return msg;
        }
        while (ChatBlock.msgLength(msg) < length) {
            msg = msg + " ";
        }
        return msg;
    }

    public static double msgLength(String str) {
        double length = 0.0;
        str = ChatBlock.cleanColors(str);
        for (int x = 0; x < str.length(); ++x) {
            int len = ChatBlock.charLength(str.charAt(x));
            if (len > 0) {
                length += (double)len;
                continue;
            }
            ++x;
        }
        return length;
    }

    public static String cleanColors(String str) {
        String patternStr = "\u00ef\u00bf\u00bd.";
        String replacementStr = "";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(str);
        String out = matcher.replaceAll(replacementStr);
        return out;
    }

    public static int charLength(char x) {
        if ("i.:,;|!".indexOf(x) != -1) {
            return 2;
        }
        if ("l'".indexOf(x) != -1) {
            return 3;
        }
        if ("tI[]".indexOf(x) != -1) {
            return 4;
        }
        if ("fk{}<>\"*()".indexOf(x) != -1) {
            return 5;
        }
        if ("abcdeghjmnopqrsuvwxyzABCDEFGHJKLMNOPQRSTUVWXYZ1234567890\\/#?$%-=_+&^".indexOf(x) != -1) {
            return 6;
        }
        if ("@~".indexOf(x) != -1) {
            return 7;
        }
        if (x == ' ') {
            return 4;
        }
        return -1;
    }

    public static String[] wordWrap(String msg) {
        return ChatBlock.wordWrap(msg, 0);
    }

    public static String[] wordWrap(String msg, int prefixLn) {
        ArrayList<String> split = new ArrayList<String>();
        split.addAll(Arrays.asList(msg.split(" ")));
        ArrayList<String> out = new ArrayList<String>();
        while (!split.isEmpty()) {
            int len = 0;
            ArrayList<String> words = new ArrayList<String>();
            while (!split.isEmpty() && split.get(0) != null && len <= 320 - prefixLn) {
                double wordLength = ChatBlock.msgLength((String)split.get(0)) + 4.0;
                if (wordLength > (double)(320 - prefixLn)) {
                    String[] tempArray = ChatBlock.wordCut(len, (String)split.remove(0));
                    words.add(tempArray[0]);
                    split.add(tempArray[1]);
                }
                if ((len = (int)((double)len + wordLength)) >= 320 - prefixLn + 4) continue;
                words.add((String)split.remove(0));
            }
            String merged = ChatBlock.combineSplit(0, words.toArray(new String[words.size()]), " ") + " ";
            out.add(merged.replaceAll("\\s+$", ""));
        }
        return out.toArray(new String[out.size()]);
    }

    public static String combineSplit(int startIndex, String[] string, String seperator) {
        StringBuilder builder = new StringBuilder();
        for (int i = startIndex; i < string.length; ++i) {
            builder.append(string[i]);
            builder.append(seperator);
        }
        builder.deleteCharAt(builder.length() - seperator.length());
        return builder.toString();
    }

    public static String[] wordCut(int lengthBefore, String str) {
        int x;
        int length = lengthBefore;
        String[] output = new String[2];
        for (x = 0; length < 320 && x < str.length(); ++x) {
            int len = ChatBlock.charLength(str.charAt(x));
            if (len > 0) {
                length += len;
                continue;
            }
            ++x;
        }
        if (x > str.length()) {
            x = str.length();
        }
        output[0] = str.substring(0, x);
        output[1] = str.substring(x);
        return output;
    }

    public static void send(String playerName, String msg, Object ... args) {
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player != null) {
            String[] message;
            msg = ChatBlock.format(msg, args);
            for (String out : message = ChatBlock.colorize(ChatBlock.wordWrap(msg, 0))) {
                player.sendMessage(out);
            }
        }
    }

    public static void send(CommandSender receiver, String msg, Object ... args) {
        String[] message;
        if (receiver == null) {
            return;
        }
        msg = ChatBlock.format(msg, args);
        for (String out : message = ChatBlock.colorize(ChatBlock.wordWrap(msg, 0))) {
            receiver.sendMessage(out);
        }
    }

    public static void sendPrefixed(CommandSender receiver, String prefix, String msg, Object ... args) {
        String[] message;
        if (receiver == null) {
            return;
        }
        msg = ChatBlock.formatPrefixed(prefix, msg, args);
        for (String out : message = ChatBlock.colorize(ChatBlock.wordWrap(msg, 0))) {
            receiver.sendMessage(out);
        }
    }

    public static void sendPs(CommandSender receiver, String msg, Object ... args) {
        String[] message;
        if (receiver == null) {
            return;
        }
        msg = ChatBlock.formatPrefixed("{dark-gray}[ps]{gray}", msg, args);
        for (String out : message = ChatBlock.colorize(ChatBlock.wordWrap(msg, 0))) {
            receiver.sendMessage(out);
        }
    }

    public static void saySingle(CommandSender receiver, String msg, Object ... args) {
        if (receiver == null) {
            return;
        }
        msg = ChatBlock.format(msg, args);
        receiver.sendMessage(ChatBlock.cropRightToFit(ChatBlock.colorize(new String[]{msg})[0], 320.0));
    }

    public void startColor(String color) {
        this.color = color;
    }

    public static void sendBlank(CommandSender receiver) {
        if (receiver == null) {
            return;
        }
        receiver.sendMessage(" ");
    }

    public static String[] say(String message) {
        return ChatBlock.colorize(ChatBlock.wordWrap(message));
    }

    public static String[] colorize(String[] message) {
        return ChatBlock.colorizeBase(message, 167);
    }

    public static String colorize(String message) {
        return ChatBlock.colorizeBase(new String[]{message}, 167)[0];
    }

    public static String[] colorizeBase(String[] message, int charcode) {
        if (message != null && message[0] != null && !message[0].isEmpty()) {
            String prevColor = "";
            String lastColor = "";
            int counter = 0;
            for (String msg : message) {
                for (int x = 0; x < msg.length(); ++x) {
                    if (msg.codePointAt(x) != charcode) continue;
                    lastColor = ChatColor.getByChar((char)msg.charAt(++x)) + "";
                }
                message[counter] = prevColor + msg;
                prevColor = lastColor;
                ++counter;
            }
        }
        return message;
    }

    public static String format(String msg, Object ... args) {
        String lang = PreciousStones.getInstance().getLanguageManager().get(msg);
        if (lang != null) {
            msg = lang;
        }
        return ChatBlock.replaceFormatting(msg, args);
    }

    public static String formatPrefixed(String prefix, String msg, Object ... args) {
        String lang = PreciousStones.getInstance().getLanguageManager().get(msg);
        if (lang != null) {
            msg = prefix + lang;
        }
        return ChatBlock.replaceFormatting(msg, args);
    }

    private static String replaceFormatting(String msg, Object[] args) {
        msg = msg.replace("{aqua}", ChatColor.AQUA.toString());
        msg = msg.replace("{black}", ChatColor.BLACK.toString());
        msg = msg.replace("{blue}", ChatColor.BLUE.toString());
        msg = msg.replace("{white}", ChatColor.WHITE.toString());
        msg = msg.replace("{yellow}", ChatColor.YELLOW.toString());
        msg = msg.replace("{gold}", ChatColor.GOLD.toString());
        msg = msg.replace("{gray}", ChatColor.GRAY.toString());
        msg = msg.replace("{green}", ChatColor.GREEN.toString());
        msg = msg.replace("{red}", ChatColor.RED.toString());
        msg = msg.replace("{dark-aqua}", ChatColor.DARK_AQUA.toString());
        msg = msg.replace("{dark-blue}", ChatColor.DARK_BLUE.toString());
        msg = msg.replace("{dark-gray}", ChatColor.DARK_GRAY.toString());
        msg = msg.replace("{dark-green}", ChatColor.DARK_GREEN.toString());
        msg = msg.replace("{dark-purple}", ChatColor.DARK_PURPLE.toString());
        msg = msg.replace("{dark-red}", ChatColor.DARK_RED.toString());
        msg = msg.replace("{light-purple}", ChatColor.LIGHT_PURPLE.toString());
        msg = msg.replace("{magic}", ChatColor.MAGIC.toString());
        msg = msg.replace("{bold}", ChatColor.BOLD.toString());
        msg = msg.replace("{italic}", ChatColor.ITALIC.toString());
        msg = msg.replace("{reset}", ChatColor.RESET.toString());
        msg = msg.replace("{strikethrough}", ChatColor.STRIKETHROUGH.toString());
        msg = msg.replace("{underline}", ChatColor.UNDERLINE.toString());
        if (args.length > 0) {
            msg = msg.replaceAll("\\{1.*?\\}", args[0].toString());
        }
        if (args.length > 1) {
            msg = msg.replaceAll("\\{2.*?\\}", args[1].toString());
        }
        if (args.length > 2) {
            msg = msg.replaceAll("\\{3.*?\\}", args[2].toString());
        }
        if (args.length > 3) {
            msg = msg.replaceAll("\\{4.*?\\}", args[3].toString());
        }
        if (args.length > 4) {
            msg = msg.replaceAll("\\{5.*?\\}", args[4].toString());
        }
        if (args.length > 5) {
            msg = msg.replaceAll("\\{6.*?\\}", args[5].toString());
        }
        if (args.length > 6) {
            msg = msg.replaceAll("\\{7.*?\\}", args[6].toString());
        }
        if (args.length > 7) {
            msg = msg.replaceAll("\\{8.*?\\}", args[7].toString());
        }
        if (args.length > 8) {
            msg = msg.replaceAll("\\{9.*?\\}", args[8].toString());
        }
        return Helper.capitalize(msg);
    }
}

