/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.SignHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class FieldSettings {
    private int foresterUses = 1;
    private int groundBlock = 2;
    private int treeCount = 64;
    private int creatureCount = 6;
    private int growTime = 20;
    private int shrubDensity = 64;
    private boolean validField = true;
    private BlockTypeEntry type;
    private boolean spoutBlock;
    private int radius = 0;
    private int fenceItem = 0;
    private int fenceItemPrice = 0;
    private int heal = 0;
    private int damage = 0;
    private int maskOnDisabled = 49;
    private int maskOnEnabled = 49;
    private int feed = 0;
    private int repair = 0;
    private int launchHeight = 0;
    private int cannonHeight = 0;
    private int customHeight = 0;
    private int customVolume = 0;
    private int mineDelaySeconds = 0;
    private int lightningDelaySeconds = 0;
    private int lightningReplaceBlock = 0;
    private int mixingGroup = 0;
    private int autoDisableTime = 0;
    private int mustBeAbove = 0;
    private int mustBeBelow = 0;
    private boolean mineHasFire = false;
    private int mine = 6;
    private String groupOnEntry = "";
    private String requiredPermissionAllow = "";
    private String requiredPermissionUse = "";
    private String requiredPermission = "";
    private String deleteIfNoPermission = "";
    private GameMode forceEntryGameMode = null;
    private GameMode forceLeavingGameMode = null;
    private String title;
    private int price = 0;
    private int refund = -1;
    private int teleportCost = 0;
    private int teleportBackAfterSeconds = 0;
    private int teleportMaxDistance = 0;
    private int griefRevertInterval = 0;
    private int payToEnable = 0;
    private List<String> commandOnEnter = new ArrayList<String>();
    private List<String> commandOnExit = new ArrayList<String>();
    private List<String> playerCommandOnEnter = new ArrayList<String>();
    private List<String> playerCommandOnExit = new ArrayList<String>();
    private List<Integer> teleportIfHoldingItems = new ArrayList<Integer>();
    private List<Integer> teleportIfNotHoldingItems = new ArrayList<Integer>();
    private List<Integer> teleportIfHasItems = new ArrayList<Integer>();
    private List<Integer> teleportIfNotHasItems = new ArrayList<Integer>();
    private List<BlockTypeEntry> unusableItems = new ArrayList<BlockTypeEntry>();
    private List<BlockTypeEntry> teleportIfWalkingOn = new ArrayList<BlockTypeEntry>();
    private List<BlockTypeEntry> teleportIfNotWalkingOn = new ArrayList<BlockTypeEntry>();
    private List<Integer> treeTypes = new ArrayList<Integer>();
    private List<Integer> shrubTypes = new ArrayList<Integer>();
    private List<String> creatureTypes = new ArrayList<String>();
    private List<Integer> fertileBlocks = new ArrayList<Integer>();
    private List<Integer> limits = new ArrayList<Integer>();
    private List<BlockTypeEntry> surfaces = new ArrayList<BlockTypeEntry>();
    private List<BlockTypeEntry> translocationBlacklist = new ArrayList<BlockTypeEntry>();
    private List<BlockTypeEntry> preventPlaceBlacklist = new ArrayList<BlockTypeEntry>();
    private List<BlockTypeEntry> preventDestroyBlacklist = new ArrayList<BlockTypeEntry>();
    private List<Integer> preventUse = new ArrayList<Integer>();
    private List<BlockTypeEntry> confiscatedItems = new ArrayList<BlockTypeEntry>();
    private List<String> allowedWorlds = new ArrayList<String>();
    private List<String> allowedOnlyInside = new ArrayList<String>();
    private List<String> allowedOnlyOutside = new ArrayList<String>();
    private List<String> commandBlackList = new ArrayList<String>();
    private List<FieldFlag> defaultFlags = new ArrayList<FieldFlag>();
    private List<FieldFlag> reversedFlags = new ArrayList<FieldFlag>();
    private List<FieldFlag> alledflags = new ArrayList<FieldFlag>();
    private List<FieldFlag> disabledFlags = new ArrayList<FieldFlag>();
    private List<Integer> allowGrief = new ArrayList<Integer>();
    private HashMap<PotionEffectType, Integer> potions = new HashMap();
    private List<PotionEffectType> neutralizePotions = new ArrayList<PotionEffectType>();
    private List<String> allowedPlayers = new ArrayList<String>();
    private List<String> deniedPlayers = new ArrayList<String>();
    private LinkedHashMap<String, Object> map;

    public FieldSettings(LinkedHashMap<String, Object> map) {
        this.map = map;
        if (map == null) {
            return;
        }
        this.defaultFlags.add(FieldFlag.ALL);
        this.parseSettings();
    }

    private void parseSettings() {
        String leavingGameMode;
        String entryGameMode;
        PreciousStones.debug("**********************", new Object[0]);
        this.title = this.loadString("title");
        if (this.title == null) {
            this.validField = false;
            return;
        }
        this.spoutBlock = this.loadBoolean("spout");
        if (this.spoutBlock) {
            if (PreciousStones.hasSpout()) {
                this.type = this.loadSpoutTypeEntry("block");
            } else {
                PreciousStones.log(Level.WARNING, (Object)"** Spout not loaded, spout field skipped: %s", this.title);
            }
        } else {
            this.type = this.loadTypeEntry("block");
        }
        if (this.type == null) {
            this.validField = false;
            return;
        }
        this.customHeight = this.loadInt("custom-height");
        if (this.customHeight > 0 && this.customHeight % 2 == 0) {
            ++this.customHeight;
        }
        if ((entryGameMode = this.loadString("entry-game-mode")).equalsIgnoreCase("creative")) {
            this.forceEntryGameMode = GameMode.CREATIVE;
        }
        if (entryGameMode.equalsIgnoreCase("survival")) {
            this.forceEntryGameMode = GameMode.SURVIVAL;
        }
        if ((leavingGameMode = this.loadString("leaving-game-mode")).equalsIgnoreCase("creative")) {
            this.forceLeavingGameMode = GameMode.CREATIVE;
        }
        if (leavingGameMode.equalsIgnoreCase("survival")) {
            this.forceLeavingGameMode = GameMode.SURVIVAL;
        }
        List<String> pts = this.loadStringList("potions");
        List<Integer> intensities = this.loadIntList("potion-intensity");
        int pos = 0;
        for (String name : pts) {
            int i = 1;
            if (intensities != null) {
                i = intensities.get(pos);
            }
            if (PotionEffectType.getByName((String)name) != null) {
                this.potions.put(PotionEffectType.getByName((String)name), i);
            }
            ++pos;
        }
        List<String> npts = this.loadStringList("neutralize-potions");
        for (String name : npts) {
            if (PotionEffectType.getByName((String)name) == null) continue;
            this.neutralizePotions.add(PotionEffectType.getByName((String)name));
        }
        this.loadBoolean("prevent-fire");
        this.loadBoolean("enable-with-redstone");
        this.loadBoolean("allow-place");
        this.loadBoolean("allow-destroy");
        this.loadBoolean("prevent-place");
        this.loadBoolean("prevent-destroy");
        this.loadBoolean("prevent-vehicle-destroy");
        this.loadBoolean("prevent-enderman-destroy");
        this.loadBoolean("prevent-explosions");
        this.loadBoolean("prevent-creeper-explosions");
        this.loadBoolean("prevent-wither-explosions");
        this.loadBoolean("prevent-tnt-explosions");
        this.loadBoolean("rollback-explosions");
        this.loadBoolean("prevent-pvp");
        this.loadBoolean("prevent-teleport");
        this.loadBoolean("prevent-mob-damage");
        this.loadBoolean("prevent-mob-spawn");
        this.loadBoolean("prevent-animal-spawn");
        this.loadBoolean("prevent-entry");
        this.loadBoolean("prevent-unprotectable");
        this.loadBoolean("prevent-potion-splash");
        this.loadBoolean("prevent-portal-enter");
        this.loadBoolean("prevent-portal-creation");
        this.loadBoolean("prevent-portal-destination");
        this.loadBoolean("prevent-potion-splash");
        this.loadBoolean("prevent-vehicle-enter");
        this.loadBoolean("prevent-vehicle-exit");
        this.loadBoolean("prevent-item-frame-take");
        this.loadBoolean("prevent-entity-interact");
        this.loadBoolean("protect-animals");
        this.loadBoolean("protect-villagers");
        this.loadBoolean("protect-crops");
        this.loadBoolean("protect-mobs");
        this.loadBoolean("protect-lwc");
        this.loadBoolean("protect-inventories");
        this.loadBoolean("remove-mob");
        this.loadBoolean("worldguard-repellent");
        this.loadBoolean("breakable");
        this.loadBoolean("welcome-message");
        this.loadBoolean("farewell-message");
        this.loadBoolean("air");
        this.loadBoolean("snitch");
        this.loadBoolean("no-conflict");
        this.loadBoolean("no-owner");
        this.loadBoolean("launch");
        this.loadBoolean("cannon");
        this.loadBoolean("lightning");
        this.loadBoolean("no-fall-damage");
        this.loadBoolean("sneak-to-place");
        this.loadBoolean("plot");
        this.loadBoolean("prevent-flow");
        this.loadBoolean("forester");
        this.loadBoolean("grief-revert");
        this.loadBoolean("grief-revert-drop");
        this.loadBoolean("grief-revert-safety");
        this.loadBoolean("entry-alert");
        this.loadBoolean("cuboid");
        this.loadBoolean("visualize-on-src");
        this.loadBoolean("visualize-on-place");
        this.loadBoolean("keep-chunks-loaded");
        this.loadBoolean("place-grief");
        this.loadBoolean("toggle-on-disabled");
        this.loadBoolean("redefine-on-disabled");
        this.loadBoolean("modify-on-disabled");
        this.loadBoolean("enable-on-src");
        this.loadBoolean("breakable-on-disabled");
        this.loadBoolean("no-player-place");
        this.loadBoolean("no-projectile-throw");
        this.loadBoolean("no-dropping-items");
        this.loadBoolean("no-player-sprint");
        this.loadBoolean("translocation");
        this.loadBoolean("translocation-safety");
        this.loadBoolean("prevent-flight");
        this.loadBoolean("allowed-can-break");
        this.loadBoolean("sneaking-bypass");
        this.loadBoolean("dynmap-area");
        this.loadBoolean("dynmap-marker");
        this.loadBoolean("dynmap-disabled");
        this.loadBoolean("dynmap-no-toggle");
        this.loadBoolean("dynmap-hide-players");
        this.loadBoolean("dynmap-show-players");
        this.loadBoolean("can-change-owner");
        this.loadBoolean("no-allowing");
        this.loadBoolean("hidable");
        this.loadBoolean("teleport-before-death");
        this.loadBoolean("teleport-on-damage");
        this.loadBoolean("teleport-on-feeding");
        this.loadBoolean("teleport-mobs-on-enable");
        this.loadBoolean("teleport-animals-on-enable");
        this.loadBoolean("teleport-players-on-enable");
        this.loadBoolean("teleport-villagers-on-enable");
        this.loadBoolean("teleport-on-fire");
        this.loadBoolean("teleport-on-pvp");
        this.loadBoolean("teleport-on-block-place");
        this.loadBoolean("teleport-on-block-break");
        this.loadBoolean("teleport-on-sneak");
        this.loadBoolean("teleport-on-entry");
        this.loadBoolean("teleport-on-exit");
        this.loadBoolean("teleport-explosion-effect");
        this.loadBoolean("teleport-relatively");
        this.loadBoolean("teleport-announce");
        this.loadBoolean("teleport-destination");
        this.loadBoolean("disable-when-online");
        this.loadBoolean("no-growth");
        this.loadBoolean("single-use");
        this.loadBoolean("commands-on-overlap");
        this.loadBoolean("shareable");
        this.loadBoolean("buyable");
        this.loadBoolean("rentable");
        this.loadBoolean("command-blacklisting");
        this.loadBoolean("anti-plot");
        this.foresterUses = this.loadInt("forester-uses");
        this.surfaces = this.loadTypeEntries("surfaces");
        this.requiredPermission = this.loadString("required-permission");
        this.requiredPermissionUse = this.loadString("required-permission-use");
        this.requiredPermissionAllow = this.loadString("required-permission-allow");
        this.deleteIfNoPermission = this.loadString("delete-if-no-permission");
        this.groupOnEntry = this.loadString("group-on-entry");
        this.autoDisableTime = this.loadPeriodSeconds("auto-disable");
        this.radius = this.loadInt("radius");
        this.mixingGroup = this.loadInt("mixing-group");
        this.customVolume = this.loadInt("custom-volume");
        this.launchHeight = this.loadInt("launch-velocity");
        this.cannonHeight = this.loadInt("cannon-velocity");
        this.mineDelaySeconds = this.loadInt("mine-delay-seconds");
        this.mineHasFire = this.loadBoolean("mine-has-fire");
        this.lightningReplaceBlock = this.loadInt("lightning-replace-block");
        this.lightningDelaySeconds = this.loadInt("lightning-delay-seconds");
        this.treeCount = this.loadInt("tree-count");
        this.growTime = this.loadInt("grow-time");
        this.shrubDensity = this.loadInt("shrub-density");
        this.groundBlock = this.loadInt("ground-block");
        this.preventUse = this.loadIntList("prevent-use");
        this.confiscatedItems = this.loadTypeEntries("confiscate-items");
        this.allowedPlayers = this.loadStringList("always-allow-players");
        this.deniedPlayers = this.loadStringList("always-deny-players");
        this.allowGrief = this.loadIntList("allow-grief");
        this.treeTypes = this.loadIntList("tree-types");
        this.shrubTypes = this.loadIntList("shrub-types");
        this.creatureTypes = this.loadStringList("creature-types");
        this.fertileBlocks = this.loadIntList("fertile-blocks");
        this.allowedWorlds = this.loadStringList("allowed-worlds");
        this.creatureCount = this.loadInt("creature-count");
        this.limits = this.loadIntList("limits");
        this.price = this.loadInt("price");
        this.refund = this.loadInt("refund", -1);
        this.unusableItems = this.loadTypeEntries("unusable-items");
        this.translocationBlacklist = this.loadTypeEntries("translocation-blacklist");
        this.preventPlaceBlacklist = this.loadTypeEntries("prevent-place-blacklist");
        this.preventDestroyBlacklist = this.loadTypeEntries("prevent-destroy-blacklist");
        this.allowedOnlyInside = this.loadStringList("allowed-only-inside");
        this.allowedOnlyOutside = this.loadStringList("allowed-only-outside");
        this.heal = this.loadInt("heal");
        this.feed = this.loadInt("feed");
        this.repair = this.loadInt("repair");
        this.damage = this.loadInt("damage");
        this.maskOnDisabled = this.loadInt("mask-on-disabled");
        this.maskOnEnabled = this.loadInt("mask-on-enabled");
        this.mine = this.loadInt("mine");
        this.heal = this.loadInt("heal");
        this.griefRevertInterval = this.loadInt("grief-revert-interval");
        this.commandOnEnter = this.loadStringList("command-on-enter");
        this.commandOnExit = this.loadStringList("command-on-exit");
        this.playerCommandOnEnter = this.loadStringList("player-command-on-enter");
        this.playerCommandOnExit = this.loadStringList("player-command-on-exit");
        this.commandBlackList = this.loadStringList("command-blacklist");
        this.teleportCost = this.loadInt("teleport-cost");
        this.teleportBackAfterSeconds = this.loadInt("teleport-back-after-seconds");
        this.teleportMaxDistance = this.loadInt("teleport-max-distance");
        this.teleportIfWalkingOn = this.loadTypeEntries("teleport-if-walking-on");
        this.teleportIfNotWalkingOn = this.loadTypeEntries("teleport-if-not-walking-on");
        this.teleportIfHoldingItems = this.loadIntList("teleport-if-holding-items");
        this.teleportIfNotHoldingItems = this.loadIntList("teleport-if-not-holding-items");
        this.teleportIfHasItems = this.loadIntList("teleport-if-has-items");
        this.teleportIfNotHasItems = this.loadIntList("teleport-if-not-has-items");
        this.mustBeAbove = this.loadInt("must-be-above");
        this.mustBeBelow = this.loadInt("must-be-below");
        this.payToEnable = this.loadInt("pay-to-enable");
        this.fenceItem = this.loadInt("fence-on-place");
        this.fenceItemPrice = this.loadInt("price-per-fence");
    }

    private boolean loadBoolean(String flagStr) {
        if (this.containsKey(flagStr)) {
            boolean value = Boolean.parseBoolean(this.getValue(flagStr).toString());
            if (value) {
                this.loadFlags(this.getKey(flagStr));
            }
            PreciousStones.debug("   %s: %s", flagStr, value);
            return value;
        }
        return false;
    }

    private int loadInt(String flagStr) {
        return this.loadInt(flagStr, 0);
    }

    private int loadInt(String flagStr, int defaultValue) {
        if (this.containsKey(flagStr)) {
            if (Helper.isInteger(this.getValue(flagStr))) {
                int value = (Integer)this.getValue(flagStr);
                this.loadFlags(this.getKey(flagStr));
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return defaultValue;
    }

    private String loadString(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isString(this.getValue(flagStr))) {
                String value = (String)this.getValue(flagStr);
                if (value != null) {
                    if (!value.isEmpty()) {
                        this.loadFlags(this.getKey(flagStr));
                    }
                } else {
                    PreciousStones.log(Level.WARNING, (Object)"** Malformed Flag %s", flagStr);
                }
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return "";
    }

    private int loadPeriodSeconds(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isInteger(this.getValue(flagStr))) {
                int value = (Integer)this.getValue(flagStr);
                this.loadFlags(this.getKey(flagStr));
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            if (Helper.isString(this.getValue(flagStr))) {
                String str = (String)this.getValue(flagStr);
                int value = SignHelper.periodToSeconds(str);
                this.loadFlags(this.getKey(flagStr));
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return 0;
    }

    private BlockTypeEntry loadTypeEntry(String flagStr) {
        if (this.containsKey(flagStr)) {
            BlockTypeEntry value = null;
            Object typeStr = this.getValue(flagStr);
            if (Helper.isString(typeStr) && Helper.isTypeEntry((String)typeStr) && Helper.hasData(typeStr.toString())) {
                value = Helper.toTypeEntry(typeStr.toString());
            } else if (Helper.isInteger(typeStr)) {
                value = new BlockTypeEntry((Integer)typeStr, 0);
            } else if (Helper.isInteger(typeStr.toString())) {
                value = new BlockTypeEntry(Integer.parseInt(typeStr.toString()), 0);
            } else {
                PreciousStones.log(Level.WARNING, (Object)"** Malformed Flag %s", flagStr);
            }
            if (value != null) {
                this.loadFlags(this.getKey(flagStr));
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return null;
    }

    private BlockTypeEntry loadSpoutTypeEntry(String flagStr) {
        if (this.containsKey(flagStr)) {
            BlockTypeEntry value = null;
            Object typeStr = this.getValue(flagStr);
            if (Helper.isString(typeStr) && Helper.isTypeEntry((String)typeStr) && Helper.hasData(typeStr.toString())) {
                value = Helper.toSpoutTypeEntry(typeStr.toString());
            } else if (Helper.isInteger(typeStr)) {
                value = new BlockTypeEntry((Integer)typeStr, 0, true);
            } else if (Helper.isInteger(typeStr.toString())) {
                value = new BlockTypeEntry(Integer.parseInt(typeStr.toString()), 0, true);
            } else {
                PreciousStones.log(Level.WARNING, (Object)"** Malformed Flag %s", flagStr);
            }
            if (value != null) {
                this.loadFlags(this.getKey(flagStr));
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return null;
    }

    private List<String> loadStringList(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isStringList(this.getValue(flagStr))) {
                List value = (List)this.getValue(flagStr);
                if (value != null) {
                    if (!value.isEmpty()) {
                        this.loadFlags(this.getKey(flagStr));
                    }
                } else {
                    PreciousStones.log(Level.WARNING, (Object)"** Malformed Flag %s", flagStr);
                }
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return new ArrayList<String>();
    }

    private List<BlockTypeEntry> loadTypeEntries(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isStringList(this.getValue(flagStr))) {
                List<BlockTypeEntry> value = Helper.toTypeEntriesBlind((List)this.getValue(flagStr));
                if (value != null) {
                    if (!value.isEmpty()) {
                        this.loadFlags(this.getKey(flagStr));
                    }
                } else {
                    PreciousStones.log(Level.WARNING, (Object)"** Malformed Flag %s", flagStr);
                }
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return new ArrayList<BlockTypeEntry>();
    }

    private List<Integer> loadIntList(String flagStr) {
        if (this.containsKey(flagStr)) {
            if (Helper.isIntList(this.getValue(flagStr))) {
                List value = (List)this.getValue(flagStr);
                if (value != null) {
                    if (!value.isEmpty()) {
                        this.loadFlags(this.getKey(flagStr));
                    }
                } else {
                    PreciousStones.log(Level.WARNING, (Object)"** Malformed Flag %s", flagStr);
                }
                PreciousStones.debug("   %s: %s", flagStr, value);
                return value;
            }
            PreciousStones.debug("   %s: *bad*", flagStr);
        }
        return new ArrayList<Integer>();
    }

    private boolean containsKey(String flagStr) {
        if (this.map.containsKey(flagStr)) {
            return true;
        }
        if (this.map.containsKey("~" + flagStr)) {
            return true;
        }
        if (this.map.containsKey("^" + flagStr)) {
            return true;
        }
        return this.map.containsKey("?" + flagStr);
    }

    private String getKey(String flagStr) {
        if (this.map.containsKey(flagStr)) {
            return flagStr;
        }
        if (this.map.containsKey("~" + flagStr)) {
            return "~" + flagStr;
        }
        if (this.map.containsKey("^" + flagStr)) {
            return "^" + flagStr;
        }
        if (this.map.containsKey("?" + flagStr)) {
            return "?" + flagStr;
        }
        return null;
    }

    private Object getValue(String flagStr) {
        if (this.map.get(flagStr) != null) {
            return this.map.get(flagStr);
        }
        if (this.map.get("~" + flagStr) != null) {
            return this.map.get("~" + flagStr);
        }
        if (this.map.get("^" + flagStr) != null) {
            return this.map.get("^" + flagStr);
        }
        if (this.map.get("?" + flagStr) != null) {
            return this.map.get("?" + flagStr);
        }
        return null;
    }

    private void loadFlags(String flagStr) {
        if (flagStr == null || flagStr.isEmpty()) {
            return;
        }
        if (flagStr.startsWith("^")) {
            FieldFlag flag = FieldFlag.getByString(flagStr);
            if (flag != null) {
                if (!this.reversedFlags.contains((Object)flag)) {
                    this.alledflags.add(flag);
                }
                this.loadFlags(flagStr.substring(1));
            }
            return;
        }
        if (flagStr.startsWith("~")) {
            FieldFlag flag = FieldFlag.getByString(flagStr);
            if (flag != null) {
                if (!this.alledflags.contains((Object)flag)) {
                    this.reversedFlags.add(flag);
                }
                this.loadFlags(flagStr.substring(1));
            }
            return;
        }
        if (flagStr.startsWith("?")) {
            FieldFlag flag = FieldFlag.getByString(flagStr);
            if (flag != null) {
                this.disabledFlags.add(flag);
                this.loadFlags(flagStr.substring(1));
            }
            return;
        }
        FieldFlag flag = FieldFlag.getByString(flagStr);
        if (flag != null) {
            this.defaultFlags.add(flag);
        }
    }

    public boolean hasDefaultFlag(FieldFlag flag) {
        return this.defaultFlags.contains((Object)flag);
    }

    public boolean hasNameableFlag() {
        for (FieldFlag flag : this.defaultFlags) {
            if (!flag.isNameable()) continue;
            return true;
        }
        return false;
    }

    public boolean hasVeocityFlag() {
        return this.defaultFlags.contains((Object)FieldFlag.CANNON) || this.defaultFlags.contains((Object)FieldFlag.LAUNCH);
    }

    public boolean hasLimit() {
        return !this.limits.isEmpty();
    }

    public String getTitle() {
        return this.title;
    }

    public int getCustomHeight() {
        return this.customHeight;
    }

    public boolean canTranslocate(BlockTypeEntry type) {
        return !this.translocationBlacklist.contains(type);
    }

    public boolean teleportDueToWalking(Location loc, Field field, Player player) {
        Block standingOn = new Vec(loc).subtract(0, 1, 0).getBlock();
        if (standingOn.getTypeId() == 0) {
            return false;
        }
        boolean teleport = false;
        if (FieldFlag.TELEPORT_IF_WALKING_ON.applies(field, player)) {
            teleport = this.teleportIfWalkingOn.contains(new BlockTypeEntry(standingOn));
        }
        if (FieldFlag.TELEPORT_IF_NOT_WALKING_ON.applies(field, player)) {
            teleport = !this.teleportIfNotWalkingOn.contains(new BlockTypeEntry(standingOn));
        }
        return teleport;
    }

    public boolean inDestroyBlacklist(Block block) {
        BlockTypeEntry type = new BlockTypeEntry(block);
        return this.preventDestroyBlacklist.contains(type);
    }

    public boolean inPlaceBlacklist(Block block) {
        BlockTypeEntry type = new BlockTypeEntry(block);
        return this.preventPlaceBlacklist.contains(type);
    }

    public boolean isCanceledCommand(String command) {
        int i = (command = command.replace("/", "")).indexOf(32);
        if (i > -1) {
            command = command.substring(0, i);
        }
        return this.commandBlackList.contains(command);
    }

    public boolean isTeleportHoldingItem(int itemId) {
        if (this.teleportIfHasItems.contains(0) && itemId > 0) {
            return true;
        }
        return this.teleportIfHoldingItems.contains(itemId);
    }

    public boolean isTeleportNotHoldingItem(int itemId) {
        return this.teleportIfNotHoldingItems.contains(itemId);
    }

    public boolean isTeleportHasItem(int itemId) {
        if (this.teleportIfHasItems.contains(0) && itemId > 0) {
            return true;
        }
        return this.teleportIfHasItems.contains(itemId);
    }

    public boolean isTeleportHasNotItem(int itemId) {
        return this.teleportIfNotHasItems.contains(itemId);
    }

    public boolean isReversedFlag(FieldFlag flag) {
        return this.reversedFlags.contains((Object)flag);
    }

    public boolean isAlledFlag(FieldFlag flag) {
        return this.alledflags.contains((Object)flag);
    }

    public boolean canUse(int type) {
        return !this.preventUse.contains(type);
    }

    public boolean isUnusableItem(int type, byte data) {
        for (BlockTypeEntry entry : this.unusableItems) {
            if (!(entry.getData() == 0 ? entry.getTypeId() == type : entry.getTypeId() == type && entry.getData() == data)) continue;
            return true;
        }
        return false;
    }

    public boolean canCarry(int type, byte data) {
        if (this.confiscatedItems.isEmpty()) {
            return true;
        }
        for (BlockTypeEntry entry : this.confiscatedItems) {
            if (!(entry.getData() == 0 ? entry.getTypeId() == type : entry.getTypeId() == type && entry.getData() == data)) continue;
            return false;
        }
        return true;
    }

    public String getPotionString() {
        String out = "";
        for (PotionEffectType potion : this.potions.keySet()) {
            out = out + Helper.friendlyBlockType(potion.getName()) + ", ";
        }
        return Helper.stripTrailing(out, ", ");
    }

    public String getNeutralizePotionString() {
        String out = "";
        for (PotionEffectType potion : this.neutralizePotions) {
            out = out + Helper.friendlyBlockType(potion.getName()) + ", ";
        }
        return Helper.stripTrailing(out, ", ");
    }

    public boolean inAllowedList(String playerName) {
        return this.allowedPlayers.contains(playerName);
    }

    public boolean inDeniedList(String playerName) {
        return this.deniedPlayers.contains(playerName);
    }

    public boolean canGrief(int type) {
        return this.allowGrief.contains(type);
    }

    public boolean allowedWorld(World world) {
        return this.allowedWorlds.isEmpty() || this.allowedWorlds.contains(world.getName());
    }

    public boolean hasAllowedOnlyInside() {
        return !this.allowedOnlyInside.isEmpty();
    }

    public boolean isAllowedOnlyInside(Field field) {
        return this.allowedOnlyInside.contains(field.getSettings().getTitle());
    }

    public String getAllowedOnlyInsideString() {
        return Helper.toMessage(this.allowedOnlyInside, " or ");
    }

    public boolean hasAllowedOnlyOutside() {
        return !this.allowedOnlyOutside.isEmpty();
    }

    public boolean isAllowedOnlyOutside(Field field) {
        return this.allowedOnlyOutside.contains(field.getSettings().getTitle());
    }

    public String getAllowedOnlyOutsideString() {
        return Helper.toMessage(this.allowedOnlyOutside, " or ");
    }

    public int getTypeId() {
        return this.type.getTypeId();
    }

    public byte getData() {
        return this.type.getData();
    }

    public BlockTypeEntry getTypeEntry() {
        return this.type;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getLaunchHeight() {
        return this.launchHeight;
    }

    public int getCannonHeight() {
        return this.cannonHeight;
    }

    public int getMineDelaySeconds() {
        return this.mineDelaySeconds;
    }

    public int getLightningDelaySeconds() {
        return this.lightningDelaySeconds;
    }

    public int getLightningReplaceBlock() {
        return this.lightningReplaceBlock;
    }

    public int getPrice() {
        return this.price;
    }

    public boolean isValidField() {
        return this.validField;
    }

    public List<Integer> getLimits() {
        return Collections.unmodifiableList(this.limits);
    }

    public List<FieldFlag> getDefaultFlags() {
        return Collections.unmodifiableList(this.defaultFlags);
    }

    public int getCustomVolume() {
        return this.customVolume;
    }

    public int getMixingGroup() {
        return this.mixingGroup;
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public int getAutoDisableTime() {
        return this.autoDisableTime;
    }

    public String getGroupOnEntry() {
        return this.groupOnEntry;
    }

    public GameMode getForceEntryGameMode() {
        return this.forceEntryGameMode;
    }

    public GameMode getForceLeavingGameMode() {
        return this.forceLeavingGameMode;
    }

    public int getHeal() {
        return this.heal;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getFeed() {
        return this.feed;
    }

    public int getRepair() {
        return this.repair;
    }

    public List<Integer> getTreeTypes() {
        return new ArrayList<Integer>(this.treeTypes);
    }

    public List<Integer> getShrubTypes() {
        return new ArrayList<Integer>(this.shrubTypes);
    }

    public int getShrubDensity() {
        return this.shrubDensity;
    }

    public int getTreeCount() {
        return this.treeCount;
    }

    public int getGrowTime() {
        return this.growTime;
    }

    public boolean isFertileType(int type) {
        return this.fertileBlocks.contains(type);
    }

    public int getGroundBlock() {
        return this.groundBlock;
    }

    public List<String> getCreatureTypes() {
        return this.creatureTypes;
    }

    public int getCreatureCount() {
        return this.creatureCount;
    }

    public boolean isMineHasFire() {
        return this.mineHasFire;
    }

    public int getMineStrength() {
        return this.mine;
    }

    public HashMap<PotionEffectType, Integer> getPotions() {
        return this.potions;
    }

    public List<PotionEffectType> getNeutralizePotions() {
        return this.neutralizePotions;
    }

    public int getMaskOnDisabledBlock() {
        return this.maskOnDisabled;
    }

    public int getMaskOnEnabledBlock() {
        return this.maskOnEnabled;
    }

    public String getRequiredPermissionAllow() {
        return this.requiredPermissionAllow;
    }

    public String getRequiredPermissionUse() {
        return this.requiredPermissionUse;
    }

    public int getRefund() {
        int refunded = -1;
        if (this.refund > -1) {
            refunded = this.refund;
        } else if (this.price > 0) {
            refunded = this.price;
        }
        return refunded;
    }

    public int getTeleportCost() {
        return this.teleportCost;
    }

    public int getTeleportBackAfterSeconds() {
        return this.teleportBackAfterSeconds;
    }

    public int getTeleportMaxDistance() {
        return this.teleportMaxDistance;
    }

    public int getGriefRevertInterval() {
        return this.griefRevertInterval;
    }

    public List<String> getCommandsOnEnter() {
        return this.commandOnEnter;
    }

    public List<String> getCommandsOnExit() {
        return this.commandOnExit;
    }

    public List<String> getPlayerCommandsOnEnter() {
        return this.playerCommandOnEnter;
    }

    public List<String> getPlayerCommandsOnExit() {
        return this.playerCommandOnExit;
    }

    public List<FieldFlag> getDisabledFlags() {
        return this.disabledFlags;
    }

    public int getMustBeAbove() {
        return this.mustBeAbove;
    }

    public int getMustBeBelow() {
        return this.mustBeBelow;
    }

    public int getPayToEnable() {
        return this.payToEnable;
    }

    public boolean isSpoutBlock() {
        return this.spoutBlock;
    }

    public String getDeleteIfNoPermission() {
        return this.deleteIfNoPermission;
    }

    public int getFenceItem() {
        return this.fenceItem;
    }

    public int getFenceItemPrice() {
        return this.fenceItemPrice;
    }

    public boolean isSurface(Block fieldBlock) {
        if (this.surfaces.isEmpty()) {
            return true;
        }
        return this.surfaces.contains(new BlockTypeEntry(fieldBlock.getLocation().add(0.0, -1.0, 0.0).getBlock()));
    }

    public String getSurfaceString() {
        String out = "";
        for (BlockTypeEntry entry : this.surfaces) {
            out = out + entry.getFriendly() + ", ";
        }
        return Helper.stripTrailing(out, ", ");
    }

    public int getForesterUses() {
        return this.foresterUses;
    }
}

