/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.FieldSign;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.material.Attachable;
import org.bukkit.material.MaterialData;

public class SignHelper {
    public static boolean isSign(Block block) {
        if (block == null) {
            return false;
        }
        return block.getState() instanceof Sign;
    }

    public static Block getAttachedBlock(Block signBlock) {
        MaterialData m = signBlock.getState().getData();
        BlockFace face = BlockFace.DOWN;
        if (m instanceof Attachable) {
            face = ((Attachable)m).getAttachedFace();
        }
        return signBlock.getRelative(face);
    }

    public static FieldSign getAttachedFieldSign(Block block) {
        BlockFace[] faces;
        for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP}) {
            FieldSign s;
            Block attached;
            Block sign = block.getRelative(face);
            if (!SignHelper.isSign(sign) || !Helper.isSameBlock((attached = SignHelper.getAttachedBlock(sign)).getLocation(), block.getLocation()) || !(s = new FieldSign(sign)).isValid()) continue;
            return s;
        }
        return null;
    }

    public static boolean cannotBreakFieldSign(Block block, Player player) {
        FieldSign s;
        if (block != null && SignHelper.isSign(block) && (s = new FieldSign(block)).isValid()) {
            if (player == null) {
                return true;
            }
            if (s.getField().isOwner(player.getName())) {
                return s.getField().hasPendingPurchase();
            }
            return true;
        }
        return false;
    }

    public static FieldSign getFieldSign(Block sign) {
        FieldSign s;
        if (sign != null && SignHelper.isSign(sign) && (s = new FieldSign(sign)).isValid()) {
            return s;
        }
        return null;
    }

    public static int periodToSeconds(String period) {
        int counter = 0;
        int seconds = 0;
        ArrayList<String> strings = new ArrayList<String>();
        String[] chars = period.replaceAll(" ", "").toLowerCase().split("");
        String word = "";
        for (String ch : chars) {
            word = word + ch;
            if (!ch.equals("w") && !ch.equals("d") && !ch.equals("h") && !ch.equals("m") && !ch.equals("s")) continue;
            strings.add(word);
            word = "";
        }
        for (String string : strings) {
            if (string.contains("w") && Helper.isInteger(string = string.replace("w", ""))) {
                seconds += Integer.parseInt(string) * 60 * 60 * 24 * 7;
                ++counter;
            }
            if (string.contains("d") && Helper.isInteger(string = string.replace("d", ""))) {
                seconds += Integer.parseInt(string) * 60 * 60 * 24;
                ++counter;
            }
            if (string.contains("h") && Helper.isInteger(string = string.replace("h", ""))) {
                seconds += Integer.parseInt(string) * 60 * 60;
                ++counter;
            }
            if (counter < 3 && string.contains("m") && Helper.isInteger(string = string.replace("m", ""))) {
                seconds += Integer.parseInt(string) * 60;
                ++counter;
            }
            if (counter >= 3 || !string.contains("s") || !Helper.isInteger(string = string.replace("s", ""))) continue;
            seconds += Integer.parseInt(string);
            ++counter;
        }
        return seconds;
    }

    public static String secondsToPeriods(int seconds) {
        int hd;
        int dd;
        int counter = 0;
        String out = "";
        int w = 604800;
        int d = 86400;
        int h = 3600;
        int m = 60;
        int wd = seconds / w;
        if (wd > 0) {
            out = out + wd + "w ";
            seconds %= w;
            ++counter;
        }
        if ((dd = seconds / d) > 0) {
            out = out + dd + "d ";
            seconds %= d;
            ++counter;
        }
        if ((hd = seconds / h) > 0) {
            out = out + hd + "h ";
            seconds %= h;
            ++counter;
        }
        int md = seconds / m;
        if (counter < 3 && md > 0) {
            out = out + md + "m ";
            seconds %= m;
            ++counter;
        }
        int sd = seconds;
        if (counter < 3 && sd > 0) {
            out = out + sd + "s";
        }
        return Helper.stripTrailing(out, " ");
    }

    public static boolean isValidPeriod(String period) {
        String string = period.replaceAll(" ", "").toLowerCase().replaceAll("[wdhms]", "");
        return Helper.isInteger(string);
    }

    public static BlockTypeEntry extractItemFromParenthesis(String line) {
        Pattern p = Pattern.compile("\\((.*?)\\)", 32);
        Matcher m = p.matcher(line);
        while (m.find()) {
            if (!Helper.isTypeEntry(m.group(1))) continue;
            return new BlockTypeEntry(m.group(1));
        }
        return null;
    }

    public static int extractPrice(String line) {
        line = line.replaceAll("\\((.*?)\\)", "");
        return Helper.forceParseInteger(line);
    }
}

