/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class TargetBlock {
    private Location loc;
    private double viewHeight;
    private int maxDistance;
    private int[] blockToIgnore;
    private double checkDistance;
    private double curDistance;
    private double xRotation;
    private double yRotation;
    private Vector targetPos = new Vector();
    private Vector targetPosDouble = new Vector();
    private Vector prevPos = new Vector();
    private Vector offset = new Vector();

    public TargetBlock(Player player) {
        this.setValues(player.getLocation(), 300, 1.65, 0.2, null);
    }

    public TargetBlock(Location loc) {
        this.setValues(loc, 300, 0.0, 0.2, null);
    }

    public TargetBlock(Player player, int maxDistance, double checkDistance) {
        this.setValues(player.getLocation(), maxDistance, 1.65, checkDistance, null);
    }

    public TargetBlock(Location loc, int maxDistance, double checkDistance) {
        this.setValues(loc, maxDistance, 0.0, checkDistance, null);
    }

    public TargetBlock(Player player, int maxDistance, double checkDistance, int[] blocksToIgnore) {
        this.setValues(player.getLocation(), maxDistance, 1.65, checkDistance, blocksToIgnore);
    }

    public TargetBlock(Location loc, int maxDistance, double checkDistance, int[] blocksToIgnore) {
        this.setValues(loc, maxDistance, 0.0, checkDistance, blocksToIgnore);
    }

    public TargetBlock(Player player, int maxDistance, double checkDistance, ArrayList<String> blocksToIgnore) {
        int[] bti = this.convertStringArraytoIntArray(blocksToIgnore);
        this.setValues(player.getLocation(), maxDistance, 1.65, checkDistance, bti);
    }

    public TargetBlock(Player player, int maxDistance, double checkDistance, List<Integer> blocksToIgnore) {
        int[] bti = this.convertIntListtoIntArray(blocksToIgnore);
        this.setValues(player.getLocation(), maxDistance, 1.65, checkDistance, bti);
    }

    public TargetBlock(Location loc, int maxDistance, double checkDistance, ArrayList<String> blocksToIgnore) {
        int[] bti = this.convertStringArraytoIntArray(blocksToIgnore);
        this.setValues(loc, maxDistance, 0.0, checkDistance, bti);
    }

    public TargetBlock(Location loc, int maxDistance, double checkDistance, List<Integer> blocksToIgnore) {
        int[] bti = this.convertIntListtoIntArray(blocksToIgnore);
        this.setValues(loc, maxDistance, 0.0, checkDistance, bti);
    }

    private void setValues(Location loc, int maxDistance, double viewHeight, double checkDistance, int[] blocksToIgnore) {
        this.loc = loc;
        this.maxDistance = maxDistance;
        this.viewHeight = viewHeight;
        this.checkDistance = checkDistance;
        this.blockToIgnore = blocksToIgnore;
        this.curDistance = 0.0;
        this.xRotation = (loc.getYaw() + 90.0f) % 360.0f;
        this.yRotation = loc.getPitch() * -1.0f;
        double h = checkDistance * Math.cos(Math.toRadians(this.yRotation));
        this.offset.setY(checkDistance * Math.sin(Math.toRadians(this.yRotation)));
        this.offset.setX(h * Math.cos(Math.toRadians(this.xRotation)));
        this.offset.setZ(h * Math.sin(Math.toRadians(this.xRotation)));
        this.targetPosDouble = new Vector(loc.getX(), loc.getY() + viewHeight, loc.getZ());
        this.targetPos = new Vector(this.targetPosDouble.getBlockX(), this.targetPosDouble.getBlockY(), this.targetPosDouble.getBlockZ());
        this.prevPos = this.targetPos.clone();
    }

    public void reset() {
        this.targetPosDouble = new Vector(this.loc.getX(), this.loc.getY() + this.viewHeight, this.loc.getZ());
        this.targetPos = new Vector(this.targetPosDouble.getBlockX(), this.targetPosDouble.getBlockY(), this.targetPosDouble.getBlockZ());
        this.prevPos = this.targetPos.clone();
        this.curDistance = 0.0;
    }

    public double getDistanceToBlock() {
        Vector blockUnderPlayer = new Vector((int)Math.floor(this.loc.getX() + 0.5), (int)Math.floor(this.loc.getY() - 0.5), (int)Math.floor(this.loc.getZ() + 0.5));
        Block blk = this.getTargetBlock();
        double x = blk.getX() - blockUnderPlayer.getBlockX();
        double y = blk.getY() - blockUnderPlayer.getBlockY();
        double z = blk.getZ() - blockUnderPlayer.getBlockZ();
        return Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
    }

    public int getDistanceToBlockRounded() {
        Vector blockUnderPlayer = new Vector((int)Math.floor(this.loc.getX() + 0.5), (int)Math.floor(this.loc.getY() - 0.5), (int)Math.floor(this.loc.getZ() + 0.5));
        Block blk = this.getTargetBlock();
        double x = blk.getX() - blockUnderPlayer.getBlockX();
        double y = blk.getY() - blockUnderPlayer.getBlockY();
        double z = blk.getZ() - blockUnderPlayer.getBlockZ();
        return (int)Math.round(Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)));
    }

    public int getXDistanceToBlock() {
        this.reset();
        return (int)Math.floor((double)(this.getTargetBlock().getX() - this.loc.getBlockX()) + 0.5);
    }

    public int getYDistanceToBlock() {
        this.reset();
        return (int)Math.floor((double)(this.getTargetBlock().getY() - this.loc.getBlockY()) + this.viewHeight);
    }

    public int getZDistanceToBlock() {
        this.reset();
        return (int)Math.floor((double)(this.getTargetBlock().getZ() - this.loc.getBlockZ()) + 0.5);
    }

    public Block getTargetBlock() {
        this.reset();
        while (this.getNextBlock() != null && (this.getCurrentBlock().getTypeId() == 0 || this.blockToIgnoreHasValue(this.getCurrentBlock().getTypeId()))) {
        }
        return this.getCurrentBlock();
    }

    public boolean setTargetBlock(int typeID) {
        this.reset();
        while (this.getNextBlock() != null && this.getCurrentBlock().getTypeId() == 0) {
        }
        if (this.getCurrentBlock() != null) {
            Block blk = this.loc.getWorld().getBlockAt(this.targetPos.getBlockX(), this.targetPos.getBlockY(), this.targetPos.getBlockZ());
            blk.setTypeId(typeID);
            return true;
        }
        return false;
    }

    public boolean setTargetBlock(Material type) {
        this.reset();
        while (this.getNextBlock() != null && (this.getCurrentBlock().getTypeId() == 0 || this.blockToIgnoreHasValue(this.getCurrentBlock().getTypeId()))) {
        }
        if (this.getCurrentBlock() != null) {
            Block blk = this.loc.getWorld().getBlockAt(this.targetPos.getBlockX(), this.targetPos.getBlockY(), this.targetPos.getBlockZ());
            blk.setType(type);
            return true;
        }
        return false;
    }

    public boolean setTargetBlock(String type) {
        Material mat = Material.valueOf((String)type);
        if (mat != null) {
            this.reset();
            while (this.getNextBlock() != null && (this.getCurrentBlock().getTypeId() == 0 || this.blockToIgnoreHasValue(this.getCurrentBlock().getTypeId()))) {
            }
            if (this.getCurrentBlock() != null) {
                Block blk = this.loc.getWorld().getBlockAt(this.targetPos.getBlockX(), this.targetPos.getBlockY(), this.targetPos.getBlockZ());
                blk.setType(mat);
                return true;
            }
        }
        return false;
    }

    public Block getFaceBlock() {
        while (this.getNextBlock() != null && (this.getCurrentBlock().getTypeId() == 0 || this.blockToIgnoreHasValue(this.getCurrentBlock().getTypeId()))) {
        }
        if (this.getCurrentBlock() != null) {
            return this.getPreviousBlock();
        }
        return null;
    }

    public boolean setFaceBlock(int typeID) {
        if (Material.getMaterial((int)typeID) != null && this.getCurrentBlock() != null) {
            Block blk = this.loc.getWorld().getBlockAt(this.prevPos.getBlockX(), this.prevPos.getBlockY(), this.prevPos.getBlockZ());
            blk.setTypeId(typeID);
            return true;
        }
        return false;
    }

    public boolean setFaceBlock(Material type) {
        if (this.getCurrentBlock() != null) {
            Block blk = this.loc.getWorld().getBlockAt(this.prevPos.getBlockX(), this.prevPos.getBlockY(), this.prevPos.getBlockZ());
            blk.setType(type);
            return true;
        }
        return false;
    }

    public boolean setFaceBlock(String type) {
        Material mat = Material.valueOf((String)type);
        if (mat != null && this.getCurrentBlock() != null) {
            Block blk = this.loc.getWorld().getBlockAt(this.prevPos.getBlockX(), this.prevPos.getBlockY(), this.prevPos.getBlockZ());
            blk.setType(mat);
            return true;
        }
        return false;
    }

    public Block getNextBlock() {
        this.prevPos = this.targetPos.clone();
        do {
            this.curDistance += this.checkDistance;
            this.targetPosDouble.setX(this.offset.getX() + this.targetPosDouble.getX());
            this.targetPosDouble.setY(this.offset.getY() + this.targetPosDouble.getY());
            this.targetPosDouble.setZ(this.offset.getZ() + this.targetPosDouble.getZ());
            this.targetPos = new Vector(this.targetPosDouble.getBlockX(), this.targetPosDouble.getBlockY(), this.targetPosDouble.getBlockZ());
        } while (this.curDistance <= (double)this.maxDistance && this.targetPos.getBlockX() == this.prevPos.getBlockX() && this.targetPos.getBlockY() == this.prevPos.getBlockY() && this.targetPos.getBlockZ() == this.prevPos.getBlockZ());
        if (this.curDistance > (double)this.maxDistance) {
            return null;
        }
        return this.loc.getWorld().getBlockAt(this.targetPos.getBlockX(), this.targetPos.getBlockY(), this.targetPos.getBlockZ());
    }

    public Block getCurrentBlock() {
        if (this.curDistance > (double)this.maxDistance) {
            return null;
        }
        return this.loc.getWorld().getBlockAt(this.targetPos.getBlockX(), this.targetPos.getBlockY(), this.targetPos.getBlockZ());
    }

    public boolean setCurrentBlock(int typeID) {
        Block blk = this.getCurrentBlock();
        if (blk != null) {
            blk.setTypeId(typeID);
            return true;
        }
        return false;
    }

    public boolean setCurrentBlock(Material type) {
        Block blk = this.getCurrentBlock();
        if (blk != null) {
            blk.setType(type);
            return true;
        }
        return false;
    }

    public boolean setCurrentBlock(String type) {
        Block blk;
        Material mat = Material.valueOf((String)type);
        if (mat != null && (blk = this.getCurrentBlock()) != null) {
            blk.setType(mat);
            return true;
        }
        return false;
    }

    public Block getPreviousBlock() {
        return this.loc.getWorld().getBlockAt(this.prevPos.getBlockX(), this.prevPos.getBlockY(), this.prevPos.getBlockZ());
    }

    public boolean setPreviousBlock(int typeID) {
        Block blk;
        if (Material.getMaterial((int)typeID) != null && (blk = this.getPreviousBlock()) != null) {
            blk.setTypeId(typeID);
            return true;
        }
        return false;
    }

    public boolean setPreviousBlock(Material type) {
        Block blk = this.getPreviousBlock();
        if (blk != null) {
            blk.setType(type);
            return true;
        }
        return false;
    }

    public boolean setPreviousBlock(String type) {
        Block blk;
        Material mat = Material.valueOf((String)type);
        if (mat != null && (blk = this.getPreviousBlock()) != null) {
            blk.setType(mat);
            return true;
        }
        return false;
    }

    private int[] convertStringArraytoIntArray(ArrayList<String> array) {
        if (array != null) {
            int[] intarray = new int[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                try {
                    intarray[i] = Integer.parseInt(array.get(i));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    intarray[i] = 0;
                }
            }
            return intarray;
        }
        return null;
    }

    private int[] convertIntListtoIntArray(List<Integer> array) {
        if (array != null) {
            int[] intarray = new int[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                try {
                    intarray[i] = array.get(i);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    intarray[i] = 0;
                }
            }
            return intarray;
        }
        return null;
    }

    private boolean blockToIgnoreHasValue(int value) {
        if (this.blockToIgnore != null && this.blockToIgnore.length > 0) {
            for (int i : this.blockToIgnore) {
                if (i != value) continue;
                return true;
            }
        }
        return false;
    }
}

