/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones;

import java.util.LinkedList;
import java.util.Queue;
import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.TranslocationBlock;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TranslocationRemover
implements Runnable {
    private PreciousStones plugin;
    private Queue<TranslocationBlock> translocationQueue;
    private Queue<TranslocationBlock> dependentQueue = new LinkedList<TranslocationBlock>();
    private final int timerID;
    private final Player player;
    private final Field field;
    private int count;
    private int notRemovedCount;

    public TranslocationRemover(Field field, Queue<TranslocationBlock> translocationQueue, Player player) {
        this.field = field;
        this.translocationQueue = translocationQueue;
        this.player = player;
        this.plugin = PreciousStones.getInstance();
        field.setTranslocating(true);
        this.timerID = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, 5L, 5L);
    }

    @Override
    public void run() {
        boolean applied;
        TranslocationBlock tb;
        int i = 0;
        while (i < 100 && !this.translocationQueue.isEmpty()) {
            tb = this.translocationQueue.poll();
            if (tb != null) {
                if (this.plugin.getSettingsManager().isDependentBlock(tb.getTypeId())) {
                    this.dependentQueue.add(tb);
                    continue;
                }
                applied = PreciousStones.getInstance().getTranslocationManager().applyTranslocationBlock(tb, this.player.getWorld());
                if (!applied) {
                    this.plugin.getStorageManager().updateTranslocationBlockApplied(this.field, tb, false);
                    ++this.notRemovedCount;
                } else {
                    this.plugin.getStorageManager().deleteTranslocation(this.field, tb);
                    ++this.count;
                    this.announce();
                }
            }
            ++i;
        }
        if (this.translocationQueue.isEmpty()) {
            while (i < 200 && !this.dependentQueue.isEmpty()) {
                tb = this.dependentQueue.poll();
                applied = PreciousStones.getInstance().getTranslocationManager().applyTranslocationBlock(tb, this.player.getWorld());
                if (!applied) {
                    this.plugin.getStorageManager().updateTranslocationBlockApplied(this.field, tb, false);
                    ++this.notRemovedCount;
                } else {
                    this.plugin.getStorageManager().deleteTranslocation(this.field, tb);
                    ++this.count;
                    this.announce();
                }
                ++i;
            }
            if (!this.dependentQueue.iterator().hasNext()) {
                Bukkit.getServer().getScheduler().cancelTask(this.timerID);
                this.field.setDisabled(false);
                this.field.setTranslocating(false);
                this.field.dirtyFlags();
                ChatBlock.send((CommandSender)this.player, "removalComplete", new Object[0]);
                if (this.notRemovedCount > 0) {
                    ChatBlock.send((CommandSender)this.player, "blocksSkipped", this.count);
                    ChatBlock.send((CommandSender)this.player, "blocksSkipped2", new Object[0]);
                }
            }
        }
    }

    public void announce() {
        if (this.count % 25 == 0 && this.count != 0 && this.player != null) {
            ChatBlock.send((CommandSender)this.player, "removedBlocks", this.count);
        }
    }
}

