/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class BlockEntry {
    private final int typeId;
    private final byte data;
    private final Location location;

    public BlockEntry(Block block) {
        this.typeId = block.getTypeId();
        this.data = block.getData();
        this.location = block.getLocation();
    }

    public BlockEntry(Location loc, int typeId, byte data) {
        this.typeId = typeId;
        this.data = data;
        this.location = loc;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public byte getData() {
        return this.data;
    }

    public Location getLocation() {
        return this.location;
    }

    public Block getBlock() {
        return this.location.getWorld().getBlockAt(this.location);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockEntry)) {
            return false;
        }
        BlockEntry other = (BlockEntry)obj;
        return other.getTypeId() == this.getTypeId() && other.getData() == this.getData() && Helper.isSameBlock(this.getLocation(), other.getLocation());
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.getTypeId();
        hash = 47 * hash + this.getData();
        hash = 47 * hash + this.getLocation().getBlockX() + this.getLocation().getBlockY() + this.getLocation().getBlockZ();
        return hash;
    }

    public String toString() {
        return "[" + this.getTypeId() + ":" + this.getData() + " " + Helper.toLocationString(this.location) + "]";
    }
}

