/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import net.sacredlabyrinth.Phaed.PreciousStones.ChatBlock;
import net.sacredlabyrinth.Phaed.PreciousStones.FieldFlag;
import net.sacredlabyrinth.Phaed.PreciousStones.Helper;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.SignHelper;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.BlockTypeEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Field;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;

public class FieldSign {
    private Sign sign;
    private boolean valid = true;
    private String tag;
    private Field field;
    private boolean fieldSign;
    private String period;
    private int price;
    private BlockTypeEntry item;
    private String playerName;
    private String failReason;

    public FieldSign(Block signBlock) {
        if (!SignHelper.isSign(signBlock)) {
            this.valid = false;
            return;
        }
        this.sign = (Sign)signBlock.getState();
        String[] lines = this.sign.getLines();
        this.valid = this.extractData(signBlock, lines);
    }

    public FieldSign(Block signBlock, boolean silent) {
        if (!SignHelper.isSign(signBlock)) {
            this.valid = false;
            return;
        }
        this.sign = (Sign)signBlock.getState();
        String[] lines = this.sign.getLines();
        this.valid = this.extractData(signBlock, lines);
    }

    public FieldSign(Block signBlock, String[] lines, Player player) {
        if (!SignHelper.isSign(signBlock)) {
            this.valid = false;
            return;
        }
        this.valid = this.extractData(signBlock, lines);
        this.playerName = player.getName();
    }

    public boolean extractData(Block signBlock, String[] lines) {
        this.tag = ChatColor.stripColor((String)lines[0]);
        boolean bl = this.fieldSign = this.tag.equalsIgnoreCase(ChatBlock.format("fieldSignRent", new Object[0])) || this.tag.equalsIgnoreCase(ChatBlock.format("fieldSignBuy", new Object[0])) || this.tag.equalsIgnoreCase(ChatBlock.format("fieldSignShare", new Object[0]));
        if (!this.fieldSign) {
            this.failReason = null;
            return false;
        }
        this.price = SignHelper.extractPrice(ChatColor.stripColor((String)lines[1]));
        if (this.price == 0) {
            this.failReason = "fieldSignNoPrice";
            return false;
        }
        this.item = SignHelper.extractItemFromParenthesis(ChatColor.stripColor((String)lines[1]));
        if (this.item == null && !PreciousStones.getInstance().getPermissionsManager().hasEconomy()) {
            this.item = PreciousStones.getInstance().getSettingsManager().getDefaulItemCurrency();
        }
        Block attachedBlock = SignHelper.getAttachedBlock(signBlock);
        this.field = PreciousStones.getInstance().getForceFieldManager().getField(attachedBlock);
        if (this.field == null) {
            this.failReason = null;
            return false;
        }
        if (this.playerName != null && !this.field.isOwner(this.playerName)) {
            this.failReason = "fieldSignNotOwner";
            return false;
        }
        if (!this.isBuyable()) {
            this.period = ChatColor.stripColor((String)lines[2]);
            if (!SignHelper.isValidPeriod(this.period)) {
                this.failReason = "fieldSignInvalidPeriod";
                return false;
            }
        }
        if (this.isRentable() && !this.field.hasFlag(FieldFlag.RENTABLE)) {
            this.failReason = "fieldSignNotRentable";
            return false;
        }
        if (this.isShareable() && !this.field.hasFlag(FieldFlag.SHAREABLE)) {
            this.failReason = "fieldSignNotShareable";
            return false;
        }
        if (this.isBuyable() && !this.field.hasFlag(FieldFlag.BUYABLE)) {
            this.failReason = "fieldSignNotBuyable";
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isRentable() {
        return this.tag.equalsIgnoreCase(ChatBlock.format("fieldSignRent", new Object[0]));
    }

    public boolean isBuyable() {
        return this.tag.equalsIgnoreCase(ChatBlock.format("fieldSignBuy", new Object[0]));
    }

    public boolean isShareable() {
        return this.tag.equalsIgnoreCase(ChatBlock.format("fieldSignShare", new Object[0]));
    }

    public void setRentedColor() {
        this.sign.setLine(0, ChatColor.RED + "" + ChatColor.BOLD + ChatColor.stripColor((String)this.sign.getLine(0)));
        this.sign.update();
    }

    public void setBoughtColor(Player player) {
        this.sign.setLine(0, ChatColor.RED + "" + ChatColor.BOLD + ChatColor.stripColor((String)this.sign.getLine(0)));
        this.sign.setLine(3, ChatColor.BOLD + player.getName());
        this.sign.update();
    }

    public void setSharedColor() {
        this.sign.setLine(0, ChatColor.GOLD + "" + ChatColor.BOLD + ChatColor.stripColor((String)this.sign.getLine(0)));
        this.sign.update();
    }

    public void setAvailableColor() {
        this.sign.setLine(0, ChatColor.BOLD + ChatColor.stripColor((String)this.sign.getLine(0)));
        this.sign.setLine(3, "");
        this.sign.update();
    }

    public void updateRemainingTime(int seconds) {
        this.sign.setLine(3, ChatColor.BOLD + SignHelper.secondsToPeriods(seconds));
        this.sign.update();
    }

    public void cleanRemainingTime() {
        this.sign.setLine(3, "");
        this.sign.update();
    }

    public void eject() {
        Helper.dropBlockWipe(this.sign.getBlock());
    }

    public Block getAttachedBlock() {
        return SignHelper.getAttachedBlock(this.sign.getBlock());
    }

    public Field getField() {
        if (this.field != null) {
            return this.field;
        }
        return PreciousStones.getInstance().getForceFieldManager().getField(this.getAttachedBlock());
    }

    public boolean isFieldSign() {
        return this.fieldSign;
    }

    public String getPeriod() {
        return this.period;
    }

    public int getPrice() {
        return this.price;
    }

    public BlockTypeEntry getItem() {
        return this.item;
    }

    public Sign getSign() {
        return this.sign;
    }

    public String getFailReason() {
        return this.failReason;
    }
}

