/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONObject;

public class ItemStackEntry {
    private final int typeId;
    private final byte data;
    private final short durability;
    private final int amount;
    private Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();

    public ItemStackEntry(ItemStack item) {
        this.typeId = item.getTypeId();
        this.data = item.getData().getData();
        this.durability = item.getDurability();
        this.enchantments = item.getEnchantments();
        this.amount = item.getAmount();
    }

    public ItemStackEntry(JSONObject o) {
        this.typeId = Integer.parseInt(o.get((Object)"id").toString());
        this.data = Byte.parseByte(o.get((Object)"d").toString());
        this.durability = Short.parseShort(o.get((Object)"dmg").toString());
        this.amount = Integer.parseInt(o.get((Object)"a").toString());
        JSONObject ench = (JSONObject)o.get((Object)"e");
        if (ench != null) {
            for (Object enchId : ench.keySet()) {
                Integer id = Integer.parseInt(enchId.toString());
                Integer level = Integer.parseInt(ench.get(enchId).toString());
                this.enchantments.put(Enchantment.getById((int)id), level);
            }
        }
    }

    public JSONObject serialize() {
        JSONObject ench = new JSONObject();
        for (Enchantment e : this.enchantments.keySet()) {
            Integer integer = this.enchantments.get(e);
            ench.put((Object)e.getId(), (Object)integer);
        }
        JSONObject out = new JSONObject();
        out.put((Object)"id", (Object)this.getTypeId());
        out.put((Object)"d", (Object)this.getData());
        out.put((Object)"dmg", (Object)this.getDurability());
        out.put((Object)"a", (Object)this.getAmount());
        out.put((Object)"e", (Object)ench);
        return out;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public byte getData() {
        return this.data;
    }

    public short getDurability() {
        return this.durability;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemStackEntry)) {
            return false;
        }
        ItemStackEntry other = (ItemStackEntry)obj;
        int id1 = this.getTypeId();
        int id2 = other.getTypeId();
        byte data1 = this.getData();
        byte data2 = other.getData();
        if (id1 == id2 && data1 == data2) {
            return true;
        }
        return id1 == 8 && id2 == 9 || id1 == 9 && id2 == 8 || id1 == 11 && id2 == 10 || id1 == 10 && id2 == 11 || id1 == 73 && id2 == 74 || id1 == 74 && id2 == 73 || id1 == 61 && id2 == 62 || id1 == 62 && id2 == 61;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + this.getTypeId();
        hash = 47 * hash + this.getData();
        return hash;
    }

    public ItemStack toItemStack() {
        ItemStack is = new ItemStack(this.getTypeId(), this.getAmount(), this.getDurability(), Byte.valueOf(this.getData()));
        for (Enchantment ench : this.enchantments.keySet()) {
            is.addUnsafeEnchantment(ench, Math.min(this.enchantments.get(ench), ench.getMaxLevel()));
        }
        return is;
    }

    public String toString() {
        if (this.getData() == 0) {
            return this.getTypeId() + "";
        }
        if (this.getDurability() == 0) {
            return this.getTypeId() + ":" + this.getData();
        }
        return this.getTypeId() + ":" + this.getData() + ":" + this.getDurability();
    }
}

