/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.Phaed.PreciousStones.entries;

import java.util.ArrayList;
import java.util.List;
import net.sacredlabyrinth.Phaed.PreciousStones.PreciousStones;
import net.sacredlabyrinth.Phaed.PreciousStones.entries.ItemStackEntry;
import net.sacredlabyrinth.Phaed.PreciousStones.vectors.Vec;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class PlayerEntry {
    private String name;
    private boolean disabled;
    private boolean online;
    private int density;
    private boolean bypassDisabled;
    private Location outsideLocation;
    private JSONArray confiscatedInventory = new JSONArray();
    private ItemStackEntry confiscatedHelmet = null;
    private ItemStackEntry confiscatedChestplate = null;
    private ItemStackEntry confiscatedLeggings = null;
    private ItemStackEntry confiscatedBoots = null;
    private boolean teleporting = false;
    private int teleportSecondsRemaining = 0;
    private Vec teleportVec = null;
    private boolean teleportPending = false;
    private int task;

    public PlayerEntry() {
        this.disabled = PreciousStones.getInstance().getSettingsManager().isOffByDefault();
        this.density = PreciousStones.getInstance().getSettingsManager().getVisualizeDensity();
    }

    public void confiscate(List<ItemStackEntry> items, ItemStackEntry helmet, ItemStackEntry chestplate, ItemStackEntry leggings, ItemStackEntry boots) {
        for (ItemStackEntry entry : items) {
            this.confiscatedInventory.add((Object)entry.serialize());
        }
        if (helmet != null) {
            this.confiscatedHelmet = helmet;
        }
        if (chestplate != null) {
            this.confiscatedChestplate = chestplate;
        }
        if (leggings != null) {
            this.confiscatedLeggings = leggings;
        }
        if (boots != null) {
            this.confiscatedBoots = boots;
        }
    }

    public List<ItemStackEntry> returnInventory() {
        ArrayList<ItemStackEntry> out = new ArrayList<ItemStackEntry>();
        for (Object stackEntry : this.confiscatedInventory) {
            out.add(new ItemStackEntry((JSONObject)stackEntry));
        }
        this.confiscatedInventory.clear();
        return out;
    }

    public ItemStackEntry returnHelmet() {
        ItemStackEntry out = this.confiscatedHelmet;
        this.confiscatedHelmet = null;
        return out;
    }

    public ItemStackEntry returnChestplate() {
        ItemStackEntry out = this.confiscatedChestplate;
        this.confiscatedChestplate = null;
        return out;
    }

    public ItemStackEntry returnLeggings() {
        ItemStackEntry out = this.confiscatedLeggings;
        this.confiscatedLeggings = null;
        return out;
    }

    public ItemStackEntry returnBoots() {
        ItemStackEntry out = this.confiscatedBoots;
        this.confiscatedBoots = null;
        return out;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public Location getOutsideLocation() {
        return this.outsideLocation;
    }

    public void setOutsideLocation(Location outsideLocation) {
        this.outsideLocation = outsideLocation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFlags() {
        JSONObject json = new JSONObject();
        if (this.disabled) {
            json.put((Object)"disabled", (Object)this.disabled);
        }
        if (!this.confiscatedInventory.isEmpty()) {
            json.put((Object)"confiscated", (Object)this.confiscatedInventory);
        }
        if (this.confiscatedHelmet != null) {
            json.put((Object)"helmet", (Object)this.confiscatedHelmet.serialize());
        }
        if (this.confiscatedChestplate != null) {
            json.put((Object)"chestplate", (Object)this.confiscatedChestplate.serialize());
        }
        if (this.confiscatedLeggings != null) {
            json.put((Object)"leggings", (Object)this.confiscatedLeggings.serialize());
        }
        if (this.confiscatedBoots != null) {
            json.put((Object)"boots", (Object)this.confiscatedBoots.serialize());
        }
        if (this.teleportSecondsRemaining > 0) {
            json.put((Object)"teleportSecondsRemaining", (Object)this.teleportSecondsRemaining);
        }
        if (this.teleportVec != null) {
            json.put((Object)"teleportVec", (Object)this.teleportVec.serialize());
        }
        if (this.teleportPending) {
            json.put((Object)"teleportPending", (Object)this.teleportPending);
        }
        if (this.bypassDisabled) {
            json.put((Object)"bypassDisabled", (Object)this.bypassDisabled);
        }
        json.put((Object)"density", (Object)this.density);
        json.put((Object)"density", (Object)this.density);
        return json.toString();
    }

    public void setFlags(String flagString) {
        Object obj;
        JSONObject flags;
        if (flagString != null && !flagString.isEmpty() && (flags = (JSONObject)(obj = JSONValue.parse((String)flagString))) != null) {
            for (Object flag : flags.keySet()) {
                try {
                    if (flag.equals("disabled")) {
                        this.disabled = (Boolean)flags.get(flag);
                    }
                    if (flag.equals("density")) {
                        this.density = ((Long)flags.get(flag)).intValue();
                    }
                    if (flag.equals("confiscated")) {
                        this.confiscatedInventory = (JSONArray)flags.get(flag);
                    }
                    if (flag.equals("helmet")) {
                        this.confiscatedHelmet = new ItemStackEntry((JSONObject)flags.get(flag));
                    }
                    if (flag.equals("chestplate")) {
                        this.confiscatedChestplate = new ItemStackEntry((JSONObject)flags.get(flag));
                    }
                    if (flag.equals("leggings")) {
                        this.confiscatedLeggings = new ItemStackEntry((JSONObject)flags.get(flag));
                    }
                    if (flag.equals("boots")) {
                        this.confiscatedBoots = new ItemStackEntry((JSONObject)flags.get(flag));
                    }
                    if (flag.equals("teleportSecondsRemaining")) {
                        this.teleportSecondsRemaining = ((Long)flags.get(flag)).intValue();
                    }
                    if (flag.equals("teleportVec")) {
                        this.teleportVec = new Vec(flags.get(flag).toString());
                    }
                    if (flag.equals("teleportPending")) {
                        this.teleportPending = (Boolean)flags.get(flag);
                    }
                    if (flag.equals("bypassDisabled")) {
                        this.bypassDisabled = (Boolean)flags.get(flag);
                    }
                    if (this.teleportSecondsRemaining > 0) {
                        if (this.teleportVec == null) continue;
                        this.startTeleportCountDown();
                        continue;
                    }
                    if (!this.teleportPending) continue;
                    this.tryTeleport();
                }
                catch (Exception ex) {
                    System.out.print("Failed reading player flag: " + flag);
                    System.out.print("Value: " + flags.get(flag));
                    System.out.print("Error: " + ex.getMessage());
                    for (StackTraceElement el : ex.getStackTrace()) {
                        System.out.print(el.toString());
                    }
                }
            }
        }
    }

    public void startTeleportCountDown() {
        this.task = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)PreciousStones.getInstance(), new Runnable(){

            @Override
            public void run() {
                PlayerEntry.this.teleportSecondsRemaining -= 1;
                if (PlayerEntry.this.teleportSecondsRemaining <= 0) {
                    PlayerEntry.this.tryTeleport();
                    Bukkit.getServer().getScheduler().cancelTask(PlayerEntry.this.task);
                }
            }
        }, 20L, 20L);
    }

    private void tryTeleport() {
        if (this.teleportVec == null) {
            this.teleportSecondsRemaining = 0;
            this.teleportPending = false;
            return;
        }
        Player player = Bukkit.getServer().getPlayerExact(this.name);
        if (player != null) {
            player.teleport(this.teleportVec.getLocation());
            this.teleportSecondsRemaining = 0;
            this.teleportVec = null;
            this.teleportPending = false;
        } else {
            this.teleportPending = true;
        }
    }

    public int getDensity() {
        return Math.max(this.density, 1);
    }

    public void setDensity(int density) {
        this.density = density;
    }

    public boolean isTeleporting() {
        return this.teleporting;
    }

    public void setTeleporting(boolean teleporting) {
        this.teleporting = teleporting;
    }

    public int getTeleportSecondsRemaining() {
        return this.teleportSecondsRemaining;
    }

    public void setTeleportSecondsRemaining(int teleportSecondsRemaining) {
        this.teleportSecondsRemaining = teleportSecondsRemaining;
    }

    public Vec getTeleportVec() {
        return this.teleportVec;
    }

    public void setTeleportVec(Vec teleportVec) {
        this.teleportVec = teleportVec;
    }

    public boolean isBypassDisabled() {
        return this.bypassDisabled;
    }

    public void setBypassDisabled(boolean bypassDisabled) {
        this.bypassDisabled = bypassDisabled;
    }
}

